/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdatePartitionDataRecordV3;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageUpdatePartitionDataRecordV4
extends MetaPageUpdatePartitionDataRecordV3 {
    private long tombstonesCnt;

    public MetaPageUpdatePartitionDataRecordV4(int grpId, long pageId, long updateCntr, long globalRmvId, int partSize, long cntrsPageId, byte state, int allocatedIdxCandidate, long link, int encryptedPageIdx, int encryptedPageCnt, long tombstonesCnt) {
        super(grpId, pageId, updateCntr, globalRmvId, partSize, cntrsPageId, state, allocatedIdxCandidate, link, encryptedPageIdx, encryptedPageCnt);
        this.tombstonesCnt = tombstonesCnt;
    }

    public MetaPageUpdatePartitionDataRecordV4(DataInput in) throws IOException {
        super(in);
        this.tombstonesCnt = in.readLong();
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        super.applyDelta(pageMem, pageAddr);
        PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
        io.setTombstonesCount(pageAddr, this.tombstonesCnt);
    }

    public long tombstonesCount() {
        return this.tombstonesCnt;
    }

    @Override
    public void toBytes(ByteBuffer buf) {
        super.toBytes(buf);
        buf.putLong(this.tombstonesCnt);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PARTITION_META_PAGE_DELTA_RECORD_V4;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageUpdatePartitionDataRecordV4.class, this, "partId", (Object)PageIdUtils.partId(this.pageId()), "super", (Object)super.toString());
    }
}

