/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.compress.CompressionProcessor;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheCompressionManager
extends GridCacheManagerAdapter {
    private DiskPageCompression diskPageCompression;
    private int diskPageCompressLevel;
    private CompressionProcessor compressProc;

    @Override
    protected void start0() throws IgniteCheckedException {
        this.diskPageCompression = DiskPageCompression.DISABLED;
    }

    public ByteBuffer compressPage(ByteBuffer page, PageStore store) throws IgniteCheckedException {
        if (this.diskPageCompression == DiskPageCompression.DISABLED) {
            return page;
        }
        int blockSize = store.getBlockSize();
        if (blockSize <= 0) {
            throw new IgniteCheckedException("Failed to detect storage block size on " + U.osString());
        }
        return this.compressProc.compressPage(page, store.getPageSize(), blockSize, this.diskPageCompression, this.diskPageCompressLevel);
    }
}

