/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemander;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloaderAssignments;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridCachePreloaderAdapter
implements GridCachePreloader {
    protected final CacheGroupContext grp;
    protected final GridCacheSharedContext ctx;
    protected final IgniteLogger log;
    private final IgniteInternalFuture finFut;
    protected IgnitePredicate<GridCacheEntryInfo> preloadPred;

    public GridCachePreloaderAdapter(CacheGroupContext grp) {
        assert (grp != null);
        this.grp = grp;
        this.ctx = grp.shared();
        this.log = this.ctx.logger(this.getClass());
        this.finFut = new GridFinishedFuture<Boolean>(true);
    }

    @Override
    public void start() throws IgniteCheckedException {
    }

    @Override
    public void onKernalStop() {
    }

    @Override
    public IgniteInternalFuture<Boolean> forceRebalance() {
        return new GridFinishedFuture<Boolean>(true);
    }

    @Override
    public boolean needForceKeys() {
        return false;
    }

    @Override
    public void onReconnected() {
    }

    @Override
    public void preloadPredicate(IgnitePredicate<GridCacheEntryInfo> preloadPred) {
        this.preloadPred = preloadPred;
    }

    @Override
    public IgnitePredicate<GridCacheEntryInfo> preloadPredicate() {
        return this.preloadPred;
    }

    @Override
    public IgniteInternalFuture<Object> startFuture() {
        return this.finFut;
    }

    @Override
    public IgniteInternalFuture<?> syncFuture() {
        return this.finFut;
    }

    @Override
    public IgniteInternalFuture<Boolean> rebalanceFuture() {
        return this.finFut;
    }

    @Override
    public void handleSupplyMessage(UUID id, GridDhtPartitionSupplyMessage s) {
    }

    @Override
    public void handleDemandMessage(int idx, UUID id, GridDhtPartitionDemandMessage d) {
    }

    @Override
    public GridDhtFuture<Object> request(GridCacheContext ctx, Collection<KeyCacheObject> keys, AffinityTopologyVersion topVer) {
        return null;
    }

    @Override
    public GridDhtFuture<Object> request(GridCacheContext ctx, GridNearAtomicAbstractUpdateRequest req, AffinityTopologyVersion topVer) {
        return null;
    }

    @Override
    public void onInitialExchangeComplete(@Nullable Throwable err) {
    }

    @Override
    public boolean rebalanceRequired(GridDhtPartitionsExchangeFuture exchFut) {
        return true;
    }

    @Override
    public GridDhtPreloaderAssignments generateAssignments(GridDhtPartitionExchangeId exchId, GridDhtPartitionsExchangeFuture exchFut) {
        return null;
    }

    @Override
    public GridDhtPartitionDemander.RebalanceFuture addAssignments(GridDhtPreloaderAssignments assignments, boolean forcePreload, long rebalanceId, GridDhtPartitionDemander.RebalanceFuture next, @Nullable GridCompoundFuture<Boolean, Boolean> forcedRebFut, GridCompoundFuture<Boolean, Boolean> compatibleRebFut) {
        return null;
    }

    @Override
    public void onTopologyChanged(GridDhtPartitionsExchangeFuture lastFut) {
    }

    @Override
    public void dumpDebugInfo() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public long timeout() {
        return this.grp.shared().gridConfig().getRebalanceTimeout() == 10000L ? this.grp.config().getRebalanceTimeout() : this.grp.shared().gridConfig().getRebalanceTimeout();
    }

    @Override
    public long batchesPrefetchCount() {
        return this.grp.shared().gridConfig().getRebalanceBatchesPrefetchCount() == 2L ? this.grp.config().getRebalanceBatchesPrefetchCount() : this.grp.shared().gridConfig().getRebalanceBatchesPrefetchCount();
    }

    @Override
    public long throttle() {
        return this.grp.shared().gridConfig().getRebalanceThrottle() == 0L ? this.grp.config().getRebalanceThrottle() : this.grp.shared().gridConfig().getRebalanceThrottle();
    }

    @Override
    public int batchSize() {
        return this.grp.shared().gridConfig().getRebalanceBatchSize() == 524288 ? this.grp.config().getRebalanceBatchSize() : this.grp.shared().gridConfig().getRebalanceBatchSize();
    }

    @Override
    public void finishPreloading(AffinityTopologyVersion topVer, long rebalanceId) {
    }
}

