/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.checker.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.checker.objects.ReconciliationAffectedEntries;
import org.apache.ignite.internal.processors.cache.checker.objects.ReconciliationAffectedEntriesExtended;
import org.apache.ignite.internal.processors.cache.checker.objects.VersionedKey;
import org.apache.ignite.internal.processors.cache.checker.objects.VersionedValue;
import org.apache.ignite.internal.processors.cache.checker.util.ConsistencyCheckUtils;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationDataRowMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationKeyMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationRepairMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationSkippedEntityHolder;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationValueMeta;
import org.apache.ignite.internal.processors.cache.verify.RepairMeta;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.U;

public interface ReconciliationResultCollector {
    public void appendSkippedEntries(String var1, int var2, Map<VersionedKey, Map<UUID, VersionedValue>> var3);

    public void appendConflictedEntries(String var1, int var2, Map<KeyCacheObject, Map<UUID, GridCacheVersion>> var3, Map<KeyCacheObject, Map<UUID, VersionedValue>> var4);

    public void appendRepairedEntries(String var1, int var2, Map<VersionedKey, RepairMeta> var3);

    public void onPartitionProcessed(String var1, int var2);

    public ReconciliationAffectedEntries result();

    public File flushResultsToFile(LocalDateTime var1);

    public static class Compact
    extends Simple {
        private final AtomicInteger totalKeysCnt = new AtomicInteger();
        private final Map<String, String> tmpFiles = new ConcurrentHashMap<String, String>();
        private final Map<UUID, String> nodesIdsToConsistentIdsMap = this.ignite.cluster().nodes().stream().collect(Collectors.toMap(ClusterNode::id, n -> n.consistentId().toString()));
        private final long sesId;

        Compact(IgniteEx ignite, IgniteLogger log, long sesId, boolean includeSensitive) throws IgniteCheckedException {
            super(ignite, log, includeSensitive);
            this.sesId = sesId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPartitionProcessed(String cacheName, int partId) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition has been processed [cacheName=" + cacheName + ", partId=" + partId + ']');
            }
            List meta = null;
            Map map = this.inconsistentKeys;
            synchronized (map) {
                Map c = (Map)this.inconsistentKeys.get(cacheName);
                if (c != null) {
                    meta = (List)c.remove(partId);
                }
            }
            if (meta != null && !meta.isEmpty()) {
                this.totalKeysCnt.addAndGet(meta.size());
                this.storePartition(cacheName, partId, meta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReconciliationAffectedEntries result() {
            Map map = this.inconsistentKeys;
            synchronized (map) {
                Map map2 = this.skippedEntries;
                synchronized (map2) {
                    return new ReconciliationAffectedEntriesExtended(this.totalKeysCnt.get(), 0, this.skippedEntries.size());
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public File flushResultsToFile(LocalDateTime startTime) {
            if (this.tmpFiles.isEmpty()) return null;
            try {
                File file2 = ConsistencyCheckUtils.createLocalResultFile(this.ignite.context().discovery().localNode(), startTime);
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file2)));){
                    this.printFileHead(out, this.totalKeysCnt.get());
                    for (Map.Entry<String, String> e : this.tmpFiles.entrySet()) {
                        out.println(e.getKey());
                        try (BufferedReader reader = new BufferedReader(new FileReader(e.getValue()));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                out.println(line);
                            }
                        }
                        Files.delete(Paths.get(e.getValue(), new String[0]));
                    }
                    out.flush();
                    File file = file2;
                    return file;
                }
                catch (IOException e) {
                    this.log.error("Unable to write report to file " + e.getMessage());
                    return null;
                }
            }
            catch (IOException | IgniteCheckedException e) {
                this.log.error("Unable to create file " + e.getMessage());
            }
            return null;
        }

        private void printFileHead(PrintWriter out, long inconsistentKeyCnt) {
            out.println();
            out.println("INCONSISTENT KEYS: " + inconsistentKeyCnt);
            out.println();
            out.println("<cacheName>");
            out.println("\t<partitionId>");
            out.println("\t\t<key>");
            out.println("\t\t\t<nodeConsistentId>, <nodeId>: <value> <version>");
            out.println("\t\t\t...");
            out.println("\t\t\t<info on whether confilct is fixed>");
            out.println();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storePartition(String cacheName, int partId, List<PartitionReconciliationDataRowMeta> meta) {
            String maskId = U.maskForFileName(this.ignite.context().discovery().localNode().consistentId().toString());
            String fileName = this.tmpFiles.computeIfAbsent(cacheName, d -> {
                File file = new File(this.reconciliationDir.getPath() + File.separatorChar + maskId + '-' + this.sesId + '-' + cacheName + ".txt");
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    this.log.error("Cannot create a file for storing partition's data [cacheName=" + cacheName + ", partId" + partId + ']');
                    return null;
                }
                return file.getAbsolutePath();
            });
            if (fileName == null) {
                return;
            }
            String string = fileName;
            synchronized (string) {
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));){
                    out.print('\t');
                    out.println(partId);
                    for (PartitionReconciliationDataRowMeta row : meta) {
                        out.print(ReconciliationAffectedEntries.getConflictsAsString(row, this.nodesIdsToConsistentIdsMap, true));
                    }
                }
                catch (IOException e) {
                    this.log.error("Cannot store partition's data [cacheName=" + cacheName + ", partId" + partId + ']');
                }
            }
        }
    }

    public static class Simple
    implements ReconciliationResultCollector {
        protected final IgniteEx ignite;
        protected final IgniteLogger log;
        protected final boolean includeSensitive;
        protected final File reconciliationDir;
        protected final Map<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> inconsistentKeys = new HashMap<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>>();
        protected final Map<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>> skippedEntries = new HashMap<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Simple(IgniteEx ignite, IgniteLogger log, boolean includeSensitive) throws IgniteCheckedException {
            this.ignite = ignite;
            this.log = log;
            this.includeSensitive = includeSensitive;
            Class<ReconciliationResultCollector> clazz = ReconciliationResultCollector.class;
            synchronized (ReconciliationResultCollector.class) {
                this.reconciliationDir = new File(U.defaultWorkDirectory() + File.separatorChar + "reconciliation");
                if (!this.reconciliationDir.exists()) {
                    this.reconciliationDir.mkdir();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendSkippedEntries(String cacheName, int partId, Map<VersionedKey, Map<UUID, VersionedValue>> keys) {
            CacheObjectContext ctx = this.ignite.cachex(cacheName).context().cacheObjectContext();
            Map<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>> map = this.skippedEntries;
            synchronized (map) {
                HashSet<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>> data = new HashSet<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>();
                for (VersionedKey keyVersion : keys.keySet()) {
                    try {
                        byte[] bytes = keyVersion.key().valueBytes(ctx);
                        String strVal = ConsistencyCheckUtils.objectStringView(ctx, (CacheObject)keyVersion.key().value(ctx, false));
                        PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta> holder = new PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>(new PartitionReconciliationKeyMeta(bytes, strVal), PartitionReconciliationSkippedEntityHolder.SkippingReason.KEY_WAS_NOT_REPAIRED);
                        data.add(holder);
                    }
                    catch (Exception e) {
                        this.log.error("Serialization problem.", e);
                    }
                }
                this.skippedEntries.computeIfAbsent(cacheName, k -> new HashMap()).computeIfAbsent(partId, l -> new HashSet()).addAll(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendConflictedEntries(String cacheName, int partId, Map<KeyCacheObject, Map<UUID, GridCacheVersion>> conflicts, Map<KeyCacheObject, Map<UUID, VersionedValue>> actualKeys) {
            CacheObjectContext ctx = this.ignite.cachex(cacheName).context().cacheObjectContext();
            Map<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> map = this.inconsistentKeys;
            synchronized (map) {
                try {
                    this.inconsistentKeys.computeIfAbsent(cacheName, k -> new HashMap()).computeIfAbsent(partId, k -> new ArrayList()).addAll(ConsistencyCheckUtils.mapPartitionReconciliation(conflicts, actualKeys, ctx));
                }
                catch (IgniteCheckedException e) {
                    this.log.error("Broken key can't be added to result. ", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendRepairedEntries(String cacheName, int partId, Map<VersionedKey, RepairMeta> repairedKeys) {
            CacheObjectContext ctx = this.ignite.cachex(cacheName).context().cacheObjectContext();
            Map<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> map = this.inconsistentKeys;
            synchronized (map) {
                try {
                    ArrayList<PartitionReconciliationDataRowMeta> res = new ArrayList<PartitionReconciliationDataRowMeta>();
                    for (Map.Entry<VersionedKey, RepairMeta> entry : repairedKeys.entrySet()) {
                        HashMap<UUID, PartitionReconciliationValueMeta> valMap = new HashMap<UUID, PartitionReconciliationValueMeta>();
                        for (Map.Entry<UUID, VersionedValue> uuidBasedEntry : entry.getValue().getPreviousValue().entrySet()) {
                            Optional<CacheObject> cacheObjOpt = Optional.ofNullable(uuidBasedEntry.getValue().value());
                            valMap.put(uuidBasedEntry.getKey(), cacheObjOpt.isPresent() ? new PartitionReconciliationValueMeta(cacheObjOpt.get().valueBytes(ctx), cacheObjOpt.map(o -> ConsistencyCheckUtils.objectStringView(ctx, o)).orElse(null), uuidBasedEntry.getValue().version()) : null);
                        }
                        KeyCacheObject key = entry.getKey().key();
                        key.finishUnmarshal(ctx, null);
                        RepairMeta repairMeta = entry.getValue();
                        Optional<CacheObject> cacheObjRepairValOpt = Optional.ofNullable(repairMeta.value());
                        res.add(new PartitionReconciliationDataRowMeta(new PartitionReconciliationKeyMeta(key.valueBytes(ctx), ConsistencyCheckUtils.objectStringView(ctx, key)), valMap, new PartitionReconciliationRepairMeta(repairMeta.fixed(), cacheObjRepairValOpt.isPresent() ? new PartitionReconciliationValueMeta(cacheObjRepairValOpt.get().valueBytes(ctx), cacheObjRepairValOpt.map(o -> ConsistencyCheckUtils.objectStringView(ctx, o)).orElse(null), null) : null, repairMeta.repairAlg())));
                    }
                    this.inconsistentKeys.computeIfAbsent(cacheName, k -> new HashMap()).computeIfAbsent(partId, k -> new ArrayList()).addAll(res);
                }
                catch (IgniteCheckedException e) {
                    this.log.error("Broken key can't be added to result. ", e);
                }
            }
        }

        @Override
        public void onPartitionProcessed(String cacheName, int partId) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReconciliationAffectedEntries result() {
            Map<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> map = this.inconsistentKeys;
            synchronized (map) {
                Map<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>> map2 = this.skippedEntries;
                synchronized (map2) {
                    return new ReconciliationAffectedEntries(this.ignite.cluster().nodes().stream().collect(Collectors.toMap(ClusterNode::id, n -> n.consistentId().toString())), this.inconsistentKeys, this.skippedEntries);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public File flushResultsToFile(LocalDateTime startTime) {
            ReconciliationAffectedEntries res = this.result();
            if (res == null) return null;
            if (res.isEmpty()) return null;
            try {
                File file2 = ConsistencyCheckUtils.createLocalResultFile(this.ignite.context().discovery().localNode(), startTime);
                try (PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file2)));){
                    res.print(pw::write, this.includeSensitive);
                    pw.flush();
                    File file = file2;
                    return file;
                }
                catch (IOException e) {
                    this.log.error("Unable to write report to file " + e.getMessage());
                    return null;
                }
            }
            catch (IOException | IgniteCheckedException e) {
                this.log.error("Unable to create file " + e.getMessage());
            }
            return null;
        }
    }
}

