/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.checker.tasks;

import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.checker.objects.VersionedValue;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;

public class RepairEntryProcessor
implements EntryProcessor {
    private Object val;
    private Map<UUID, VersionedValue> data;
    private long rmvQueueMaxSize;
    private boolean forceRepair;
    private AffinityTopologyVersion startTopVer;

    public RepairEntryProcessor(Object val, Map<UUID, VersionedValue> data, long rmvQueueMaxSize, boolean forceRepair, AffinityTopologyVersion startTopVer) {
        this.val = val;
        this.data = data;
        this.rmvQueueMaxSize = rmvQueueMaxSize;
        this.forceRepair = forceRepair;
        this.startTopVer = startTopVer;
    }

    public Object process(MutableEntry entry, Object ... arguments) throws EntryProcessorException {
        GridCacheContext cctx = this.cacheContext(entry);
        GridCacheVersion currKeyGridCacheVer = this.keyVersion(entry);
        if (this.topologyChanged(cctx, this.startTopVer)) {
            throw new EntryProcessorException("Topology version was changed");
        }
        UUID locNodeId = cctx.localNodeId();
        VersionedValue versionedVal = this.data.get(locNodeId);
        if (versionedVal != null) {
            if (currKeyGridCacheVer.compareTo(versionedVal.version()) == 0) {
                if (this.val == null) {
                    entry.remove();
                } else {
                    entry.setValue(this.val);
                }
                return RepairStatus.SUCCESS;
            }
            return RepairStatus.CONCURRENT_MODIFICATION;
        }
        if (currKeyGridCacheVer.compareTo(new GridCacheVersion(0, 0, 0L)) == 0) {
            if (cctx.config().getAtomicityMode() != CacheAtomicityMode.ATOMIC) {
                if (this.val == null) {
                    entry.remove();
                } else {
                    entry.setValue(this.val);
                }
                return RepairStatus.SUCCESS;
            }
        } else {
            return RepairStatus.CONCURRENT_MODIFICATION;
        }
        if (this.forceRepair) {
            if (this.val == null) {
                entry.remove();
            } else {
                entry.setValue(this.val);
            }
            return RepairStatus.SUCCESS;
        }
        return RepairStatus.FAIL;
    }

    protected GridCacheContext cacheContext(MutableEntry entry) {
        return (GridCacheContext)entry.unwrap(GridCacheContext.class);
    }

    protected boolean topologyChanged(GridCacheContext cctx, AffinityTopologyVersion expTop) {
        AffinityTopologyVersion currTopVer = cctx.affinity().affinityTopologyVersion();
        return !cctx.shared().exchange().lastAffinityChangedTopologyVersion(currTopVer).equals(expTop);
    }

    protected GridCacheVersion keyVersion(MutableEntry entry) {
        CacheEntry verEntry = (CacheEntry)entry.unwrap(CacheEntry.class);
        return (GridCacheVersion)verEntry.version();
    }

    protected long updateCounter(GridCacheContext cctx, Object affKey) {
        return cctx.topology().localPartition(cctx.cache().affinity().partition(affKey)).updateCounter();
    }

    private long minValue(Function<VersionedValue, Long> mapper) {
        return this.data.values().stream().mapToLong(mapper::apply).min().orElseThrow(() -> new IllegalStateException("Unreachable state [mapper = " + mapper.getClass().getName() + ", data=" + this.data + "]."));
    }

    public static enum RepairStatus {
        SUCCESS,
        FAIL,
        CONCURRENT_MODIFICATION;

    }
}

