/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.ReaderArguments;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridCompoundIdentityFuture;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridDhtGetFuture<K, V>
extends GridCompoundIdentityFuture<Collection<GridCacheEntryInfo>>
implements GridDhtFuture<Collection<GridCacheEntryInfo>> {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private long msgId;
    private UUID reader;
    private boolean readThrough;
    private GridCacheContext<K, V> cctx;
    private Map<KeyCacheObject, Boolean> keys;
    private int[] parts;
    private IgniteUuid futId;
    private GridCacheVersion ver;
    private AffinityTopologyVersion topVer;
    private Collection<Integer> retries;
    private UUID subjId;
    private int taskNameHash;
    private IgniteCacheExpiryPolicy expiryPlc;
    private boolean skipVals;
    private final boolean recovery;
    private final boolean addReaders;
    private final String txLbl;
    private final MvccSnapshot mvccSnapshot;

    public GridDhtGetFuture(GridCacheContext<K, V> cctx, long msgId, UUID reader, Map<KeyCacheObject, Boolean> keys, boolean readThrough, @NotNull AffinityTopologyVersion topVer, @Nullable UUID subjId, int taskNameHash, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean recovery, boolean addReaders, @Nullable String txLbl, MvccSnapshot mvccSnapshot) {
        super(CU.collectionsReducer(keys.size()));
        assert (reader != null);
        assert (!F.isEmpty(keys));
        this.reader = reader;
        this.cctx = cctx;
        this.msgId = msgId;
        this.keys = keys;
        this.readThrough = readThrough;
        this.topVer = topVer;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.expiryPlc = expiryPlc;
        this.skipVals = skipVals;
        this.recovery = recovery;
        this.addReaders = addReaders;
        this.txLbl = txLbl;
        this.mvccSnapshot = mvccSnapshot;
        this.futId = IgniteUuid.randomUuid();
        this.ver = cctx.cache().nextVersion();
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridDhtGetFuture.class);
        }
    }

    void init() {
        this.span = this.cctx.kernalContext().tracing().create(SpanType.CACHE_API_DHT_GET_FUTURE, MTC.span());
        try (MTC.TraceSurroundings ignored = MTC.supportContinual(this.span);){
            GridDhtFuture<Object> fut = this.cctx.group().preloader().request(this.cctx, this.keys.keySet(), this.topVer);
            assert (!this.cctx.mvccEnabled() || fut == null);
            if (fut != null) {
                if (!F.isEmpty(fut.invalidPartitions())) {
                    if (this.retries == null) {
                        this.retries = new HashSet<Integer>();
                    }
                    this.retries.addAll(fut.invalidPartitions());
                }
                fut.listen(new CI1<IgniteInternalFuture<Object>>(){

                    @Override
                    public void apply(IgniteInternalFuture<Object> fut) {
                        try {
                            fut.get();
                        }
                        catch (IgniteCheckedException e) {
                            if (log.isDebugEnabled()) {
                                log.debug("Failed to request keys from preloader [keys=" + GridDhtGetFuture.this.keys + ", err=" + e + ']');
                            }
                            GridDhtGetFuture.this.onDone(e);
                            return;
                        }
                        GridDhtGetFuture.this.map0(GridDhtGetFuture.this.keys, true);
                        GridDhtGetFuture.this.markInitialized();
                    }
                });
            } else {
                this.map0(this.keys, false);
                this.markInitialized();
            }
        }
    }

    @Override
    public Collection<Integer> invalidPartitions() {
        return this.retries == null ? Collections.emptyList() : this.retries;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public GridCacheVersion version() {
        return this.ver;
    }

    @Override
    public boolean onDone(Collection<GridCacheEntryInfo> res, Throwable err) {
        if (super.onDone(res, err)) {
            if (this.parts != null) {
                this.cctx.topology().releasePartitions(this.parts);
            }
            return true;
        }
        return false;
    }

    private void map0(Map<KeyCacheObject, Boolean> keys, boolean forceKeys) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.cctx.kernalContext().tracing().create(SpanType.CACHE_API_GET_MAP, this.span));){
            MTC.span().addTag("topology.version", () -> Objects.toString(this.topVer));
            LinkedHashMap<KeyCacheObject, Boolean> mappedKeys = null;
            for (Map.Entry<KeyCacheObject, Boolean> key : keys.entrySet()) {
                int part = this.cctx.affinity().partition(key.getKey());
                if (this.retries != null && this.retries.contains(part)) continue;
                if (!this.map(key.getKey(), forceKeys)) {
                    if (this.retries == null) {
                        this.retries = new HashSet<Integer>();
                    }
                    this.retries.add(part);
                    if (mappedKeys != null) continue;
                    mappedKeys = U.newLinkedHashMap(keys.size());
                    for (Map.Entry<KeyCacheObject, Boolean> key1 : keys.entrySet()) {
                        if (key1.getKey() == key.getKey()) break;
                        mappedKeys.put(key.getKey(), key1.getValue());
                    }
                    continue;
                }
                if (mappedKeys == null) continue;
                mappedKeys.put(key.getKey(), key.getValue());
            }
            IgniteInternalFuture<Collection<GridCacheEntryInfo>> fut = this.getAsync(mappedKeys == null ? keys : mappedKeys);
            if (fut.isDone() && !this.hasFutures()) {
                if (fut.error() != null) {
                    this.onDone(fut.error());
                } else {
                    this.onDone(fut.result());
                }
                return;
            }
            this.add(fut);
        }
    }

    private boolean map(KeyCacheObject key, boolean forceKeys) {
        try {
            GridDhtLocalPartition part;
            boolean noOwners;
            int keyPart = this.cctx.affinity().partition(key);
            if (this.cctx.mvccEnabled() && (noOwners = this.cctx.topology().owners(keyPart, this.topVer).isEmpty())) {
                forceKeys = true;
            }
            GridDhtLocalPartition gridDhtLocalPartition = part = this.topVer.topologyVersion() > 0L ? this.cache().topology().localPartition(keyPart, this.topVer, true) : this.cache().topology().localPartition(keyPart);
            if (part == null) {
                return false;
            }
            if (this.parts == null || !F.contains(this.parts, part.id())) {
                if (part.reserve()) {
                    if (forceKeys || part.state() == GridDhtPartitionState.OWNING || part.state() == GridDhtPartitionState.LOST) {
                        this.parts = this.parts == null ? new int[1] : Arrays.copyOf(this.parts, this.parts.length + 1);
                        this.parts[this.parts.length - 1] = part.id();
                        return true;
                    }
                    part.release();
                    return false;
                }
                return false;
            }
            return true;
        }
        catch (GridDhtInvalidPartitionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Attempted to create a partition which does not belong to local node, will remap [key=" + key + ", part=" + e.partition() + ']');
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<Collection<GridCacheEntryInfo>> getAsync(final Map<KeyCacheObject, Boolean> keys) {
        IgniteInternalFuture<Object> fut;
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture<Collection<GridCacheEntryInfo>>(Collections.emptyList());
        }
        String taskName0 = this.cctx.kernalContext().job().currentTaskName();
        if (taskName0 == null) {
            taskName0 = this.cctx.kernalContext().task().resolveTaskName(this.taskNameHash);
        }
        final String taskName = taskName0;
        GridCompoundFuture<Boolean, Boolean> txFut = null;
        ReaderArguments readerArgs = null;
        if (this.addReaders && !this.skipVals && !this.cctx.localNodeId().equals(this.reader)) {
            block8: for (Map.Entry<KeyCacheObject, Boolean> k : keys.entrySet()) {
                if (!k.getValue().booleanValue()) continue;
                while (true) {
                    GridDhtCacheEntry e = this.cache().entryExx(k.getKey(), this.topVer);
                    try {
                        IgniteInternalFuture<Boolean> f;
                        boolean addReader;
                        if (e.obsolete()) continue;
                        boolean bl = addReader = !e.deleted();
                        if (addReader) {
                            e.unswap(false);
                            if (readerArgs == null) {
                                readerArgs = new ReaderArguments(this.reader, this.msgId, this.topVer);
                            }
                        }
                        if ((f = addReader ? e.addReader(this.reader, this.msgId, this.topVer) : null) == null) continue block8;
                        if (txFut == null) {
                            txFut = new GridCompoundFuture<Boolean, Boolean>(CU.boolReducer());
                        }
                        txFut.add(f);
                        continue block8;
                    }
                    catch (IgniteCheckedException err) {
                        GridFinishedFuture<Collection<GridCacheEntryInfo>> gridFinishedFuture = new GridFinishedFuture<Collection<GridCacheEntryInfo>>(err);
                        return gridFinishedFuture;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Got removed entry when getting a DHT value: " + e);
                        continue;
                    }
                    finally {
                        e.touch();
                        continue;
                    }
                    break;
                }
            }
            if (txFut != null) {
                txFut.markInitialized();
            }
        }
        if (txFut == null || txFut.isDone()) {
            fut = this.cache().getDhtAllAsync(keys.keySet(), readerArgs, this.readThrough, this.subjId, taskName, this.expiryPlc, this.skipVals, this.recovery, this.txLbl, this.mvccSnapshot);
        } else {
            final ReaderArguments args = readerArgs;
            fut = new GridEmbeddedFuture<Map<KeyCacheObject, EntryGetResult>, Boolean>(txFut, new C2<Boolean, Exception, IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>>>(){

                @Override
                public IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>> apply(Boolean b, Exception e) {
                    if (e != null) {
                        throw new GridClosureException(e);
                    }
                    return GridDhtGetFuture.this.cache().getDhtAllAsync(keys.keySet(), args, GridDhtGetFuture.this.readThrough, GridDhtGetFuture.this.subjId, taskName, GridDhtGetFuture.this.expiryPlc, GridDhtGetFuture.this.skipVals, GridDhtGetFuture.this.recovery, GridDhtGetFuture.this.txLbl, GridDhtGetFuture.this.mvccSnapshot);
                }
            });
        }
        if (fut.isDone()) {
            if (fut.error() != null) {
                this.onDone(fut.error());
            } else {
                return new GridFinishedFuture<Collection<GridCacheEntryInfo>>(this.toEntryInfos((Map)fut.result()));
            }
        }
        return new GridEmbeddedFuture<Collection<GridCacheEntryInfo>, Object>(new C2<Map<KeyCacheObject, EntryGetResult>, Exception, Collection<GridCacheEntryInfo>>(){

            @Override
            public Collection<GridCacheEntryInfo> apply(Map<KeyCacheObject, EntryGetResult> map, Exception e) {
                if (e != null) {
                    GridDhtGetFuture.this.onDone(e);
                    return Collections.emptyList();
                }
                return GridDhtGetFuture.this.toEntryInfos(map);
            }
        }, fut);
    }

    private Collection<GridCacheEntryInfo> toEntryInfos(Map<KeyCacheObject, EntryGetResult> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GridCacheEntryInfo> infos = new ArrayList<GridCacheEntryInfo>(map.size());
        for (Map.Entry<KeyCacheObject, EntryGetResult> entry : map.entrySet()) {
            EntryGetResult val = entry.getValue();
            assert (val != null);
            GridCacheEntryInfo info = new GridCacheEntryInfo();
            info.cacheId(this.cctx.cacheId());
            info.key(entry.getKey());
            info.value(this.skipVals ? null : (CacheObject)val.value());
            info.version(val.version());
            info.expireTime(val.expireTime());
            info.ttl(val.ttl());
            infos.add(info);
        }
        return infos;
    }

    private GridDhtCacheAdapter<K, V> cache() {
        return (GridDhtCacheAdapter)this.cctx.cache();
    }
}

