/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointReadWriteLock;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.Checkpointer;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CheckpointTimeoutLock {
    protected final IgniteLogger log;
    private final FailureProcessor failureProcessor;
    private final Supplier<Collection<DataRegion>> dataRegions;
    private final CheckpointReadWriteLock checkpointReadWriteLock;
    private final Checkpointer checkpointer;
    private volatile long checkpointReadLockTimeout;
    private boolean stop;

    CheckpointTimeoutLock(Function<Class<?>, IgniteLogger> logger, FailureProcessor processor, Supplier<Collection<DataRegion>> regions, CheckpointReadWriteLock lock, Checkpointer checkpointer, long checkpointReadLockTimeout) {
        this.log = logger.apply(this.getClass());
        this.failureProcessor = processor;
        this.dataRegions = regions;
        this.checkpointReadWriteLock = lock;
        this.checkpointer = checkpointer;
        this.checkpointReadLockTimeout = checkpointReadLockTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointReadLock() {
        block22: {
            if (this.checkpointReadWriteLock.isWriteLockHeldByCurrentThread()) {
                return;
            }
            long timeout = this.checkpointReadLockTimeout;
            long start = U.currentTimeMillis();
            boolean interrupted = false;
            block10: while (true) {
                while (true) {
                    try {
                        while (true) {
                            if (timeout > 0L && U.currentTimeMillis() - start >= timeout) {
                                this.failCheckpointReadLock();
                            }
                            try {
                                if (timeout > 0L) {
                                    if (!this.checkpointReadWriteLock.tryReadLock(timeout - (U.currentTimeMillis() - start), TimeUnit.MILLISECONDS)) {
                                        this.failCheckpointReadLock();
                                    }
                                } else {
                                    this.checkpointReadWriteLock.readLock();
                                }
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                                continue;
                            }
                            if (this.stop) {
                                this.checkpointReadWriteLock.readUnlock();
                                throw new IgniteException(new NodeStoppingException("Failed to perform cache update: node is stopping."));
                            }
                            if (this.checkpointReadWriteLock.getReadHoldCount() > 1 || this.safeToUpdatePageMemories()) break block22;
                            if (this.checkpointer.runner() == null) {
                                break block22;
                            }
                            CheckpointProgress checkpoint = this.checkpointer.scheduleCheckpoint(0L, "too many dirty pages");
                            this.checkpointReadWriteLock.readUnlock();
                            if (timeout > 0L && U.currentTimeMillis() - start >= timeout) {
                                this.failCheckpointReadLock();
                            }
                            try {
                                checkpoint.futureFor(CheckpointState.LOCK_RELEASED).getUninterruptibly();
                                continue block10;
                            }
                            catch (IgniteFutureTimeoutCheckedException e) {
                                this.failCheckpointReadLock();
                                continue;
                            }
                            catch (IgniteCheckedException e) {
                                throw new IgniteException("Failed to wait for checkpoint begin.", e);
                            }
                            break;
                        }
                    }
                    catch (CheckpointReadLockTimeoutException e) {
                        this.log.error(e.getMessage(), e);
                        timeout = 0L;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public boolean tryCheckpointReadLock() {
        return this.checkpointReadWriteLock.tryReadLock();
    }

    private boolean safeToUpdatePageMemories() {
        Collection<DataRegion> memPlcs = this.dataRegions.get();
        if (memPlcs == null) {
            return true;
        }
        for (DataRegion memPlc : memPlcs) {
            PageMemoryEx pageMemEx;
            if (!memPlc.config().isPersistenceEnabled() || (pageMemEx = (PageMemoryEx)memPlc.pageMemory()).safeToUpdate()) continue;
            return false;
        }
        return true;
    }

    public void checkpointReadUnlock() {
        this.checkpointReadWriteLock.readUnlock();
    }

    private void failCheckpointReadLock() throws CheckpointReadLockTimeoutException, IgniteException {
        String msg = "Checkpoint read lock acquisition has been timed out.";
        IgniteException e = new IgniteException(msg);
        if (this.failureProcessor.process(new FailureContext(FailureType.SYSTEM_CRITICAL_OPERATION_TIMEOUT, e))) {
            throw e;
        }
        throw new CheckpointReadLockTimeoutException(msg);
    }

    public long checkpointReadLockTimeout() {
        return this.checkpointReadLockTimeout;
    }

    public void checkpointReadLockTimeout(long val) {
        this.checkpointReadLockTimeout = val;
    }

    public boolean checkpointLockIsHeldByThread() {
        return this.checkpointReadWriteLock.checkpointLockIsHeldByThread();
    }

    public void stop() {
        this.checkpointReadWriteLock.writeLock();
        try {
            this.stop = true;
        }
        finally {
            this.checkpointReadWriteLock.writeUnlock();
        }
    }

    public void start() {
        this.stop = false;
    }

    private static class CheckpointReadLockTimeoutException
    extends IgniteCheckedException {
        private static final long serialVersionUID = 0L;

        private CheckpointReadLockTimeoutException(String msg) {
            super(msg);
        }
    }
}

