/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.client.util.GridConcurrentHashSet;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.store.PageStoreCollection;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.DefragmentationFileUtils;
import org.apache.ignite.internal.processors.cache.persistence.file.EncryptedFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FileVersionCheckingFactory;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageReadWriteManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageReadWriteManagerImpl;
import org.apache.ignite.internal.util.GridStripedReadWriteLock;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePageStoreManager
extends GridCacheSharedManagerAdapter
implements IgnitePageStoreManager,
PageStoreCollection {
    public static final String FILE_SUFFIX = ".bin";
    public static final String ZIP_SUFFIX = ".zip";
    public static final String TMP_SUFFIX = ".tmp";
    public static final String PART_FILE_PREFIX = "part-";
    public static final String INDEX_FILE_PREFIX = "index";
    public static final String INDEX_FILE_NAME = "index.bin";
    public static final String PART_FILE_TEMPLATE = "part-%d.bin";
    public static final String CACHE_DIR_PREFIX = "cache-";
    public static final String CACHE_GRP_DIR_PREFIX = "cacheGroup-";
    public static final String CACHE_DATA_FILENAME = "cache_data.dat";
    public static final String CACHE_DATA_TMP_FILENAME = "cache_data.dat.tmp";
    public static final String DFLT_STORE_DIR = "db";
    public static final String META_STORAGE_NAME = "metastorage";
    public static final PathMatcher TMP_FILE_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.tmp");
    public static final String CORRUPTED_DATA_FILES_MNTC_TASK_NAME = "corrupted-cache-data-files-task";
    private final Marshaller marshaller;
    private final PageReadWriteManager pmPageMgr;
    private final LongOperationAsyncExecutor cleanupAsyncExecutor;
    private final Map<Integer, CacheStoreHolder> idxCacheStores;
    private final IgniteConfiguration igniteCfg;
    private FileIOFactory pageStoreFileIoFactory;
    private FileIOFactory pageStoreV1FileIoFactory;
    private final DataStorageConfiguration dsCfg;
    private File storeWorkDir;
    private final Set<Integer> grpsWithoutIdx = Collections.newSetFromMap(new ConcurrentHashMap());
    private final GridStripedReadWriteLock initDirLock = new GridStripedReadWriteLock(Math.max(Runtime.getRuntime().availableProcessors(), 8));

    public FilePageStoreManager(GridKernalContext ctx) {
        this.igniteCfg = ctx.config();
        this.cleanupAsyncExecutor = new LongOperationAsyncExecutor(ctx.igniteInstanceName(), ctx.config().getGridLogger());
        this.idxCacheStores = new IdxCacheStores<Integer, CacheStoreHolder>(this.cleanupAsyncExecutor);
        DataStorageConfiguration dsCfg = this.igniteCfg.getDataStorageConfiguration();
        assert (dsCfg != null);
        this.dsCfg = dsCfg;
        this.pageStoreV1FileIoFactory = this.pageStoreFileIoFactory = dsCfg.getFileIOFactory();
        this.marshaller = MarshallerUtils.jdkMarshaller(ctx.igniteInstanceName());
        this.pmPageMgr = new PageReadWriteManagerImpl(ctx, this, FilePageStoreManager.class.getSimpleName());
    }

    @Override
    public void start0() throws IgniteCheckedException {
        File[] files;
        GridKernalContext ctx = this.cctx.kernalContext();
        if (ctx.clientNode()) {
            return;
        }
        PdsFolderSettings folderSettings = ctx.pdsFolderResolver().resolveFolders();
        this.storeWorkDir = new File(folderSettings.persistentStoreRootPath(), folderSettings.folderName());
        U.ensureDirectory(this.storeWorkDir, "page store work directory", this.log);
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null && this.storeWorkDir.getAbsolutePath().startsWith(tmpDir)) {
            this.log.warning("Persistence store directory is in the temp directory and may be cleaned.To avoid this set \"IGNITE_HOME\" environment variable properly or change location of persistence directories in data storage configuration (see DataStorageConfiguration#walPath, DataStorageConfiguration#walArchivePath, DataStorageConfiguration#storagePath properties). Current persistence store directory is: [" + this.storeWorkDir.getAbsolutePath() + "]");
        }
        for (File file : files = this.storeWorkDir.listFiles()) {
            File[] tmpFiles;
            if (!file.isDirectory() || (tmpFiles = file.listFiles((k, v) -> v.endsWith(CACHE_DATA_TMP_FILENAME))) == null) continue;
            for (File tmpFile : tmpFiles) {
                if (tmpFile.delete()) continue;
                this.log.warning("Failed to delete temporary cache config file(make sure Ignite process has enough rights):" + file.getName());
            }
        }
    }

    @Override
    public void cleanupPersistentSpace(CacheConfiguration cacheConfiguration) throws IgniteCheckedException {
        try {
            File cacheWorkDir = this.cacheWorkDir(cacheConfiguration);
            if (!cacheWorkDir.exists()) {
                return;
            }
            try (DirectoryStream<Path> files = Files.newDirectoryStream(cacheWorkDir.toPath(), (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    return entry.toFile().getName().endsWith(FilePageStoreManager.FILE_SUFFIX);
                }
            });){
                for (Path path : files) {
                    Files.delete(path);
                }
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to cleanup persistent directory: ", e);
        }
    }

    @Override
    public void cleanupPersistentSpace() throws IgniteCheckedException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.storeWorkDir.toPath(), entry -> {
            String name = entry.toFile().getName();
            return !name.equals(META_STORAGE_NAME) && (name.startsWith(CACHE_DIR_PREFIX) || name.startsWith(CACHE_GRP_DIR_PREFIX));
        });){
            for (Path path : files) {
                U.delete(path);
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to cleanup persistent directory: ", e);
        }
    }

    @Override
    public void cleanupPageStoreIfMatch(Predicate<Integer> cacheGrpPred, boolean cleanFiles) {
        Map<Integer, CacheStoreHolder> filteredStores = this.idxCacheStores.entrySet().stream().filter(e -> cacheGrpPred.test((Integer)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.idxCacheStores.entrySet().removeIf(e -> cacheGrpPred.test((Integer)e.getKey()));
        Runnable doShutdown = () -> {
            IgniteCheckedException ex = this.shutdown(filteredStores.values(), cleanFiles);
            if (ex != null) {
                U.error(this.log, "Failed to gracefully stop page store managers", ex);
            }
            U.log(this.log, "Cleanup cache stores [total=" + filteredStores.keySet().size() + ", left=" + this.idxCacheStores.size() + ", cleanFiles=" + cleanFiles + ']');
        };
        if (cleanFiles) {
            this.cleanupAsyncExecutor.async(doShutdown);
            U.log(this.log, "Cache stores cleanup started asynchronously");
        } else {
            doShutdown.run();
        }
    }

    @Override
    public void stop0(boolean cancel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping page store manager.");
        }
        this.cleanupPageStoreIfMatch(p -> true, false);
    }

    @Override
    public void onKernalStop0(boolean cancel) {
        this.cleanupAsyncExecutor.awaitAsyncTaskCompletion(cancel);
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activate page store manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.start0();
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate page store manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.stop0(true);
    }

    @Override
    public void beginRecover() {
        List<String> groupsWithWalDisabled = this.checkCachesWithDisabledWal();
        if (!groupsWithWalDisabled.isEmpty()) {
            String errorMsg = "Cache groups with potentially corrupted partition files found. To cleanup them maintenance is needed, node will enter maintenance mode on next restart. Cleanup cache group folders manually or trigger maintenance action to do that and restart the node. Corrupted files are located in subdirectories " + groupsWithWalDisabled + " in a work dir " + this.storeWorkDir;
            this.log.warning(errorMsg);
            try {
                this.cctx.kernalContext().maintenanceRegistry().registerMaintenanceTask(new MaintenanceTask(CORRUPTED_DATA_FILES_MNTC_TASK_NAME, "Corrupted cache groups found", groupsWithWalDisabled.stream().collect(Collectors.joining(File.separator))));
            }
            catch (IgniteCheckedException e) {
                this.log.warning("Failed to register maintenance record for corrupted partition files.", e);
            }
            throw new IgniteException(errorMsg);
        }
        for (CacheStoreHolder holder : this.idxCacheStores.values()) {
            holder.idxStore.beginRecover();
            for (PageStore partStore : holder.partStores) {
                partStore.beginRecover();
            }
        }
    }

    private List<String> checkCachesWithDisabledWal() {
        ArrayList<String> corruptedCachesDirs = new ArrayList<String>();
        for (Integer grpDescId : this.idxCacheStores.keySet()) {
            File dir;
            CacheGroupDescriptor desc = this.cctx.cache().cacheGroupDescriptor(grpDescId);
            if (desc == null || !desc.persistenceEnabled()) continue;
            boolean localEnabled = this.cctx.database().walEnabled(grpDescId, true);
            boolean globalEnabled = this.cctx.database().walEnabled(grpDescId, false);
            if (localEnabled && globalEnabled || Arrays.stream((dir = this.cacheWorkDir(desc.config())).listFiles()).filter(f -> !f.getName().equals(CACHE_DATA_FILENAME)).count() <= 0L) continue;
            corruptedCachesDirs.add(dir.getName());
        }
        return corruptedCachesDirs;
    }

    @Override
    public void finishRecover() throws IgniteCheckedException {
        try {
            for (CacheStoreHolder holder : this.idxCacheStores.values()) {
                holder.idxStore.finishRecover();
                for (PageStore partStore : holder.partStores) {
                    partStore.finishRecover();
                }
            }
        }
        catch (StorageException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public void initialize(int cacheId, int partitions, String workingDir, PageMetrics pageMetrics) throws IgniteCheckedException {
        assert (this.storeWorkDir != null);
        if (!this.idxCacheStores.containsKey(cacheId)) {
            CacheStoreHolder holder = this.initDir(new File(this.storeWorkDir, workingDir), cacheId, partitions, pageMetrics, this.cctx.cacheContext(cacheId) != null && this.cctx.cacheContext(cacheId).config().isEncryptionEnabled());
            CacheStoreHolder old = this.idxCacheStores.put(cacheId, holder);
            assert (old == null) : "Non-null old store holder for cacheId: " + cacheId;
        }
    }

    @Override
    public void initializeForCache(CacheGroupDescriptor grpDesc, StoredCacheData cacheData) throws IgniteCheckedException {
        assert (this.storeWorkDir != null);
        int grpId = grpDesc.groupId();
        if (!this.idxCacheStores.containsKey(grpId)) {
            CacheStoreHolder holder = this.initForCache(grpDesc, cacheData.config());
            CacheStoreHolder old = this.idxCacheStores.put(grpId, holder);
            assert (old == null) : "Non-null old store holder for cache: " + cacheData.config().getName();
        }
    }

    @Override
    public void initializeForMetastorage() throws IgniteCheckedException {
        assert (this.storeWorkDir != null);
        int grpId = MetaStorage.METASTORAGE_CACHE_ID;
        if (!this.idxCacheStores.containsKey(grpId)) {
            DataRegion dataRegion = this.cctx.database().dataRegion("metastoreMemPlc");
            PageMetrics pageMetrics = dataRegion.metrics().cacheGrpPageMetrics(grpId);
            CacheStoreHolder holder = this.initDir(new File(this.storeWorkDir, META_STORAGE_NAME), grpId, 2, pageMetrics, false);
            CacheStoreHolder old = this.idxCacheStores.put(grpId, holder);
            assert (old == null) : "Non-null old store holder for metastorage";
        }
    }

    @Override
    public void storeCacheData(StoredCacheData cacheData, boolean overwrite) throws IgniteCheckedException {
        block16: {
            File cacheWorkDir = this.cacheWorkDir(cacheData.config());
            this.checkAndInitCacheWorkDir(cacheWorkDir);
            assert (cacheWorkDir.exists()) : "Work directory does not exist: " + cacheWorkDir;
            File file = cacheData.config().getGroupName() != null ? new File(cacheWorkDir, cacheData.config().getName() + CACHE_DATA_FILENAME) : new File(cacheWorkDir, CACHE_DATA_FILENAME);
            Path filePath = file.toPath();
            try {
                if (!overwrite && Files.exists(filePath, new LinkOption[0]) && Files.size(filePath) != 0L) break block16;
                File tmp = new File(file.getParent(), file.getName() + TMP_SUFFIX);
                if (tmp.exists() && !tmp.delete()) {
                    this.log.warning("Failed to delete temporary cache config file(make sure Ignite process has enough rights):" + file.getName());
                }
                try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(tmp));){
                    this.marshaller.marshal(cacheData, stream);
                }
                Files.move(tmp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, ex));
                throw new IgniteCheckedException("Failed to persist cache configuration: " + cacheData.config().getName(), ex);
            }
        }
    }

    @Override
    public void shutdownForCacheGroup(CacheGroupContext grp, boolean destroy) throws IgniteCheckedException {
        this.grpsWithoutIdx.remove(grp.groupId());
        CacheStoreHolder old = this.idxCacheStores.remove(grp.groupId());
        if (old != null) {
            IgniteCheckedException ex = this.shutdown(old, destroy, null);
            if (destroy) {
                this.removeCacheGroupConfigurationData(grp);
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    @Override
    public void onPartitionCreated(int grpId, int partId) {
    }

    @Override
    public void onPartitionDestroyed(int grpId, int partId, int tag) throws IgniteCheckedException {
        assert (partId <= 65500);
        PageStore store = this.getStore(grpId, partId);
        store.truncate(tag);
    }

    @Override
    public void read(int grpId, long pageId, ByteBuffer pageBuf, boolean keepCrc) throws IgniteCheckedException {
        this.pmPageMgr.read(grpId, pageId, pageBuf, keepCrc);
    }

    @Override
    public boolean exists(int grpId, int partId) throws IgniteCheckedException {
        PageStore store = this.getStore(grpId, partId);
        return store.exists();
    }

    @Override
    public void readHeader(int grpId, int partId, ByteBuffer buf) throws IgniteCheckedException {
        PageStore store = this.getStore(grpId, partId);
        try {
            store.readHeader(buf);
        }
        catch (StorageException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public PageStore write(int grpId, long pageId, ByteBuffer pageBuf, int tag, boolean calculateCrc) throws IgniteCheckedException {
        return this.pmPageMgr.write(grpId, pageId, pageBuf, tag, calculateCrc);
    }

    @Override
    public long pageOffset(int grpId, long pageId) throws IgniteCheckedException {
        PageStore store = this.getStore(grpId, PageIdUtils.partId(pageId));
        return store.pageOffset(pageId);
    }

    public Path getPath(boolean isSharedGroup, String cacheOrGroupName, int partId) {
        return this.getPartitionFilePath(this.cacheWorkDir(isSharedGroup, cacheOrGroupName), partId);
    }

    private CacheStoreHolder initForCache(CacheGroupDescriptor grpDesc, CacheConfiguration ccfg) throws IgniteCheckedException {
        assert (!grpDesc.sharedGroup() || ccfg.getGroupName() != null) : ccfg.getName();
        File cacheWorkDir = this.cacheWorkDir(ccfg);
        String dataRegionName = grpDesc.config().getDataRegionName();
        DataRegion dataRegion = this.cctx.database().dataRegion(dataRegionName);
        PageMetrics pageMetrics = dataRegion.metrics().cacheGrpPageMetrics(grpDesc.groupId());
        return this.initDir(cacheWorkDir, grpDesc.groupId(), grpDesc.config().getAffinity().partitions(), pageMetrics, ccfg.isEncryptionEnabled());
    }

    public FilePageStoreFactory getPageStoreFactory(int grpId, boolean encrypted) {
        FileIOFactory pageStoreFileIoFactory = this.pageStoreFileIoFactory;
        FileIOFactory pageStoreV1FileIoFactory = this.pageStoreV1FileIoFactory;
        if (encrypted) {
            pageStoreFileIoFactory = new EncryptedFileIOFactory(this.pageStoreFileIoFactory, grpId, this.pageSize(), this.cctx.kernalContext().encryption(), this.cctx.gridConfig().getEncryptionSpi());
            pageStoreV1FileIoFactory = new EncryptedFileIOFactory(this.pageStoreV1FileIoFactory, grpId, this.pageSize(), this.cctx.kernalContext().encryption(), this.cctx.gridConfig().getEncryptionSpi());
        }
        FileVersionCheckingFactory pageStoreFactory = new FileVersionCheckingFactory(pageStoreFileIoFactory, pageStoreV1FileIoFactory, this.igniteCfg.getDataStorageConfiguration());
        if (encrypted) {
            int headerSize = pageStoreFactory.headerSize(pageStoreFactory.latestVersion());
            ((EncryptedFileIOFactory)pageStoreFileIoFactory).headerSize(headerSize);
            ((EncryptedFileIOFactory)pageStoreV1FileIoFactory).headerSize(headerSize);
        }
        return pageStoreFactory;
    }

    private CacheStoreHolder initDir(File cacheWorkDir, int grpId, int partitions, PageMetrics pageMetrics, boolean encrypted) throws IgniteCheckedException {
        try {
            MaintenanceRegistry mntcReg;
            boolean dirExisted = this.checkAndInitCacheWorkDir(cacheWorkDir);
            if (dirExisted && !(mntcReg = this.cctx.kernalContext().maintenanceRegistry()).isMaintenanceMode()) {
                DefragmentationFileUtils.beforeInitPageStores(cacheWorkDir, this.log);
            }
            File idxFile = new File(cacheWorkDir, INDEX_FILE_NAME);
            if (dirExisted && !idxFile.exists()) {
                this.grpsWithoutIdx.add(grpId);
            }
            FileIOFactory pageStoreFileIoFactory = this.pageStoreFileIoFactory;
            FileIOFactory pageStoreV1FileIoFactory = this.pageStoreV1FileIoFactory;
            if (encrypted) {
                pageStoreFileIoFactory = new EncryptedFileIOFactory(this.pageStoreFileIoFactory, grpId, this.pageSize(), this.cctx.kernalContext().encryption(), this.cctx.gridConfig().getEncryptionSpi());
                pageStoreV1FileIoFactory = new EncryptedFileIOFactory(this.pageStoreV1FileIoFactory, grpId, this.pageSize(), this.cctx.kernalContext().encryption(), this.cctx.gridConfig().getEncryptionSpi());
            }
            FileVersionCheckingFactory pageStoreFactory = new FileVersionCheckingFactory(pageStoreFileIoFactory, pageStoreV1FileIoFactory, this.igniteCfg.getDataStorageConfiguration());
            if (encrypted) {
                int headerSize = pageStoreFactory.headerSize(pageStoreFactory.latestVersion());
                ((EncryptedFileIOFactory)pageStoreFileIoFactory).headerSize(headerSize);
                ((EncryptedFileIOFactory)pageStoreV1FileIoFactory).headerSize(headerSize);
            }
            PageStore idxStore = pageStoreFactory.createPageStore((byte)2, idxFile, pageMetrics.totalPages()::add);
            PageStore[] partStores = new PageStore[partitions];
            for (int partId = 0; partId < partStores.length; ++partId) {
                PageStore partStore;
                int p = partId;
                partStores[partId] = partStore = pageStoreFactory.createPageStore((byte)1, () -> this.getPartitionFilePath(cacheWorkDir, p), pageMetrics.totalPages()::add);
            }
            return new CacheStoreHolder(idxStore, partStores);
        }
        catch (IgniteCheckedException e) {
            if (X.hasCause((Throwable)e, StorageException.class, IOException.class)) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
            throw e;
        }
    }

    @NotNull
    private Path getPartitionFilePath(File cacheWorkDir, int partId) {
        return new File(cacheWorkDir, String.format(PART_FILE_TEMPLATE, partId)).toPath();
    }

    @Override
    public boolean checkAndInitCacheWorkDir(CacheConfiguration cacheCfg) throws IgniteCheckedException {
        return this.checkAndInitCacheWorkDir(this.cacheWorkDir(cacheCfg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndInitCacheWorkDir(File cacheWorkDir) throws IgniteCheckedException {
        boolean dirExisted;
        block16: {
            dirExisted = false;
            ReadWriteLock lock = this.initDirLock.getLock(cacheWorkDir.getName().hashCode());
            lock.writeLock().lock();
            try {
                if (!Files.exists(cacheWorkDir.toPath(), new LinkOption[0])) {
                    try {
                        Files.createDirectory(cacheWorkDir.toPath(), new FileAttribute[0]);
                        break block16;
                    }
                    catch (IOException e) {
                        throw new IgniteCheckedException("Failed to initialize cache working directory (failed to create, make sure the work folder has correct permissions): " + cacheWorkDir.getAbsolutePath(), e);
                    }
                }
                if (cacheWorkDir.isFile()) {
                    throw new IgniteCheckedException("Failed to initialize cache working directory (a file with the same name already exists): " + cacheWorkDir.getAbsolutePath());
                }
                File lockF = new File(cacheWorkDir, "snapshot-started.loc");
                Path cacheWorkDirPath = cacheWorkDir.toPath();
                Path tmp = cacheWorkDirPath.getParent().resolve(cacheWorkDir.getName() + TMP_SUFFIX);
                if (Files.exists(tmp, new LinkOption[0]) && Files.isDirectory(tmp, new LinkOption[0]) && Files.exists(tmp.resolve("finished.tmp"), new LinkOption[0])) {
                    U.warn(this.log, "Ignite node crashed during the snapshot restore process (there is a snapshot restore lock file left for cache). But old version of cache was saved. Trying to restore it. Cache - [" + cacheWorkDir.getAbsolutePath() + ']');
                    U.delete(cacheWorkDir);
                    try {
                        Files.move(tmp, cacheWorkDirPath, StandardCopyOption.ATOMIC_MOVE);
                        cacheWorkDirPath.resolve("finished.tmp").toFile().delete();
                    }
                    catch (IOException e) {
                        throw new IgniteCheckedException(e);
                    }
                } else if (lockF.exists()) {
                    U.warn(this.log, "Ignite node crashed during the snapshot restore process (there is a snapshot restore lock file left for cache). Will remove both the lock file and incomplete cache directory [cacheDir=" + cacheWorkDir.getAbsolutePath() + ']');
                    boolean deleted = U.delete(cacheWorkDir);
                    if (!deleted) {
                        throw new IgniteCheckedException("Failed to remove obsolete cache working directory (remove the directory manually and make sure the work folder has correct permissions): " + cacheWorkDir.getAbsolutePath());
                    }
                    cacheWorkDir.mkdirs();
                } else {
                    dirExisted = true;
                }
                if (!cacheWorkDir.exists()) {
                    throw new IgniteCheckedException("Failed to initialize cache working directory (failed to create, make sure the work folder has correct permissions): " + cacheWorkDir.getAbsolutePath());
                }
                if (Files.exists(tmp, new LinkOption[0])) {
                    U.delete(tmp);
                }
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        return dirExisted;
    }

    @Override
    public void sync(int grpId, int partId) throws IgniteCheckedException {
        try {
            this.getStore(grpId, partId).sync();
        }
        catch (StorageException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public void ensure(int grpId, int partId) throws IgniteCheckedException {
        try {
            this.getStore(grpId, partId).ensure();
        }
        catch (StorageException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public long allocatePage(int grpId, int partId, byte flags) throws IgniteCheckedException {
        return this.pmPageMgr.allocatePage(grpId, partId, flags);
    }

    @Override
    public int pages(int grpId, int partId) throws IgniteCheckedException {
        PageStore store = this.getStore(grpId, partId);
        return store.pages();
    }

    @Override
    public Map<String, StoredCacheData> readCacheConfigurations() throws IgniteCheckedException {
        if (this.cctx.kernalContext().clientNode()) {
            return Collections.emptyMap();
        }
        Object[] files = this.storeWorkDir.listFiles();
        if (files == null) {
            return Collections.emptyMap();
        }
        HashMap<String, StoredCacheData> ccfgs = new HashMap<String, StoredCacheData>();
        Arrays.sort(files);
        for (Object file : files) {
            if (!((File)file).isDirectory()) continue;
            if (((File)file).getName().startsWith(CACHE_DIR_PREFIX)) {
                File conf = new File((File)file, CACHE_DATA_FILENAME);
                if (!conf.exists() || conf.length() <= 0L) continue;
                StoredCacheData cacheData = this.readCacheData(conf);
                String cacheName = cacheData.config().getName();
                if (!ccfgs.containsKey(cacheName)) {
                    ccfgs.put(cacheName, cacheData);
                    continue;
                }
                U.warn(this.log, "Cache with name=" + cacheName + " is already registered, skipping config file " + ((File)file).getName());
                continue;
            }
            if (!((File)file).getName().startsWith(CACHE_GRP_DIR_PREFIX)) continue;
            this.readCacheGroupCaches((File)file, ccfgs);
        }
        return ccfgs;
    }

    private void readCacheGroupCaches(File grpDir, Map<String, StoredCacheData> ccfgs) throws IgniteCheckedException {
        File[] files = grpDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory() || !file.getName().endsWith(CACHE_DATA_FILENAME) || file.length() <= 0L) continue;
            StoredCacheData cacheData = this.readCacheData(file);
            String cacheName = cacheData.config().getName();
            if (!ccfgs.containsKey(cacheName)) {
                ccfgs.put(cacheName, cacheData);
                continue;
            }
            U.warn(this.log, "Cache with name=" + cacheName + " is already registered, skipping config file " + file.getName() + " in group directory " + grpDir.getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StoredCacheData readCacheData(File conf) throws IgniteCheckedException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(conf));){
            StoredCacheData storedCacheData = (StoredCacheData)this.marshaller.unmarshal(stream, U.resolveClassLoader(this.igniteCfg));
            return storedCacheData;
        }
        catch (IOException | IgniteCheckedException e) {
            throw new IgniteCheckedException("An error occurred during cache configuration loading from file [file=" + conf.getAbsolutePath() + "]", e);
        }
    }

    @Override
    public boolean hasIndexStore(int grpId) {
        return !this.grpsWithoutIdx.contains(grpId);
    }

    @Override
    public long pagesAllocated(int grpId) {
        CacheStoreHolder holder = this.idxCacheStores.get(grpId);
        if (holder == null) {
            return 0L;
        }
        long pageCnt = holder.idxStore.pages();
        for (int i = 0; i < holder.partStores.length; ++i) {
            pageCnt += (long)holder.partStores[i].pages();
        }
        return pageCnt;
    }

    public File workDir() {
        return this.storeWorkDir;
    }

    public File cacheWorkDir(CacheConfiguration ccfg) {
        boolean isSharedGrp = ccfg.getGroupName() != null;
        return this.cacheWorkDir(isSharedGrp, isSharedGrp ? ccfg.getGroupName() : ccfg.getName());
    }

    public File cacheWorkDir(boolean isSharedGroup, String cacheOrGroupName) {
        String dirName = isSharedGroup ? CACHE_GRP_DIR_PREFIX + cacheOrGroupName : CACHE_DIR_PREFIX + cacheOrGroupName;
        return new File(this.storeWorkDir, dirName);
    }

    private IgniteCheckedException shutdown(Collection<CacheStoreHolder> holders, boolean cleanFiles) {
        IgniteCheckedException ex = null;
        for (CacheStoreHolder holder : holders) {
            ex = this.shutdown(holder, cleanFiles, ex);
        }
        return ex;
    }

    private IgniteCheckedException shutdown(CacheStoreHolder holder, boolean cleanFile, @Nullable IgniteCheckedException aggr) {
        aggr = this.shutdown(holder.idxStore, cleanFile, aggr);
        for (PageStore store : holder.partStores) {
            if (store == null) continue;
            aggr = this.shutdown(store, cleanFile, aggr);
        }
        return aggr;
    }

    private void removeCacheGroupConfigurationData(CacheGroupContext ctx) throws IgniteCheckedException {
        File cacheGrpDir = this.cacheWorkDir(ctx.sharedGroup(), ctx.cacheOrGroupName());
        if (cacheGrpDir != null && cacheGrpDir.exists()) {
            DirectoryStream.Filter<Path> cacheCfgFileFilter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path path) {
                    return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(FilePageStoreManager.CACHE_DATA_FILENAME);
                }
            };
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(cacheGrpDir.toPath(), (DirectoryStream.Filter<? super Path>)cacheCfgFileFilter);){
                for (Path path : dirStream) {
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to delete cache configurations of group: " + ctx.toString(), e);
            }
        }
    }

    @Override
    public void removeCacheData(StoredCacheData cacheData) throws IgniteCheckedException {
        CacheConfiguration<?, ?> cacheCfg = cacheData.config();
        File cacheWorkDir = this.cacheWorkDir(cacheCfg);
        File file = cacheData.config().getGroupName() != null ? new File(cacheWorkDir, cacheCfg.getName() + CACHE_DATA_FILENAME) : new File(cacheWorkDir, CACHE_DATA_FILENAME);
        if (file.exists() && !file.delete()) {
            throw new IgniteCheckedException("Failed to delete cache configuration: " + cacheCfg.getName());
        }
    }

    private IgniteCheckedException shutdown(PageStore store, boolean cleanFile, IgniteCheckedException aggr) {
        try {
            if (store != null) {
                store.stop(cleanFile);
            }
        }
        catch (IgniteCheckedException e) {
            if (aggr == null) {
                aggr = new IgniteCheckedException("Failed to gracefully shutdown store");
            }
            aggr.addSuppressed(e);
        }
        return aggr;
    }

    private CacheStoreHolder getHolder(int grpId) throws IgniteCheckedException {
        try {
            return this.idxCacheStores.computeIfAbsent(grpId, key -> {
                CacheGroupDescriptor gDesc = this.cctx.cache().cacheGroupDescriptor(grpId);
                CacheStoreHolder holder0 = null;
                if (gDesc != null && CU.isPersistentCache(gDesc.config(), this.cctx.gridConfig().getDataStorageConfiguration())) {
                    try {
                        holder0 = this.initForCache(gDesc, gDesc.config());
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                }
                return holder0;
            });
        }
        catch (IgniteException ex) {
            if (X.hasCause((Throwable)ex, IgniteCheckedException.class)) {
                throw ex.getCause(IgniteCheckedException.class);
            }
            throw ex;
        }
    }

    @Override
    public Collection<PageStore> getStores(int grpId) throws IgniteCheckedException {
        return this.getHolder(grpId);
    }

    @Override
    public PageStore getStore(int grpId, int partId) throws IgniteCheckedException {
        CacheStoreHolder holder = this.getHolder(grpId);
        if (holder == null) {
            throw new IgniteCheckedException("Failed to get page store for the given cache ID (cache has not been started): " + grpId);
        }
        if (partId == 65535) {
            return holder.idxStore;
        }
        if (partId > 65500) {
            throw new IgniteCheckedException("Partition ID is reserved: " + partId);
        }
        PageStore store = holder.partStores[partId];
        if (store == null) {
            throw new IgniteCheckedException("Failed to get page store for the given partition ID (partition has not been created) [grpId=" + grpId + ", partId=" + partId + ']');
        }
        return store;
    }

    public void setPageStoreFileIOFactories(FileIOFactory pageStoreFileIoFactory, FileIOFactory pageStoreV1FileIoFactory) {
        this.pageStoreFileIoFactory = pageStoreFileIoFactory;
        this.pageStoreV1FileIoFactory = pageStoreV1FileIoFactory;
    }

    public FileIOFactory getPageStoreFileIoFactory() {
        return this.pageStoreFileIoFactory;
    }

    public int pageSize() {
        return this.dsCfg.getPageSize();
    }

    private static class IdxCacheStores<K, V>
    extends ConcurrentHashMap<K, V> {
        private static final long serialVersionUID = 0L;
        private final LongOperationAsyncExecutor longOperationAsyncExecutor;

        IdxCacheStores(LongOperationAsyncExecutor longOperationAsyncExecutor) {
            this.longOperationAsyncExecutor = longOperationAsyncExecutor;
        }

        @Override
        public V put(K key, V val) {
            return (V)this.longOperationAsyncExecutor.afterAsyncCompletion(() -> super.put(key, val));
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.longOperationAsyncExecutor.afterAsyncCompletion(() -> {
                super.putAll(m);
                return null;
            });
        }

        @Override
        public V putIfAbsent(K key, V val) {
            return (V)this.longOperationAsyncExecutor.afterAsyncCompletion(() -> super.putIfAbsent(key, val));
        }

        @Override
        public boolean replace(K key, V oldVal, V newVal) {
            return this.longOperationAsyncExecutor.afterAsyncCompletion(() -> super.replace(key, oldVal, newVal));
        }

        @Override
        public V replace(K key, V val) {
            return (V)this.longOperationAsyncExecutor.afterAsyncCompletion(() -> super.replace(key, val));
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            return (V)this.longOperationAsyncExecutor.afterAsyncCompletion(() -> super.computeIfAbsent(key, mappingFunction));
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return (V)this.longOperationAsyncExecutor.afterAsyncCompletion(() -> super.computeIfPresent(key, remappingFunction));
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return (V)this.longOperationAsyncExecutor.afterAsyncCompletion(() -> super.compute(key, remappingFunction));
        }

        @Override
        public V merge(K key, V val, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            return (V)this.longOperationAsyncExecutor.afterAsyncCompletion(() -> super.merge(key, val, remappingFunction));
        }
    }

    protected static class LongOperationAsyncExecutor {
        private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private final String igniteInstanceName;
        private final IgniteLogger log;
        private Set<GridWorker> workers = new GridConcurrentHashSet<GridWorker>();
        private static final AtomicLong workerCounter = new AtomicLong(0L);

        public LongOperationAsyncExecutor(String igniteInstanceName, IgniteLogger log) {
            this.igniteInstanceName = igniteInstanceName;
            this.log = log;
        }

        public void async(final Runnable runnable) {
            String workerName = "async-file-store-cleanup-task-" + workerCounter.getAndIncrement();
            GridWorker worker = new GridWorker(this.igniteInstanceName, workerName, this.log){

                @Override
                protected void body() {
                    readWriteLock.writeLock().lock();
                    try {
                        runnable.run();
                    }
                    finally {
                        readWriteLock.writeLock().unlock();
                        workers.remove(this);
                    }
                }
            };
            this.workers.add(worker);
            IgniteThread asyncTask = new IgniteThread(worker);
            asyncTask.start();
        }

        public <T> T afterAsyncCompletion(IgniteOutClosure<T> closure) {
            this.readWriteLock.readLock().lock();
            try {
                T t = closure.apply();
                return t;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }

        public void awaitAsyncTaskCompletion(boolean cancel) {
            U.awaitForWorkersStop(this.workers, cancel, this.log);
        }
    }

    private static class CacheStoreHolder
    extends AbstractList<PageStore> {
        private final PageStore idxStore;
        private final PageStore[] partStores;

        CacheStoreHolder(PageStore idxStore, PageStore[] partStores) {
            this.idxStore = Objects.requireNonNull(idxStore);
            this.partStores = Objects.requireNonNull(partStores);
        }

        @Override
        public PageStore get(int idx) {
            return Objects.requireNonNull(idx == this.partStores.length ? this.idxStore : this.partStores[idx]);
        }

        @Override
        public int size() {
            return this.partStores.length + 1;
        }
    }
}

