/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointLockStateChecker;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagesWriteThrottlePolicy;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteOutClosure;

public class PagesWriteThrottle
implements PagesWriteThrottlePolicy {
    private final PageMemoryImpl pageMemory;
    private final IgniteOutClosure<CheckpointProgress> cpProgress;
    private final boolean throttleOnlyPagesInCheckpoint;
    private CheckpointLockStateChecker stateChecker;
    private static final long STARTING_THROTTLE_NANOS = 4000L;
    private static final double BACKOFF_RATIO = 1.05;
    private final AtomicInteger notInCheckpointBackoffCntr = new AtomicInteger(0);
    private final AtomicInteger inCheckpointBackoffCntr = new AtomicInteger(0);
    private IgniteLogger log;
    private final ConcurrentHashMap<Long, Thread> cpBufThrottledThreads = new ConcurrentHashMap();

    public PagesWriteThrottle(PageMemoryImpl pageMemory, IgniteOutClosure<CheckpointProgress> cpProgress, CheckpointLockStateChecker stateChecker, boolean throttleOnlyPagesInCheckpoint, IgniteLogger log) {
        this.pageMemory = pageMemory;
        this.cpProgress = cpProgress;
        this.stateChecker = stateChecker;
        this.throttleOnlyPagesInCheckpoint = throttleOnlyPagesInCheckpoint;
        this.log = log;
        assert (throttleOnlyPagesInCheckpoint || cpProgress != null) : "cpProgress must be not null if ratio based throttling mode is used";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMarkDirty(boolean isPageInCheckpoint) {
        AtomicInteger cntr;
        assert (this.stateChecker.checkpointLockIsHeldByThread());
        boolean shouldThrottle = false;
        if (isPageInCheckpoint) {
            shouldThrottle = this.shouldThrottle();
        }
        if (!shouldThrottle && !this.throttleOnlyPagesInCheckpoint) {
            int cpTotalPages;
            AtomicInteger writtenPagesCntr;
            CheckpointProgress progress = this.cpProgress.apply();
            AtomicInteger atomicInteger = writtenPagesCntr = progress == null ? null : progress.writtenPagesCounter();
            if (progress == null || writtenPagesCntr == null) {
                return;
            }
            int cpWrittenPages = writtenPagesCntr.get();
            if (cpWrittenPages == (cpTotalPages = progress.currentCheckpointPagesCount())) {
                shouldThrottle = this.pageMemory.shouldThrottle(0.75);
            } else {
                double dirtyRatioThreshold = (double)cpWrittenPages / (double)cpTotalPages;
                dirtyRatioThreshold = (dirtyRatioThreshold * 0.95 + 0.05) * 7.0 / 12.0;
                shouldThrottle = this.pageMemory.shouldThrottle(dirtyRatioThreshold);
            }
        }
        AtomicInteger atomicInteger = cntr = isPageInCheckpoint ? this.inCheckpointBackoffCntr : this.notInCheckpointBackoffCntr;
        if (shouldThrottle) {
            int throttleLevel = cntr.getAndIncrement();
            long throttleParkTimeNs = (long)(4000.0 * Math.pow(1.05, throttleLevel));
            Thread curThread = Thread.currentThread();
            if (throttleParkTimeNs > LOGGING_THRESHOLD) {
                U.warn(this.log, "Parking thread=" + curThread.getName() + " for timeout(ms)=" + throttleParkTimeNs / 1000000L);
            }
            long startTime = U.currentTimeMillis();
            if (isPageInCheckpoint) {
                this.cpBufThrottledThreads.put(curThread.getId(), curThread);
                try {
                    LockSupport.parkNanos(throttleParkTimeNs);
                }
                finally {
                    this.cpBufThrottledThreads.remove(curThread.getId());
                    if (throttleParkTimeNs > LOGGING_THRESHOLD) {
                        U.warn(this.log, "Unparking thread=" + curThread.getName() + " with park timeout(ms)=" + throttleParkTimeNs / 1000000L);
                    }
                }
            } else {
                LockSupport.parkNanos(throttleParkTimeNs);
            }
            this.pageMemory.metrics().addThrottlingTime(U.currentTimeMillis() - startTime);
        } else {
            int oldCntr = cntr.getAndSet(0);
            if (isPageInCheckpoint && oldCntr != 0) {
                this.cpBufThrottledThreads.values().forEach(LockSupport::unpark);
            }
        }
    }

    @Override
    public void tryWakeupThrottledThreads() {
        if (!this.shouldThrottle()) {
            this.inCheckpointBackoffCntr.set(0);
            this.cpBufThrottledThreads.values().forEach(LockSupport::unpark);
        }
    }

    @Override
    public void onBeginCheckpoint() {
    }

    @Override
    public void onFinishCheckpoint() {
        this.inCheckpointBackoffCntr.set(0);
        this.notInCheckpointBackoffCntr.set(0);
    }

    @Override
    public boolean shouldThrottle() {
        int checkpointBufLimit = (int)((float)this.pageMemory.checkpointBufferPagesSize() * 0.6666667f);
        return this.pageMemory.checkpointBufferPagesCount() > checkpointBufLimit;
    }
}

