/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CacheVersionIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccUpdateResult;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridStringBuilder;

public class DataPageIO
extends AbstractDataPageIO<CacheDataRow> {
    public static final int MVCC_INFO_SIZE = 40;
    public static final IOVersions<DataPageIO> VERSIONS = new IOVersions((PageIO[])new DataPageIO[]{new DataPageIO(1)});

    protected DataPageIO(int ver) {
        super(1, ver);
    }

    @Override
    protected void writeRowData(long pageAddr, int dataOff, int payloadSize, CacheDataRow row, boolean newRow) throws IgniteCheckedException {
        int mvccInfoSize;
        long addr = pageAddr + (long)dataOff;
        int cacheIdSize = row.cacheId() != 0 ? 4 : 0;
        int n = mvccInfoSize = row.mvccCoordinatorVersion() > 0L ? 40 : 0;
        if (newRow) {
            PageUtils.putShort(addr, 0, (short)payloadSize);
            addr += 2L;
            if (mvccInfoSize > 0) {
                assert (MvccUtils.mvccVersionIsValid(row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter()));
                int keyAbsentBeforeFlag = row instanceof MvccUpdateResult && ((MvccUpdateResult)((Object)row)).isKeyAbsentBefore() ? 0x20000000 : 0;
                PageUtils.putLong(addr, 0, row.mvccCoordinatorVersion());
                PageUtils.putLong(addr, 8, row.mvccCounter());
                PageUtils.putInt(addr, 16, row.mvccOperationCounter() | row.mvccTxState() << 30 | (row.newMvccCoordinatorVersion() == 0L ? keyAbsentBeforeFlag : 0));
                assert (row.newMvccCoordinatorVersion() == 0L || MvccUtils.mvccVersionIsValid(row.newMvccCoordinatorVersion(), row.newMvccCounter(), row.newMvccOperationCounter()));
                PageUtils.putLong(addr, 20, row.newMvccCoordinatorVersion());
                PageUtils.putLong(addr, 28, row.newMvccCounter());
                PageUtils.putInt(addr, 36, row.newMvccOperationCounter() | row.newMvccTxState() << 30 | (row.newMvccCoordinatorVersion() == 0L ? 0 : keyAbsentBeforeFlag));
                addr += (long)mvccInfoSize;
            }
            if (cacheIdSize != 0) {
                PageUtils.putInt(addr, 0, row.cacheId());
                addr += (long)cacheIdSize;
            }
            addr += (long)row.key().putValue(addr);
        } else {
            addr += (long)(2 + mvccInfoSize + cacheIdSize + row.key().valueBytesLength(null));
        }
        addr += (long)row.value().putValue(addr);
        CacheVersionIO.write(addr, row.version(), false);
        PageUtils.putLong(addr += (long)CacheVersionIO.size(row.version(), false), 0, row.expireTime());
    }

    @Override
    protected void writeFragmentData(CacheDataRow row, ByteBuffer buf, int rowOff, int payloadSize) throws IgniteCheckedException {
        int keySize = row.key().valueBytesLength(null);
        int valSize = row.value().valueBytesLength(null);
        int written = this.writeFragment(row, buf, rowOff, payloadSize, EntryPart.MVCC_INFO, keySize, valSize);
        written += this.writeFragment(row, buf, rowOff + written, payloadSize - written, EntryPart.CACHE_ID, keySize, valSize);
        written += this.writeFragment(row, buf, rowOff + written, payloadSize - written, EntryPart.KEY, keySize, valSize);
        written += this.writeFragment(row, buf, rowOff + written, payloadSize - written, EntryPart.EXPIRE_TIME, keySize, valSize);
        written += this.writeFragment(row, buf, rowOff + written, payloadSize - written, EntryPart.VALUE, keySize, valSize);
        written += this.writeFragment(row, buf, rowOff + written, payloadSize - written, EntryPart.VERSION, keySize, valSize);
        assert (written == payloadSize);
    }

    private int writeFragment(CacheDataRow row, ByteBuffer buf, int rowOff, int payloadSize, EntryPart type, int keySize, int valSize) throws IgniteCheckedException {
        int keyAbsentBeforeFlag;
        int curLen;
        int prevLen;
        if (payloadSize == 0) {
            return 0;
        }
        int cacheIdSize = row.cacheId() == 0 ? 0 : 4;
        int mvccInfoSize = row.mvccCoordinatorVersion() > 0L ? 40 : 0;
        switch (type) {
            case MVCC_INFO: {
                prevLen = 0;
                curLen = mvccInfoSize;
                break;
            }
            case CACHE_ID: {
                prevLen = mvccInfoSize;
                curLen = mvccInfoSize + cacheIdSize;
                break;
            }
            case KEY: {
                prevLen = mvccInfoSize + cacheIdSize;
                curLen = mvccInfoSize + cacheIdSize + keySize;
                break;
            }
            case EXPIRE_TIME: {
                prevLen = mvccInfoSize + cacheIdSize + keySize;
                curLen = mvccInfoSize + cacheIdSize + keySize + 8;
                break;
            }
            case VALUE: {
                prevLen = mvccInfoSize + cacheIdSize + keySize + 8;
                curLen = mvccInfoSize + cacheIdSize + keySize + valSize + 8;
                break;
            }
            case VERSION: {
                prevLen = mvccInfoSize + cacheIdSize + keySize + valSize + 8;
                curLen = mvccInfoSize + cacheIdSize + keySize + valSize + CacheVersionIO.size(row.version(), false) + 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown entry part type: " + (Object)((Object)type));
            }
        }
        if (curLen <= rowOff) {
            return 0;
        }
        int len = Math.min(curLen - rowOff, payloadSize);
        int n = keyAbsentBeforeFlag = row instanceof MvccUpdateResult && ((MvccUpdateResult)((Object)row)).isKeyAbsentBefore() ? 0x20000000 : 0;
        if (type == EntryPart.EXPIRE_TIME) {
            this.writeExpireTimeFragment(buf, row.expireTime(), rowOff, len, prevLen);
        } else if (type == EntryPart.CACHE_ID) {
            this.writeCacheIdFragment(buf, row.cacheId(), rowOff, len, prevLen);
        } else if (type == EntryPart.MVCC_INFO) {
            this.writeMvccInfoFragment(buf, row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter() | row.mvccTxState() << 30 | (row.newMvccCoordinatorVersion() == 0L ? keyAbsentBeforeFlag : 0), row.newMvccCoordinatorVersion(), row.newMvccCounter(), row.newMvccOperationCounter() | row.newMvccTxState() << 30 | (row.newMvccCoordinatorVersion() == 0L ? 0 : keyAbsentBeforeFlag), len);
        } else if (type != EntryPart.VERSION) {
            CacheObject co = type == EntryPart.KEY ? row.key() : row.value();
            co.putValue(buf, rowOff - prevLen, len);
        } else {
            this.writeVersionFragment(buf, row.version(), rowOff, len, prevLen);
        }
        return len;
    }

    public void updateNewVersion(long pageAddr, int dataOff, long mvccCrd, long mvccCntr, int mvccOpCntr, byte txState) {
        long addr = pageAddr + (long)dataOff;
        this.updateNewVersion(addr, mvccCrd, mvccCntr, mvccOpCntr & 0x3FFFFFFF | txState << 30);
    }

    public void updateNewVersion(long pageAddr, int itemId, int pageSize, long mvccCrd, long mvccCntr, int mvccOpCntr) {
        int dataOff = this.getDataOffset(pageAddr, itemId, pageSize);
        long addr = pageAddr + (long)dataOff + (long)(this.isFragmented(pageAddr, dataOff) ? 10 : 2);
        this.updateNewVersion(addr, mvccCrd, mvccCntr, mvccOpCntr);
    }

    public void updateTxState(long pageAddr, int itemId, int pageSize, byte txState) {
        int dataOff = this.getDataOffset(pageAddr, itemId, pageSize);
        long addr = pageAddr + (long)dataOff + (long)(this.isFragmented(pageAddr, dataOff) ? 10 : 2);
        int opCntr = this.rawMvccOperationCounter(addr, 0);
        this.rawMvccOperationCounter(addr, 0, opCntr & 0x3FFFFFFF | txState << 30);
    }

    public void updateNewTxState(long pageAddr, int itemId, int pageSize, byte txState) {
        int dataOff = this.getDataOffset(pageAddr, itemId, pageSize);
        long addr = pageAddr + (long)dataOff + (long)(this.isFragmented(pageAddr, dataOff) ? 10 : 2);
        int opCntr = this.rawNewMvccOperationCounter(addr, 0);
        this.rawNewMvccOperationCounter(addr, 0, opCntr & 0x3FFFFFFF | txState << 30);
    }

    private void updateNewVersion(long addr, long mvccCrd, long mvccCntr, int mvccOpCntr) {
        PageUtils.putLong(addr += 20L, 0, mvccCrd);
        PageUtils.putLong(addr, 8, mvccCntr);
        PageUtils.putInt(addr, 16, mvccOpCntr);
    }

    public long mvccCoordinator(long pageAddr, int dataOff) {
        long addr = pageAddr + (long)dataOff;
        return PageUtils.getLong(addr, 0);
    }

    public long mvccCounter(long pageAddr, int dataOff) {
        long addr = pageAddr + (long)dataOff;
        return PageUtils.getLong(addr, 8);
    }

    public int rawMvccOperationCounter(long pageAddr, int dataOff) {
        long addr = pageAddr + (long)dataOff;
        return PageUtils.getInt(addr, 16);
    }

    public void rawMvccOperationCounter(long pageAddr, int dataOff, int opCntr) {
        long addr = pageAddr + (long)dataOff;
        PageUtils.putInt(addr, 16, opCntr);
    }

    public long newMvccCoordinator(long pageAddr, int dataOff) {
        long addr = pageAddr + (long)dataOff;
        return PageUtils.getLong(addr += 20L, 0);
    }

    public long newMvccCounter(long pageAddr, int dataOff) {
        long addr = pageAddr + (long)dataOff;
        return PageUtils.getLong(addr += 20L, 8);
    }

    public int rawNewMvccOperationCounter(long pageAddr, int dataOff) {
        long addr = pageAddr + (long)dataOff;
        return PageUtils.getInt(addr += 20L, 16);
    }

    public void rawNewMvccOperationCounter(long pageAddr, int dataOff, int opCntr) {
        long addr = pageAddr + (long)dataOff;
        PageUtils.putInt(addr += 20L, 16, opCntr);
    }

    private void writeVersionFragment(ByteBuffer buf, GridCacheVersion ver, int rowOff, int len, int prevLen) {
        int verSize = CacheVersionIO.size(ver, false);
        assert (len <= verSize) : len;
        if (verSize == len) {
            CacheVersionIO.write(buf, ver, false);
        } else {
            ByteBuffer verBuf = ByteBuffer.allocate(verSize);
            verBuf.order(buf.order());
            CacheVersionIO.write(verBuf, ver, false);
            buf.put(verBuf.array(), rowOff - prevLen, len);
        }
    }

    private void writeExpireTimeFragment(ByteBuffer buf, long expireTime, int rowOff, int len, int prevLen) {
        int size = 8;
        if (size <= len) {
            buf.putLong(expireTime);
        } else {
            ByteBuffer timeBuf = ByteBuffer.allocate(size);
            timeBuf.order(buf.order());
            timeBuf.putLong(expireTime);
            buf.put(timeBuf.array(), rowOff - prevLen, len);
        }
    }

    private void writeCacheIdFragment(ByteBuffer buf, int cacheId, int rowOff, int len, int prevLen) {
        if (cacheId == 0) {
            return;
        }
        int size = 4;
        if (size <= len) {
            buf.putInt(cacheId);
        } else {
            ByteBuffer cacheIdBuf = ByteBuffer.allocate(size);
            cacheIdBuf.order(buf.order());
            cacheIdBuf.putInt(cacheId);
            buf.put(cacheIdBuf.array(), rowOff - prevLen, len);
        }
    }

    private void writeMvccInfoFragment(ByteBuffer buf, long mvccCrd, long mvccCntr, int mvccOpCntr, long newMvccCrd, long newMvccCntr, int newMvccOpCntr, int len) {
        if (mvccCrd == 0L) {
            return;
        }
        assert (len >= 40) : "Mvcc info should fit on the one page!";
        assert (MvccUtils.mvccVersionIsValid(mvccCrd, mvccCntr, mvccOpCntr));
        buf.putLong(mvccCrd);
        buf.putLong(mvccCntr);
        buf.putInt(mvccOpCntr);
        assert (newMvccCrd == 0L || MvccUtils.mvccVersionIsValid(newMvccCrd, newMvccCntr, newMvccOpCntr));
        buf.putLong(newMvccCrd);
        buf.putLong(newMvccCntr);
        buf.putInt(newMvccOpCntr);
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        sb.a("DataPageIO [\n");
        this.printPageLayout(addr, pageSize, sb);
        sb.a("\n]");
    }

    static enum EntryPart {
        KEY,
        VALUE,
        VERSION,
        EXPIRE_TIME,
        CACHE_ID,
        MVCC_INFO;

    }
}

