/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOGG;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOV3;
import org.apache.ignite.internal.util.GridStringBuilder;

public class PagePartitionMetaIOV1GG
extends PagePartitionMetaIOV3
implements PagePartitionMetaIOGG {
    protected static final int UPDATE_TREE_ROOT_OFF = 169;

    public PagePartitionMetaIOV1GG(int ver) {
        super(ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize, PageMetrics metrics) {
        super.initNewPage(pageAddr, pageId, pageSize, metrics);
        this.setUpdateTreeRoot(pageAddr, 0L);
    }

    @Override
    public long getUpdateTreeRoot(long pageAddr) {
        return PageUtils.getLong(pageAddr, 169);
    }

    @Override
    public boolean setUpdateTreeRoot(long pageAddr, long link) {
        if (this.getUpdateTreeRoot(pageAddr) == link) {
            return false;
        }
        PageUtils.putLong(pageAddr, 169, link);
        return true;
    }

    @Override
    protected void printFields(long pageAddr, GridStringBuilder sb) {
        super.printFields(pageAddr, sb);
        sb.a(",\n\tupdLogRootPageId=").a(this.getUpdateTreeRoot(pageAddr));
    }

    @Override
    public void upgradePage(long pageAddr) {
        assert (PageIO.getType(pageAddr) == this.getType());
        int from = PageIO.getVersion(pageAddr);
        PageIO.setVersion(pageAddr, this.getVersion());
        if (from < 2) {
            this.setPendingTreeRoot(pageAddr, 0L);
            this.setPartitionMetaStoreReuseListRoot(pageAddr, 0L);
            this.setGapsLink(pageAddr, 0L);
        }
        if (from < 3) {
            this.setEncryptedPageIndex(pageAddr, 0);
            this.setEncryptedPageCount(pageAddr, 0);
        }
        this.setUpdateTreeRoot(pageAddr, 0L);
    }
}

