/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOV1GG;
import org.apache.ignite.internal.util.GridStringBuilder;

public class PagePartitionMetaIOV2GG
extends PagePartitionMetaIOV1GG {
    public static final int TOMBSTONES_COUNT_OFF = 177;

    public PagePartitionMetaIOV2GG(int ver) {
        super(ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize, PageMetrics metrics) {
        super.initNewPage(pageAddr, pageId, pageSize, metrics);
        this.setTombstonesCount(pageAddr, 0L);
    }

    @Override
    protected void printFields(long pageAddr, GridStringBuilder sb) {
        super.printFields(pageAddr, sb);
        sb.a(",\n\ttombstonesCount=").a(this.getTombstonesCount(pageAddr));
    }

    @Override
    public long getTombstonesCount(long pageAddr) {
        return PageUtils.getLong(pageAddr, 177);
    }

    @Override
    public boolean setTombstonesCount(long pageAddr, long tombstonesCnt) {
        if (this.getTombstonesCount(pageAddr) == tombstonesCnt) {
            return false;
        }
        PageUtils.putLong(pageAddr, 177, tombstonesCnt);
        return true;
    }

    @Override
    public void upgradePage(long pageAddr) {
        assert (PageIO.getType(pageAddr) == this.getType());
        int from = PageIO.getVersion(pageAddr);
        PagePartitionMetaIO fromIo = PagePartitionMetaIO.VERSIONS.forVersion(from);
        long tombstonesCnt = 0L;
        long updLogRootPageId = 0L;
        try {
            tombstonesCnt = fromIo.getTombstonesCount(pageAddr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            updLogRootPageId = fromIo.getUpdateTreeRoot(pageAddr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.upgradePage(pageAddr);
        if (from < this.getVersion()) {
            this.setUpdateTreeRoot(pageAddr, updLogRootPageId);
            this.setTombstonesCount(pageAddr, tombstonesCnt);
        }
    }
}

