/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOV3;
import org.apache.ignite.internal.util.GridStringBuilder;

public class PagePartitionMetaIOV4
extends PagePartitionMetaIOV3 {
    protected static final int TOMBSTONES_COUNT_OFF = 169;

    public PagePartitionMetaIOV4(int ver) {
        super(ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize, PageMetrics metrics) {
        super.initNewPage(pageAddr, pageId, pageSize, metrics);
        this.setTombstonesCount(pageAddr, 0L);
    }

    @Override
    public long getTombstonesCount(long pageAddr) {
        return PageUtils.getLong(pageAddr, 169);
    }

    @Override
    public boolean setTombstonesCount(long pageAddr, long tombstonesCnt) {
        if (this.getTombstonesCount(pageAddr) == tombstonesCnt) {
            return false;
        }
        PageUtils.putLong(pageAddr, 169, tombstonesCnt);
        return true;
    }

    @Override
    protected void printFields(long pageAddr, GridStringBuilder sb) {
        super.printFields(pageAddr, sb);
        sb.a(",\n\ttombstonesCount=").a(this.getTombstonesCount(pageAddr));
    }
}

