/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.reader;

import java.util.Set;
import java.util.function.Predicate;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionMetaStateRecord;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiTuple;

public class WalFilters {
    public static Predicate<IgniteBiTuple<WALPointer, WALRecord>> checkpoint() {
        return record -> record.get2() instanceof CheckpointRecord;
    }

    public static Predicate<IgniteBiTuple<WALPointer, WALRecord>> pageOwner(Set<T2<Integer, Long>> pageOwnerIds) {
        return record -> {
            WALRecord walRecord = (WALRecord)record.get2();
            if (walRecord instanceof PageDeltaRecord) {
                PageDeltaRecord rec0 = (PageDeltaRecord)walRecord;
                return pageOwnerIds.contains(new T2<Integer, Long>(rec0.groupId(), rec0.pageId()));
            }
            if (walRecord instanceof PageSnapshot) {
                PageSnapshot rec0 = (PageSnapshot)walRecord;
                return pageOwnerIds.contains(new T2<Integer, Long>(rec0.groupId(), rec0.fullPageId().pageId()));
            }
            return false;
        };
    }

    public static Predicate<IgniteBiTuple<WALPointer, WALRecord>> partitionMetaStateUpdate(Set<T2<Integer, Integer>> partsMetaupdate) {
        return record -> {
            WALRecord walRecord = (WALRecord)record.get2();
            if (walRecord instanceof PartitionMetaStateRecord) {
                PartitionMetaStateRecord rec0 = (PartitionMetaStateRecord)walRecord;
                return partsMetaupdate.contains(new T2<Integer, Integer>(rec0.groupId(), rec0.partitionId()));
            }
            return false;
        };
    }
}

