/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.transactions.TxDeadlock;
import org.apache.ignite.internal.processors.cache.transactions.TxLock;
import org.apache.ignite.internal.processors.cache.transactions.TxLockList;
import org.apache.ignite.internal.processors.cache.transactions.TxLocksResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class TxDeadlockDetection {
    private static int deadLockTimeout = IgniteSystemProperties.getInteger("IGNITE_TX_DEADLOCK_DETECTION_TIMEOUT", 60000);
    private static final AtomicLong SEQ = new AtomicLong();
    private final GridCacheSharedContext cctx;
    private final IgniteLogger log;

    public TxDeadlockDetection(GridCacheSharedContext<?, ?> cctx) {
        this.cctx = cctx;
        this.log = cctx.logger(TxDeadlockDetection.class);
    }

    TxDeadlockFuture detectDeadlock(IgniteInternalTx tx, Set<IgniteTxKey> keys) {
        GridCacheVersion txId = tx.nearXidVersion();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deadlock detection started [nodeId=" + this.cctx.localNodeId() + ", xidVersion=" + txId + ", keys=" + keys + ']');
        }
        TxDeadlockFuture fut = new TxDeadlockFuture(this.cctx, txId, tx.topologyVersion(), keys);
        fut.init();
        return fut;
    }

    static List<GridCacheVersion> findCycle(Map<GridCacheVersion, Set<GridCacheVersion>> wfg, GridCacheVersion txId) {
        if (wfg == null || wfg.isEmpty()) {
            return null;
        }
        ArrayDeque<GridCacheVersion> stack = new ArrayDeque<GridCacheVersion>();
        HashSet<GridCacheVersion> inPath = new HashSet<GridCacheVersion>();
        HashSet<GridCacheVersion> visited = new HashSet<GridCacheVersion>();
        HashMap<GridCacheVersion, GridCacheVersion> edgeTo = new HashMap<GridCacheVersion, GridCacheVersion>();
        stack.push(txId);
        while (!stack.isEmpty()) {
            GridCacheVersion v = (GridCacheVersion)stack.peek();
            if (visited.contains(v)) {
                stack.pop();
                inPath.remove(v);
                continue;
            }
            visited.add(v);
            Set<GridCacheVersion> children = wfg.get(v);
            if (children == null || children.isEmpty()) {
                stack.pop();
                inPath.remove(v);
                continue;
            }
            inPath.add(v);
            for (GridCacheVersion w : children) {
                if (inPath.contains(w) && visited.contains(w)) {
                    ArrayList<GridCacheVersion> cycle = new ArrayList<GridCacheVersion>();
                    GridCacheVersion x = v;
                    while (!x.equals(w)) {
                        cycle.add(x);
                        x = (GridCacheVersion)edgeTo.get(x);
                    }
                    cycle.add(w);
                    cycle.add(v);
                    return cycle;
                }
                edgeTo.put(w, v);
                stack.push(w);
            }
        }
        return null;
    }

    static /* synthetic */ AtomicLong access$200() {
        return SEQ;
    }

    private static class UniqueDeque<E>
    extends ArrayDeque<E> {
        private static final long serialVersionUID = 0L;
        private final Set<E> items = new HashSet();

        private UniqueDeque() {
        }

        @Override
        public void addFirst(E e) {
            boolean first = false;
            boolean contains = this.items.contains(e);
            if (contains && !(first = this.getFirst().equals(e))) {
                this.remove(e);
            }
            if (!contains) {
                this.items.add(e);
            }
            if (!first) {
                super.addFirst(e);
            }
        }

        @Override
        public void addLast(E e) {
            if (!this.items.contains(e)) {
                super.addLast(e);
                this.items.add(e);
            }
        }

        @Override
        public E pollFirst() {
            Object e = super.pollFirst();
            this.items.remove(e);
            return e;
        }
    }

    static class TxDeadlockFuture
    extends GridFutureAdapter<TxDeadlock> {
        private final GridCacheSharedContext cctx;
        private final long futId = TxDeadlockDetection.access$200().incrementAndGet();
        private final GridCacheVersion txId;
        private final Set<IgniteTxKey> keys;
        @GridToStringInclude
        private final Set<IgniteTxKey> processedKeys = new HashSet<IgniteTxKey>();
        private final Set<UUID> processedNodes = new HashSet<UUID>();
        @GridToStringInclude
        private Map<UUID, Set<IgniteTxKey>> pendingKeys = new HashMap<UUID, Set<IgniteTxKey>>();
        @GridToStringInclude
        private final UniqueDeque<UUID> nodesQueue = new UniqueDeque();
        private final Set<UUID> preferredNodes = new HashSet<UUID>();
        private final Map<GridCacheVersion, Set<IgniteTxKey>> txLockedKeys = new HashMap<GridCacheVersion, Set<IgniteTxKey>>();
        private final Map<IgniteTxKey, Set<GridCacheVersion>> txRequestedKeys = new HashMap<IgniteTxKey, Set<GridCacheVersion>>();
        private final Map<GridCacheVersion, Set<GridCacheVersion>> wfg = new HashMap<GridCacheVersion, Set<GridCacheVersion>>();
        private final AffinityTopologyVersion topVer;
        private final Map<GridCacheVersion, T2<UUID, Long>> txs = new HashMap<GridCacheVersion, T2<UUID, Long>>();
        private UUID curNodeId;
        private int itersCnt;
        @GridToStringExclude
        private DeadlockTimeoutObject timeoutObj;
        private volatile boolean timedOut;

        private TxDeadlockFuture(GridCacheSharedContext cctx, GridCacheVersion txId, AffinityTopologyVersion topVer, Set<IgniteTxKey> keys) {
            this.cctx = cctx;
            this.txId = txId;
            this.topVer = topVer;
            this.keys = keys;
            if (deadLockTimeout > 0) {
                this.timeoutObj = new DeadlockTimeoutObject();
                cctx.time().addTimeoutObject(this.timeoutObj);
            }
        }

        long futureId() {
            return this.futId;
        }

        public void onNodeLeft(UUID nodeId) {
            if (this.compareAndSet(nodeId, null)) {
                IgniteLogger log = this.cctx.logger(TxDeadlockDetection.class);
                if (log.isDebugEnabled()) {
                    log.debug("Failed to finish deadlock detection, node left: " + nodeId);
                }
                this.onDone();
            }
        }

        private void init() {
            this.cctx.tm().addFuture(this);
            if (this.topVer == null) {
                this.onDone();
            } else {
                this.map(this.keys, Collections.emptyMap());
            }
        }

        private void map(@Nullable Set<IgniteTxKey> keys, Map<IgniteTxKey, TxLockList> txLocks) {
            this.mapTxKeys(keys, txLocks);
            UUID nodeId = this.nodesQueue.pollFirst();
            boolean set = this.compareAndSet(null, nodeId);
            assert (set);
            if (nodeId == null || this.itersCnt++ >= IgniteTxManager.DEADLOCK_MAX_ITERS || this.timedOut) {
                this.onDone();
            } else {
                Set<IgniteTxKey> txKeys = this.pendingKeys.get(nodeId);
                this.processedKeys.addAll(txKeys);
                this.processedNodes.add(nodeId);
                this.pendingKeys.remove(nodeId);
                this.cctx.tm().txLocksInfo(nodeId, this, txKeys);
            }
        }

        private void detect(TxLocksResponse res) {
            assert (res != null);
            this.merge(res);
            this.updateWaitForGraph(res.txLocks());
            List<GridCacheVersion> cycle = TxDeadlockDetection.findCycle(this.wfg, this.txId);
            if (cycle != null) {
                this.onDone(new TxDeadlock(cycle, this.txs, this.txLockedKeys, this.txRequestedKeys));
            } else {
                this.map(res.keys(), res.txLocks());
            }
        }

        private void mapTxKeys(@Nullable Set<IgniteTxKey> txKeys, Map<IgniteTxKey, TxLockList> txLocks) {
            for (Map.Entry<IgniteTxKey, TxLockList> e : txLocks.entrySet()) {
                List<TxLock> locks = e.getValue().txLocks();
                for (int i = 0; i < locks.size(); ++i) {
                    Set<IgniteTxKey> mappedKeys;
                    TxLock txLock = locks.get(i);
                    UUID nearNodeId = txLock.nearNodeId();
                    IgniteTxKey txKey = e.getKey();
                    if (this.processedKeys.contains(txKey) && this.processedNodes.contains(nearNodeId)) continue;
                    if (txLock.requested()) {
                        UUID nodeId = this.primary(txKey);
                        this.preferredNodes.add(nodeId);
                        Set<IgniteTxKey> mappedKeys2 = this.pendingKeys.get(nodeId);
                        if (mappedKeys2 == null) {
                            mappedKeys2 = new HashSet<IgniteTxKey>();
                            this.pendingKeys.put(nodeId, mappedKeys2);
                        }
                        mappedKeys2.add(txKey);
                        continue;
                    }
                    if (txLock.owner()) {
                        if (!this.preferredNodes.contains(nearNodeId)) {
                            this.nodesQueue.addFirst(nearNodeId);
                        }
                    } else {
                        this.nodesQueue.addLast(nearNodeId);
                    }
                    if ((mappedKeys = this.pendingKeys.get(nearNodeId)) == null) {
                        mappedKeys = new HashSet<IgniteTxKey>();
                        this.pendingKeys.put(nearNodeId, mappedKeys);
                    }
                    mappedKeys.add(txKey);
                }
            }
            for (UUID nodeId : this.preferredNodes) {
                this.nodesQueue.addFirst(nodeId);
            }
            this.preferredNodes.clear();
            if (txKeys != null) {
                for (IgniteTxKey txKey : txKeys) {
                    UUID nodeId = this.primary(txKey);
                    if (this.processedKeys.contains(txKey) && this.processedNodes.contains(nodeId)) continue;
                    this.nodesQueue.addLast(nodeId);
                    Set<IgniteTxKey> mappedKeys = this.pendingKeys.get(nodeId);
                    if (mappedKeys == null) {
                        mappedKeys = new HashSet<IgniteTxKey>();
                        this.pendingKeys.put(nodeId, mappedKeys);
                    }
                    mappedKeys.add(txKey);
                }
            }
        }

        private UUID primary(IgniteTxKey txKey) {
            GridCacheContext ctx = this.cctx.cacheContext(txKey.cacheId());
            ClusterNode node = ctx.affinity().primaryByKey(txKey.key(), this.topVer);
            assert (node != null) : this.topVer;
            return node.id();
        }

        private void merge(TxLocksResponse res) {
            Map<IgniteTxKey, TxLockList> txLocks = res.txLocks();
            if (txLocks == null || txLocks.isEmpty()) {
                return;
            }
            for (Map.Entry<IgniteTxKey, TxLockList> e : txLocks.entrySet()) {
                IgniteTxKey txKey = e.getKey();
                TxLockList lockList = e.getValue();
                if (lockList == null || lockList.isEmpty()) continue;
                for (TxLock lock : lockList.txLocks()) {
                    if ((lock.owner() || lock.candiate()) && this.txs.get(lock.txId()) == null) {
                        this.txs.put(lock.txId(), new T2<UUID, Long>(lock.nearNodeId(), lock.threadId()));
                    }
                    if (lock.owner()) {
                        GridCacheVersion txId = lock.txId();
                        Set<IgniteTxKey> keys = this.txLockedKeys.get(txId);
                        if (keys == null) {
                            keys = new HashSet<IgniteTxKey>();
                            this.txLockedKeys.put(txId, keys);
                        }
                        keys.add(txKey);
                        continue;
                    }
                    if (!lock.candiate()) continue;
                    Set<GridCacheVersion> txs = this.txRequestedKeys.get(txKey);
                    if (txs == null) {
                        txs = new HashSet<GridCacheVersion>();
                        this.txRequestedKeys.put(txKey, txs);
                    }
                    txs.add(lock.txId());
                }
            }
        }

        private void updateWaitForGraph(Map<IgniteTxKey, TxLockList> txLocks) {
            if (txLocks == null || txLocks.isEmpty()) {
                return;
            }
            for (Map.Entry<IgniteTxKey, TxLockList> e : txLocks.entrySet()) {
                GridCacheVersion txOwner = null;
                for (TxLock lock : e.getValue().txLocks()) {
                    if (lock.owner() && txOwner == null) {
                        txOwner = lock.txId();
                        if (!this.keys.contains(e.getKey()) || this.txId.equals(lock.txId())) continue;
                        Set<GridCacheVersion> waitingTxs = this.wfg.get(this.txId);
                        if (waitingTxs == null) {
                            waitingTxs = new HashSet<GridCacheVersion>();
                            this.wfg.put(this.txId, waitingTxs);
                        }
                        waitingTxs.add(lock.txId());
                        continue;
                    }
                    if (!lock.candiate() && !lock.owner()) continue;
                    GridCacheVersion txId0 = lock.txId();
                    Set<GridCacheVersion> waitForTxs = this.wfg.get(txId0);
                    if (waitForTxs == null) {
                        waitForTxs = new HashSet<GridCacheVersion>();
                        this.wfg.put(txId0, waitForTxs);
                    }
                    waitForTxs.add(txOwner);
                }
            }
        }

        public void onResult(UUID nodeId, TxLocksResponse res) {
            boolean set = this.compareAndSet(nodeId, null);
            if (res != null && set) {
                if (res.classError() != null) {
                    IgniteLogger log = this.cctx.kernalContext().log(this.getClass());
                    U.warn(log, "Failed to finish deadlock detection due to an error: " + nodeId);
                    this.onDone();
                } else {
                    this.detect(res);
                }
            } else {
                this.onDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean compareAndSet(UUID exp, UUID val) {
            TxDeadlockFuture txDeadlockFuture = this;
            synchronized (txDeadlockFuture) {
                if (Objects.equals(this.curNodeId, exp)) {
                    this.curNodeId = val;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean onDone(@Nullable TxDeadlock res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                this.cctx.tm().removeFuture(this.futId);
                if (this.timeoutObj != null) {
                    this.cctx.time().removeTimeoutObject(this.timeoutObj);
                }
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return S.toString(TxDeadlockFuture.class, this);
        }

        private class DeadlockTimeoutObject
        extends GridTimeoutObjectAdapter {
            DeadlockTimeoutObject() {
                super(deadLockTimeout);
            }

            @Override
            public void onTimeout() {
                TxDeadlockFuture.this.timedOut = true;
                IgniteLogger log = TxDeadlockFuture.this.cctx.kernalContext().log(this.getClass());
                U.warn(log, "Deadlock detection was timed out [timeout=" + deadLockTimeout + ", fut=" + this + ']');
                TxDeadlockFuture.this.onDone();
            }

            public String toString() {
                return S.toString(DeadlockTimeoutObject.class, this);
            }
        }
    }
}

