/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.tree.PendingRow;
import org.apache.ignite.internal.processors.cache.tree.PendingRowIO;

public abstract class AbstractPendingEntryLeafIO
extends BPlusLeafIO<PendingRow>
implements PendingRowIO {
    AbstractPendingEntryLeafIO(int type, int ver, int itemSize) {
        super(type, ver, itemSize);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, PendingRow row) throws IgniteCheckedException {
        assert (row.link != 0L);
        assert (row.expireTime != 0L);
        long expireTime = row.expireTime;
        if (row.tombstone.booleanValue()) {
            expireTime |= Long.MIN_VALUE;
        }
        PageUtils.putLong(pageAddr, off, expireTime);
        PageUtils.putLong(pageAddr, off + 8, row.link);
        if (this.storeCacheId()) {
            assert (row.cacheId != 0);
            PageUtils.putInt(pageAddr, off + 16, row.cacheId);
        }
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BPlusIO<PendingRow> srcIo, long srcPageAddr, int srcIdx) throws IgniteCheckedException {
        int dstOff = this.offset(dstIdx);
        long link = ((PendingRowIO)((Object)srcIo)).getLink(srcPageAddr, srcIdx);
        long expireTime = ((PendingRowIO)((Object)srcIo)).getExpireTime(srcPageAddr, srcIdx);
        PageUtils.putLong(dstPageAddr, dstOff, expireTime);
        PageUtils.putLong(dstPageAddr, dstOff + 8, link);
        if (this.storeCacheId()) {
            int cacheId = ((PendingRowIO)((Object)srcIo)).getCacheId(srcPageAddr, srcIdx);
            assert (cacheId != 0);
            PageUtils.putInt(dstPageAddr, dstOff + 16, cacheId);
        }
    }

    @Override
    public PendingRow getLookupRow(BPlusTree<PendingRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        long expireTime = this.getExpireTime(pageAddr, idx);
        boolean tombstone = false;
        if ((expireTime & Long.MIN_VALUE) != 0L) {
            tombstone = true;
            expireTime &= Long.MAX_VALUE;
        }
        return new PendingRow(this.getCacheId(pageAddr, idx), tombstone, expireTime, this.getLink(pageAddr, idx));
    }

    @Override
    public long getExpireTime(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx));
    }

    @Override
    public long getLink(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 8);
    }

    protected abstract boolean storeCacheId();
}

