/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;

public class PendingRow {
    public long expireTime;
    public long link;
    public int cacheId;
    public Boolean tombstone;
    public KeyCacheObject key;
    public IgniteUuid deploymentId;

    public PendingRow(int cacheId) {
        this.cacheId = cacheId;
    }

    public PendingRow(int cacheId, boolean tombstone, long expireTime, long link) {
        this.cacheId = cacheId;
        this.tombstone = tombstone;
        this.expireTime = expireTime;
        this.link = link;
    }

    PendingRow initKey(CacheGroupContext grp) throws IgniteCheckedException {
        CacheDataRowAdapter rowData = grp.mvccEnabled() ? new MvccDataRow(this.link) : new CacheDataRowAdapter(this.link);
        rowData.initFromLink(grp, CacheDataRowAdapter.RowData.KEY_ONLY);
        this.key = rowData.key();
        return this;
    }

    public String toString() {
        return S.toString(PendingRow.class, this, "expireTime", (Object)this.expireTime, "link", (Object)this.link, "cacheId", (Object)this.cacheId, "tombstone", (Object)this.tombstone, "key", (Object)this.key);
    }
}

