/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.mvcc.data;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionImpl;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MvccDataRow
extends DataRow {
    @GridToStringInclude
    private long mvccCrd;
    @GridToStringInclude
    private long mvccCntr;
    @GridToStringInclude
    private int mvccOpCntr;
    @GridToStringInclude
    private byte mvccTxState;
    @GridToStringInclude
    private long newMvccCrd;
    @GridToStringInclude
    private long newMvccCntr;
    @GridToStringInclude
    private int newMvccOpCntr;
    @GridToStringInclude
    private byte newMvccTxState;
    @GridToStringInclude
    private boolean keyAbsentFlag;

    public MvccDataRow(long link) {
        super(link);
    }

    public MvccDataRow(CacheGroupContext grp, int hash, long link, int part, CacheDataRowAdapter.RowData rowData, long crdVer, long mvccCntr, int mvccOpCntr, boolean skipVer) {
        super(grp, hash, link, part, rowData, skipVer);
        assert (MvccUtils.mvccVersionIsValid(crdVer, mvccCntr, mvccOpCntr));
        assert (rowData == CacheDataRowAdapter.RowData.LINK_ONLY || this.mvccCoordinatorVersion() == crdVer && this.mvccCounter() == mvccCntr && this.mvccOperationCounter() == mvccOpCntr) : "mvccVer=" + new MvccVersionImpl(crdVer, mvccCntr, mvccOpCntr) + ", dataMvccVer=" + new MvccVersionImpl(this.mvccCoordinatorVersion(), this.mvccCounter(), this.mvccOperationCounter());
        if (rowData == CacheDataRowAdapter.RowData.LINK_ONLY) {
            this.mvccCrd = crdVer;
            this.mvccCntr = mvccCntr;
            this.mvccOpCntr = mvccOpCntr;
        }
        assert ((mvccOpCntr & 0xE0000000) == 0) : mvccOpCntr;
    }

    public MvccDataRow() {
        super(0L);
    }

    public MvccDataRow(KeyCacheObject key, CacheObject val, GridCacheVersion ver, int part, long expireTime, int cacheId, MvccVersion mvccVer, MvccVersion newMvccVer) {
        super(key, val, ver, part, expireTime, cacheId);
        this.mvccCrd = mvccVer.coordinatorVersion();
        this.mvccCntr = mvccVer.counter();
        this.mvccOpCntr = mvccVer.operationCounter();
        assert ((this.mvccOpCntr & 0xE0000000) == 0) : this.mvccOpCntr;
        if (newMvccVer == null) {
            this.newMvccCrd = 0L;
            this.newMvccCntr = 0L;
            this.newMvccOpCntr = 0;
        } else {
            this.newMvccCrd = newMvccVer.coordinatorVersion();
            this.newMvccCntr = newMvccVer.counter();
            this.newMvccOpCntr = newMvccVer.operationCounter();
            assert ((this.newMvccOpCntr & 0xE0000000) == 0) : this.newMvccOpCntr;
        }
    }

    @Override
    protected int readHeader(GridCacheSharedContext<?, ?> sharedCtx, long addr, int off, CacheDataRowAdapter.RowData rowData) {
        boolean addHints = rowData == CacheDataRowAdapter.RowData.FULL_WITH_HINTS || rowData == CacheDataRowAdapter.RowData.NO_KEY_WITH_HINTS;
        this.mvccCrd = PageUtils.getLong(addr, off);
        this.mvccCntr = PageUtils.getLong(addr, off + 8);
        int withHint = PageUtils.getInt(addr, off + 16);
        this.mvccOpCntr = withHint & 0x1FFFFFFF;
        this.mvccTxState = (byte)(withHint >>> 30);
        if (addHints && this.mvccTxState == 0) {
            this.mvccTxState = MvccUtils.state(sharedCtx.coordinators(), this.mvccCrd, this.mvccCntr, this.mvccOpCntr);
        }
        assert (MvccUtils.mvccVersionIsValid(this.mvccCrd, this.mvccCntr, this.mvccOpCntr));
        this.keyAbsentFlag = (withHint & 0x20000000) != 0;
        this.newMvccCrd = PageUtils.getLong(addr, off + 20);
        this.newMvccCntr = PageUtils.getLong(addr, off + 28);
        withHint = PageUtils.getInt(addr, off + 36);
        this.newMvccOpCntr = withHint & 0x1FFFFFFF;
        this.newMvccTxState = (byte)(withHint >>> 30);
        assert (this.newMvccCrd == 0L || MvccUtils.mvccVersionIsValid(this.newMvccCrd, this.newMvccCntr, this.newMvccOpCntr));
        if (this.newMvccCrd != 0L) {
            boolean bl = this.keyAbsentFlag = (withHint & 0x20000000) != 0;
            if (addHints && this.newMvccTxState == 0) {
                this.newMvccTxState = MvccUtils.state(sharedCtx.coordinators(), this.newMvccCrd, this.newMvccCntr, this.newMvccOpCntr);
            }
        }
        return 40;
    }

    @Override
    public long mvccCoordinatorVersion() {
        return this.mvccCrd;
    }

    @Override
    public long mvccCounter() {
        return this.mvccCntr;
    }

    @Override
    public int mvccOperationCounter() {
        assert ((this.mvccCntr & 0xFFFFFFFFE0000000L) == 0L);
        return this.mvccOpCntr;
    }

    @Override
    public byte mvccTxState() {
        return this.mvccTxState;
    }

    @Override
    public long newMvccCoordinatorVersion() {
        return this.newMvccCrd;
    }

    @Override
    public long newMvccCounter() {
        return this.newMvccCntr;
    }

    @Override
    public int newMvccOperationCounter() {
        assert ((this.newMvccOpCntr & 0xE0000000) == 0);
        return this.newMvccOpCntr;
    }

    @Override
    public byte newMvccTxState() {
        return this.newMvccTxState;
    }

    @Override
    public void newMvccVersion(long crd, long cntr, int opCntr) {
        assert ((opCntr & 0xE0000000) == 0) : opCntr;
        this.newMvccCrd = crd;
        this.newMvccCntr = cntr;
        this.newMvccOpCntr = opCntr;
        this.newMvccTxState = 0;
    }

    @Override
    public void mvccVersion(long crd, long cntr, int opCntr) {
        assert ((opCntr & 0xE0000000) == 0) : opCntr;
        this.mvccCrd = crd;
        this.mvccCntr = cntr;
        this.mvccOpCntr = opCntr;
        this.mvccTxState = 0;
    }

    public void mvccTxState(byte mvccTxState) {
        this.mvccTxState = mvccTxState;
    }

    public void newMvccTxState(byte newMvccTxState) {
        this.newMvccTxState = newMvccTxState;
    }

    protected boolean keyAbsentBeforeFlag() {
        return this.keyAbsentFlag;
    }

    protected void keyAbsentBeforeFlag(boolean flag) {
        this.keyAbsentFlag = flag;
    }

    @Override
    public int size() throws IgniteCheckedException {
        return super.size() + 40;
    }

    @Override
    public int headerSize() {
        return 40;
    }

    @Override
    public boolean tombstone() {
        return false;
    }

    @Override
    public String toString() {
        return S.toString(MvccDataRow.class, this, "super", (Object)super.toString());
    }
}

