/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.updatelog;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.tree.PendingRowIO;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogRow;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogRowIO;

public abstract class AbstractUpdateLogLeafIO
extends BPlusLeafIO<UpdateLogRow>
implements UpdateLogRowIO {
    AbstractUpdateLogLeafIO(int type, int ver, int itemSize) {
        super(type, ver, itemSize);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, UpdateLogRow row) {
        assert (row.link != 0L);
        assert (row.updCntr != 0L);
        PageUtils.putLong(pageAddr, off, row.updCntr);
        PageUtils.putLong(pageAddr, off + 8, row.link);
        if (this.storeCacheId()) {
            assert (row.cacheId != 0);
            PageUtils.putInt(pageAddr, off + 16, row.cacheId);
        }
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BPlusIO<UpdateLogRow> srcIo, long srcPageAddr, int srcIdx) throws IgniteCheckedException {
        int dstOff = this.offset(dstIdx);
        long link = ((UpdateLogRowIO)((Object)srcIo)).getLink(srcPageAddr, srcIdx);
        long updCntr = ((UpdateLogRowIO)((Object)srcIo)).getUpdateCounter(srcPageAddr, srcIdx);
        PageUtils.putLong(dstPageAddr, dstOff, updCntr);
        PageUtils.putLong(dstPageAddr, dstOff + 8, link);
        if (this.storeCacheId()) {
            int cacheId = ((PendingRowIO)((Object)srcIo)).getCacheId(srcPageAddr, srcIdx);
            assert (cacheId != 0);
            PageUtils.putInt(dstPageAddr, dstOff + 16, cacheId);
        }
    }

    @Override
    public UpdateLogRow getLookupRow(BPlusTree<UpdateLogRow, ?> tree, long pageAddr, int idx) {
        return new UpdateLogRow(this.getCacheId(pageAddr, idx), this.getUpdateCounter(pageAddr, idx), this.getLink(pageAddr, idx));
    }

    @Override
    public long getUpdateCounter(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx));
    }

    @Override
    public long getLink(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 8);
    }

    protected abstract boolean storeCacheId();
}

