/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.updatelog;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.tree.updatelog.CacheIdAwareUpdateLogInnerIO;
import org.apache.ignite.internal.processors.cache.tree.updatelog.CacheIdAwareUpdateLogLeafIO;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogInnerIO;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogLeafIO;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogRow;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogRowIO;

public class PartitionLogTree
extends BPlusTree<UpdateLogRow, UpdateLogRow> {
    public static final Object FULL_ROW = new Object();
    private final CacheGroupContext grp;

    public PartitionLogTree(CacheGroupContext grp, String name, PageMemory pageMem, long metaPageId, ReuseList reuseList, boolean initNew, PageLockTrackerManager pageLockTrackerManager, byte pageFlag) throws IgniteCheckedException {
        super(name, grp.groupId(), grp.name(), pageMem, grp.dataRegion().config().isPersistenceEnabled() ? grp.shared().wal() : null, grp.offheap().globalRemoveId(), metaPageId, reuseList, grp.sharedGroup() ? CacheIdAwareUpdateLogInnerIO.VERSIONS : UpdateLogInnerIO.VERSIONS, grp.sharedGroup() ? CacheIdAwareUpdateLogLeafIO.VERSIONS : UpdateLogLeafIO.VERSIONS, pageFlag, grp.shared().kernalContext().failure(), pageLockTrackerManager);
        this.grp = grp;
        assert (!grp.dataRegion().config().isPersistenceEnabled() || grp.shared().database().checkpointLockIsHeldByThread());
        this.initTree(initNew);
    }

    @Override
    protected int compare(BPlusIO<UpdateLogRow> iox, long pageAddr, int idx, UpdateLogRow row) {
        int cmp;
        UpdateLogRowIO io = (UpdateLogRowIO)((Object)iox);
        if (this.grp.sharedGroup()) {
            assert (row.cacheId != 0) : "Cache ID is not provided!";
            assert (io.getCacheId(pageAddr, idx) != 0) : "Cache ID is not stored!";
            cmp = Integer.compare(io.getCacheId(pageAddr, idx), row.cacheId);
            if (cmp != 0) {
                return cmp;
            }
            if (row.updCntr == 0L && row.link == 0L) {
                return cmp;
            }
        }
        long updCntr = io.getUpdateCounter(pageAddr, idx);
        cmp = Long.compare(updCntr, row.updCntr);
        assert (cmp != 0 || row.link == 0L || io.getLink(pageAddr, idx) == row.link);
        return cmp;
    }

    @Override
    public UpdateLogRow getRow(BPlusIO<UpdateLogRow> io, long pageAddr, int idx, Object flag) throws IgniteCheckedException {
        UpdateLogRow row = io.getLookupRow(this, pageAddr, idx);
        return flag == FULL_ROW ? row.initRow(this.grp) : row;
    }
}

