/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.updatelog;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class UpdateLogRow {
    @GridToStringInclude
    final int cacheId;
    @GridToStringInclude
    final long updCntr;
    @GridToStringInclude
    final long link;
    private CacheDataRowAdapter rowData;

    public UpdateLogRow(int cacheId) {
        this(cacheId, 0L);
    }

    public UpdateLogRow(int cacheId, long updCntr) {
        this(cacheId, updCntr, 0L);
    }

    public UpdateLogRow(int cacheId, long updCntr, long link) {
        this.cacheId = cacheId;
        this.updCntr = updCntr;
        this.link = link;
    }

    public long link() {
        return this.link;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public long updateCounter() {
        return this.updCntr;
    }

    UpdateLogRow initRow(CacheGroupContext grp) throws IgniteCheckedException {
        assert (!grp.mvccEnabled()) : "MVCC is not supported.";
        this.rowData = new CacheDataRowAdapter(this.link);
        this.rowData.initFromLink(grp, CacheDataRowAdapter.RowData.FULL);
        return this;
    }

    public KeyCacheObject key() {
        return this.rowData.key();
    }

    public CacheObject value() {
        return this.rowData.value();
    }

    public GridCacheVersion version() {
        return this.rowData.version();
    }

    public long expireTime() {
        return this.rowData.expireTime();
    }

    public String toString() {
        return S.toString(UpdateLogRow.class, this);
    }
}

