/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class DiscoveryDataClusterState
implements Serializable {
    private static final long serialVersionUID = 0L;
    @Deprecated
    private final boolean active;
    private final ClusterState state;
    private final long lastStateChangeTime;
    private final long activationTime;
    @Nullable
    private final BaselineTopology baselineTopology;
    private final UUID transitionReqId;
    private final ClusterState prevClusterState;
    @GridToStringInclude
    private final AffinityTopologyVersion transitionTopVer;
    @GridToStringExclude
    private final Set<UUID> transitionNodes;
    private volatile transient ClusterState transitionRes;
    private transient DiscoveryDataClusterState prevState;
    private volatile transient Exception transitionError;
    private volatile transient boolean locBaselineAutoAdjustment;

    static DiscoveryDataClusterState createState(ClusterState state, @Nullable BaselineTopology baselineTopology, long activationTime) {
        return new DiscoveryDataClusterState(null, state, baselineTopology, null, null, activationTime, null);
    }

    static DiscoveryDataClusterState createTransitionState(ClusterState state, DiscoveryDataClusterState prevState, @Nullable BaselineTopology baselineTopology, UUID transitionReqId, AffinityTopologyVersion transitionTopVer, long activationTime, Set<UUID> transitionNodes) {
        assert (transitionReqId != null);
        assert (transitionTopVer != null);
        assert (!F.isEmpty(transitionNodes)) : transitionNodes;
        assert (prevState != null);
        return new DiscoveryDataClusterState(prevState, state, baselineTopology, transitionReqId, transitionTopVer, activationTime, transitionNodes);
    }

    private DiscoveryDataClusterState(@Nullable DiscoveryDataClusterState prevState, ClusterState state, @Nullable BaselineTopology baselineTopology, @Nullable UUID transitionReqId, @Nullable AffinityTopologyVersion transitionTopVer, long activationTime, @Nullable Set<UUID> transitionNodes) {
        assert (state != null);
        this.prevState = prevState;
        this.state = state;
        this.active = ClusterState.active(state);
        this.lastStateChangeTime = U.currentTimeMillis();
        this.activationTime = activationTime;
        this.baselineTopology = baselineTopology;
        this.transitionReqId = transitionReqId;
        this.transitionTopVer = transitionTopVer;
        this.transitionNodes = transitionNodes;
        this.prevClusterState = prevState == null ? null : prevState.state;
    }

    public ClusterState lastState() {
        if (this.transition()) {
            return this.prevClusterState != null ? this.prevClusterState : (!this.active ? ClusterState.INACTIVE : ClusterState.ACTIVE);
        }
        return this.state();
    }

    @Nullable
    public ClusterState transitionResult() {
        return this.transitionRes;
    }

    public void setTransitionResult(UUID reqId, ClusterState state) {
        if (reqId.equals(this.transitionReqId)) {
            this.transitionRes = state;
        }
    }

    public UUID transitionRequestId() {
        return this.transitionReqId;
    }

    public boolean transition() {
        return this.transitionReqId != null;
    }

    public boolean baselineChanging() {
        return this.transition() && this.prevState != null && this.prevState.active() && this.active();
    }

    public AffinityTopologyVersion transitionTopologyVersion() {
        return this.transitionTopVer;
    }

    @Deprecated
    public boolean active() {
        return ClusterState.active(this.state());
    }

    public long activationTime() {
        return this.activationTime;
    }

    public ClusterState state() {
        return this.state != null ? this.state : (this.active ? ClusterState.ACTIVE : ClusterState.INACTIVE);
    }

    public long lastStateChangeTime() {
        return this.lastStateChangeTime;
    }

    @Nullable
    public BaselineTopology baselineTopology() {
        return this.baselineTopology;
    }

    @Nullable
    public BaselineTopology previousBaselineTopology() {
        return this.prevState != null ? this.prevState.baselineTopology() : null;
    }

    public boolean hasBaselineTopology() {
        return this.baselineTopology != null;
    }

    public Set<UUID> transitionNodes() {
        return this.transitionNodes;
    }

    @Nullable
    public Exception transitionError() {
        return this.transitionError;
    }

    public void transitionError(Exception ex) {
        this.transitionError = ex;
    }

    public boolean localBaselineAutoAdjustment() {
        return this.locBaselineAutoAdjustment;
    }

    public void localBaselineAutoAdjustment(boolean adjusted) {
        this.locBaselineAutoAdjustment = adjusted;
    }

    public DiscoveryDataClusterState finish(boolean success) {
        if (success) {
            ClusterState newState = this.state != null ? this.state : (this.active ? ClusterState.ACTIVE : ClusterState.INACTIVE);
            return DiscoveryDataClusterState.createState(newState, this.baselineTopology, this.activationTime);
        }
        return this.prevState != null ? this.prevState : DiscoveryDataClusterState.createState(ClusterState.INACTIVE, null, 0L);
    }

    public String toString() {
        return S.toString(DiscoveryDataClusterState.class, this);
    }
}

