/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.GridKernalGateway;
import org.apache.ignite.internal.IgniteProperties;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.cluster.HttpIgniteUpdatesChecker;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.plugin.PluginProvider;
import org.jetbrains.annotations.Nullable;

class GridUpdateNotifier {
    private static final String COMMUNITY_EDITION = "ce";
    private static final String ENTERPRISE_EDITION = "ee";
    private static final String ULTIMATE_EDITION = "ue";
    static final String CHARSET = "UTF-8";
    private final String updStatusParams = IgniteProperties.get("ignite.update.status.params");
    private static final long THROTTLE_PERIOD = 86400000L;
    private static final int WORKER_THREAD_SLEEP_TIME = 5000;
    static final String DEFAULT_GRIDGAIN_UPDATES_URL = "https://www.gridgain.com/notifier/update";
    private final String ver;
    private final GridDiscoveryManager discoSpi;
    private volatile Exception err;
    private volatile String latestVer;
    private volatile String downloadUrl;
    private final String igniteInstanceName;
    private volatile boolean reportOnlyNew;
    private final String vmProps;
    private final String pluginsVers;
    private final GridKernalGateway gw;
    private int srvNodes = 0;
    private String product;
    private long lastLog = -1L;
    private final AtomicReference<Runnable> cmd = new AtomicReference();
    private final Thread workerThread;
    private final HttpIgniteUpdatesChecker updatesChecker;
    private static final Set<String> PROPS_TO_EXCLUDE = new HashSet<String>();

    GridUpdateNotifier(String igniteInstanceName, String ver, GridKernalGateway gw, GridDiscoveryManager discovery, Collection<PluginProvider> pluginProviders, boolean reportOnlyNew, HttpIgniteUpdatesChecker updatesChecker) throws IgniteCheckedException {
        try {
            this.ver = this.regularize(ver);
            this.igniteInstanceName = igniteInstanceName == null ? "null" : igniteInstanceName;
            this.gw = gw;
            this.updatesChecker = updatesChecker;
            SB pluginsBuilder = new SB();
            for (PluginProvider provider : pluginProviders) {
                pluginsBuilder.a("&").a(provider.name() + "-plugin-version").a("=").a(URLEncoder.encode(Optional.ofNullable(provider.version()).orElse("UNKNOWN"), CHARSET));
            }
            this.pluginsVers = pluginsBuilder.toString();
            this.reportOnlyNew = reportOnlyNew;
            this.vmProps = GridUpdateNotifier.getSystemProperties();
            this.product = this.checkProduct();
            this.discoSpi = discovery;
            this.workerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            Runnable cmd0 = GridUpdateNotifier.this.cmd.getAndSet(null);
                            if (cmd0 != null) {
                                cmd0.run();
                                continue;
                            }
                            Thread.sleep(5000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }, "upd-ver-checker");
            this.workerThread.setDaemon(true);
            this.workerThread.start();
        }
        catch (UnsupportedEncodingException e) {
            throw new IgniteCheckedException("Failed to encode.", e);
        }
    }

    private String checkProduct() {
        String res = COMMUNITY_EDITION;
        try {
            Class<?> c = Class.forName("org.gridgain.grid.internal.processors.cache.database.SnapshotsMessageFactory");
            res = ULTIMATE_EDITION;
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> c = Class.forName("org.gridgain.grid.persistentstore.GridSnapshot");
                res = ENTERPRISE_EDITION;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return res;
    }

    private String regularize(String ver) {
        int pos = ver.indexOf(45);
        return ver.substring(0, pos >= 0 ? pos : ver.length());
    }

    private static String getSystemProperties() {
        try {
            StringWriter sw = new StringWriter();
            try {
                Properties snapshot = IgniteSystemProperties.snapshot();
                for (String toExclude : PROPS_TO_EXCLUDE) {
                    snapshot.remove(toExclude);
                }
                snapshot.store(new PrintWriter(sw), "");
            }
            catch (IOException ignore) {
                return null;
            }
            return sw.toString();
        }
        catch (SecurityException ignore) {
            return null;
        }
    }

    void reportOnlyNew(boolean reportOnlyNew) {
        this.reportOnlyNew = reportOnlyNew;
    }

    String latestVersion() {
        return this.latestVer;
    }

    Exception error() {
        return this.err;
    }

    void checkForNewVersion(IgniteLogger log) {
        assert (log != null);
        log = log.getLogger(this.getClass());
        try {
            this.cmd.set(new UpdateChecker(log));
        }
        catch (RejectedExecutionException e) {
            U.error(log, "Failed to schedule a thread due to execution rejection (safely ignoring): " + e.getMessage());
        }
    }

    void reportStatus(IgniteLogger log) {
        assert (log != null);
        log = log.getLogger(this.getClass());
        String latestVer = this.latestVer;
        String downloadUrl = this.downloadUrl;
        String string = downloadUrl = downloadUrl != null ? downloadUrl : "gridgain.com";
        if (latestVer != null) {
            if (latestVer.equals(this.ver)) {
                if (!this.reportOnlyNew) {
                    this.throttle(log, false, "Your version is up to date.");
                }
            } else {
                this.throttle(log, true, "New version is available at " + downloadUrl + ": " + latestVer);
            }
        } else if (!this.reportOnlyNew) {
            this.throttle(log, false, "Update status is not available.");
        }
    }

    private void throttle(IgniteLogger log, boolean warn, String msg) {
        assert (log != null);
        assert (msg != null);
        long now = U.currentTimeMillis();
        if (now - this.lastLog > 86400000L) {
            if (!warn) {
                U.log(log, msg);
            } else {
                U.quiet(true, msg);
                if (log.isInfoEnabled()) {
                    log.warning(msg);
                }
            }
            this.lastLog = now;
        }
    }

    public void stop() {
        this.workerThread.interrupt();
    }

    static {
        PROPS_TO_EXCLUDE.add("sun.boot.library.path");
        PROPS_TO_EXCLUDE.add("sun.boot.class.path");
        PROPS_TO_EXCLUDE.add("java.class.path");
        PROPS_TO_EXCLUDE.add("java.endorsed.dirs");
        PROPS_TO_EXCLUDE.add("java.library.path");
        PROPS_TO_EXCLUDE.add("java.home");
        PROPS_TO_EXCLUDE.add("java.ext.dirs");
        PROPS_TO_EXCLUDE.add("user.dir");
        PROPS_TO_EXCLUDE.add("user.home");
        PROPS_TO_EXCLUDE.add("user.name");
        PROPS_TO_EXCLUDE.add("IGNITE_HOME");
        PROPS_TO_EXCLUDE.add("IGNITE_CONFIG_URL");
    }

    private class UpdateChecker
    extends GridWorker {
        private final IgniteLogger log;

        UpdateChecker(IgniteLogger log) {
            super(GridUpdateNotifier.this.igniteInstanceName, "grid-version-checker", log);
            this.log = log.getLogger(this.getClass());
        }

        @Override
        protected void body() throws InterruptedException {
            block8: {
                try {
                    String stackTrace = GridUpdateNotifier.this.gw != null ? GridUpdateNotifier.this.gw.userStackTrace() : null;
                    GridUpdateNotifier.this.srvNodes = GridUpdateNotifier.this.discoSpi.serverNodes(GridUpdateNotifier.this.discoSpi.topologyVersionEx()).size();
                    String postParams = "igniteInstanceName=" + URLEncoder.encode(GridUpdateNotifier.this.igniteInstanceName, GridUpdateNotifier.CHARSET) + (!F.isEmpty(GridUpdateNotifier.this.updStatusParams) ? "&" + GridUpdateNotifier.this.updStatusParams : "") + "&srvNodes=" + GridUpdateNotifier.this.srvNodes + "&product=" + GridUpdateNotifier.this.product + (!F.isEmpty(stackTrace) ? "&stackTrace=" + URLEncoder.encode(stackTrace, GridUpdateNotifier.CHARSET) : "") + (!F.isEmpty(GridUpdateNotifier.this.vmProps) ? "&vmProps=" + URLEncoder.encode(GridUpdateNotifier.this.vmProps, GridUpdateNotifier.CHARSET) : "") + GridUpdateNotifier.this.pluginsVers;
                    if (!this.isCancelled()) {
                        try {
                            String[] lines;
                            String updatesRes = GridUpdateNotifier.this.updatesChecker.getUpdates(postParams);
                            for (String line : lines = updatesRes.split("\n")) {
                                if (line.contains("version")) {
                                    GridUpdateNotifier.this.latestVer = GridUpdateNotifier.this.regularize(this.obtainVersionFrom(line));
                                    continue;
                                }
                                if (!line.contains("downloadUrl")) continue;
                                GridUpdateNotifier.this.downloadUrl = this.obtainDownloadUrlFrom(line);
                            }
                            GridUpdateNotifier.this.err = null;
                        }
                        catch (IOException e) {
                            GridUpdateNotifier.this.err = e;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed to connect to Ignite update server. " + e.getMessage());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    GridUpdateNotifier.this.err = e;
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug("Unexpected exception in update checker. " + e.getMessage());
                }
            }
        }

        @Nullable
        private String obtainMeta(String metaName, String line) {
            assert (line.contains(metaName));
            return line.substring(line.indexOf(metaName) + metaName.length()).trim();
        }

        @Nullable
        private String obtainVersionFrom(String line) {
            return this.obtainMeta("version=", line);
        }

        @Nullable
        private String obtainDownloadUrlFrom(String line) {
            return this.obtainMeta("downloadUrl=", line);
        }
    }
}

