/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.configuration.distributed;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.configuration.distributed.PropertyUpdateClosure;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.processors.metastorage.DistributedMetastorageLifecycleListener;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

public class DistributedConfigurationProcessor
extends GridProcessorAdapter
implements DistributedPropertyDispatcher {
    private static final String DIST_CONF_PREFIX = "distrConf-";
    private final Map<String, DistributedChangeableProperty> props = new ConcurrentHashMap<String, DistributedChangeableProperty>();
    private volatile DistributedMetaStorage distributedMetastorage;
    private volatile AllowableAction allowableAction = AllowableAction.REGISTER;

    public DistributedConfigurationProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.ctx.isDaemon()) {
            return;
        }
        final GridInternalSubscriptionProcessor isp = this.ctx.internalSubscriptionProcessor();
        isp.registerDistributedMetastorageListener(new DistributedMetastorageLifecycleListener(){

            @Override
            public void onReadyForRead(ReadableDistributedMetaStorage metastorage) {
                DistributedConfigurationProcessor.this.distributedMetastorage = DistributedConfigurationProcessor.this.ctx.distributedMetastorage();
                DistributedConfigurationProcessor.this.distributedMetastorage.listen(key -> key.startsWith(DistributedConfigurationProcessor.DIST_CONF_PREFIX), (key, oldVal, newVal) -> {
                    DistributedChangeableProperty prop = (DistributedChangeableProperty)DistributedConfigurationProcessor.this.props.get(DistributedConfigurationProcessor.toPropertyKey(key));
                    if (prop != null) {
                        prop.localUpdate(newVal);
                    }
                });
                DistributedConfigurationProcessor.this.switchCurrentActionTo(AllowableAction.ACTUALIZE);
                isp.getDistributedConfigurationListeners().forEach(listener -> listener.onReadyToRegister(DistributedConfigurationProcessor.this));
            }

            @Override
            public void onReadyForWrite(DistributedMetaStorage metastorage) {
                DistributedConfigurationProcessor.this.switchCurrentActionTo(AllowableAction.CLUSTER_WIDE_UPDATE);
                isp.getDistributedConfigurationListeners().forEach(DistributedConfigurationLifecycleListener::onReadyToWrite);
            }
        });
    }

    private synchronized void switchCurrentActionTo(AllowableAction to) {
        AllowableAction oldAct = this.allowableAction;
        assert (oldAct.ordinal() <= to.ordinal()) : "Current action : " + (Object)((Object)oldAct) + ", new action : " + (Object)((Object)to);
        this.allowableAction = to;
        for (AllowableAction action : AllowableAction.values()) {
            if (action.ordinal() > oldAct.ordinal()) {
                this.props.values().forEach(prop -> this.doAction(action, (DistributedChangeableProperty)prop));
            }
            if (action == to) break;
        }
    }

    private static String toMetaStorageKey(String propKey) {
        return DIST_CONF_PREFIX + propKey;
    }

    private static String toPropertyKey(String metaStorageKey) {
        return metaStorageKey.substring(DIST_CONF_PREFIX.length());
    }

    @Override
    public <T extends DistributedChangeableProperty> void registerProperties(T ... props) {
        Arrays.stream(props).forEach(this::registerProperty);
    }

    @Override
    public <T extends Serializable> DistributedProperty<T> registerProperty(DistributedChangeableProperty<T> prop) {
        this.doAllAllowableActions(prop);
        return prop;
    }

    public List<DistributedChangeableProperty<Serializable>> properties() {
        return this.props.values().stream().map(p -> p).collect(Collectors.toList());
    }

    public DistributedChangeableProperty<Serializable> property(String name) {
        DistributedChangeableProperty p = this.props.get(name);
        if (!(p instanceof DistributedChangeableProperty)) {
            return null;
        }
        return p;
    }

    private void doAllAllowableActions(DistributedChangeableProperty prop) {
        for (AllowableAction action : AllowableAction.values()) {
            this.doAction(action, prop);
            if (action == this.allowableAction) break;
        }
    }

    private void doAction(AllowableAction act, DistributedChangeableProperty prop) {
        switch (act) {
            case REGISTER: {
                this.doRegister(prop);
                break;
            }
            case ACTUALIZE: {
                this.doActualize(prop);
                break;
            }
            case CLUSTER_WIDE_UPDATE: {
                this.doClusterWideUpdate(prop);
            }
        }
    }

    private void doRegister(DistributedChangeableProperty prop) {
        if (this.props.containsKey(prop.getName())) {
            throw new IllegalArgumentException("Property already exists : " + prop.getName());
        }
        this.props.put(prop.getName(), prop);
        prop.onAttached();
    }

    private void doActualize(DistributedChangeableProperty prop) {
        Serializable readVal = null;
        try {
            readVal = (Serializable)this.distributedMetastorage.read(DistributedConfigurationProcessor.toMetaStorageKey(prop.getName()));
        }
        catch (IgniteCheckedException e) {
            this.log.error("Can not read value of property '" + prop.getName() + "'", e);
        }
        prop.localUpdate(readVal);
    }

    private void doClusterWideUpdate(DistributedChangeableProperty prop) {
        prop.onReadyForUpdate(new PropertyUpdateClosure(){

            @Override
            public GridFutureAdapter<?> update(String key, Serializable newValue) throws IgniteCheckedException {
                return DistributedConfigurationProcessor.this.distributedMetastorage.writeAsync(DistributedConfigurationProcessor.toMetaStorageKey(key), newValue);
            }

            @Override
            public GridFutureAdapter<?> casUpdate(String key, Serializable expectedValue, Serializable newValue) throws IgniteCheckedException {
                return DistributedConfigurationProcessor.this.distributedMetastorage.compareAndSetAsync(DistributedConfigurationProcessor.toMetaStorageKey(key), expectedValue, newValue);
            }
        });
    }

    static enum AllowableAction {
        REGISTER,
        ACTUALIZE,
        CLUSTER_WIDE_UPDATE;

    }
}

