/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.datastructures.AtomicDataStructureProxy;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicSequenceEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicSequenceValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public final class GridCacheAtomicSequenceImpl
extends AtomicDataStructureProxy<GridCacheAtomicSequenceValue>
implements GridCacheAtomicSequenceEx,
IgniteChangeGlobalStateSupport,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };
    @GridToStringInclude(sensitive=true)
    private volatile long locVal;
    private long upBound;
    private volatile int batchSize;
    private final Lock localUpdate = new ReentrantLock();
    private final ReentrantLock distUpdateFreeTop = new ReentrantLock();
    private final ReentrantLock distUpdateLockedTop = new ReentrantLock();
    private final Callable<Long> incAndGetCall = this.internalUpdate(1L, true);
    private final Callable<Long> getAndIncCall = this.internalUpdate(1L, false);

    public GridCacheAtomicSequenceImpl() {
    }

    public GridCacheAtomicSequenceImpl(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicSequenceValue> seqView, int batchSize, long locVal, long upBound) {
        super(name, key, seqView);
        assert (locVal <= upBound);
        this.batchSize = batchSize;
        this.upBound = upBound;
        this.locVal = locVal;
    }

    @Override
    public long get() {
        this.checkRemoved();
        return this.locVal;
    }

    @Override
    public long incrementAndGet() {
        try {
            return this.internalUpdate(1L, this.incAndGetCall, true);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndIncrement() {
        try {
            return this.internalUpdate(1L, this.getAndIncCall, false);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long addAndGet(long l) {
        A.ensure(l > 0L, " Parameter mustn't be less then 1: " + l);
        try {
            return this.internalUpdate(l, null, true);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndAdd(long l) {
        A.ensure(l > 0L, " Parameter mustn't be less then 1: " + l);
        try {
            return this.internalUpdate(l, null, false);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private long internalUpdate(long l, @Nullable Callable<Long> updateCall, boolean updated) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public void batchSize(int size) {
        A.ensure(size > 0, " Batch size can't be less then 0: " + size);
        this.localUpdate.lock();
        try {
            this.batchSize = size;
        }
        finally {
            this.localUpdate.unlock();
        }
    }

    @Override
    protected void invalidateLocalState() {
        this.locVal = 0L;
        this.upBound = -1L;
    }

    @Override
    public void close() {
        try {
            if (this.rmvd) {
                return;
            }
            this.ctx.kernalContext().dataStructures().removeSequence(this.name, this.ctx.group().name());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private Callable<Long> internalUpdate(final long l, final boolean updated) {
        return new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Long call() throws Exception {
                assert (GridCacheAtomicSequenceImpl.this.distUpdateFreeTop.isHeldByCurrentThread() || GridCacheAtomicSequenceImpl.this.distUpdateLockedTop.isHeldByCurrentThread());
                try (GridNearTxLocal tx = CU.txStartInternal(GridCacheAtomicSequenceImpl.this.ctx, GridCacheAtomicSequenceImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    long newUpBound;
                    long curLocVal;
                    GridCacheAtomicSequenceValue seq = (GridCacheAtomicSequenceValue)GridCacheAtomicSequenceImpl.this.cacheView.get(GridCacheAtomicSequenceImpl.this.key);
                    GridCacheAtomicSequenceImpl.this.checkRemoved();
                    assert (seq != null);
                    GridCacheAtomicSequenceImpl.this.localUpdate.lock();
                    try {
                        long newLocVal;
                        long off;
                        curLocVal = GridCacheAtomicSequenceImpl.this.locVal;
                        if (curLocVal + l <= GridCacheAtomicSequenceImpl.this.upBound) {
                            GridCacheAtomicSequenceImpl.this.locVal = curLocVal + l;
                            Long l2 = updated ? curLocVal + l : curLocVal;
                            return l2;
                        }
                        long curGlobalVal = seq.get();
                        long l3 = off = GridCacheAtomicSequenceImpl.this.batchSize > 1 ? (long)(GridCacheAtomicSequenceImpl.this.batchSize - 1) : 1L;
                        if (curLocVal + l >= curGlobalVal) {
                            newLocVal = curLocVal + l;
                            newUpBound = newLocVal + off;
                        } else {
                            newLocVal = curGlobalVal;
                            newUpBound = newLocVal + off;
                        }
                        GridCacheAtomicSequenceImpl.this.locVal = newLocVal;
                        GridCacheAtomicSequenceImpl.this.upBound = newUpBound;
                        if (updated) {
                            curLocVal = newLocVal;
                        }
                    }
                    finally {
                        GridCacheAtomicSequenceImpl.this.localUpdate.unlock();
                    }
                    seq.set(newUpBound + 1L);
                    GridCacheAtomicSequenceImpl.this.cacheView.put(GridCacheAtomicSequenceImpl.this.key, seq);
                    tx.commit();
                    Long l4 = curLocVal;
                    return l4;
                }
                catch (Error | Exception e) {
                    if (X.hasCause(e, ClusterTopologyCheckedException.class)) throw e;
                    U.error(GridCacheAtomicSequenceImpl.this.log, "Failed to get and add: " + this, e);
                    throw e;
                }
            }
        };
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx.kernalContext());
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteAtomicSequence igniteAtomicSequence = t.get1().dataStructures().sequence(t.get2(), null, 0L, false);
            return igniteAtomicSequence;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    @Override
    public String toString() {
        return S.toString(GridCacheAtomicSequenceImpl.class, this, super.toString());
    }
}

