/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metastorage.persistence;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageClusterNodeData;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageHistoryItem;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageKeyValuePair;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageUtil;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageVersion;
import org.apache.ignite.internal.processors.metastorage.persistence.DmsLocalMetaStorageLock;
import org.apache.ignite.internal.processors.metastorage.persistence.DmsWorkerStatus;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.jetbrains.annotations.Nullable;

class DmsDataWriterWorker
extends GridWorker {
    public static final byte[] DUMMY_VALUE = new byte[0];
    private final LinkedBlockingQueue<Object> updateQueue = new LinkedBlockingQueue();
    private final DmsLocalMetaStorageLock lock;
    private final Consumer<Throwable> errorHnd;
    private volatile DmsWorkerStatus status = DmsWorkerStatus.CONTINUE;
    private DistributedMetaStorageVersion workerDmsVer;
    private volatile ReadWriteMetastorage metastorage;
    private volatile boolean firstStart = true;

    public DmsWorkerStatus status() {
        return this.status;
    }

    public DmsDataWriterWorker(@Nullable String igniteInstanceName, IgniteLogger log, DmsLocalMetaStorageLock lock, Consumer<Throwable> errorHnd) {
        super(igniteInstanceName, "dms-writer", log);
        this.lock = lock;
        this.errorHnd = errorHnd;
    }

    public void setMetaStorage(ReadWriteMetastorage metastorage) {
        this.metastorage = metastorage;
    }

    public void update(DistributedMetaStorageHistoryItem histItem) {
        this.updateQueue.offer(histItem);
    }

    public void update(DistributedMetaStorageClusterNodeData fullNodeData) {
        assert (fullNodeData.fullData != null);
        assert (fullNodeData.hist != null);
        this.updateQueue.clear();
        this.updateQueue.offer(fullNodeData);
    }

    public void removeHistItem(long ver) {
        this.updateQueue.offer(ver);
    }

    public void cancel(boolean halt) throws InterruptedException {
        if (halt) {
            this.updateQueue.clear();
        }
        this.status = halt ? DmsWorkerStatus.HALT : DmsWorkerStatus.CANCEL;
        this.updateQueue.offer((Object)this.status);
        Thread runner = this.runner();
        if (runner != null) {
            runner.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
        this.status = DmsWorkerStatus.CONTINUE;
        try {
            if (this.firstStart) {
                this.firstStart = false;
                this.lock.lock();
                try {
                    this.restore();
                }
                finally {
                    this.lock.unlock();
                }
            }
            while (true) {
                Object update = this.updateQueue.peek();
                try {
                    update = this.updateQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.lock.lock();
                try {
                    if (update instanceof DistributedMetaStorageHistoryItem) {
                        this.applyUpdate((DistributedMetaStorageHistoryItem)update);
                        continue;
                    }
                    if (update instanceof DistributedMetaStorageClusterNodeData) {
                        DistributedMetaStorageClusterNodeData fullNodeData = (DistributedMetaStorageClusterNodeData)update;
                        this.metastorage.writeRaw(DistributedMetaStorageUtil.cleanupGuardKey(), DUMMY_VALUE);
                        this.doCleanup();
                        for (DistributedMetaStorageKeyValuePair item : fullNodeData.fullData) {
                            this.metastorage.writeRaw(DistributedMetaStorageUtil.localKey(item.key), item.valBytes);
                        }
                        int len = fullNodeData.hist.length;
                        for (int i = 0; i < len; ++i) {
                            DistributedMetaStorageHistoryItem histItem = fullNodeData.hist[i];
                            long histItemVer = fullNodeData.ver.id + (long)i - (long)(len - 1);
                            this.metastorage.write(DistributedMetaStorageUtil.historyItemKey(histItemVer), histItem);
                        }
                        this.metastorage.write(DistributedMetaStorageUtil.versionKey(), fullNodeData.ver);
                        this.workerDmsVer = fullNodeData.ver;
                        this.metastorage.remove(DistributedMetaStorageUtil.cleanupGuardKey());
                        continue;
                    }
                    if (update instanceof Long) {
                        long ver = (Long)update;
                        this.metastorage.remove(DistributedMetaStorageUtil.historyItemKey(ver));
                        continue;
                    }
                    assert (update instanceof DmsWorkerStatus) : update;
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            this.errorHnd.accept(t);
        }
    }

    private void applyUpdate(DistributedMetaStorageHistoryItem histItem) throws IgniteCheckedException {
        this.metastorage.write(DistributedMetaStorageUtil.historyItemKey(this.workerDmsVer.id + 1L), histItem);
        this.workerDmsVer = this.workerDmsVer.nextVersion(histItem);
        this.metastorage.write(DistributedMetaStorageUtil.versionKey(), this.workerDmsVer);
        int len = histItem.keys.length;
        for (int i = 0; i < len; ++i) {
            this.write(histItem.keys[i], histItem.valBytesArray[i]);
        }
    }

    private void restore() throws IgniteCheckedException {
        block3: {
            DistributedMetaStorageHistoryItem histItem;
            DistributedMetaStorageVersion storedVer;
            block5: {
                block4: {
                    block2: {
                        if (this.metastorage.readRaw(DistributedMetaStorageUtil.cleanupGuardKey()) == null) break block2;
                        this.doCleanup();
                        this.metastorage.remove(DistributedMetaStorageUtil.cleanupGuardKey());
                        break block3;
                    }
                    storedVer = (DistributedMetaStorageVersion)this.metastorage.read(DistributedMetaStorageUtil.versionKey());
                    if (storedVer != null) break block4;
                    this.workerDmsVer = DistributedMetaStorageVersion.INITIAL_VERSION;
                    this.metastorage.write(DistributedMetaStorageUtil.versionKey(), DistributedMetaStorageVersion.INITIAL_VERSION);
                    break block3;
                }
                histItem = (DistributedMetaStorageHistoryItem)this.metastorage.read(DistributedMetaStorageUtil.historyItemKey(storedVer.id + 1L));
                if (histItem == null) break block5;
                this.workerDmsVer = storedVer.nextVersion(histItem);
                this.metastorage.write(DistributedMetaStorageUtil.versionKey(), this.workerDmsVer);
                int len = histItem.keys.length;
                for (int i = 0; i < len; ++i) {
                    this.write(histItem.keys[i], histItem.valBytesArray[i]);
                }
                break block3;
            }
            this.workerDmsVer = storedVer;
            histItem = (DistributedMetaStorageHistoryItem)this.metastorage.read(DistributedMetaStorageUtil.historyItemKey(storedVer.id));
            if (histItem == null) break block3;
            boolean equal = true;
            int len = histItem.keys.length;
            for (int i = 0; i < len; ++i) {
                byte[] valBytes = this.metastorage.readRaw(DistributedMetaStorageUtil.localKey(histItem.keys[i]));
                if (equal && Arrays.equals(valBytes, histItem.valBytesArray[i])) continue;
                equal = false;
                this.write(histItem.keys[i], histItem.valBytesArray[i]);
            }
        }
    }

    private void doCleanup() throws IgniteCheckedException {
        HashSet allKeys = new HashSet();
        this.metastorage.iterate("\u0000", (key, val) -> allKeys.add(key), false);
        allKeys.remove(DistributedMetaStorageUtil.cleanupGuardKey());
        for (String key2 : allKeys) {
            this.metastorage.remove(key2);
        }
        this.workerDmsVer = DistributedMetaStorageVersion.INITIAL_VERSION;
        this.metastorage.write(DistributedMetaStorageUtil.versionKey(), DistributedMetaStorageVersion.INITIAL_VERSION);
    }

    private void write(String key, byte[] valBytes) throws IgniteCheckedException {
        if (valBytes == null) {
            this.metastorage.remove(DistributedMetaStorageUtil.localKey(key));
        } else {
            this.metastorage.writeRaw(DistributedMetaStorageUtil.localKey(key), valBytes);
        }
    }
}

