/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.odbc.ClientListenerConnectionContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.jetbrains.annotations.Nullable;

public abstract class ClientListenerAbstractConnectionContext
implements ClientListenerConnectionContext {
    protected final GridKernalContext ctx;
    protected final GridNioSession ses;
    private SecurityContext secCtx;
    private long connId;
    private AuthorizationContext authCtx;
    protected Map<String, String> userAttrs;
    private String clientDesc;

    protected ClientListenerAbstractConnectionContext(GridKernalContext ctx, GridNioSession ses, long connId) {
        this.ctx = ctx;
        this.connId = connId;
        this.ses = ses;
    }

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    @Override
    @Nullable
    public SecurityContext securityContext() {
        return this.secCtx;
    }

    @Override
    @Nullable
    public AuthorizationContext authorizationContext() {
        return this.authCtx;
    }

    @Override
    public long connectionId() {
        return this.connId;
    }

    protected AuthorizationContext authenticate(Certificate[] certificates, String user, String pwd) throws IgniteCheckedException {
        if (this.ctx.security().enabled()) {
            this.authCtx = this.authenticateExternal(certificates, user, pwd).authorizationContext();
        } else if (this.ctx.authentication().enabled()) {
            if (F.isEmpty(user)) {
                throw new IgniteAccessControlException("Unauthenticated sessions are prohibited.");
            }
            this.authCtx = this.ctx.authentication().authenticate(user, pwd);
            if (this.authCtx == null) {
                throw new IgniteAccessControlException("Unknown authentication error.");
            }
        } else {
            this.authCtx = null;
        }
        return this.authCtx;
    }

    private AuthenticationContext authenticateExternal(Certificate[] certificates, String user, String pwd) throws IgniteCheckedException {
        SecurityCredentials cred = new SecurityCredentials(user, pwd);
        AuthenticationContext authCtx = new AuthenticationContext();
        authCtx.subjectType(SecuritySubjectType.REMOTE_CLIENT);
        authCtx.subjectId(UUID.randomUUID());
        authCtx.nodeAttributes(F.isEmpty(this.userAttrs) ? Collections.emptyMap() : this.userAttrs);
        authCtx.credentials(cred);
        authCtx.certificates(certificates);
        this.secCtx = this.ctx.security().authenticate(authCtx);
        if (this.secCtx == null) {
            throw new IgniteAccessControlException(String.format("The user name or password is incorrect [userName=%s]", user));
        }
        return authCtx;
    }

    @Override
    public void onDisconnected() {
        if (this.ctx.security().enabled()) {
            this.ctx.security().onSessionExpired(this.secCtx.subject().id());
        }
    }

    protected void initClientDescriptor(String prefix) {
        this.clientDesc = prefix + ":" + this.ses.remoteAddress().getHostString() + ":" + this.ses.remoteAddress().getPort();
        if (this.authCtx != null) {
            this.clientDesc = this.clientDesc + "@" + this.authCtx.userName();
        } else if (this.secCtx != null) {
            this.clientDesc = this.clientDesc + "@" + this.secCtx.subject().login();
        }
    }

    public String clientDescriptor() {
        return this.clientDesc;
    }
}

