/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.EnumSet;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;

public class JdbcProtocolContext {
    private final ClientListenerProtocolVersion ver;
    private final EnumSet<JdbcThinFeature> features;
    private final TimeZone srvTz;
    private final boolean client;
    private final boolean keepBinary;

    public JdbcProtocolContext(ClientListenerProtocolVersion ver, EnumSet<JdbcThinFeature> features, TimeZone srvTz, boolean client, boolean keepBinary) {
        assert (Objects.nonNull(features));
        this.ver = ver;
        this.features = features;
        this.srvTz = srvTz;
        this.client = client;
        this.keepBinary = keepBinary;
    }

    public boolean isStreamingSupported() {
        return this.ver.compareTo(JdbcConnectionContext.VER_2_4_0) >= 0;
    }

    public boolean isAutoCommitSupported() {
        return this.ver.compareTo(JdbcConnectionContext.VER_2_7_0) >= 0;
    }

    public boolean isTableTypesSupported() {
        return this.ver.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0;
    }

    public boolean isAffinityAwarenessSupported() {
        return this.ver.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0;
    }

    public boolean isFeatureSupported(JdbcThinFeature feature) {
        return this.features.contains(feature);
    }

    EnumSet<JdbcThinFeature> features() {
        return this.features;
    }

    public boolean client() {
        return this.client;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    public TimeZone serverTimeZone() {
        return this.srvTz;
    }
}

