/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;
import org.jetbrains.annotations.Nullable;

public class JdbcUtils {
    public static void writeItems(BinaryWriterExImpl writer, List<List<Object>> items, JdbcProtocolContext protoCtx) {
        writer.writeInt(items.size());
        for (List<Object> row : items) {
            if (row == null) continue;
            writer.writeInt(row.size());
            for (Object obj : row) {
                JdbcUtils.writeObject(writer, obj, protoCtx);
            }
        }
    }

    public static List<List<Object>> readItems(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) {
        int rowsSize = reader.readInt();
        if (rowsSize > 0) {
            ArrayList<List<Object>> items = new ArrayList<List<Object>>(rowsSize);
            for (int i = 0; i < rowsSize; ++i) {
                int colsSize = reader.readInt();
                ArrayList<Object> col = new ArrayList<Object>(colsSize);
                for (int colCnt = 0; colCnt < colsSize; ++colCnt) {
                    col.add(JdbcUtils.readObject(reader, protoCtx));
                }
                items.add(col);
            }
            return items;
        }
        return Collections.emptyList();
    }

    public static void writeStringCollection(BinaryWriterExImpl writer, Collection<String> lst) {
        if (lst == null) {
            writer.writeInt(0);
        } else {
            writer.writeInt(lst.size());
            for (String s : lst) {
                writer.writeString(s);
            }
        }
    }

    public static List<String> readStringList(BinaryReaderExImpl reader) {
        int size = reader.readInt();
        if (size > 0) {
            ArrayList<String> lst = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                lst.add(reader.readString());
            }
            return lst;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static Integer readNullableInteger(BinaryReaderExImpl reader) {
        return reader.readBoolean() ? Integer.valueOf(reader.readInt()) : null;
    }

    public static void writeNullableInteger(BinaryWriterExImpl writer, @Nullable Integer val) {
        writer.writeBoolean(val != null);
        if (val != null) {
            writer.writeInt(val);
        }
    }

    public static void writeNullableLong(BinaryWriterExImpl writer, @Nullable Long val) {
        writer.writeBoolean(val != null);
        if (val != null) {
            writer.writeLong(val);
        }
    }

    @Nullable
    public static Object readObject(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        byte type = reader.readByte();
        switch (type) {
            case 11: {
                if (protoCtx.client()) {
                    return new java.sql.Date(SqlListenerUtils.convertWithTimeZone(BinaryUtils.doReadDate(reader.in()), protoCtx.serverTimeZone(), TimeZone.getDefault()).getTime());
                }
                return BinaryUtils.doReadDate(reader.in());
            }
            case 36: {
                if (protoCtx.client()) {
                    return SqlListenerUtils.convertWithTimeZone(BinaryUtils.doReadTime(reader.in()), protoCtx.serverTimeZone(), TimeZone.getDefault());
                }
                return BinaryUtils.doReadTime(reader.in());
            }
            case 33: {
                if (protoCtx.client()) {
                    return SqlListenerUtils.convertWithTimeZone(BinaryUtils.doReadTimestamp(reader.in()), protoCtx.serverTimeZone(), TimeZone.getDefault());
                }
                return BinaryUtils.doReadTimestamp(reader.in());
            }
        }
        return SqlListenerUtils.readObject(type, reader, protoCtx.isFeatureSupported(JdbcThinFeature.CUSTOM_OBJECT), protoCtx.keepBinary());
    }

    public static void writeObject(BinaryWriterExImpl writer, @Nullable Object obj, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        if (obj == null) {
            writer.writeByte((byte)101);
            return;
        }
        Class<?> cls = obj.getClass();
        if (cls == java.sql.Date.class || cls == Date.class) {
            if (protoCtx.client()) {
                writer.writeDate(SqlListenerUtils.convertWithTimeZone((Date)obj, TimeZone.getDefault(), protoCtx.serverTimeZone()));
            } else {
                writer.writeDate((Date)obj);
            }
        } else if (cls == Time.class) {
            if (protoCtx.client()) {
                writer.writeTime(SqlListenerUtils.convertWithTimeZone((Time)obj, TimeZone.getDefault(), protoCtx.serverTimeZone()));
            } else {
                writer.writeTime((Time)obj);
            }
        } else if (cls == Timestamp.class) {
            if (protoCtx.client()) {
                writer.writeTimestamp(SqlListenerUtils.convertWithTimeZone((Timestamp)obj, TimeZone.getDefault(), protoCtx.serverTimeZone()));
            } else {
                writer.writeTimestamp((Timestamp)obj);
            }
        } else {
            SqlListenerUtils.writeObject(writer, obj, protoCtx.isFeatureSupported(JdbcThinFeature.CUSTOM_OBJECT));
        }
    }
}

