/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.resource;

import java.util.Collection;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.resource.GridResourceBasicInjector;
import org.apache.ignite.internal.processors.resource.GridResourceField;
import org.apache.ignite.internal.processors.resource.GridResourceMethod;
import org.apache.ignite.internal.processors.resource.GridResourceUtils;
import org.apache.ignite.resources.ServiceResource;
import org.apache.ignite.services.Service;

public class GridResourceServiceInjector
extends GridResourceBasicInjector<Collection<Service>> {
    private Ignite ignite;

    public GridResourceServiceInjector(Ignite ignite) {
        super(null);
        this.ignite = ignite;
    }

    @Override
    public void inject(GridResourceField field, Object target, Class<?> depCls, GridDeployment dep) throws IgniteCheckedException {
        ServiceResource ann = (ServiceResource)field.getAnnotation();
        Class<?> svcItf = ann.proxyInterface();
        Object svc = svcItf == Void.class ? this.ignite.services().service(ann.serviceName()) : this.ignite.services().serviceProxy(ann.serviceName(), svcItf, ann.proxySticky());
        if (svc != null) {
            GridResourceUtils.inject(field.getField(), target, svc);
        }
    }

    @Override
    public void inject(GridResourceMethod mtd, Object target, Class<?> depCls, GridDeployment dep) throws IgniteCheckedException {
        ServiceResource ann = (ServiceResource)mtd.getAnnotation();
        Class<?> svcItf = ann.proxyInterface();
        Object svc = svcItf == Void.class ? this.ignite.services().service(ann.serviceName()) : this.ignite.services().serviceProxy(ann.serviceName(), svcItf, ann.proxySticky());
        Class<?>[] types = mtd.getMethod().getParameterTypes();
        if (types.length != 1) {
            throw new IgniteCheckedException("Setter does not have single parameter of required type [type=" + svc.getClass().getName() + ", setter=" + mtd + ']');
        }
        if (svc != null) {
            GridResourceUtils.inject(mtd.getMethod(), target, svc);
        }
    }
}

