/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.GridProcessor;
import org.apache.ignite.internal.processors.security.GridSecurityProcessor;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.jetbrains.annotations.Nullable;

public class IgniteSecurityProcessor
implements IgniteSecurity,
GridProcessor {
    public static final String ATTR_GRID_SEC_PROC_CLASS = "grid.security.processor.class";
    private final GridKernalContext ctx;
    private final GridSecurityProcessor secPrc;
    private final JdkMarshaller marsh;
    private final Map<UUID, SecurityContext> secCtxs = new ConcurrentHashMap<UUID, SecurityContext>();
    private final IgniteLogger log;
    private volatile ThreadLocal<SecurityContext> curSecCtx = ThreadLocal.withInitial(this::localSecurityContext);

    public IgniteSecurityProcessor(GridKernalContext ctx, GridSecurityProcessor secPrc) {
        assert (ctx != null);
        assert (secPrc != null);
        this.ctx = ctx;
        this.log = ctx.log(IgniteSecurityProcessor.class);
        this.secPrc = secPrc;
        this.marsh = MarshallerUtils.jdkMarshaller(ctx.igniteInstanceName());
    }

    @Override
    public OperationSecurityContext withContext(SecurityContext secCtx) {
        assert (secCtx != null);
        this.secPrc.touch(secCtx);
        SecurityContext old = this.curSecCtx.get();
        this.curSecCtx.set(secCtx);
        return new OperationSecurityContext(this, old);
    }

    @Override
    public OperationSecurityContext withContext(UUID subjId) {
        SecurityContext res;
        ClusterNode node = Optional.ofNullable(this.ctx.discovery().node(subjId)).orElseGet(() -> this.ctx.discovery().historicalNode(subjId));
        SecurityContext securityContext = res = node != null ? this.secCtxs.computeIfAbsent(subjId, uuid -> SecurityUtils.nodeSecurityContext(this.marsh, U.resolveClassLoader(this.ctx.config()), node)) : this.secPrc.securityContext(subjId);
        if (res == null) {
            SecuritySubjectType type = node != null ? SecuritySubjectType.REMOTE_NODE : SecuritySubjectType.REMOTE_CLIENT;
            this.log.warning("Switched to the 'deny all' policy because of failing to find a security context [subjId=" + subjId + ", type=" + (Object)((Object)type) + ']');
            res = new DenyAllSecurityContext(subjId, type);
        }
        return this.withContext(res);
    }

    @Override
    public SecurityContext securityContext() {
        SecurityContext res = this.curSecCtx.get();
        assert (res != null);
        return res;
    }

    @Override
    public SecurityContext authenticateNode(ClusterNode node, SecurityCredentials cred) throws IgniteCheckedException {
        return this.secPrc.authenticateNode(node, cred);
    }

    @Override
    public boolean isGlobalNodeAuthentication() {
        return this.secPrc.isGlobalNodeAuthentication();
    }

    @Override
    public SecurityContext authenticate(AuthenticationContext ctx) throws IgniteCheckedException {
        return this.secPrc.authenticate(ctx);
    }

    @Override
    public Collection<SecuritySubject> authenticatedSubjects() throws IgniteCheckedException {
        return this.secPrc.authenticatedSubjects();
    }

    @Override
    public SecuritySubject authenticatedSubject(UUID subjId) throws IgniteCheckedException {
        return this.secPrc.authenticatedSubject(subjId);
    }

    @Override
    public void onSessionExpired(UUID subjId) {
        this.secPrc.onSessionExpired(subjId);
    }

    @Override
    public void authorize(String name, SecurityPermission perm) throws SecurityException {
        SecurityContext secCtx = this.curSecCtx.get();
        assert (secCtx != null);
        this.secPrc.authorize(name, perm, secCtx);
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctx.addNodeAttribute(ATTR_GRID_SEC_PROC_CLASS, this.secPrc.getClass().getName());
        this.secPrc.start();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.secPrc.stop(cancel);
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        this.ctx.event().addDiscoveryEventListener((evt, discoCache) -> this.secCtxs.remove(evt.eventNode().id()), 12, 11);
        this.secPrc.onKernalStart(active);
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.secPrc.onKernalStop(cancel);
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        this.secPrc.collectJoiningNodeData(dataBag);
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        this.secPrc.collectGridNodeData(dataBag);
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        this.secPrc.onGridDataReceived(data);
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        this.secPrc.onJoiningNodeDataReceived(data);
    }

    @Override
    public void printMemoryStats() {
        this.secPrc.printMemoryStats();
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        IgniteNodeValidationResult res = this.validateSecProcClass(node);
        return res != null ? res : this.secPrc.validateNode(node);
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        IgniteNodeValidationResult res = this.validateSecProcClass(node);
        return res != null ? res : this.secPrc.validateNode(node, discoData);
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return this.secPrc.discoveryDataType();
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        this.secPrc.onDisconnected(reconnectFut);
    }

    @Override
    @Nullable
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        this.curSecCtx = ThreadLocal.withInitial(this::localSecurityContext);
        return this.secPrc.onReconnected(clusterRestarted);
    }

    private SecurityContext localSecurityContext() {
        return SecurityUtils.nodeSecurityContext(this.marsh, U.resolveClassLoader(this.ctx.config()), this.ctx.discovery().localNode());
    }

    private IgniteNodeValidationResult validateSecProcClass(ClusterNode node) {
        String rmtCls = (String)node.attribute(ATTR_GRID_SEC_PROC_CLASS);
        String locCls = this.secPrc.getClass().getName();
        boolean securityMsgSupported = IgniteFeatures.allNodesSupports(this.ctx, this.ctx.discovery().allNodes(), IgniteFeatures.IGNITE_SECURITY_PROCESSOR);
        if (securityMsgSupported && !F.eq(locCls, rmtCls)) {
            return new IgniteNodeValidationResult(node.id(), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", this.ctx.localNodeId(), node.id(), locCls, rmtCls), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", node.id(), this.ctx.localNodeId(), rmtCls, locCls));
        }
        return null;
    }

    public GridSecurityProcessor gridSecurityProcessor() {
        return this.secPrc;
    }

    private static class AllowNothingSecurityPermissionSet
    implements SecurityPermissionSet {
        private static final long serialVersionUID = 0L;

        private AllowNothingSecurityPermissionSet() {
        }

        @Override
        public boolean defaultAllowAll() {
            return false;
        }

        @Override
        public Map<String, Collection<SecurityPermission>> taskPermissions() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Collection<SecurityPermission>> cachePermissions() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Collection<SecurityPermission>> servicePermissions() {
            return Collections.emptyMap();
        }

        @Override
        public Collection<SecurityPermission> systemPermissions() {
            return Collections.emptyList();
        }
    }

    private static class DenyAllSecuritySubject
    implements SecuritySubject {
        private static final long serialVersionUID = 0L;
        private final UUID subjId;
        private final SecuritySubjectType subjType;

        DenyAllSecuritySubject(UUID subjId, SecuritySubjectType subjType) {
            this.subjId = subjId;
            this.subjType = subjType;
        }

        @Override
        public UUID id() {
            return this.subjId;
        }

        @Override
        public SecuritySubjectType type() {
            return this.subjType;
        }

        @Override
        public Object login() {
            return "";
        }

        @Override
        public InetSocketAddress address() {
            return null;
        }

        @Override
        public SecurityPermissionSet permissions() {
            return new AllowNothingSecurityPermissionSet();
        }
    }

    private static class DenyAllSecurityContext
    implements SecurityContext,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final SecuritySubject secSubj;

        DenyAllSecurityContext(UUID subjId, SecuritySubjectType subjType) {
            this.secSubj = new DenyAllSecuritySubject(subjId, subjType);
        }

        @Override
        public SecuritySubject subject() {
            return this.secSubj;
        }

        @Override
        public boolean taskOperationAllowed(String taskClsName, SecurityPermission perm) {
            return false;
        }

        @Override
        public boolean cacheOperationAllowed(String cacheName, SecurityPermission perm) {
            return false;
        }

        @Override
        public boolean serviceOperationAllowed(String srvcName, SecurityPermission perm) {
            return false;
        }

        @Override
        public boolean systemOperationAllowed(SecurityPermission perm) {
            return false;
        }
    }
}

