/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.service;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.services.ServiceDescriptor;

public class VisorServiceDescriptor
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private String srvcCls;
    private int totalCnt;
    private int maxPerNodeCnt;
    private String cacheName;
    private UUID originNodeId;
    private Map<UUID, Integer> topSnapshot;

    public VisorServiceDescriptor() {
    }

    public VisorServiceDescriptor(ServiceDescriptor srvc) {
        this.name = srvc.name();
        try {
            this.srvcCls = VisorTaskUtils.compactClass(srvc.serviceClass());
        }
        catch (Throwable e) {
            this.srvcCls = e.getClass().getName() + ": " + e.getMessage();
        }
        this.totalCnt = srvc.totalCount();
        this.maxPerNodeCnt = srvc.maxPerNodeCount();
        this.cacheName = srvc.cacheName();
        this.originNodeId = srvc.originNodeId();
        this.topSnapshot = srvc.topologySnapshot();
    }

    public String getName() {
        return this.name;
    }

    public String getServiceClass() {
        return this.srvcCls;
    }

    public int getTotalCnt() {
        return this.totalCnt;
    }

    public int getMaxPerNodeCnt() {
        return this.maxPerNodeCnt;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public UUID getOriginNodeId() {
        return this.originNodeId;
    }

    public Map<UUID, Integer> getTopologySnapshot() {
        return this.topSnapshot;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeString(out, this.srvcCls);
        out.writeInt(this.totalCnt);
        out.writeInt(this.maxPerNodeCnt);
        U.writeString(out, this.cacheName);
        U.writeUuid(out, this.originNodeId);
        U.writeMap(out, this.topSnapshot);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.srvcCls = U.readString(in);
        this.totalCnt = in.readInt();
        this.maxPerNodeCnt = in.readInt();
        this.cacheName = U.readString(in);
        this.originNodeId = U.readUuid(in);
        this.topSnapshot = U.readMap(in);
    }

    public String toString() {
        return S.toString(VisorServiceDescriptor.class, this);
    }
}

