/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EchoingLogger
implements IgniteLogger {
    private final IgniteLogger delegate;
    private final Consumer<String> echoTo;

    public EchoingLogger(@NotNull IgniteLogger delegate, @NotNull Consumer<String> echoTo) {
        this.delegate = Objects.requireNonNull(delegate);
        this.echoTo = Objects.requireNonNull(echoTo);
    }

    @Override
    public IgniteLogger getLogger(Object ctgr) {
        return new EchoingLogger(this.delegate.getLogger(ctgr), this.echoTo);
    }

    @Override
    public void trace(String msg) {
        if (this.delegate.isTraceEnabled()) {
            this.delegate.trace(msg);
            this.echoTo.accept(String.format("[%-23s][%-5s] %s", EchoingLogger.now(), "TRACE", msg));
        }
    }

    @Override
    public void debug(String msg) {
        if (this.delegate.isDebugEnabled()) {
            this.delegate.debug(msg);
            this.echoTo.accept(String.format("[%-23s][%-5s] %s", EchoingLogger.now(), "DEBUG", msg));
        }
    }

    @Override
    public void info(String msg) {
        if (this.delegate.isInfoEnabled()) {
            this.delegate.info(msg);
            this.echoTo.accept(String.format("[%-23s][%-5s] %s", EchoingLogger.now(), "INFO", msg));
        }
    }

    @Override
    public void warning(String msg, @Nullable Throwable e) {
        this.delegate.warning(msg, e);
        this.echoTo.accept(String.format("[%-23s][%-5s] %s%s", EchoingLogger.now(), "WARN", msg, EchoingLogger.formatThrowable(Optional.ofNullable(e))));
    }

    @Override
    public void error(String msg, @Nullable Throwable e) {
        this.delegate.error(msg, e);
        this.echoTo.accept(String.format("[%-23s][%-5s] %s%s", EchoingLogger.now(), "ERROR", msg, EchoingLogger.formatThrowable(Optional.ofNullable(e))));
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public boolean isQuiet() {
        return this.delegate.isQuiet();
    }

    @Override
    public String fileName() {
        return this.delegate.fileName();
    }

    private static String now() {
        return LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    private static String formatThrowable(Optional<Throwable> e) {
        return e.map(EchoingLogger::formatThrowable).orElse("");
    }

    private static String formatThrowable(@NotNull Throwable e) {
        return (e.getMessage() != null ? ": " + e.getMessage() : "") + System.lineSeparator() + Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).map(s -> "at " + s).collect(Collectors.joining(System.lineSeparator()));
    }
}

