/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mxbean;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.management.JMException;
import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParametersDescriptions;
import org.apache.ignite.mxbean.MXBeanParametersNames;

@MXBeanDescription(value="MBean that provides access to Kernal information.")
public interface IgniteMXBean {
    public static final String FULL_VER_DESC = "String presentation of the Ignite version.";
    public static final String COPYRIGHT_DESC = "Copyright statement for Ignite product.";
    public static final String START_TIMESTAMP_FORMATTED_DESC = "String presentation of the kernal start timestamp.";
    public static final String IS_REBALANCE_ENABLED_DESC = "Rebalance enabled flag.";
    public static final String UPTIME_FORMATTED_DESC = "String presentation of up-time for the kernal.";
    public static final String START_TIMESTAMP_DESC = "Start timestamp of the kernal.";
    public static final String UPTIME_DESC = "Up-time of the kernal.";
    public static final String LONG_JVM_PAUSES_CNT_DESC = "Long JVM pauses count.";
    public static final String LONG_JVM_PAUSES_TOTAL_DURATION_DESC = "Long JVM pauses total duration.";
    public static final String LONG_JVM_PAUSE_LAST_EVENTS_DESC = "Long JVM pause last events.";
    public static final String USER_ATTRS_FORMATTED_DESC = "Collection of formatted user-defined attributes added to this node.";
    public static final String GRID_LOG_FORMATTED_DESC = "Formatted instance of logger that is in grid.";
    public static final String EXECUTOR_SRVC_FORMATTED_DESC = "Formatted instance of fully configured thread pool that is used in grid.";
    public static final String IGNITE_HOME_DESC = "Ignite installation home folder.";
    public static final String MBEAN_SERVER_FORMATTED_DESC = "Formatted instance of MBean server instance.";
    public static final String LOC_NODE_ID_DESC = "Unique identifier for this node within grid.";
    public static final String IS_PEER_CLS_LOADING_ENABLED_DESC = "Whether or not peer class loading (a.k.a. P2P class loading) is enabled.";
    public static final String LIFECYCLE_BEANS_FORMATTED_DESC = "String representation of lifecycle beans.";
    public static final String ACTIVE_DESC = "Checks Ignite grid is active or is not active.";
    public static final String DISCOVERY_SPI_FORMATTED_DESC = "Formatted instance of configured discovery SPI implementation.";
    public static final String COMMUNICATION_SPI_FORMATTED_DESC = "Formatted instance of fully configured SPI communication implementation.";
    public static final String DEPLOYMENT_SPI_FORMATTED_DESC = "Formatted instance of fully configured deployment SPI implementation.";
    public static final String CHECKPOINT_SPI_FORMATTED_DESC = "Formatted instance of configured checkpoint SPI implementation.";
    public static final String COLLISION_SPI_FORMATTED_DESC = "Formatted instance of configured collision SPI implementations.";
    public static final String EVT_STORAGE_SPI_FORMATTED_DESC = "Formatted instance of fully configured event SPI implementation.";
    public static final String FAILOVER_SPI_FORMATTED_DESC = "Formatted instance of fully configured failover SPI implementations.";
    public static final String LOAD_BALANCING_SPI_FORMATTED_DESC = "Formatted instance of fully configured load balancing SPI implementations.";
    public static final String OS_INFO_DESC = "OS information.";
    public static final String JDK_INFO_DESC = "JDK information.";
    public static final String OS_USER_DESC = "OS user name.";
    public static final String VM_NAME_DESC = "VM name.";
    public static final String INSTANCE_NAME_DESC = "Optional kernal instance name.";
    public static final String CUR_COORDINATOR_FORMATTED_DESC = "Formatted properties of current coordinator.";
    public static final String IS_NODE_BASELINE_DESC = "Baseline node flag.";
    public static final String LAST_CLUSTER_STATE_CHANGE_TIME_DESC = "Unix time of last cluster state change operation.";
    public static final String CLUSTER_STATE_DESC = "Checks cluster state.";

    @Deprecated
    @MXBeanDescription(value="String presentation of the Ignite version.")
    public String getFullVersion();

    @Deprecated
    @MXBeanDescription(value="Copyright statement for Ignite product.")
    public String getCopyright();

    @Deprecated
    @MXBeanDescription(value="Start timestamp of the kernal.")
    public String getStartTimestampFormatted();

    @Deprecated
    @MXBeanDescription(value="Rebalance enabled flag.")
    public boolean isRebalanceEnabled();

    @MXBeanParametersDescriptions(value={"Enable cache partitions rebalance on node.", "Disable cache partitions rebalance on node."})
    public void rebalanceEnabled(boolean var1);

    @Deprecated
    @MXBeanDescription(value="String presentation of up-time for the kernal.")
    public String getUpTimeFormatted();

    @Deprecated
    @MXBeanDescription(value="Start timestamp of the kernal.")
    public long getStartTimestamp();

    @Deprecated
    @MXBeanDescription(value="Up-time of the kernal.")
    public long getUpTime();

    @Deprecated
    @MXBeanDescription(value="Long JVM pauses count.")
    public long getLongJVMPausesCount();

    @Deprecated
    @MXBeanDescription(value="Long JVM pauses total duration.")
    public long getLongJVMPausesTotalDuration();

    @Deprecated
    @MXBeanDescription(value="Long JVM pause last events.")
    public Map<Long, Long> getLongJVMPauseLastEvents();

    @Deprecated
    @MXBeanDescription(value="Collection of formatted user-defined attributes added to this node.")
    public List<String> getUserAttributesFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of logger that is in grid.")
    public String getGridLoggerFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured thread pool that is used in grid.")
    public String getExecutorServiceFormatted();

    @MXBeanDescription(value="Public thread pool size.")
    public int getPublicThreadPoolSize();

    @Deprecated
    @MXBeanDescription(value="Ignite installation home folder.")
    public String getIgniteHome();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of MBean server instance.")
    public String getMBeanServerFormatted();

    @Deprecated
    @MXBeanDescription(value="Unique identifier for this node within grid.")
    public UUID getLocalNodeId();

    @Deprecated
    @MXBeanDescription(value="Whether or not peer class loading (a.k.a. P2P class loading) is enabled.")
    public boolean isPeerClassLoadingEnabled();

    @Deprecated
    @MXBeanDescription(value="String representation of lifecycle beans.")
    public List<String> getLifecycleBeansFormatted();

    @MXBeanDescription(value="This method allows manually remove the checkpoint with given key. Return true if specified checkpoint was indeed removed, false otherwise.")
    @MXBeanParametersNames(value={"key"})
    @MXBeanParametersDescriptions(value={"Checkpoint key to remove."})
    public boolean removeCheckpoint(String var1);

    @MXBeanDescription(value="Pings node with given node ID to see whether it is alive. Returns whether or not node is alive.")
    @MXBeanParametersNames(value={"nodeId"})
    @MXBeanParametersDescriptions(value={"String presentation of node ID. See java.util.UUID class for details."})
    public boolean pingNode(String var1);

    @MXBeanDescription(value="Execute activate or deactivate process.")
    @MXBeanParametersNames(value={"active"})
    public void active(boolean var1);

    @Deprecated
    @MXBeanDescription(value="Checks Ignite grid is active or is not active.")
    public boolean active();

    @MXBeanDescription(value="Makes the best attempt to undeploy a task from the whole grid.")
    @MXBeanParametersNames(value={"taskName"})
    @MXBeanParametersDescriptions(value={"Name of the task to undeploy."})
    public void undeployTaskFromGrid(String var1) throws JMException;

    @MXBeanDescription(value="A shortcut method that executes given task assuming single String argument and String return type. Returns Task return value (assumed of String type).")
    @MXBeanParametersNames(value={"taskName", "arg"})
    @MXBeanParametersDescriptions(value={"Name of the task to execute.", "Single task execution argument (can be null)."})
    public String executeTask(String var1, String var2) throws JMException;

    @MXBeanDescription(value="Pings node with given host name to see if it is alive. Returns whether or not node is alive.")
    @MXBeanParametersNames(value={"host"})
    @MXBeanParametersDescriptions(value={"Host name or IP address of the node to ping."})
    public boolean pingNodeByAddress(String var1);

    @Deprecated
    @MXBeanDescription(value="Formatted instance of configured discovery SPI implementation.")
    public String getDiscoverySpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured SPI communication implementation.")
    public String getCommunicationSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured deployment SPI implementation.")
    public String getDeploymentSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of configured checkpoint SPI implementation.")
    public String getCheckpointSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of configured collision SPI implementations.")
    public String getCollisionSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured event SPI implementation.")
    public String getEventStorageSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured failover SPI implementations.")
    public String getFailoverSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured load balancing SPI implementations.")
    public String getLoadBalancingSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="OS information.")
    public String getOsInformation();

    @Deprecated
    @MXBeanDescription(value="JDK information.")
    public String getJdkInformation();

    @Deprecated
    @MXBeanDescription(value="OS user name.")
    public String getOsUser();

    @Deprecated
    @MXBeanDescription(value="VM name.")
    public String getVmName();

    @Deprecated
    @MXBeanDescription(value="Optional kernal instance name.")
    public String getInstanceName();

    @MXBeanDescription(value="Prints last suppressed errors.")
    public void printLastErrors();

    @MXBeanDescription(value="Dumps debug information for the current node.")
    public void dumpDebugInfo();

    @Deprecated
    @MXBeanDescription(value="Formatted properties of current coordinator.")
    public String getCurrentCoordinatorFormatted();

    @Deprecated
    @MXBeanDescription(value="Baseline node flag.")
    public boolean isNodeInBaseline();

    @MXBeanDescription(value="Runs IO latency test against all remote server nodes in cluster.")
    @MXBeanParametersNames(value={"warmup", "duration", "threads", "maxLatency", "rangesCnt", "payLoadSize", "procFromNioThread"})
    @MXBeanParametersDescriptions(value={"Warmup duration (millis).", "Test duration (millis).", "Threads count.", "Maximum latency expected (nanos).", "Ranges count for histogram.", "Payload size (bytes).", "Process requests in NIO-threads flag."})
    public void runIoTest(long var1, long var3, int var5, long var6, int var8, int var9, boolean var10);

    @MXBeanDescription(value="Clears local node map.")
    public void clearNodeLocalMap();

    @MXBeanDescription(value="Resets metrics of a given registry.")
    @MXBeanParametersNames(value={"registry"})
    @MXBeanParametersDescriptions(value={"Metrics registry."})
    public void resetMetrics(String var1);

    @MXBeanDescription(value="Checks cluster state.")
    public String clusterState();

    @MXBeanDescription(value="Changes current cluster state.")
    @MXBeanParametersNames(value={"state"})
    @MXBeanParametersDescriptions(value={"New cluster state."})
    public void clusterState(String var1);

    @MXBeanDescription(value="Unix time of last cluster state change operation.")
    public long lastClusterStateChangeTime();
}

