/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.plugin.security;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityBasicPermissionSet;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;

public class SecurityPermissionSetBuilder {
    private Map<String, Collection<SecurityPermission>> cachePerms = new HashMap<String, Collection<SecurityPermission>>();
    private Map<String, Collection<SecurityPermission>> taskPerms = new HashMap<String, Collection<SecurityPermission>>();
    private Map<String, Collection<SecurityPermission>> srvcPerms = new HashMap<String, Collection<SecurityPermission>>();
    private Set<SecurityPermission> sysPerms = new HashSet<SecurityPermission>();
    private boolean dfltAllowAll;
    public static final SecurityPermissionSet ALLOW_ALL = SecurityPermissionSetBuilder.create().build();

    public static SecurityPermissionSetBuilder create() {
        return new SecurityPermissionSetBuilder().defaultAllowAll(true);
    }

    public SecurityPermissionSetBuilder defaultAllowAll(boolean dfltAllowAll) {
        this.dfltAllowAll = dfltAllowAll;
        return this;
    }

    public SecurityPermissionSetBuilder appendTaskPermissions(String name, SecurityPermission ... perms) {
        this.validate(this.toCollection("TASK_"), perms);
        this.append(this.taskPerms, name, this.toCollection(perms));
        return this;
    }

    public SecurityPermissionSetBuilder appendServicePermissions(String name, SecurityPermission ... perms) {
        this.validate(this.toCollection("SERVICE_"), perms);
        this.append(this.srvcPerms, name, this.toCollection(perms));
        return this;
    }

    public SecurityPermissionSetBuilder appendCachePermissions(String name, SecurityPermission ... perms) {
        this.validate(this.toCollection("CACHE_"), perms);
        this.append(this.cachePerms, name, this.toCollection(perms));
        return this;
    }

    public SecurityPermissionSetBuilder appendSystemPermissions(SecurityPermission ... perms) {
        this.validate(this.toCollection("EVENTS_", "ADMIN_", "CACHE_CREATE", "CACHE_DESTROY", "JOIN_AS_SERVER", "SET_QUERY_MEMORY_QUOTA", "GET_QUERY_VIEWS", "KILL_QUERY", "CHANGE_STATISTICS", "REFRESH_STATISTICS"), perms);
        this.sysPerms.addAll(this.toCollection(perms));
        return this;
    }

    public SecurityPermissionSetBuilder appendPermissionSet(SecurityPermissionSet permSet) {
        this.append(this.cachePerms, permSet.cachePermissions());
        this.append(this.taskPerms, permSet.taskPermissions());
        this.append(this.srvcPerms, permSet.servicePermissions());
        if (permSet.systemPermissions() != null) {
            this.sysPerms.addAll(permSet.systemPermissions());
        }
        return this;
    }

    private void validate(Collection<String> ptrns, SecurityPermission ... perms) {
        assert (ptrns != null);
        assert (perms != null);
        for (SecurityPermission perm : perms) {
            this.validate(ptrns, perm);
        }
    }

    private void validate(Collection<String> ptrns, SecurityPermission perm) {
        assert (ptrns != null);
        assert (perm != null);
        boolean ex = true;
        String name = perm.name();
        for (String ptrn : ptrns) {
            if (!name.startsWith(ptrn)) continue;
            ex = false;
            break;
        }
        if (ex) {
            throw new IgniteException("you can assign permission only start with " + ptrns + ", but you try " + name);
        }
    }

    @SafeVarargs
    private final <T> Collection<T> toCollection(T ... perms) {
        assert (perms != null);
        LinkedHashSet col = U.newLinkedHashSet(perms.length);
        Collections.addAll(col, perms);
        return col;
    }

    private void append(Map<String, Collection<SecurityPermission>> target, Map<String, Collection<SecurityPermission>> source) {
        assert (target != null);
        if (source != null) {
            for (Map.Entry<String, Collection<SecurityPermission>> e : source.entrySet()) {
                this.append(target, e.getKey(), e.getValue());
            }
        }
    }

    private void append(Map<String, Collection<SecurityPermission>> permsMap, String name, Collection<SecurityPermission> perms) {
        assert (permsMap != null);
        assert (name != null);
        assert (perms != null);
        Collection<SecurityPermission> col = permsMap.get(name);
        if (col == null) {
            if (!(perms instanceof Set)) {
                LinkedHashSet set = U.newLinkedHashSet(perms.size());
                set.addAll(perms);
                perms = set;
            }
            assert (perms instanceof Set);
            permsMap.put(name, perms);
        } else {
            col.addAll(perms);
        }
    }

    public SecurityPermissionSet build() {
        SecurityBasicPermissionSet permSet = new SecurityBasicPermissionSet();
        permSet.setDefaultAllowAll(this.dfltAllowAll);
        permSet.setCachePermissions(Collections.unmodifiableMap(this.cachePerms));
        permSet.setTaskPermissions(Collections.unmodifiableMap(this.taskPerms));
        permSet.setServicePermissions(Collections.unmodifiableMap(this.srvcPerms));
        permSet.setSystemPermissions(Collections.unmodifiableSet(this.sysPerms));
        return permSet;
    }
}

