/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.ClusterMetricsSnapshot;
import org.apache.ignite.internal.managers.discovery.IgniteClusterNode;
import org.apache.ignite.internal.util.lang.GridMetadataAwareAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.spi.discovery.DiscoveryMetricsProvider;
import org.jetbrains.annotations.Nullable;

public class TcpDiscoveryNode
extends GridMetadataAwareAdapter
implements IgniteClusterNode,
Comparable<TcpDiscoveryNode>,
Externalizable {
    public static final ThreadLocal<Boolean> RESOLVE_ADDRESSES = ThreadLocal.withInitial(() -> true);
    private static final long serialVersionUID = 0L;
    private UUID id;
    @GridToStringInclude
    private Object consistentId;
    @GridToStringExclude
    private Map<String, Object> attrs;
    @GridToStringInclude
    private Collection<String> addrs;
    private Collection<String> hostNames;
    @GridToStringInclude
    private Collection<InetSocketAddress> sockAddrs;
    @GridToStringInclude
    private int discPort;
    @GridToStringExclude
    private volatile ClusterMetrics metrics;
    @GridToStringExclude
    private volatile Map<Integer, CacheMetrics> cacheMetrics;
    private volatile long order;
    private volatile long intOrder;
    @GridToStringExclude
    private volatile long lastUpdateTimeNanos = System.nanoTime();
    private volatile long lastExchangeTime = U.currentTimeMillis();
    @GridToStringExclude
    private volatile long lastExchangeTimeNanos = System.nanoTime();
    @GridToStringExclude
    private DiscoveryMetricsProvider metricsProvider;
    @GridToStringExclude
    private boolean visible;
    private boolean loc;
    private IgniteProductVersion ver;
    @GridToStringExclude
    private volatile transient long aliveCheckTimeNanos;
    @GridToStringExclude
    private UUID clientRouterNodeId;
    @GridToStringExclude
    private volatile transient InetSocketAddress lastSuccessfulAddr;
    @GridToStringExclude
    private volatile transient boolean cacheCliInit;
    @GridToStringExclude
    private transient boolean cacheCli;
    @GridToStringExclude
    private volatile transient boolean daemonInit;
    @GridToStringExclude
    private transient boolean daemon;

    public TcpDiscoveryNode() {
    }

    public TcpDiscoveryNode(UUID id, Collection<String> addrs, Collection<String> hostNames, int discPort, DiscoveryMetricsProvider metricsProvider, IgniteProductVersion ver, Serializable consistentId) {
        assert (id != null);
        assert (metricsProvider != null);
        assert (ver != null);
        this.id = id;
        ArrayList<String> sortedAddrs = new ArrayList<String>(addrs);
        Collections.sort(sortedAddrs);
        this.addrs = sortedAddrs;
        this.hostNames = hostNames;
        this.discPort = discPort;
        this.metricsProvider = metricsProvider;
        this.ver = ver;
        this.consistentId = consistentId != null ? consistentId : U.consistentId(sortedAddrs, discPort);
        this.metrics = metricsProvider.metrics();
        this.cacheMetrics = metricsProvider.cacheMetrics();
        this.sockAddrs = U.toSocketAddresses(this, discPort);
    }

    @Nullable
    public InetSocketAddress lastSuccessfulAddress() {
        return this.lastSuccessfulAddr;
    }

    public void lastSuccessfulAddress(InetSocketAddress lastSuccessfulAddr) {
        this.lastSuccessfulAddr = lastSuccessfulAddr;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Object consistentId() {
        return this.consistentId;
    }

    @Override
    public void setConsistentId(Serializable consistentId) {
        this.consistentId = consistentId;
        HashMap<String, Object> map = new HashMap<String, Object>(this.attrs);
        map.put("org.apache.ignite.consistent.id", consistentId);
        this.attrs = Collections.unmodifiableMap(map);
    }

    @Override
    public <T> T attribute(String name) {
        if ("org.apache.ignite.security.cred".equals(name)) {
            return null;
        }
        return (T)this.attrs.get(name);
    }

    @Override
    public Map<String, Object> attributes() {
        return F.view(this.attrs, new IgnitePredicate<String>(){

            @Override
            public boolean apply(String s) {
                return !"org.apache.ignite.security.cred".equals(s);
            }
        });
    }

    public void setAttributes(Map<String, Object> attrs) {
        this.attrs = U.sealMap(attrs);
    }

    public Map<String, Object> getAttributes() {
        return this.attrs;
    }

    @Override
    public ClusterMetrics metrics() {
        if (this.metricsProvider != null) {
            ClusterMetrics metrics0;
            this.metrics = metrics0 = this.metricsProvider.metrics();
            return metrics0;
        }
        return this.metrics;
    }

    @Override
    public void setMetrics(ClusterMetrics metrics) {
        assert (metrics != null);
        this.metrics = metrics;
    }

    @Override
    public Map<Integer, CacheMetrics> cacheMetrics() {
        if (this.metricsProvider != null) {
            Map<Integer, CacheMetrics> cacheMetrics0 = this.metricsProvider.cacheMetrics();
            this.cacheMetrics = cacheMetrics0;
            return cacheMetrics0;
        }
        return this.cacheMetrics;
    }

    @Override
    public void setCacheMetrics(Map<Integer, CacheMetrics> cacheMetrics) {
        this.cacheMetrics = cacheMetrics != null ? cacheMetrics : Collections.emptyMap();
    }

    public long internalOrder() {
        return this.intOrder;
    }

    public void internalOrder(long intOrder) {
        assert (intOrder > 0L);
        this.intOrder = intOrder;
    }

    @Override
    public long order() {
        return this.order;
    }

    public void order(long order) {
        assert (order > 0L) : "Order is invalid: " + this;
        this.order = order;
    }

    @Override
    public IgniteProductVersion version() {
        return this.ver;
    }

    public void version(IgniteProductVersion ver) {
        assert (ver != null);
        this.ver = ver;
    }

    @Override
    public Collection<String> addresses() {
        return this.addrs;
    }

    @Override
    public boolean isLocal() {
        return this.loc;
    }

    public void local(boolean loc) {
        this.loc = loc;
    }

    @Override
    public boolean isDaemon() {
        if (!this.daemonInit) {
            this.daemon = "true".equalsIgnoreCase((String)this.attribute("org.apache.ignite.daemon"));
            this.daemonInit = true;
        }
        return this.daemon;
    }

    @Override
    public Collection<String> hostNames() {
        return this.hostNames;
    }

    public int discoveryPort() {
        return this.discPort;
    }

    public Collection<InetSocketAddress> socketAddresses() {
        return this.sockAddrs;
    }

    public long lastUpdateTime() {
        return System.currentTimeMillis() - U.nanosToMillis(System.nanoTime() - this.lastUpdateTimeNanos);
    }

    public long lastUpdateTimeNanos() {
        return this.lastUpdateTimeNanos;
    }

    public void lastUpdateTimeNanos(long lastUpdateTimeNanos) {
        this.lastUpdateTimeNanos = lastUpdateTimeNanos;
    }

    public long lastExchangeTimeNanos() {
        return this.lastExchangeTimeNanos;
    }

    public void lastExchangeTime(long lastExchangeTime, long lastExchangeTimeNanos) {
        this.lastExchangeTime = lastExchangeTime;
        this.lastExchangeTimeNanos = lastExchangeTimeNanos;
    }

    public boolean visible() {
        return this.visible;
    }

    public void visible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isClient() {
        if (!this.cacheCliInit) {
            Boolean clientModeAttr = (Boolean)this.attribute("org.apache.ignite.cache.client");
            this.cacheCli = clientModeAttr != null && clientModeAttr != false;
            this.cacheCliInit = true;
        }
        return this.cacheCli;
    }

    public boolean isClientAlive() {
        assert (this.isClient()) : this;
        return this.aliveCheckTimeNanos - System.nanoTime() >= 0L;
    }

    public void clientAliveTime(long aliveTime) {
        assert (this.isClient()) : this;
        this.aliveCheckTimeNanos = System.nanoTime() + U.millisToNanos(aliveTime);
    }

    public boolean clientAliveTimeSet() {
        return this.aliveCheckTimeNanos != 0L;
    }

    public long aliveCheckTimeNanos() {
        return this.aliveCheckTimeNanos;
    }

    public UUID clientRouterNodeId() {
        return this.clientRouterNodeId;
    }

    public void clientRouterNodeId(UUID clientRouterNodeId) {
        this.clientRouterNodeId = clientRouterNodeId;
    }

    public void onClientDisconnected(UUID newId) {
        this.id = newId;
    }

    public TcpDiscoveryNode clientReconnectNode(Map<String, Object> nodeAttrs) {
        TcpDiscoveryNode node = new TcpDiscoveryNode(this.id, this.addrs, this.hostNames, this.discPort, this.metricsProvider, this.ver, null);
        node.attrs = Collections.unmodifiableMap(new HashMap<String, Object>(nodeAttrs));
        node.clientRouterNodeId = this.clientRouterNodeId;
        return node;
    }

    @Override
    public int compareTo(@Nullable TcpDiscoveryNode node) {
        if (node == null) {
            return 1;
        }
        int res = Long.compare(this.internalOrder(), node.internalOrder());
        if (res == 0) {
            assert (this.id().equals(node.id())) : "Duplicate order [this=" + this + ", other=" + node + ']';
            res = this.id().compareTo(node.id());
        }
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.id);
        U.writeMap(out, this.attrs);
        U.writeCollection(out, this.addrs);
        U.writeCollection(out, this.hostNames);
        out.writeInt(this.discPort);
        byte[] mtr = null;
        ClusterMetrics metrics = this.metrics;
        if (metrics != null) {
            mtr = ClusterMetricsSnapshot.serialize(metrics);
        }
        U.writeByteArray(out, mtr);
        out.writeInt(0);
        out.writeLong(this.order);
        out.writeLong(this.intOrder);
        out.writeObject(this.ver);
        U.writeUuid(out, this.clientRouterNodeId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readUuid(in);
        this.attrs = U.sealMap(U.readMap(in));
        this.addrs = U.readCollection(in);
        this.hostNames = U.readCollection(in);
        this.discPort = in.readInt();
        this.sockAddrs = U.toSocketAddresses(this.addrs, this.hostNames, this.discPort, Boolean.TRUE.equals(RESOLVE_ADDRESSES.get()));
        Object consistentIdAttr = this.attrs.get("org.apache.ignite.consistent.id");
        byte[] mtr = U.readByteArray(in);
        if (mtr != null) {
            this.metrics = ClusterMetricsSnapshot.deserialize(mtr, 0);
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            in.readInt();
            in.readObject();
        }
        this.order = in.readLong();
        this.intOrder = in.readLong();
        this.ver = (IgniteProductVersion)in.readObject();
        this.clientRouterNodeId = U.readUuid(in);
        this.consistentId = this.clientRouterNodeId() != null ? (consistentIdAttr != null ? consistentIdAttr : this.id) : (consistentIdAttr != null ? consistentIdAttr : U.consistentId(this.addrs, this.discPort));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return F.eqNodes(this, o);
    }

    public String toString() {
        return S.toString(TcpDiscoveryNode.class, this, "isClient", (Object)this.isClient());
    }

    public TcpDiscoveryNode(ClusterNode node) {
        this.id = node.id();
        this.consistentId = node.consistentId();
        this.addrs = node.addresses();
        this.hostNames = node.hostNames();
        this.order = node.order();
        this.ver = node.version();
        this.daemon = node.isDaemon();
        this.clientRouterNodeId = node.isClient() ? node.id() : null;
        this.attrs = Collections.singletonMap("org.apache.ignite.consistent.id", this.consistentId);
    }
}

