/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command;

import java.util.ArrayList;
import org.gridgain.internal.h2.command.Command;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.ParameterInterface;
import org.gridgain.internal.h2.result.ResultInterface;

class CommandList
extends Command {
    private final Command command;
    private final String remaining;

    CommandList(Session session, String sql, Command c, String remaining) {
        super(session, sql);
        this.command = c;
        this.remaining = remaining;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.command.getParameters();
    }

    private void executeRemaining() {
        Command remainingCommand = this.session.prepareLocal(this.remaining);
        if (remainingCommand.isQuery()) {
            remainingCommand.query(0);
        } else {
            remainingCommand.update();
        }
    }

    @Override
    public int update() {
        int updateCount = this.command.executeUpdate(false).getUpdateCount();
        this.executeRemaining();
        return updateCount;
    }

    @Override
    public void prepareJoinBatch() {
        this.command.prepareJoinBatch();
    }

    @Override
    public ResultInterface query(int maxrows) {
        ResultInterface result = this.command.query(maxrows);
        this.executeRemaining();
        return result;
    }

    @Override
    public boolean isQuery() {
        return this.command.isQuery();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.command.queryMeta();
    }

    @Override
    public int getCommandType() {
        return this.command.getCommandType();
    }
}

