/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.gridgain.internal.h2.api.IntervalQualifier;
import org.gridgain.internal.h2.command.Command;
import org.gridgain.internal.h2.command.CommandContainer;
import org.gridgain.internal.h2.command.CommandList;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.ddl.AlterIndexRename;
import org.gridgain.internal.h2.command.ddl.AlterSchemaRename;
import org.gridgain.internal.h2.command.ddl.AlterSequence;
import org.gridgain.internal.h2.command.ddl.AlterTableAddConstraint;
import org.gridgain.internal.h2.command.ddl.AlterTableAlterColumn;
import org.gridgain.internal.h2.command.ddl.AlterTableDropConstraint;
import org.gridgain.internal.h2.command.ddl.AlterTableRename;
import org.gridgain.internal.h2.command.ddl.AlterTableRenameColumn;
import org.gridgain.internal.h2.command.ddl.AlterTableRenameConstraint;
import org.gridgain.internal.h2.command.ddl.AlterUser;
import org.gridgain.internal.h2.command.ddl.AlterView;
import org.gridgain.internal.h2.command.ddl.Analyze;
import org.gridgain.internal.h2.command.ddl.CommandWithColumns;
import org.gridgain.internal.h2.command.ddl.CreateAggregate;
import org.gridgain.internal.h2.command.ddl.CreateConstant;
import org.gridgain.internal.h2.command.ddl.CreateDomain;
import org.gridgain.internal.h2.command.ddl.CreateFunctionAlias;
import org.gridgain.internal.h2.command.ddl.CreateIndex;
import org.gridgain.internal.h2.command.ddl.CreateLinkedTable;
import org.gridgain.internal.h2.command.ddl.CreateRole;
import org.gridgain.internal.h2.command.ddl.CreateSchema;
import org.gridgain.internal.h2.command.ddl.CreateSequence;
import org.gridgain.internal.h2.command.ddl.CreateSynonym;
import org.gridgain.internal.h2.command.ddl.CreateTable;
import org.gridgain.internal.h2.command.ddl.CreateTrigger;
import org.gridgain.internal.h2.command.ddl.CreateUser;
import org.gridgain.internal.h2.command.ddl.CreateView;
import org.gridgain.internal.h2.command.ddl.DeallocateProcedure;
import org.gridgain.internal.h2.command.ddl.DefineCommand;
import org.gridgain.internal.h2.command.ddl.DropAggregate;
import org.gridgain.internal.h2.command.ddl.DropConstant;
import org.gridgain.internal.h2.command.ddl.DropDatabase;
import org.gridgain.internal.h2.command.ddl.DropDomain;
import org.gridgain.internal.h2.command.ddl.DropFunctionAlias;
import org.gridgain.internal.h2.command.ddl.DropIndex;
import org.gridgain.internal.h2.command.ddl.DropRole;
import org.gridgain.internal.h2.command.ddl.DropSchema;
import org.gridgain.internal.h2.command.ddl.DropSequence;
import org.gridgain.internal.h2.command.ddl.DropSynonym;
import org.gridgain.internal.h2.command.ddl.DropTable;
import org.gridgain.internal.h2.command.ddl.DropTrigger;
import org.gridgain.internal.h2.command.ddl.DropUser;
import org.gridgain.internal.h2.command.ddl.DropView;
import org.gridgain.internal.h2.command.ddl.GrantRevoke;
import org.gridgain.internal.h2.command.ddl.PrepareProcedure;
import org.gridgain.internal.h2.command.ddl.SchemaCommand;
import org.gridgain.internal.h2.command.ddl.SequenceOptions;
import org.gridgain.internal.h2.command.ddl.SetComment;
import org.gridgain.internal.h2.command.ddl.TruncateTable;
import org.gridgain.internal.h2.command.dml.AlterTableSet;
import org.gridgain.internal.h2.command.dml.BackupCommand;
import org.gridgain.internal.h2.command.dml.Call;
import org.gridgain.internal.h2.command.dml.CommandWithValues;
import org.gridgain.internal.h2.command.dml.Delete;
import org.gridgain.internal.h2.command.dml.ExecuteProcedure;
import org.gridgain.internal.h2.command.dml.Explain;
import org.gridgain.internal.h2.command.dml.Insert;
import org.gridgain.internal.h2.command.dml.Merge;
import org.gridgain.internal.h2.command.dml.MergeUsing;
import org.gridgain.internal.h2.command.dml.NoOperation;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.command.dml.Replace;
import org.gridgain.internal.h2.command.dml.RunScriptCommand;
import org.gridgain.internal.h2.command.dml.ScriptCommand;
import org.gridgain.internal.h2.command.dml.Select;
import org.gridgain.internal.h2.command.dml.SelectOrderBy;
import org.gridgain.internal.h2.command.dml.SelectUnion;
import org.gridgain.internal.h2.command.dml.Set;
import org.gridgain.internal.h2.command.dml.SetTypes;
import org.gridgain.internal.h2.command.dml.TransactionCommand;
import org.gridgain.internal.h2.command.dml.Update;
import org.gridgain.internal.h2.constraint.ConstraintActionType;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Domain;
import org.gridgain.internal.h2.engine.FunctionAlias;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Procedure;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.User;
import org.gridgain.internal.h2.engine.UserAggregate;
import org.gridgain.internal.h2.expression.Alias;
import org.gridgain.internal.h2.expression.BinaryOperation;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionList;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.expression.Rownum;
import org.gridgain.internal.h2.expression.SequenceValue;
import org.gridgain.internal.h2.expression.Subquery;
import org.gridgain.internal.h2.expression.UnaryOperation;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.Variable;
import org.gridgain.internal.h2.expression.Wildcard;
import org.gridgain.internal.h2.expression.aggregate.AbstractAggregate;
import org.gridgain.internal.h2.expression.aggregate.Aggregate;
import org.gridgain.internal.h2.expression.aggregate.AggregateType;
import org.gridgain.internal.h2.expression.aggregate.JavaAggregate;
import org.gridgain.internal.h2.expression.analysis.DataAnalysisOperation;
import org.gridgain.internal.h2.expression.analysis.Window;
import org.gridgain.internal.h2.expression.analysis.WindowFrame;
import org.gridgain.internal.h2.expression.analysis.WindowFrameBound;
import org.gridgain.internal.h2.expression.analysis.WindowFrameBoundType;
import org.gridgain.internal.h2.expression.analysis.WindowFrameExclusion;
import org.gridgain.internal.h2.expression.analysis.WindowFrameUnits;
import org.gridgain.internal.h2.expression.analysis.WindowFunction;
import org.gridgain.internal.h2.expression.analysis.WindowFunctionType;
import org.gridgain.internal.h2.expression.condition.CompareLike;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.expression.condition.Condition;
import org.gridgain.internal.h2.expression.condition.ConditionAndOr;
import org.gridgain.internal.h2.expression.condition.ConditionExists;
import org.gridgain.internal.h2.expression.condition.ConditionIn;
import org.gridgain.internal.h2.expression.condition.ConditionInParameter;
import org.gridgain.internal.h2.expression.condition.ConditionInSelect;
import org.gridgain.internal.h2.expression.condition.ConditionNot;
import org.gridgain.internal.h2.expression.condition.TypePredicate;
import org.gridgain.internal.h2.expression.function.Function;
import org.gridgain.internal.h2.expression.function.FunctionCall;
import org.gridgain.internal.h2.expression.function.JavaFunction;
import org.gridgain.internal.h2.expression.function.TableFunction;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.FunctionTable;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.IndexHints;
import org.gridgain.internal.h2.table.RangeTable;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.util.IntervalUtils;
import org.gridgain.internal.h2.util.ParserUtil;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.util.geometry.EWKTUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.ExtTypeInfo;
import org.gridgain.internal.h2.value.ExtTypeInfoEnum;
import org.gridgain.internal.h2.value.ExtTypeInfoGeometry;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueBytes;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueRow;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;

public class Parser {
    private static final String WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS = "WITH statement supports only SELECT, TABLE, VALUES, CREATE TABLE, INSERT, UPDATE, MERGE or DELETE statements";
    private static final int CHAR_END = 1;
    private static final int CHAR_VALUE = 2;
    private static final int CHAR_QUOTED = 3;
    private static final int CHAR_NAME = 4;
    private static final int CHAR_SPECIAL_1 = 5;
    private static final int CHAR_SPECIAL_2 = 6;
    private static final int CHAR_STRING = 7;
    private static final int CHAR_DOT = 8;
    private static final int CHAR_DOLLAR_QUOTED_STRING = 9;
    private static final int PARAMETER = 56;
    private static final int END = 57;
    private static final int VALUE = 58;
    private static final int EQUAL = 59;
    private static final int BIGGER_EQUAL = 60;
    private static final int BIGGER = 61;
    private static final int SMALLER = 62;
    private static final int SMALLER_EQUAL = 63;
    private static final int NOT_EQUAL = 64;
    private static final int AT = 65;
    private static final int MINUS_SIGN = 66;
    private static final int PLUS_SIGN = 67;
    private static final int STRING_CONCAT = 68;
    private static final int OPEN_PAREN = 69;
    private static final int CLOSE_PAREN = 70;
    private static final int SPATIAL_INTERSECTS = 71;
    private static final int ASTERISK = 72;
    private static final int COMMA = 73;
    private static final int DOT = 74;
    private static final int OPEN_BRACE = 75;
    private static final int CLOSE_BRACE = 76;
    private static final int SLASH = 77;
    private static final int PERCENT = 78;
    private static final int SEMICOLON = 79;
    private static final int COLON = 80;
    private static final int OPEN_BRACKET = 81;
    private static final int CLOSE_BRACKET = 82;
    private static final int TILDE = 83;
    private static final int COLON_COLON = 84;
    private static final int COLON_EQ = 85;
    private static final int NOT_TILDE = 86;
    private static final String[] TOKENS = new String[]{null, null, null, "ALL", "ARRAY", "CASE", "CHECK", "CONSTRAINT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DISTINCT", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "IF", "INNER", "INTERSECT", "INTERSECTS", "INTERVAL", "IS", "JOIN", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "MINUS", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "ORDER", "PRIMARY", "QUALIFY", "ROW", "_ROWID_", "ROWNUM", "SELECT", "TABLE", "TRUE", "UNION", "UNIQUE", "VALUES", "WHERE", "WINDOW", "WITH", "?", null, null, "=", ">=", ">", "<", "<=", "<>", "@", "-", "+", "||", "(", ")", "&&", "*", ",", ".", "{", "}", "/", "%", ";", ":", "[", "]", "~", "::", ":=", "!~"};
    private static final Comparator<TableFilter> TABLE_FILTER_COMPARATOR = new Comparator<TableFilter>(){

        @Override
        public int compare(TableFilter o1, TableFilter o2) {
            if (o1 == o2) {
                return 0;
            }
            assert (o1.getOrderInFrom() != o2.getOrderInFrom());
            return o1.getOrderInFrom() > o2.getOrderInFrom() ? 1 : -1;
        }
    };
    private final Database database;
    private final Session session;
    private final boolean identifiersToLower;
    private final boolean identifiersToUpper;
    private int[] characterTypes;
    private int currentTokenType;
    private String currentToken;
    private boolean currentTokenQuoted;
    private Value currentValue;
    private String originalSQL;
    private String sqlCommand;
    private char[] sqlCommandChars;
    private int lastParseIndex;
    private int parseIndex;
    private CreateView createView;
    private Prepared currentPrepared;
    private Select currentSelect;
    private ArrayList<Parameter> parameters;
    private String schemaName;
    private ArrayList<String> expectedList;
    private boolean rightsChecked;
    private boolean recompileAlways;
    private boolean literalsChecked;
    private ArrayList<Parameter> indexedParameterList;
    private int orderInFrom;
    private ArrayList<Parameter> suppliedParameterList;

    public Parser(Session session) {
        this.database = session.getDatabase();
        this.identifiersToLower = this.database.getSettings().databaseToLower;
        this.identifiersToUpper = this.database.getSettings().databaseToUpper;
        this.session = session;
    }

    public Prepared prepare(String sql) {
        Prepared p = this.parse(sql);
        p.prepare();
        if (this.currentTokenType != 57) {
            throw this.getSyntaxError();
        }
        return p;
    }

    public Command prepareCommand(String sql) {
        try {
            String remaining;
            Prepared p = this.parse(sql);
            boolean hasMore = this.isToken(79);
            if (!hasMore && this.currentTokenType != 57) {
                throw this.getSyntaxError();
            }
            try {
                p.prepare();
            }
            catch (Throwable t) {
                CommandContainer.clearCTE(this.session, p);
                throw t;
            }
            Command c = new CommandContainer(this.session, sql, p);
            if (hasMore && !StringUtils.isWhitespaceOrEmpty(remaining = this.originalSQL.substring(this.parseIndex))) {
                c = new CommandList(this.session, sql, c, remaining);
            }
            return c;
        }
        catch (DbException e) {
            throw e.addSQL(this.originalSQL);
        }
    }

    Prepared parse(String sql) {
        Prepared p;
        try {
            p = this.parse(sql, false);
        }
        catch (DbException e) {
            if (e.getErrorCode() == 42000) {
                p = this.parse(sql, true);
            }
            throw e.addSQL(sql);
        }
        p.setPrepareAlways(this.recompileAlways);
        p.setParameterList(this.parameters);
        return p;
    }

    private Prepared parse(String sql, boolean withExpectedList) {
        this.initialize(sql);
        this.expectedList = withExpectedList ? new ArrayList() : null;
        this.parameters = Utils.newSmallArrayList();
        this.currentSelect = null;
        this.currentPrepared = null;
        this.createView = null;
        this.recompileAlways = false;
        this.indexedParameterList = this.suppliedParameterList;
        this.read();
        return this.parsePrepared();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Prepared parsePrepared() {
        void var2_40;
        int start = this.lastParseIndex;
        Object var2_2 = null;
        switch (this.currentTokenType) {
            case 57: 
            case 79: {
                NoOperation noOperation = new NoOperation(this.session);
                this.setSQL(noOperation, null, start);
                return noOperation;
            }
            case 56: {
                this.readTerm();
                this.parameters.get(0).setValue(ValueNull.INSTANCE);
                this.read(59);
                this.read("CALL");
                Call call = this.parseCall();
                break;
            }
            case 20: 
            case 47: 
            case 48: 
            case 52: 
            case 69: {
                Query query = this.parseSelect();
                break;
            }
            case 55: {
                this.read();
                Prepared prepared = this.parseWithStatementOrQuery();
                break;
            }
            case 2: {
                if (this.currentTokenQuoted) break;
                switch (this.currentToken.charAt(0)) {
                    case 'A': 
                    case 'a': {
                        if (this.readIf("ALTER")) {
                            Prepared prepared = this.parseAlter();
                            break;
                        }
                        if (!this.readIf("ANALYZE")) break;
                        Prepared prepared = this.parseAnalyze();
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        if (this.readIf("BACKUP")) {
                            Prepared prepared = this.parseBackup();
                            break;
                        }
                        if (!this.readIf("BEGIN")) break;
                        TransactionCommand transactionCommand = this.parseBegin();
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        if (this.readIf("COMMIT")) {
                            TransactionCommand transactionCommand = this.parseCommit();
                            break;
                        }
                        if (this.readIf("CREATE")) {
                            Prepared prepared = this.parseCreate();
                            break;
                        }
                        if (this.readIf("CALL")) {
                            Call call = this.parseCall();
                            break;
                        }
                        if (this.readIf("CHECKPOINT")) {
                            TransactionCommand transactionCommand = this.parseCheckpoint();
                            break;
                        }
                        if (!this.readIf("COMMENT")) break;
                        Prepared prepared = this.parseComment();
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        if (this.readIf("DELETE")) {
                            Delete delete = this.parseDelete();
                            break;
                        }
                        if (this.readIf("DROP")) {
                            Prepared prepared = this.parseDrop();
                            break;
                        }
                        if (this.readIf("DECLARE")) {
                            Prepared prepared = this.parseCreate();
                            break;
                        }
                        if (!this.readIf("DEALLOCATE")) break;
                        DeallocateProcedure deallocateProcedure = this.parseDeallocate();
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (this.readIf("EXPLAIN")) {
                            Explain explain = this.parseExplain();
                            break;
                        }
                        if (!this.readIf("EXECUTE")) break;
                        Prepared prepared = this.parseExecute();
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        if (!this.readIf("GRANT")) break;
                        GrantRevoke grantRevoke = this.parseGrantRevoke(49);
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        if (!this.readIf("HELP")) break;
                        Prepared prepared = this.parseHelp();
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        if (!this.readIf("INSERT")) break;
                        Insert insert = this.parseInsert();
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        if (!this.readIf("MERGE")) break;
                        Prepared prepared = this.parseMerge();
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        if (!this.readIf("PREPARE")) break;
                        Prepared prepared = this.parsePrepare();
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        if (this.readIf("ROLLBACK")) {
                            TransactionCommand transactionCommand = this.parseRollback();
                            break;
                        }
                        if (this.readIf("REVOKE")) {
                            GrantRevoke grantRevoke = this.parseGrantRevoke(50);
                            break;
                        }
                        if (this.readIf("RUNSCRIPT")) {
                            RunScriptCommand runScriptCommand = this.parseRunScript();
                            break;
                        }
                        if (this.readIf("RELEASE")) {
                            Prepared prepared = this.parseReleaseSavepoint();
                            break;
                        }
                        if (!this.readIf("REPLACE")) break;
                        Replace replace = this.parseReplace();
                        break;
                    }
                    case 'S': 
                    case 's': {
                        if (this.readIf("SET")) {
                            Prepared prepared = this.parseSet();
                            break;
                        }
                        if (this.readIf("SAVEPOINT")) {
                            TransactionCommand transactionCommand = this.parseSavepoint();
                            break;
                        }
                        if (this.readIf("SCRIPT")) {
                            ScriptCommand scriptCommand = this.parseScript();
                            break;
                        }
                        if (this.readIf("SHUTDOWN")) {
                            TransactionCommand transactionCommand = this.parseShutdown();
                            break;
                        }
                        if (!this.readIf("SHOW")) break;
                        Prepared prepared = this.parseShow();
                        break;
                    }
                    case 'T': 
                    case 't': {
                        if (!this.readIf("TRUNCATE")) break;
                        Prepared prepared = this.parseTruncate();
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        if (this.readIf("UPDATE")) {
                            Update update = this.parseUpdate();
                            break;
                        }
                        if (!this.readIf("USE")) break;
                        Prepared prepared = this.parseUse();
                    }
                }
                break;
            }
        }
        if (var2_40 == null) {
            throw this.getSyntaxError();
        }
        if (this.indexedParameterList != null) {
            int size = this.indexedParameterList.size();
            for (int i = 0; i < size; ++i) {
                if (this.indexedParameterList.get(i) != null) continue;
                this.indexedParameterList.set(i, new Parameter(i));
            }
            this.parameters = this.indexedParameterList;
        }
        if (this.readIf(75)) {
            do {
                int index;
                if ((index = (int)this.readLong() - 1) < 0 || index >= this.parameters.size()) {
                    throw this.getSyntaxError();
                }
                Parameter p = this.parameters.get(index);
                if (p == null) {
                    throw this.getSyntaxError();
                }
                this.read(80);
                Expression expr = this.readExpression();
                expr = expr.optimize(this.session);
                p.setValue(expr.getValue(this.session));
            } while (this.readIf(73));
            this.read(76);
            for (Parameter p : this.parameters) {
                p.checkSet();
            }
            this.parameters.clear();
        }
        this.setSQL((Prepared)var2_40, null, start);
        return var2_40;
    }

    private DbException getSyntaxError() {
        if (this.expectedList == null || this.expectedList.isEmpty()) {
            return DbException.getSyntaxError(this.sqlCommand, this.parseIndex);
        }
        return DbException.getSyntaxError(this.sqlCommand, this.parseIndex, StringUtils.join(new StringBuilder(), this.expectedList, ", ").toString());
    }

    private Prepared parseBackup() {
        BackupCommand command = new BackupCommand(this.session);
        this.read("TO");
        command.setFileName(this.readExpression());
        return command;
    }

    private Prepared parseAnalyze() {
        Analyze command = new Analyze(this.session);
        if (this.readIf(48)) {
            Table table = this.readTableOrView();
            command.setTable(table);
        }
        if (this.readIf("SAMPLE_SIZE")) {
            command.setTop(this.readNonNegativeInt());
        }
        return command;
    }

    private TransactionCommand parseBegin() {
        if (!this.readIf("WORK")) {
            this.readIf("TRANSACTION");
        }
        TransactionCommand command = new TransactionCommand(this.session, 83);
        return command;
    }

    private TransactionCommand parseCommit() {
        if (this.readIf("TRANSACTION")) {
            TransactionCommand command = new TransactionCommand(this.session, 78);
            command.setTransactionName(this.readUniqueIdentifier());
            return command;
        }
        TransactionCommand command = new TransactionCommand(this.session, 71);
        this.readIf("WORK");
        return command;
    }

    private TransactionCommand parseShutdown() {
        int type = 80;
        if (this.readIf("IMMEDIATELY")) {
            type = 81;
        } else if (this.readIf("COMPACT")) {
            type = 82;
        } else if (this.readIf("DEFRAG")) {
            type = 84;
        } else {
            this.readIf("SCRIPT");
        }
        return new TransactionCommand(this.session, type);
    }

    private TransactionCommand parseRollback() {
        TransactionCommand command;
        if (this.readIf("TRANSACTION")) {
            TransactionCommand command2 = new TransactionCommand(this.session, 79);
            command2.setTransactionName(this.readUniqueIdentifier());
            return command2;
        }
        if (this.readIf("TO")) {
            this.read("SAVEPOINT");
            command = new TransactionCommand(this.session, 75);
            command.setSavepointName(this.readUniqueIdentifier());
        } else {
            this.readIf("WORK");
            command = new TransactionCommand(this.session, 72);
        }
        return command;
    }

    private Prepared parsePrepare() {
        if (this.readIf("COMMIT")) {
            TransactionCommand command = new TransactionCommand(this.session, 77);
            command.setTransactionName(this.readUniqueIdentifier());
            return command;
        }
        String procedureName = this.readAliasIdentifier();
        if (this.readIf(69)) {
            ArrayList list = Utils.newSmallArrayList();
            int i = 0;
            while (true) {
                Column column = this.parseColumnForTable("C" + i, true, false);
                list.add(column);
                if (!this.readIfMore(true)) break;
                ++i;
            }
        }
        this.read("AS");
        Prepared prep = this.parsePrepared();
        PrepareProcedure command = new PrepareProcedure(this.session);
        command.setProcedureName(procedureName);
        command.setPrepared(prep);
        return command;
    }

    private TransactionCommand parseSavepoint() {
        TransactionCommand command = new TransactionCommand(this.session, 74);
        command.setSavepointName(this.readUniqueIdentifier());
        return command;
    }

    private Prepared parseReleaseSavepoint() {
        NoOperation command = new NoOperation(this.session);
        this.readIf("SAVEPOINT");
        this.readUniqueIdentifier();
        return command;
    }

    private Schema findSchema(String schemaName) {
        if (schemaName == null) {
            return null;
        }
        Schema schema = this.database.findSchema(schemaName);
        if (schema == null && this.equalsToken("SESSION", schemaName)) {
            schema = this.database.getSchema(this.session.getCurrentSchemaName());
        }
        return schema;
    }

    private Schema getSchema(String schemaName) {
        if (schemaName == null) {
            return null;
        }
        Schema schema = this.findSchema(schemaName);
        if (schema == null) {
            throw DbException.get(90079, schemaName);
        }
        return schema;
    }

    private Schema getSchema() {
        return this.getSchema(this.schemaName);
    }

    private Schema getSchemaWithDefault() {
        if (this.schemaName == null) {
            this.schemaName = this.session.getCurrentSchemaName();
        }
        return this.getSchema(this.schemaName);
    }

    private Column readTableColumn(TableFilter filter) {
        boolean rowId = false;
        String columnName = null;
        if (this.currentTokenType == 45) {
            this.read();
            rowId = true;
        } else {
            columnName = this.readColumnIdentifier();
            if (this.readIf(74)) {
                String tableAlias = columnName;
                if (this.currentTokenType == 45) {
                    this.read();
                    rowId = true;
                } else {
                    columnName = this.readColumnIdentifier();
                    if (this.readIf(74)) {
                        String schema = tableAlias;
                        tableAlias = columnName;
                        if (this.currentTokenType == 45) {
                            this.read();
                            rowId = true;
                        } else {
                            columnName = this.readColumnIdentifier();
                            if (this.readIf(74)) {
                                if (!this.equalsToken(schema, this.database.getShortName())) {
                                    throw DbException.get(90013, schema);
                                }
                                schema = tableAlias;
                                tableAlias = columnName;
                                if (this.currentTokenType == 45) {
                                    this.read();
                                    rowId = true;
                                } else {
                                    columnName = this.readColumnIdentifier();
                                }
                            }
                        }
                        if (!this.equalsToken(schema, filter.getTable().getSchema().getName())) {
                            throw DbException.get(90079, schema);
                        }
                    }
                }
                if (!this.equalsToken(tableAlias, filter.getTableAlias())) {
                    throw DbException.get(42102, tableAlias);
                }
            }
        }
        return rowId ? filter.getRowIdColumn() : filter.getTable().getColumn(columnName);
    }

    private Update parseUpdate() {
        Update command = new Update(this.session);
        this.currentPrepared = command;
        int start = this.lastParseIndex;
        TableFilter filter = this.readSimpleTableFilter(0, null);
        command.setTableFilter(filter);
        this.parseUpdateSetClause(command, filter, start, true);
        return command;
    }

    private void parseUpdateSetClause(Update command, TableFilter filter, int start, boolean allowExtensions) {
        this.read("SET");
        if (this.readIf(69)) {
            ArrayList columns = Utils.newSmallArrayList();
            do {
                Column column = this.readTableColumn(filter);
                columns.add(column);
            } while (this.readIfMore(true));
            this.read(59);
            Expression expression = this.readExpression();
            if (columns.size() == 1 && (expression.getType() == null || expression.getType().getValueType() != 39)) {
                command.setAssignment((Column)columns.get(0), expression);
            } else {
                int size = columns.size();
                for (int i = 0; i < size; ++i) {
                    Column column = (Column)columns.get(i);
                    Function f = Function.getFunction(this.database, "ARRAY_GET");
                    f.setParameter(0, expression);
                    f.setParameter(1, ValueExpression.get(ValueInt.get(i + 1)));
                    f.doneWithParameters();
                    command.setAssignment(column, f);
                }
            }
        } else {
            do {
                Column column = this.readTableColumn(filter);
                this.read(59);
                command.setAssignment(column, this.readExpressionOrDefault());
            } while (this.readIf(73));
        }
        if (this.readIf(53)) {
            Expression condition = this.readExpression();
            command.setCondition(condition);
        }
        if (allowExtensions) {
            if (this.readIf(41)) {
                this.read("BY");
                this.parseSimpleOrderList();
            }
            if (this.readIf(32)) {
                Expression limit = this.readTerm().optimize(this.session);
                command.setLimit(limit);
            }
        }
        this.setSQL(command, "UPDATE", start);
    }

    private TableFilter readSimpleTableFilter(int orderInFrom, Collection<String> excludeTokens) {
        Table table = this.readTableOrView();
        String alias = null;
        if (this.readIf("AS")) {
            alias = this.readAliasIdentifier();
        } else if (!(this.currentTokenType != 2 || Parser.equalsTokenIgnoreCase(this.currentToken, "SET") || excludeTokens != null && this.isTokenInList(excludeTokens))) {
            alias = this.readAliasIdentifier();
        }
        return new TableFilter(this.session, table, alias, this.rightsChecked, this.currentSelect, orderInFrom, null);
    }

    private Delete parseDelete() {
        Delete command = new Delete(this.session);
        Expression limit = null;
        if (this.readIf("TOP")) {
            limit = this.readTerm().optimize(this.session);
        }
        this.currentPrepared = command;
        int start = this.lastParseIndex;
        if (!this.readIf(20) && this.database.getMode().getEnum() == Mode.ModeEnum.MySQL) {
            this.readIdentifierWithSchema();
            this.read(20);
        }
        TableFilter filter = this.readSimpleTableFilter(0, null);
        command.setTableFilter(filter);
        if (this.readIf(53)) {
            command.setCondition(this.readExpression());
        }
        if (limit == null && this.readIf(32)) {
            limit = this.readTerm().optimize(this.session);
        }
        command.setLimit(limit);
        this.setSQL(command, "DELETE", start);
        return command;
    }

    private IndexColumn[] parseIndexColumnList() {
        ArrayList<IndexColumn> columns = Utils.newSmallArrayList();
        do {
            IndexColumn column = new IndexColumn();
            column.columnName = this.readColumnIdentifier();
            column.sortType = this.parseSortType();
            columns.add(column);
        } while (this.readIfMore(true));
        return columns.toArray(new IndexColumn[0]);
    }

    private int parseSortType() {
        int sortType = this.parseSimpleSortType();
        if (this.readIf("NULLS")) {
            if (this.readIf("FIRST")) {
                sortType |= 2;
            } else {
                this.read("LAST");
                sortType |= 4;
            }
        }
        return sortType;
    }

    private int parseSimpleSortType() {
        if (!this.readIf("ASC") && this.readIf("DESC")) {
            return 1;
        }
        return 0;
    }

    private String[] parseColumnList() {
        ArrayList<String> columns = Utils.newSmallArrayList();
        do {
            String columnName = this.readColumnIdentifier();
            columns.add(columnName);
        } while (this.readIfMore(false));
        return columns.toArray(new String[0]);
    }

    private Column[] parseColumnList(Table table) {
        ArrayList<Column> columns = Utils.newSmallArrayList();
        HashSet<Column> set = new HashSet<Column>();
        if (!this.readIf(70)) {
            do {
                Column column;
                if (!set.add(column = this.parseColumn(table))) {
                    throw DbException.get(42121, column.getSQL(false));
                }
                columns.add(column);
            } while (this.readIfMore(false));
        }
        return columns.toArray(new Column[0]);
    }

    private Column parseColumn(Table table) {
        if (this.currentTokenType == 45) {
            this.read();
            return table.getRowIdColumn();
        }
        return table.getColumn(this.readColumnIdentifier());
    }

    private boolean readIfMore(boolean strict) {
        if (this.readIf(73)) {
            return strict || !this.readIf(70);
        }
        this.read(70);
        return false;
    }

    private Prepared parseHelp() {
        Select select = new Select(this.session, null);
        select.setWildcard();
        String informationSchema = this.database.sysIdentifier("INFORMATION_SCHEMA");
        Table table = this.database.getSchema(informationSchema).resolveTableOrView(this.session, this.database.sysIdentifier("HELP"));
        Function function = Function.getFunction(this.database, "UPPER");
        function.setParameter(0, new ExpressionColumn(this.database, informationSchema, this.database.sysIdentifier("HELP"), this.database.sysIdentifier("TOPIC"), false));
        function.doneWithParameters();
        TableFilter filter = new TableFilter(this.session, table, null, this.rightsChecked, select, 0, null);
        select.addTableFilter(filter, true);
        while (this.currentTokenType != 57) {
            String s = this.currentToken;
            this.read();
            CompareLike like = new CompareLike(this.database, function, ValueExpression.get(ValueString.get('%' + s + '%')), null, false);
            select.addCondition(like);
        }
        select.init();
        return select;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Prepared parseShow() {
        ArrayList<Value> paramValues = Utils.newSmallArrayList();
        StringBuilder buff = new StringBuilder("SELECT ");
        if (this.readIf("CLIENT_ENCODING")) {
            buff.append("'UNICODE' AS CLIENT_ENCODING FROM DUAL");
        } else if (this.readIf("DEFAULT_TRANSACTION_ISOLATION")) {
            buff.append("'read committed' AS DEFAULT_TRANSACTION_ISOLATION FROM DUAL");
        } else if (this.readIf("TRANSACTION")) {
            this.read("ISOLATION");
            this.read("LEVEL");
            buff.append("'read committed' AS TRANSACTION_ISOLATION FROM DUAL");
        } else if (this.readIf("DATESTYLE")) {
            buff.append("'ISO' AS DATESTYLE FROM DUAL");
        } else if (this.readIf("SERVER_VERSION")) {
            buff.append("'8.2.23' AS SERVER_VERSION FROM DUAL");
        } else if (this.readIf("SERVER_ENCODING")) {
            buff.append("'UTF8' AS SERVER_ENCODING FROM DUAL");
        } else if (this.readIf("TABLES")) {
            String schema = this.database.getMainSchema().getName();
            if (this.readIf(20)) {
                schema = this.readUniqueIdentifier();
            }
            buff.append("TABLE_NAME, TABLE_SCHEMA FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? ORDER BY TABLE_NAME");
            paramValues.add(ValueString.get(schema));
        } else if (this.readIf("COLUMNS")) {
            this.read(20);
            String tableName = this.readIdentifierWithSchema();
            String schemaName = this.getSchema().getName();
            paramValues.add(ValueString.get(tableName));
            if (this.readIf(20)) {
                schemaName = this.readUniqueIdentifier();
            }
            buff.append("C.COLUMN_NAME FIELD, C.TYPE_NAME || '(' || C.NUMERIC_PRECISION || ')' TYPE, C.IS_NULLABLE \"NULL\", CASE (SELECT MAX(I.INDEX_TYPE_NAME) FROM INFORMATION_SCHEMA.INDEXES I WHERE I.TABLE_SCHEMA=C.TABLE_SCHEMA AND I.TABLE_NAME=C.TABLE_NAME AND I.COLUMN_NAME=C.COLUMN_NAME)WHEN 'PRIMARY KEY' THEN 'PRI' WHEN 'UNIQUE INDEX' THEN 'UNI' ELSE '' END KEY, IFNULL(COLUMN_DEFAULT, 'NULL') DEFAULT FROM INFORMATION_SCHEMA.COLUMNS C WHERE C.TABLE_NAME=? AND C.TABLE_SCHEMA=? ORDER BY C.ORDINAL_POSITION");
            paramValues.add(ValueString.get(schemaName));
        } else if (this.readIf("DATABASES") || this.readIf("SCHEMAS")) {
            buff.append("SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA");
        }
        boolean b = this.session.getAllowLiterals();
        try {
            this.session.setAllowLiterals(true);
            Prepared prepared = Parser.prepare(this.session, buff.toString(), paramValues);
            return prepared;
        }
        finally {
            this.session.setAllowLiterals(b);
        }
    }

    private static Prepared prepare(Session s, String sql, ArrayList<Value> paramValues) {
        Prepared prep = s.prepare(sql);
        ArrayList<Parameter> params = prep.getParameters();
        if (params != null) {
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                Parameter p = params.get(i);
                p.setValue(paramValues.get(i));
            }
        }
        return prep;
    }

    private boolean isSelect() {
        boolean select;
        int start = this.lastParseIndex;
        while (this.readIf(69)) {
        }
        switch (this.currentTokenType) {
            case 20: 
            case 47: 
            case 52: 
            case 55: {
                select = true;
                break;
            }
            case 48: {
                this.read();
                select = !this.readIf(69);
                break;
            }
            default: {
                select = false;
            }
        }
        this.parseIndex = start;
        this.read();
        return select;
    }

    private Prepared parseMerge() {
        int start = this.lastParseIndex;
        this.read("INTO");
        List<String> excludeIdentifiers = Arrays.asList("USING", "KEY");
        TableFilter targetTableFilter = this.readSimpleTableFilter(0, excludeIdentifiers);
        if (this.readIf("USING")) {
            return this.parseMergeUsing(targetTableFilter, start);
        }
        Merge command = new Merge(this.session);
        this.currentPrepared = command;
        command.setTargetTableFilter(targetTableFilter);
        Table table = command.getTargetTable();
        if (this.readIf(69)) {
            if (this.isSelect()) {
                command.setQuery(this.parseSelect());
                this.read(70);
                return command;
            }
            Column[] columns = this.parseColumnList(table);
            command.setColumns(columns);
        }
        if (this.readIf("KEY")) {
            this.read(69);
            Column[] keys = this.parseColumnList(table);
            command.setKeys(keys);
        }
        if (this.readIf(52)) {
            this.parseValuesForCommand(command);
        } else {
            command.setQuery(this.parseSelect());
        }
        return command;
    }

    private MergeUsing parseMergeUsing(TableFilter targetTableFilter, int start) {
        MergeUsing command = new MergeUsing(this.session, targetTableFilter);
        this.currentPrepared = command;
        if (this.readIf(69)) {
            String queryAlias;
            if (this.isSelect()) {
                command.setQuery(this.parseSelect());
                this.read(70);
            }
            if ((queryAlias = this.readFromAlias(null, null)) == null) {
                queryAlias = "QUERY_ALIAS_" + this.parseIndex;
            }
            command.setQueryAlias(queryAlias);
            String[] querySQLOutput = new String[]{null};
            List<Column> columnTemplateList = TableView.createQueryColumnTemplateList(null, command.getQuery(), querySQLOutput);
            TableView temporarySourceTableView = this.createCTEView(queryAlias, querySQLOutput[0], columnTemplateList, false, false, true);
            TableFilter sourceTableFilter = new TableFilter(this.session, temporarySourceTableView, queryAlias, this.rightsChecked, (Select)command.getQuery(), 0, null);
            command.setSourceTableFilter(sourceTableFilter);
        } else {
            TableFilter sourceTableFilter = this.readSimpleTableFilter(0, null);
            command.setSourceTableFilter(sourceTableFilter);
            Select preparedQuery = new Select(this.session, null);
            preparedQuery.setWildcard();
            TableFilter filter = new TableFilter(this.session, sourceTableFilter.getTable(), sourceTableFilter.getTableAlias(), this.rightsChecked, preparedQuery, 0, null);
            preparedQuery.addTableFilter(filter, true);
            preparedQuery.init();
            command.setQuery(preparedQuery);
        }
        this.read(40);
        Expression condition = this.readExpression();
        command.setOnCondition(condition);
        this.read("WHEN");
        do {
            boolean matched;
            if (matched = this.readIf("MATCHED")) {
                this.parseWhenMatched(command);
                continue;
            }
            this.parseWhenNotMatched(command);
        } while (this.readIf("WHEN"));
        this.setSQL(command, "MERGE", start);
        return command;
    }

    private void parseWhenMatched(MergeUsing command) {
        Expression and = this.readIf("AND") ? this.readExpression() : null;
        this.read("THEN");
        int startMatched = this.lastParseIndex;
        Update updateCommand = null;
        if (this.readIf("UPDATE")) {
            updateCommand = new Update(this.session);
            TableFilter filter = command.getTargetTableFilter();
            updateCommand.setTableFilter(filter);
            this.parseUpdateSetClause(updateCommand, filter, startMatched, false);
            startMatched = this.lastParseIndex;
        }
        Delete deleteCommand = null;
        if (this.readIf("DELETE")) {
            deleteCommand = new Delete(this.session);
            deleteCommand.setTableFilter(command.getTargetTableFilter());
            if (this.readIf(53)) {
                deleteCommand.setCondition(this.readExpression());
            }
            this.setSQL(deleteCommand, "DELETE", startMatched);
        }
        if (updateCommand == null && deleteCommand == null) {
            throw this.getSyntaxError();
        }
        MergeUsing.WhenMatched when = new MergeUsing.WhenMatched(command);
        when.setAndCondition(and);
        when.setUpdateCommand(updateCommand);
        when.setDeleteCommand(deleteCommand);
        command.addWhen(when);
    }

    private void parseWhenNotMatched(MergeUsing command) {
        this.read(37);
        this.read("MATCHED");
        Expression and = this.readIf("AND") ? this.readExpression() : null;
        this.read("THEN");
        if (!this.readIf("INSERT")) {
            throw this.getSyntaxError();
        }
        Insert insertCommand = new Insert(this.session);
        insertCommand.setTable(command.getTargetTable());
        this.parseInsertGivenTable(insertCommand, command.getTargetTable());
        MergeUsing.WhenNotMatched when = new MergeUsing.WhenNotMatched(command);
        when.setAndCondition(and);
        when.setInsertCommand(insertCommand);
        command.addWhen(when);
    }

    private Insert parseInsert() {
        Insert command = new Insert(this.session);
        this.currentPrepared = command;
        if (this.database.getMode().onDuplicateKeyUpdate && this.readIf("IGNORE")) {
            command.setIgnore(true);
        }
        this.read("INTO");
        Table table = this.readTableOrView();
        command.setTable(table);
        Insert returnedCommand = this.parseInsertGivenTable(command, table);
        if (returnedCommand != null) {
            return returnedCommand;
        }
        if (this.database.getMode().onDuplicateKeyUpdate && this.readIf(40)) {
            this.read("DUPLICATE");
            this.read("KEY");
            this.read("UPDATE");
            do {
                String columnName = this.readColumnIdentifier();
                if (this.readIf(74)) {
                    String schemaOrTableName = columnName;
                    String tableOrColumnName = this.readColumnIdentifier();
                    if (this.readIf(74)) {
                        if (!table.getSchema().getName().equals(schemaOrTableName)) {
                            throw DbException.get(90080);
                        }
                        columnName = this.readColumnIdentifier();
                    } else {
                        columnName = tableOrColumnName;
                        tableOrColumnName = schemaOrTableName;
                    }
                    if (!table.getName().equals(tableOrColumnName)) {
                        throw DbException.get(42102, tableOrColumnName);
                    }
                }
                Column column = table.getColumn(columnName);
                this.read(59);
                command.addAssignmentForDuplicate(column, this.readExpressionOrDefault());
            } while (this.readIf(73));
        }
        if (this.database.getMode().isolationLevelInSelectOrInsertStatement) {
            this.parseIsolationClause();
        }
        return command;
    }

    private Insert parseInsertGivenTable(Insert command, Table table) {
        Column[] columns = null;
        if (this.readIf(69)) {
            if (this.isSelect()) {
                command.setQuery(this.parseSelect());
                this.read(70);
                return command;
            }
            columns = this.parseColumnList(table);
            command.setColumns(columns);
        }
        if (this.readIf("DIRECT")) {
            command.setInsertFromSelect(true);
        }
        if (this.readIf("SORTED")) {
            command.setSortedInsertMode(true);
        }
        if (this.readIf("DEFAULT")) {
            this.read(52);
            command.addRow(new Expression[0]);
        } else if (this.readIf(52)) {
            this.parseValuesForCommand(command);
        } else if (this.readIf("SET")) {
            if (columns != null) {
                throw this.getSyntaxError();
            }
            ArrayList<Column> columnList = Utils.newSmallArrayList();
            ArrayList<Expression> values = Utils.newSmallArrayList();
            do {
                columnList.add(this.parseColumn(table));
                this.read(59);
                values.add(this.readExpressionOrDefault());
            } while (this.readIf(73));
            command.setColumns(columnList.toArray(new Column[0]));
            command.addRow(values.toArray(new Expression[0]));
        } else {
            command.setQuery(this.parseSelect());
        }
        return null;
    }

    private Replace parseReplace() {
        Replace command = new Replace(this.session);
        this.currentPrepared = command;
        this.read("INTO");
        Table table = this.readTableOrView();
        command.setTable(table);
        if (this.readIf(69)) {
            if (this.isSelect()) {
                command.setQuery(this.parseSelect());
                this.read(70);
                return command;
            }
            Column[] columns = this.parseColumnList(table);
            command.setColumns(columns);
        }
        if (this.readIf(52)) {
            this.parseValuesForCommand(command);
        } else {
            command.setQuery(this.parseSelect());
        }
        return command;
    }

    private void parseValuesForCommand(CommandWithValues command) {
        ArrayList<Expression> values = Utils.newSmallArrayList();
        do {
            boolean multiColumn;
            values.clear();
            if (this.readIf(44)) {
                this.read(69);
                multiColumn = true;
            } else {
                multiColumn = this.readIf(69);
            }
            if (multiColumn) {
                if (!this.readIf(70)) {
                    do {
                        values.add(this.readIf("DEFAULT") ? null : this.readExpression());
                    } while (this.readIfMore(false));
                }
            } else {
                values.add(this.readIf("DEFAULT") ? null : this.readExpression());
            }
            command.addRow(values.toArray(new Expression[0]));
        } while (this.readIf(73));
    }

    /*
     * Enabled aggressive block sorting
     */
    private TableFilter readTableFilter() {
        Table table;
        String alias;
        block20: {
            String tableName;
            block26: {
                Schema schema;
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                alias = null;
                                if (this.readIf(69)) {
                                    if (this.isSelect()) {
                                        Query query = this.parseSelectUnion();
                                        this.read(70);
                                        query.setParameterList(new ArrayList<Parameter>(this.parameters));
                                        query.init();
                                        Session s = this.createView != null ? this.database.getSystemSession() : this.session;
                                        alias = this.session.getNextSystemIdentifier(this.sqlCommand);
                                        table = TableView.createTempView(s, this.session.getUser(), alias, query, this.currentSelect);
                                        break block20;
                                    } else {
                                        TableFilter top = this.readTableFilter();
                                        top = this.readJoin(top);
                                        this.read(70);
                                        alias = this.readFromAlias(null);
                                        if (alias != null) {
                                            top.setAlias(alias);
                                            ArrayList<String> derivedColumnNames = this.readDerivedColumnNames();
                                            if (derivedColumnNames != null) {
                                                top.setDerivedColumns(derivedColumnNames);
                                            }
                                        }
                                        return top;
                                    }
                                }
                                if (!this.readIf(52)) break block22;
                                table = this.parseValuesTable(0).getTable();
                                break block20;
                            }
                            if (!this.readIf(48)) break block23;
                            this.read(69);
                            table = this.readTableFunction("TABLE", null, this.database.getMainSchema());
                            break block20;
                        }
                        tableName = this.readIdentifierWithSchema(null);
                        if (this.schemaName != null) break block24;
                        schema = null;
                        break block25;
                    }
                    schema = this.findSchema(this.schemaName);
                    if (schema != null) break block25;
                    if (!this.isDualTable(tableName)) {
                        throw DbException.get(90079, this.schemaName);
                    }
                    table = this.getDualTable(false);
                    break block20;
                }
                boolean foundLeftBracket = this.readIf(69);
                if (foundLeftBracket && this.readIf("INDEX")) {
                    this.readIdentifierWithSchema(null);
                    this.read(70);
                    foundLeftBracket = false;
                }
                if (!foundLeftBracket) break block26;
                Schema mainSchema = this.database.getMainSchema();
                if (this.equalsToken(tableName, "SYSTEM_RANGE") || this.equalsToken(tableName, "GENERATE_SERIES")) {
                    Expression min = this.readExpression();
                    this.read(73);
                    Expression max = this.readExpression();
                    if (this.readIf(73)) {
                        Expression step = this.readExpression();
                        this.read(70);
                        table = new RangeTable(mainSchema, min, max, step, false);
                        break block20;
                    } else {
                        this.read(70);
                        table = new RangeTable(mainSchema, min, max, false);
                    }
                    break block20;
                } else {
                    table = this.readTableFunction(tableName, schema, mainSchema);
                }
                break block20;
            }
            table = this.readTableOrView(tableName);
        }
        ArrayList<String> derivedColumnNames = null;
        IndexHints indexHints = null;
        if (this.readIf("USE")) {
            if (this.readIf("INDEX")) {
                indexHints = this.parseIndexHints(table);
            } else {
                alias = "USE";
                derivedColumnNames = this.readDerivedColumnNames();
            }
        } else if ((alias = this.readFromAlias(alias)) != null) {
            derivedColumnNames = this.readDerivedColumnNames();
            if (this.readIf("USE")) {
                this.read("INDEX");
                indexHints = this.parseIndexHints(table);
            }
        }
        if (this.database.getMode().discardWithTableHints) {
            this.discardWithTableHints();
        }
        if (table.isView() && table.isTableExpression() && alias == null) {
            alias = table.getName();
        }
        TableFilter filter = new TableFilter(this.session, table, alias, this.rightsChecked, this.currentSelect, this.orderInFrom++, indexHints);
        if (derivedColumnNames != null) {
            filter.setDerivedColumns(derivedColumnNames);
        }
        return filter;
    }

    private Table readTableFunction(String tableName, Schema schema, Schema mainSchema) {
        Expression expr = this.readFunction(schema, tableName);
        if (!(expr instanceof FunctionCall)) {
            throw this.getSyntaxError();
        }
        FunctionCall call = (FunctionCall)((Object)expr);
        if (!call.isDeterministic()) {
            this.recompileAlways = true;
        }
        return new FunctionTable(mainSchema, this.session, expr, call);
    }

    private IndexHints parseIndexHints(Table table) {
        this.read(69);
        LinkedHashSet<String> indexNames = new LinkedHashSet<String>();
        if (!this.readIf(70)) {
            do {
                String indexName;
                if ("HASH_JOIN_IDX".equalsIgnoreCase(indexName = this.readIdentifierWithSchema())) {
                    indexNames.add("HASH_JOIN_IDX");
                    continue;
                }
                Index index = table.getIndex(indexName);
                indexNames.add(index.getName());
            } while (this.readIfMore(true));
        }
        return IndexHints.createUseIndexHints(indexNames);
    }

    private String readFromAlias(String alias, List<String> excludeIdentifiers) {
        if (this.readIf("AS")) {
            alias = this.readAliasIdentifier();
        } else if (!(this.currentTokenType != 2 || excludeIdentifiers != null && this.isTokenInList(excludeIdentifiers))) {
            alias = this.readAliasIdentifier();
        }
        return alias;
    }

    private String readFromAlias(String alias) {
        List<String> excludeIdentifiers = Arrays.asList("LEFT", "RIGHT");
        return this.readFromAlias(alias, excludeIdentifiers);
    }

    private ArrayList<String> readDerivedColumnNames() {
        if (this.readIf(69)) {
            ArrayList<String> derivedColumnNames = new ArrayList<String>();
            do {
                derivedColumnNames.add(this.readAliasIdentifier());
            } while (this.readIfMore(true));
            return derivedColumnNames;
        }
        return null;
    }

    private void discardWithTableHints() {
        if (this.readIf(55)) {
            this.read(69);
            do {
                this.discardTableHint();
            } while (this.readIfMore(true));
        }
    }

    private void discardTableHint() {
        if (this.readIf("INDEX")) {
            if (this.readIf(69)) {
                do {
                    this.readExpression();
                } while (this.readIfMore(true));
            } else {
                this.read(59);
                this.readExpression();
            }
        } else {
            this.readExpression();
        }
    }

    private Prepared parseTruncate() {
        boolean restart;
        this.read(48);
        Table table = this.readTableOrView();
        if (this.readIf("CONTINUE")) {
            this.read("IDENTITY");
            restart = false;
        } else if (this.readIf("RESTART")) {
            this.read("IDENTITY");
            restart = true;
        } else {
            restart = false;
        }
        TruncateTable command = new TruncateTable(this.session);
        command.setTable(table);
        command.setRestart(restart);
        return command;
    }

    private boolean readIfExists(boolean ifExists) {
        if (this.readIf(24)) {
            this.read(15);
            ifExists = true;
        }
        return ifExists;
    }

    private Prepared parseComment() {
        String objectName;
        int type = 0;
        this.read(40);
        boolean column = false;
        if (this.readIf(48) || this.readIf("VIEW")) {
            type = 0;
        } else if (this.readIf("COLUMN")) {
            column = true;
            type = 0;
        } else if (this.readIf("CONSTANT")) {
            type = 11;
        } else if (this.readIf(7)) {
            type = 5;
        } else if (this.readIf("ALIAS")) {
            type = 9;
        } else if (this.readIf("INDEX")) {
            type = 1;
        } else if (this.readIf("ROLE")) {
            type = 7;
        } else if (this.readIf("SCHEMA")) {
            type = 10;
        } else if (this.readIf("SEQUENCE")) {
            type = 3;
        } else if (this.readIf("TRIGGER")) {
            type = 4;
        } else if (this.readIf("USER")) {
            type = 2;
        } else if (this.readIf("DOMAIN")) {
            type = 12;
        } else {
            throw this.getSyntaxError();
        }
        SetComment command = new SetComment(this.session);
        if (column) {
            ArrayList list = Utils.newSmallArrayList();
            do {
                list.add(this.readUniqueIdentifier());
            } while (this.readIf(74));
            this.schemaName = this.session.getCurrentSchemaName();
            if (list.size() == 4 && !this.equalsToken(this.database.getShortName(), (String)list.remove(0))) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "database name");
            }
            if (list.size() == 3) {
                this.schemaName = (String)list.remove(0);
            }
            if (list.size() != 2) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "table.column");
            }
            objectName = (String)list.get(0);
            command.setColumn(true);
            command.setColumnName((String)list.get(1));
        } else {
            objectName = this.readIdentifierWithSchema();
        }
        command.setSchemaName(this.schemaName);
        command.setObjectName(objectName);
        command.setObjectType(type);
        this.read(29);
        command.setCommentExpression(this.readExpression());
        return command;
    }

    private Prepared parseDrop() {
        if (this.readIf(48)) {
            boolean ifExists = this.readIfExists(false);
            String tableName = this.readIdentifierWithSchema();
            DropTable command = new DropTable(this.session, this.getSchema());
            command.setTableName(tableName);
            while (this.readIf(73)) {
                tableName = this.readIdentifierWithSchema();
                DropTable next = new DropTable(this.session, this.getSchema());
                next.setTableName(tableName);
                command.addNextDropTable(next);
            }
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            if (this.readIf("CASCADE")) {
                command.setDropAction(ConstraintActionType.CASCADE);
                this.readIf("CONSTRAINTS");
            } else if (this.readIf("RESTRICT")) {
                command.setDropAction(ConstraintActionType.RESTRICT);
            } else if (this.readIf("IGNORE")) {
                command.setDropAction(ConstraintActionType.SET_DEFAULT);
            }
            return command;
        }
        if (this.readIf("INDEX")) {
            boolean ifExists = this.readIfExists(false);
            String indexName = this.readIdentifierWithSchema();
            DropIndex command = new DropIndex(this.session, this.getSchema());
            command.setIndexName(indexName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            if (this.readIf(40)) {
                this.readIdentifierWithSchema();
            }
            return command;
        }
        if (this.readIf("USER")) {
            boolean ifExists = this.readIfExists(false);
            DropUser command = new DropUser(this.session);
            command.setUserName(this.readUniqueIdentifier());
            ifExists = this.readIfExists(ifExists);
            this.readIf("CASCADE");
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("SEQUENCE")) {
            boolean ifExists = this.readIfExists(false);
            String sequenceName = this.readIdentifierWithSchema();
            DropSequence command = new DropSequence(this.session, this.getSchema());
            command.setSequenceName(sequenceName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("CONSTANT")) {
            boolean ifExists = this.readIfExists(false);
            String constantName = this.readIdentifierWithSchema();
            DropConstant command = new DropConstant(this.session, this.getSchema());
            command.setConstantName(constantName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("TRIGGER")) {
            boolean ifExists = this.readIfExists(false);
            String triggerName = this.readIdentifierWithSchema();
            DropTrigger command = new DropTrigger(this.session, this.getSchema());
            command.setTriggerName(triggerName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("VIEW")) {
            boolean ifExists = this.readIfExists(false);
            String viewName = this.readIdentifierWithSchema();
            DropView command = new DropView(this.session, this.getSchema());
            command.setViewName(viewName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            ConstraintActionType dropAction = this.parseCascadeOrRestrict();
            if (dropAction != null) {
                command.setDropAction(dropAction);
            }
            return command;
        }
        if (this.readIf("ROLE")) {
            boolean ifExists = this.readIfExists(false);
            DropRole command = new DropRole(this.session);
            command.setRoleName(this.readUniqueIdentifier());
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("ALIAS")) {
            boolean ifExists = this.readIfExists(false);
            String aliasName = this.readIdentifierWithSchema();
            DropFunctionAlias command = new DropFunctionAlias(this.session, this.getSchema());
            command.setAliasName(aliasName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("SCHEMA")) {
            boolean ifExists = this.readIfExists(false);
            DropSchema command = new DropSchema(this.session);
            command.setSchemaName(this.readUniqueIdentifier());
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            ConstraintActionType dropAction = this.parseCascadeOrRestrict();
            if (dropAction != null) {
                command.setDropAction(dropAction);
            }
            return command;
        }
        if (this.readIf(3)) {
            this.read("OBJECTS");
            DropDatabase command = new DropDatabase(this.session);
            command.setDropAllObjects(true);
            if (this.readIf("DELETE")) {
                this.read("FILES");
                command.setDeleteFiles(true);
            }
            return command;
        }
        if (this.readIf("DOMAIN") || this.readIf("TYPE") || this.readIf("DATATYPE")) {
            return this.parseDropDomain();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseDropAggregate();
        }
        if (this.readIf("SYNONYM")) {
            boolean ifExists = this.readIfExists(false);
            String synonymName = this.readIdentifierWithSchema();
            DropSynonym command = new DropSynonym(this.session, this.getSchema());
            command.setSynonymName(synonymName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        throw this.getSyntaxError();
    }

    private DropDomain parseDropDomain() {
        boolean ifExists = this.readIfExists(false);
        DropDomain command = new DropDomain(this.session);
        command.setTypeName(this.readUniqueIdentifier());
        ifExists = this.readIfExists(ifExists);
        command.setIfExists(ifExists);
        ConstraintActionType dropAction = this.parseCascadeOrRestrict();
        if (dropAction != null) {
            command.setDropAction(dropAction);
        }
        return command;
    }

    private DropAggregate parseDropAggregate() {
        boolean ifExists = this.readIfExists(false);
        DropAggregate command = new DropAggregate(this.session);
        command.setName(this.readUniqueIdentifier());
        ifExists = this.readIfExists(ifExists);
        command.setIfExists(ifExists);
        return command;
    }

    private TableFilter readJoin(TableFilter top) {
        TableFilter last = top;
        while (true) {
            Expression on;
            TableFilter join;
            if (this.readIf("RIGHT")) {
                this.readIf("OUTER");
                this.read(30);
                join = this.readTableFilter();
                join = this.readJoin(join);
                on = null;
                if (this.readIf(40)) {
                    on = this.readExpression();
                }
                this.addJoin(join, top, true, on);
                top = join;
            } else if (this.readIf("LEFT")) {
                this.readIf("OUTER");
                this.read(30);
                join = this.readTableFilter();
                join = this.readJoin(join);
                on = null;
                if (this.readIf(40)) {
                    on = this.readExpression();
                }
                this.addJoin(top, join, true, on);
            } else {
                if (this.readIf(21)) {
                    throw this.getSyntaxError();
                }
                if (this.readIf(25)) {
                    this.read(30);
                    join = this.readTableFilter();
                    top = this.readJoin(top);
                    on = null;
                    if (this.readIf(40)) {
                        on = this.readExpression();
                    }
                    this.addJoin(top, join, false, on);
                } else if (this.readIf(30)) {
                    join = this.readTableFilter();
                    top = this.readJoin(top);
                    on = null;
                    if (this.readIf(40)) {
                        on = this.readExpression();
                    }
                    this.addJoin(top, join, false, on);
                } else if (this.readIf(8)) {
                    this.read(30);
                    join = this.readTableFilter();
                    this.addJoin(top, join, false, null);
                } else {
                    if (!this.readIf(36)) break;
                    this.read(30);
                    join = this.readTableFilter();
                    Column[] tableCols = last.getTable().getColumns();
                    Column[] joinCols = join.getTable().getColumns();
                    String tableSchema = last.getTable().getSchema().getName();
                    String joinSchema = join.getTable().getSchema().getName();
                    Condition on2 = null;
                    for (Column tc : tableCols) {
                        String tableColumnName = tc.getName();
                        for (Column c : joinCols) {
                            String joinColumnName = c.getName();
                            if (!this.equalsToken(tableColumnName, joinColumnName)) continue;
                            join.addNaturalJoinColumn(c);
                            ExpressionColumn tableExpr = new ExpressionColumn(this.database, tableSchema, last.getTableAlias(), tableColumnName, false);
                            ExpressionColumn joinExpr = new ExpressionColumn(this.database, joinSchema, join.getTableAlias(), joinColumnName, false);
                            Comparison equal = new Comparison(this.session, 0, tableExpr, joinExpr);
                            on2 = on2 == null ? equal : new ConditionAndOr(0, on2, equal);
                        }
                    }
                    this.addJoin(top, join, false, on2);
                }
            }
            last = join;
        }
        return top;
    }

    private void addJoin(TableFilter top, TableFilter join, boolean outer, Expression on) {
        if (join.getJoin() != null) {
            String joinTable = "SYSTEM_JOIN_" + this.parseIndex;
            TableFilter n = new TableFilter(this.session, this.getDualTable(true), joinTable, this.rightsChecked, this.currentSelect, join.getOrderInFrom(), null);
            n.setNestedJoin(join);
            join = n;
        }
        top.addJoin(join, outer, on);
    }

    private Prepared parseExecute() {
        ExecuteProcedure command = new ExecuteProcedure(this.session);
        String procedureName = this.readAliasIdentifier();
        Procedure p = this.session.getProcedure(procedureName);
        if (p == null) {
            throw DbException.get(90077, procedureName);
        }
        command.setProcedure(p);
        if (this.readIf(69)) {
            int i = 0;
            while (true) {
                command.setExpression(i, this.readExpression());
                if (!this.readIfMore(true)) break;
                ++i;
            }
        }
        return command;
    }

    private DeallocateProcedure parseDeallocate() {
        this.readIf("PLAN");
        String procedureName = this.readAliasIdentifier();
        DeallocateProcedure command = new DeallocateProcedure(this.session);
        command.setProcedureName(procedureName);
        return command;
    }

    private Explain parseExplain() {
        Explain command = new Explain(this.session);
        if (this.readIf("ANALYZE")) {
            command.setExecuteCommand(true);
        } else if (this.readIf("PLAN")) {
            this.readIf(18);
        }
        switch (this.currentTokenType) {
            case 20: 
            case 47: 
            case 48: 
            case 52: 
            case 55: 
            case 69: {
                Query query = this.parseSelect();
                query.setNeverLazy(true);
                command.setCommand(query);
                break;
            }
            default: {
                if (this.readIf("DELETE")) {
                    command.setCommand(this.parseDelete());
                    break;
                }
                if (this.readIf("UPDATE")) {
                    command.setCommand(this.parseUpdate());
                    break;
                }
                if (this.readIf("INSERT")) {
                    command.setCommand(this.parseInsert());
                    break;
                }
                if (this.readIf("MERGE")) {
                    command.setCommand(this.parseMerge());
                    break;
                }
                throw this.getSyntaxError();
            }
        }
        return command;
    }

    private Query parseSelect() {
        int paramIndex = this.parameters.size();
        Query command = this.parseSelectUnion();
        int size = this.parameters.size();
        ArrayList<Parameter> params = new ArrayList<Parameter>(size);
        for (int i = paramIndex; i < size; ++i) {
            params.add(this.parameters.get(i));
        }
        command.setParameterList(params);
        command.init();
        return command;
    }

    private Prepared parseWithStatementOrQuery() {
        int paramIndex = this.parameters.size();
        Prepared command = this.parseWith();
        int size = this.parameters.size();
        ArrayList<Parameter> params = new ArrayList<Parameter>(size);
        for (int i = paramIndex; i < size; ++i) {
            params.add(this.parameters.get(i));
        }
        command.setParameterList(params);
        if (command instanceof Query) {
            Query query = (Query)command;
            query.init();
        }
        return command;
    }

    private Query parseSelectUnion() {
        int start = this.lastParseIndex;
        Query command = this.parseSelectSub();
        while (true) {
            SelectUnion.UnionType type;
            if (this.readIf(50)) {
                if (this.readIf(3)) {
                    type = SelectUnion.UnionType.UNION_ALL;
                } else {
                    this.readIf(13);
                    type = SelectUnion.UnionType.UNION;
                }
            } else if (this.readIf(14) || this.readIf(35)) {
                type = SelectUnion.UnionType.EXCEPT;
            } else {
                if (!this.readIf(26)) break;
                type = SelectUnion.UnionType.INTERSECT;
            }
            command = new SelectUnion(this.session, type, command, this.parseSelectSub());
        }
        this.parseEndOfQuery(command);
        this.setSQL(command, null, start);
        return command;
    }

    private void parseEndOfQuery(Query command) {
        if (this.readIf(41)) {
            this.read("BY");
            Select oldSelect = this.currentSelect;
            if (command instanceof Select) {
                this.currentSelect = (Select)command;
            }
            ArrayList<SelectOrderBy> orderList = Utils.newSmallArrayList();
            do {
                boolean canBeNumber = !this.readIf(59);
                SelectOrderBy order = new SelectOrderBy();
                Expression expr = this.readExpression();
                if (canBeNumber && expr instanceof ValueExpression && expr.getType().getValueType() == 4) {
                    order.columnIndexExpr = expr;
                } else if (expr instanceof Parameter) {
                    this.recompileAlways = true;
                    order.columnIndexExpr = expr;
                } else {
                    order.expression = expr;
                }
                order.sortType = this.parseSortType();
                orderList.add(order);
            } while (this.readIf(73));
            command.setOrder(orderList);
            this.currentSelect = oldSelect;
        }
        if (command.getLimit() == null) {
            Select temp = this.currentSelect;
            this.currentSelect = null;
            boolean hasOffsetOrFetch = false;
            if (this.readIf(39)) {
                hasOffsetOrFetch = true;
                command.setOffset(this.readExpression().optimize(this.session));
                if (!this.readIf(44)) {
                    this.readIf("ROWS");
                }
            }
            if (this.readIf(17)) {
                hasOffsetOrFetch = true;
                if (!this.readIf("FIRST")) {
                    this.read("NEXT");
                }
                if (this.readIf(44) || this.readIf("ROWS")) {
                    command.setLimit(ValueExpression.get(ValueInt.get(1)));
                } else {
                    Expression limit = this.readExpression().optimize(this.session);
                    command.setLimit(limit);
                    if (this.readIf("PERCENT")) {
                        command.setFetchPercent(true);
                    }
                    if (!this.readIf(44)) {
                        this.read("ROWS");
                    }
                }
                if (this.readIf(55)) {
                    this.read("TIES");
                    command.setWithTies(true);
                } else {
                    this.read("ONLY");
                }
            }
            if (!hasOffsetOrFetch && this.readIf(32)) {
                Expression offset;
                Expression limit = this.readExpression().optimize(this.session);
                command.setLimit(limit);
                if (this.readIf(39)) {
                    offset = this.readExpression().optimize(this.session);
                    command.setOffset(offset);
                } else if (this.readIf(73)) {
                    offset = limit;
                    limit = this.readExpression().optimize(this.session);
                    command.setOffset(offset);
                    command.setLimit(limit);
                }
            }
            if (this.readIf("SAMPLE_SIZE")) {
                Expression sampleSize = this.readExpression().optimize(this.session);
                command.setSampleSize(sampleSize);
            }
            this.currentSelect = temp;
        }
        if (this.readIf(18)) {
            if (this.readIf("UPDATE")) {
                if (this.readIf("OF")) {
                    do {
                        this.readIdentifierWithSchema();
                    } while (this.readIf(73));
                } else if (this.readIf("NOWAIT")) {
                    // empty if block
                }
                command.setForUpdate(true);
            } else if (this.readIf("READ") || this.readIf(17)) {
                this.read("ONLY");
            }
        }
        if (this.database.getMode().isolationLevelInSelectOrInsertStatement) {
            this.parseIsolationClause();
        }
    }

    private void parseIsolationClause() {
        if (this.readIf(55)) {
            if (this.readIf("RR") || this.readIf("RS")) {
                if (this.readIf("USE")) {
                    this.read("AND");
                    this.read("KEEP");
                    if (this.readIf("SHARE") || this.readIf("UPDATE") || this.readIf("EXCLUSIVE")) {
                        // empty if block
                    }
                    this.read("LOCKS");
                }
            } else if (this.readIf("CS") || this.readIf("UR")) {
                // empty if block
            }
        }
    }

    private Query parseSelectSub() {
        if (this.readIf(69)) {
            Query command = this.parseSelectUnion();
            this.read(70);
            return command;
        }
        if (this.readIf(55)) {
            Query query;
            try {
                query = (Query)this.parseWith();
            }
            catch (ClassCastException e) {
                throw DbException.get(42000, "WITH statement supports only SELECT (query) in this context");
            }
            query.setNeverLazy(true);
            return query;
        }
        return this.parseSelectSimple();
    }

    private void parseSelectSimpleFromPart(Select command) {
        do {
            TableFilter filter = this.readTableFilter();
            this.parseJoinTableFilter(filter, command);
        } while (this.readIf(73));
        if (this.session.isForceJoinOrder()) {
            Collections.sort(command.getTopFilters(), TABLE_FILTER_COMPARATOR);
        }
    }

    private void parseJoinTableFilter(TableFilter top, final Select command) {
        top = this.readJoin(top);
        command.addTableFilter(top, true);
        boolean isOuter = false;
        while (true) {
            TableFilter join;
            TableFilter n;
            if ((n = top.getNestedJoin()) != null) {
                n.visit(new TableFilter.TableFilterVisitor(){

                    @Override
                    public void accept(TableFilter f) {
                        command.addTableFilter(f, false);
                    }
                });
            }
            if ((join = top.getJoin()) == null) break;
            if (isOuter |= join.isJoinOuter()) {
                command.addTableFilter(join, false);
            } else {
                Expression on = join.getJoinCondition();
                if (on != null) {
                    command.addCondition(on);
                }
                join.removeJoinCondition();
                top.removeJoin();
                command.addTableFilter(join, true);
            }
            top = join;
        }
    }

    private void parseSelectSimpleSelectPart(Select command) {
        Select temp = this.currentSelect;
        this.currentSelect = null;
        if (this.readIf("TOP")) {
            Expression limit = this.readTerm().optimize(this.session);
            command.setLimit(limit);
            if (this.readIf("PERCENT")) {
                command.setFetchPercent(true);
            }
            if (this.readIf(55)) {
                this.read("TIES");
                command.setWithTies(true);
            }
        } else if (this.readIf(32)) {
            Expression offset = this.readTerm().optimize(this.session);
            command.setOffset(offset);
            Expression limit = this.readTerm().optimize(this.session);
            command.setLimit(limit);
        }
        this.currentSelect = temp;
        if (this.readIf(13)) {
            if (this.readIf(40)) {
                this.read(69);
                ArrayList<Expression> distinctExpressions = Utils.newSmallArrayList();
                do {
                    distinctExpressions.add(this.readExpression());
                } while (this.readIfMore(true));
                command.setDistinct(distinctExpressions.toArray(new Expression[0]));
            } else {
                command.setDistinct();
            }
        } else {
            this.readIf(3);
        }
        ArrayList<Expression> expressions = Utils.newSmallArrayList();
        do {
            if (this.readIf(72)) {
                expressions.add(this.parseWildcard(null, null));
                continue;
            }
            Expression expr = this.readExpression();
            if (this.readIf("AS") || this.currentTokenType == 2) {
                String alias = this.readAliasIdentifier();
                boolean aliasColumnName = this.database.getSettings().aliasColumnName;
                expr = new Alias(expr, alias, aliasColumnName |= this.database.getMode().aliasColumnName);
            }
            expressions.add(expr);
        } while (this.readIf(73));
        command.setExpressions(expressions);
    }

    private Select parseSelectSimple() {
        Expression condition;
        boolean fromFirst;
        if (this.readIf(47)) {
            fromFirst = false;
        } else if (this.readIf(20)) {
            fromFirst = true;
        } else {
            if (this.readIf(48)) {
                int start = this.lastParseIndex;
                Table table = this.readTableOrView();
                Select command = new Select(this.session, this.currentSelect);
                TableFilter filter = new TableFilter(this.session, table, null, this.rightsChecked, command, this.orderInFrom++, null);
                command.addTableFilter(filter, true);
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                expressions.add(new Wildcard(null, null));
                command.setExpressions(expressions);
                this.setSQL(command, "TABLE", start);
                return command;
            }
            if (this.readIf(52)) {
                return this.parseValues();
            }
            throw this.getSyntaxError();
        }
        Select command = new Select(this.session, this.currentSelect);
        int start = this.lastParseIndex;
        Select oldSelect = this.currentSelect;
        Prepared oldPrepared = this.currentPrepared;
        this.currentSelect = command;
        this.currentPrepared = command;
        if (fromFirst) {
            this.parseSelectSimpleFromPart(command);
            this.read(47);
            this.parseSelectSimpleSelectPart(command);
        } else {
            this.parseSelectSimpleSelectPart(command);
            if (!this.readIf(20)) {
                Table dual = this.getDualTable(false);
                TableFilter filter = new TableFilter(this.session, dual, null, this.rightsChecked, this.currentSelect, 0, null);
                command.addTableFilter(filter, true);
            } else {
                this.parseSelectSimpleFromPart(command);
            }
        }
        if (this.readIf(53)) {
            condition = this.readExpression();
            command.addCondition(condition);
        }
        this.currentSelect = oldSelect;
        if (this.readIf(22)) {
            this.read("BY");
            command.setGroupQuery();
            ArrayList<Expression> list = Utils.newSmallArrayList();
            do {
                Expression expr = this.readExpression();
                list.add(expr);
            } while (this.readIf(73));
            command.setGroupBy(list);
        }
        this.currentSelect = command;
        if (this.readIf(23)) {
            command.setGroupQuery();
            condition = this.readExpression();
            command.setHaving(condition);
        }
        if (this.readIf(54)) {
            do {
                int index = this.parseIndex;
                String name = this.readAliasIdentifier();
                this.read("AS");
                Window w = this.readWindowSpecification();
                if (this.currentSelect.addWindow(name, w)) continue;
                throw DbException.getSyntaxError(this.sqlCommand, index, "unique identifier");
            } while (this.readIf(73));
        }
        if (this.readIf(43)) {
            command.setWindowQuery();
            Expression condition2 = this.readExpression();
            command.setQualify(condition2);
        }
        command.setParameterList(this.parameters);
        this.currentSelect = oldSelect;
        this.currentPrepared = oldPrepared;
        this.setSQL(command, "SELECT", start);
        return command;
    }

    private Table getDualTable(boolean noColumns) {
        Schema main = this.database.getMainSchema();
        ValueExpression one = ValueExpression.get(ValueLong.get(1L));
        return new RangeTable(main, one, one, noColumns);
    }

    private void setSQL(Prepared command, String start, int startIndex) {
        String sql;
        int endIndex = this.lastParseIndex;
        if (start != null) {
            StringBuilder builder = new StringBuilder(start.length() + endIndex - startIndex + 1).append(start).append(' ');
            sql = StringUtils.trimSubstring(builder, this.originalSQL, startIndex, endIndex).toString();
        } else {
            sql = StringUtils.trimSubstring(this.originalSQL, startIndex, endIndex);
        }
        command.setSQL(sql);
    }

    private Expression readExpressionOrDefault() {
        if (this.readIf("DEFAULT")) {
            return ValueExpression.getDefault();
        }
        return this.readExpression();
    }

    private Expression readExpression() {
        Expression r = this.readAnd();
        while (this.readIf("OR")) {
            r = new ConditionAndOr(1, r, this.readAnd());
        }
        return r;
    }

    private Expression readAnd() {
        Expression r = this.readCondition();
        while (this.readIf("AND")) {
            r = new ConditionAndOr(0, r, this.readCondition());
        }
        return r;
    }

    private Expression readCondition() {
        if (this.readIf(37)) {
            return new ConditionNot(this.readCondition());
        }
        if (this.readIf(15)) {
            this.read(69);
            Query query = this.parseSelect();
            this.read(70);
            return new ConditionExists(query);
        }
        if (this.readIf(27)) {
            this.read(69);
            Expression r1 = this.readConcat();
            this.read(73);
            Expression r2 = this.readConcat();
            this.read(70);
            return new Comparison(this.session, 11, r1, r2);
        }
        Expression r = this.readConcat();
        while (true) {
            int backup = this.parseIndex;
            boolean not = this.readIf(37);
            if (not && this.isToken(38)) {
                this.parseIndex = backup;
                this.currentToken = "NOT";
                this.currentTokenType = 37;
                break;
            }
            if (this.readIf(31)) {
                Expression b = this.readConcat();
                Expression esc = null;
                if (this.readIf("ESCAPE")) {
                    esc = this.readConcat();
                }
                this.recompileAlways = true;
                r = new CompareLike(this.database, r, b, esc, false);
            } else if (this.readIf("ILIKE")) {
                Function function = Function.getFunction(this.database, "CAST");
                function.setDataType(new Column("X", 14));
                function.setParameter(0, r);
                r = function;
                Expression b = this.readConcat();
                Expression esc = null;
                if (this.readIf("ESCAPE")) {
                    esc = this.readConcat();
                }
                this.recompileAlways = true;
                r = new CompareLike(this.database, r, b, esc, false);
            } else if (this.readIf("REGEXP")) {
                Expression b = this.readConcat();
                this.recompileAlways = true;
                r = new CompareLike(this.database, r, b, null, true);
            } else if (this.readIf(29)) {
                if (this.readIf(37)) {
                    if (this.readIf(38)) {
                        r = new Comparison(this.session, 7, r, null);
                    } else if (this.readIf(13)) {
                        this.read(20);
                        r = new Comparison(this.session, 16, r, this.readConcat());
                    } else {
                        r = this.readIf("OF") ? this.readTypePredicate(r, true) : new Comparison(this.session, 21, r, this.readConcat());
                    }
                } else if (this.readIf(38)) {
                    r = new Comparison(this.session, 6, r, null);
                } else if (this.readIf(13)) {
                    this.read(20);
                    r = new Comparison(this.session, 21, r, this.readConcat());
                } else {
                    r = this.readIf("OF") ? this.readTypePredicate(r, false) : new Comparison(this.session, 16, r, this.readConcat());
                }
            } else if (this.readIf("IN")) {
                this.read(69);
                if (this.readIf(70)) {
                    if (this.database.getMode().prohibitEmptyInPredicate) {
                        throw this.getSyntaxError();
                    }
                    r = ValueExpression.get(ValueBoolean.FALSE);
                } else {
                    if (this.isSelect()) {
                        Query query = this.parseSelect();
                        r = new ConditionInSelect(this.database, r, query, false, 0);
                    } else {
                        Expression last;
                        ArrayList<Expression> v = Utils.newSmallArrayList();
                        do {
                            last = this.readExpression();
                            v.add(last);
                        } while (this.readIf(73));
                        if (v.size() == 1 && last instanceof Subquery) {
                            Subquery s = (Subquery)last;
                            Query q = s.getQuery();
                            r = new ConditionInSelect(this.database, r, q, false, 0);
                        } else {
                            r = new ConditionIn(this.database, r, v);
                        }
                    }
                    this.read(70);
                }
            } else if (this.readIf("BETWEEN")) {
                Expression low = this.readConcat();
                this.read("AND");
                Expression high = this.readConcat();
                Comparison condLow = new Comparison(this.session, 3, low, r);
                Comparison condHigh = new Comparison(this.session, 1, high, r);
                r = new ConditionAndOr(0, condLow, condHigh);
            } else {
                Query query;
                if (not) {
                    throw this.getSyntaxError();
                }
                int compareType = Parser.getCompareType(this.currentTokenType);
                if (compareType < 0) break;
                this.read();
                int start = this.lastParseIndex;
                if (this.readIf(3)) {
                    this.read(69);
                    if (this.isSelect()) {
                        query = this.parseSelect();
                        r = new ConditionInSelect(this.database, r, query, true, compareType);
                        this.read(70);
                    } else {
                        this.parseIndex = start;
                        this.read();
                        r = new Comparison(this.session, compareType, r, this.readConcat());
                    }
                } else if (this.readIf("ANY") || this.readIf("SOME")) {
                    this.read(69);
                    if (this.currentTokenType == 56 && compareType == 0) {
                        Parameter p = this.readParameter();
                        r = new ConditionInParameter(this.database, r, p);
                        this.read(70);
                    } else if (this.isSelect()) {
                        query = this.parseSelect();
                        r = new ConditionInSelect(this.database, r, query, false, compareType);
                        this.read(70);
                    } else {
                        this.parseIndex = start;
                        this.read();
                        r = new Comparison(this.session, compareType, r, this.readConcat());
                    }
                } else {
                    r = new Comparison(this.session, compareType, r, this.readConcat());
                }
            }
            if (!not) continue;
            r = new ConditionNot(r);
        }
        return r;
    }

    private TypePredicate readTypePredicate(Expression r, boolean not) {
        this.read(69);
        ArrayList<TypeInfo> typeList = Utils.newSmallArrayList();
        do {
            typeList.add(this.parseColumnWithType(null, false).getType());
        } while (this.readIfMore(true));
        return new TypePredicate(r, not, typeList.toArray(new TypeInfo[0]));
    }

    private Expression readConcat() {
        Expression r = this.readSum();
        while (true) {
            Function function;
            if (this.readIf(68)) {
                r = new BinaryOperation(BinaryOperation.OpType.CONCAT, r, this.readSum());
                continue;
            }
            if (this.readIf(83)) {
                if (this.readIf(72)) {
                    function = Function.getFunction(this.database, "CAST");
                    function.setDataType(new Column("X", 14));
                    function.setParameter(0, r);
                    r = function;
                }
                r = new CompareLike(this.database, r, this.readSum(), null, true);
                continue;
            }
            if (!this.readIf(86)) break;
            if (this.readIf(72)) {
                function = Function.getFunction(this.database, "CAST");
                function.setDataType(new Column("X", 14));
                function.setParameter(0, r);
                r = function;
            }
            r = new ConditionNot(new CompareLike(this.database, r, this.readSum(), null, true));
        }
        return r;
    }

    private Expression readSum() {
        Expression r = this.readFactor();
        while (true) {
            if (this.readIf(67)) {
                r = new BinaryOperation(BinaryOperation.OpType.PLUS, r, this.readFactor());
                continue;
            }
            if (!this.readIf(66)) break;
            r = new BinaryOperation(BinaryOperation.OpType.MINUS, r, this.readFactor());
        }
        return r;
    }

    private Expression readFactor() {
        Expression r = this.readTerm();
        while (true) {
            if (this.readIf(72)) {
                r = new BinaryOperation(BinaryOperation.OpType.MULTIPLY, r, this.readTerm());
                continue;
            }
            if (this.readIf(77)) {
                r = new BinaryOperation(BinaryOperation.OpType.DIVIDE, r, this.readTerm());
                continue;
            }
            if (!this.readIf(78)) break;
            r = new BinaryOperation(BinaryOperation.OpType.MODULUS, r, this.readTerm());
        }
        return r;
    }

    private Expression readAggregate(AggregateType aggregateType, String aggregateName) {
        Aggregate r;
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        switch (aggregateType) {
            case COUNT: {
                if (this.readIf(72)) {
                    r = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.currentSelect, false);
                    break;
                }
                boolean distinct = this.readDistinctAgg();
                Expression on = this.readExpression();
                if (on instanceof Wildcard && !distinct) {
                    r = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.currentSelect, false);
                    break;
                }
                r = new Aggregate(AggregateType.COUNT, new Expression[]{on}, this.currentSelect, distinct);
                break;
            }
            case LISTAGG: {
                Expression[] expressionArray;
                boolean distinct = this.readDistinctAgg();
                Expression arg = this.readExpression();
                Expression separator = null;
                ArrayList<SelectOrderBy> orderByList = null;
                if (this.equalsToken("STRING_AGG", aggregateName)) {
                    this.read(73);
                    separator = this.readExpression();
                    if (this.readIf(41)) {
                        this.read("BY");
                        orderByList = this.parseSimpleOrderList();
                    }
                } else if (this.equalsToken("GROUP_CONCAT", aggregateName)) {
                    if (this.readIf(41)) {
                        this.read("BY");
                        orderByList = this.parseSimpleOrderList();
                    }
                    if (this.readIf("SEPARATOR")) {
                        separator = this.readExpression();
                    }
                } else {
                    if (this.readIf(73)) {
                        separator = this.readExpression();
                    }
                    if (this.readIf(40)) {
                        this.read("OVERFLOW");
                        this.read("ERROR");
                    }
                }
                if (separator == null) {
                    Expression[] expressionArray2 = new Expression[1];
                    expressionArray = expressionArray2;
                    expressionArray2[0] = arg;
                } else {
                    Expression[] expressionArray3 = new Expression[2];
                    expressionArray3[0] = arg;
                    expressionArray = expressionArray3;
                    expressionArray3[1] = separator;
                }
                Expression[] args = expressionArray;
                int index = this.lastParseIndex;
                this.read(70);
                if (orderByList == null && this.isToken("WITHIN")) {
                    r = this.readWithinGroup(aggregateType, args, distinct, false);
                    break;
                }
                this.parseIndex = index;
                this.read();
                r = new Aggregate(AggregateType.LISTAGG, args, this.currentSelect, distinct);
                if (orderByList == null) break;
                r.setOrderByList(orderByList);
                break;
            }
            case ARRAY_AGG: {
                boolean distinct = this.readDistinctAgg();
                r = new Aggregate(AggregateType.ARRAY_AGG, new Expression[]{this.readExpression()}, this.currentSelect, distinct);
                if (!this.readIf(41)) break;
                this.read("BY");
                r.setOrderByList(this.parseSimpleOrderList());
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                if (this.isToken(70)) {
                    return this.readWindowFunction(aggregateName);
                }
                ArrayList<Expression> expressions = Utils.newSmallArrayList();
                do {
                    expressions.add(this.readExpression());
                } while (this.readIfMore(true));
                r = this.readWithinGroup(aggregateType, expressions.toArray(new Expression[0]), false, true);
                break;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                Expression num = this.readExpression();
                this.read(70);
                r = this.readWithinGroup(aggregateType, new Expression[]{num}, false, false);
                break;
            }
            case MODE: {
                if (this.readIf(70)) {
                    r = this.readWithinGroup(AggregateType.MODE, new Expression[0], false, false);
                    break;
                }
                Expression expr = this.readExpression();
                r = new Aggregate(aggregateType, new Expression[0], this.currentSelect, false);
                if (this.readIf(41)) {
                    this.read("BY");
                    Expression expr2 = this.readExpression();
                    String sql = expr.getSQL(true);
                    String sql2 = expr2.getSQL(true);
                    if (!sql.equals(sql2)) {
                        throw DbException.getSyntaxError(42131, this.sqlCommand, this.lastParseIndex, sql, sql2);
                    }
                    this.readAggregateOrder(r, expr, true);
                    break;
                }
                this.readAggregateOrder(r, expr, false);
                break;
            }
            default: {
                boolean distinct = this.readDistinctAgg();
                r = new Aggregate(aggregateType, new Expression[]{this.readExpression()}, this.currentSelect, distinct);
            }
        }
        this.read(70);
        this.readFilterAndOver(r);
        return r;
    }

    private Aggregate readWithinGroup(AggregateType aggregateType, Expression[] args, boolean distinct, boolean forHypotheticalSet) {
        this.read("WITHIN");
        this.read(22);
        this.read(69);
        this.read(41);
        this.read("BY");
        Aggregate r = new Aggregate(aggregateType, args, this.currentSelect, distinct);
        if (forHypotheticalSet) {
            int count = args.length;
            ArrayList<SelectOrderBy> orderList = new ArrayList<SelectOrderBy>(count);
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    this.read(73);
                }
                SelectOrderBy order = new SelectOrderBy();
                order.expression = this.readExpression();
                order.sortType = this.parseSimpleSortType();
                orderList.add(order);
            }
            r.setOrderByList(orderList);
        } else {
            this.readAggregateOrder(r, this.readExpression(), true);
        }
        return r;
    }

    private void readAggregateOrder(Aggregate r, Expression expr, boolean parseSortType) {
        ArrayList<SelectOrderBy> orderList = new ArrayList<SelectOrderBy>(1);
        SelectOrderBy order = new SelectOrderBy();
        order.expression = expr;
        if (parseSortType) {
            order.sortType = this.parseSimpleSortType();
        }
        orderList.add(order);
        r.setOrderByList(orderList);
    }

    private ArrayList<SelectOrderBy> parseSimpleOrderList() {
        ArrayList<SelectOrderBy> orderList = Utils.newSmallArrayList();
        do {
            SelectOrderBy order = new SelectOrderBy();
            order.expression = this.readExpression();
            order.sortType = this.parseSortType();
            orderList.add(order);
        } while (this.readIf(73));
        return orderList;
    }

    private JavaFunction readJavaFunction(Schema schema, String functionName, boolean throwIfNotFound) {
        FunctionAlias functionAlias = schema != null ? schema.findFunction(functionName) : this.findFunctionAlias(this.session.getCurrentSchemaName(), functionName);
        if (functionAlias == null) {
            if (throwIfNotFound) {
                throw DbException.get(90022, functionName);
            }
            return null;
        }
        ArrayList<Expression> argList = Utils.newSmallArrayList();
        if (!this.readIf(70)) {
            do {
                argList.add(this.readExpression());
            } while (this.readIfMore(true));
        }
        Expression[] args = argList.toArray(new Expression[0]);
        return new JavaFunction(functionAlias, args);
    }

    private JavaAggregate readJavaAggregate(UserAggregate aggregate) {
        boolean distinct = this.readDistinctAgg();
        ArrayList<Expression> params = Utils.newSmallArrayList();
        do {
            params.add(this.readExpression());
        } while (this.readIfMore(true));
        Expression[] list = params.toArray(new Expression[0]);
        JavaAggregate agg = new JavaAggregate(aggregate, list, this.currentSelect, distinct);
        this.readFilterAndOver(agg);
        return agg;
    }

    private boolean readDistinctAgg() {
        if (this.readIf(13)) {
            return true;
        }
        this.readIf(3);
        return false;
    }

    private void readFilterAndOver(AbstractAggregate aggregate) {
        if (this.readIf("FILTER")) {
            this.read(69);
            this.read(53);
            Expression filterCondition = this.readExpression();
            this.read(70);
            aggregate.setFilterCondition(filterCondition);
        }
        this.readOver(aggregate);
    }

    private void readOver(DataAnalysisOperation operation) {
        if (this.readIf("OVER")) {
            operation.setOverCondition(this.readWindowNameOrSpecification());
            this.currentSelect.setWindowQuery();
        } else if (operation.isAggregate()) {
            this.currentSelect.setGroupQuery();
        } else {
            throw this.getSyntaxError();
        }
    }

    private Window readWindowNameOrSpecification() {
        return this.isToken(69) ? this.readWindowSpecification() : new Window(this.readAliasIdentifier(), null, null, null);
    }

    private Window readWindowSpecification() {
        this.read(69);
        String parent = null;
        if (this.currentTokenType == 2) {
            String token = this.currentToken;
            if (this.currentTokenQuoted || !this.equalsToken(token, "PARTITION") && !this.equalsToken(token, "ROWS") && !this.equalsToken(token, "RANGE") && !this.equalsToken(token, "GROUPS")) {
                parent = token;
                this.read();
            }
        }
        ArrayList<Expression> partitionBy = null;
        if (this.readIf("PARTITION")) {
            this.read("BY");
            partitionBy = Utils.newSmallArrayList();
            do {
                Expression expr = this.readExpression();
                partitionBy.add(expr);
            } while (this.readIf(73));
        }
        ArrayList<SelectOrderBy> orderBy = null;
        if (this.readIf(41)) {
            this.read("BY");
            orderBy = this.parseSimpleOrderList();
        }
        WindowFrame frame = this.readWindowFrame();
        this.read(70);
        return new Window(parent, partitionBy, orderBy, frame);
    }

    private WindowFrame readWindowFrame() {
        WindowFrame frame;
        WindowFrameBound following;
        WindowFrameBound starting;
        WindowFrameUnits units;
        if (this.readIf("ROWS")) {
            units = WindowFrameUnits.ROWS;
        } else if (this.readIf("RANGE")) {
            units = WindowFrameUnits.RANGE;
        } else if (this.readIf("GROUPS")) {
            units = WindowFrameUnits.GROUPS;
        } else {
            return null;
        }
        if (this.readIf("BETWEEN")) {
            starting = this.readWindowFrameRange();
            this.read("AND");
            following = this.readWindowFrameRange();
        } else {
            starting = this.readWindowFrameStarting();
            following = null;
        }
        int idx = this.lastParseIndex;
        WindowFrameExclusion exclusion = WindowFrameExclusion.EXCLUDE_NO_OTHERS;
        if (this.readIf("EXCLUDE")) {
            if (this.readIf("CURRENT")) {
                this.read(44);
                exclusion = WindowFrameExclusion.EXCLUDE_CURRENT_ROW;
            } else if (this.readIf(22)) {
                exclusion = WindowFrameExclusion.EXCLUDE_GROUP;
            } else if (this.readIf("TIES")) {
                exclusion = WindowFrameExclusion.EXCLUDE_TIES;
            } else {
                this.read("NO");
                this.read("OTHERS");
            }
        }
        if (!(frame = new WindowFrame(units, starting, following, exclusion)).isValid()) {
            throw DbException.getSyntaxError(this.sqlCommand, idx);
        }
        return frame;
    }

    private WindowFrameBound readWindowFrameStarting() {
        if (this.readIf("UNBOUNDED")) {
            this.read("PRECEDING");
            return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_PRECEDING, null);
        }
        if (this.readIf("CURRENT")) {
            this.read(44);
            return new WindowFrameBound(WindowFrameBoundType.CURRENT_ROW, null);
        }
        Expression value = this.readExpression();
        this.read("PRECEDING");
        return new WindowFrameBound(WindowFrameBoundType.PRECEDING, value);
    }

    private WindowFrameBound readWindowFrameRange() {
        if (this.readIf("UNBOUNDED")) {
            if (this.readIf("PRECEDING")) {
                return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_PRECEDING, null);
            }
            this.read("FOLLOWING");
            return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_FOLLOWING, null);
        }
        if (this.readIf("CURRENT")) {
            this.read(44);
            return new WindowFrameBound(WindowFrameBoundType.CURRENT_ROW, null);
        }
        Expression value = this.readExpression();
        if (this.readIf("PRECEDING")) {
            return new WindowFrameBound(WindowFrameBoundType.PRECEDING, value);
        }
        this.read("FOLLOWING");
        return new WindowFrameBound(WindowFrameBoundType.FOLLOWING, value);
    }

    private AggregateType getAggregateType(String name) {
        if (!this.identifiersToUpper) {
            name = StringUtils.toUpperEnglish(name);
        }
        return Aggregate.getAggregateType(name);
    }

    private Expression readFunction(Schema schema, String name) {
        JavaFunction jf;
        if (schema != null) {
            return this.readJavaFunction(schema, name, true);
        }
        boolean allowOverride = this.database.isAllowBuiltinAliasOverride();
        if (allowOverride && (jf = this.readJavaFunction(null, name, false)) != null) {
            return jf;
        }
        AggregateType agg = this.getAggregateType(name);
        if (agg != null) {
            return this.readAggregate(agg, name);
        }
        Function function = Function.getFunction(this.database, name);
        if (function == null) {
            WindowFunction windowFunction = this.readWindowFunction(name);
            if (windowFunction != null) {
                return windowFunction;
            }
            UserAggregate aggregate = this.database.findAggregate(name);
            if (aggregate != null) {
                return this.readJavaAggregate(aggregate);
            }
            if (allowOverride) {
                throw DbException.get(90022, name);
            }
            return this.readJavaFunction(null, name, true);
        }
        switch (function.getFunctionType()) {
            case 203: {
                function.setParameter(0, this.readExpression());
                this.read("AS");
                Column type = this.parseColumnWithType(null, false);
                function.setDataType(type);
                this.read(70);
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    Column type = this.parseColumnWithType(null, false);
                    function.setDataType(type);
                    this.read(73);
                    function.setParameter(0, this.readExpression());
                    this.read(70);
                    break;
                }
                function.setParameter(0, this.readExpression());
                this.read(73);
                Column type = this.parseColumnWithType(null, false);
                function.setDataType(type);
                this.read(70);
                break;
            }
            case 119: {
                function.setParameter(0, ValueExpression.get(ValueString.get(this.currentToken)));
                this.read();
                this.read(20);
                function.setParameter(1, this.readExpression());
                this.read(70);
                break;
            }
            case 105: 
            case 106: {
                if (this.currentTokenType == 58) {
                    function.setParameter(0, ValueExpression.get(this.currentValue.convertTo(13)));
                } else {
                    function.setParameter(0, ValueExpression.get(ValueString.get(this.currentToken)));
                }
                this.read();
                this.read(73);
                function.setParameter(1, this.readExpression());
                this.read(73);
                function.setParameter(2, this.readExpression());
                this.read(70);
                break;
            }
            case 73: {
                function.setParameter(0, this.readExpression());
                if (this.readIf(20)) {
                    function.setParameter(1, this.readExpression());
                    if (this.readIf(18)) {
                        function.setParameter(2, this.readExpression());
                    }
                } else if (this.readIf(18)) {
                    function.setParameter(1, ValueExpression.get(ValueInt.get(0)));
                    function.setParameter(2, this.readExpression());
                } else {
                    this.read(73);
                    function.setParameter(1, this.readExpression());
                    if (this.readIf(73)) {
                        function.setParameter(2, this.readExpression());
                    }
                }
                this.read(70);
                break;
            }
            case 77: {
                function.setParameter(0, this.readConcat());
                if (!this.readIf(73)) {
                    this.read("IN");
                }
                function.setParameter(1, this.readExpression());
                this.read(70);
                break;
            }
            case 78: {
                Expression space = null;
                if (this.readIf("LEADING")) {
                    function = Function.getFunction(this.database, "LTRIM");
                    if (!this.readIf(20)) {
                        space = this.readExpression();
                        this.read(20);
                    }
                } else if (this.readIf("TRAILING")) {
                    function = Function.getFunction(this.database, "RTRIM");
                    if (!this.readIf(20)) {
                        space = this.readExpression();
                        this.read(20);
                    }
                } else if (this.readIf("BOTH") && !this.readIf(20)) {
                    space = this.readExpression();
                    this.read(20);
                }
                Expression p0 = this.readExpression();
                if (this.readIf(73)) {
                    space = this.readExpression();
                } else if (this.readIf(20)) {
                    space = p0;
                    p0 = this.readExpression();
                }
                function.setParameter(0, p0);
                if (space != null) {
                    function.setParameter(1, space);
                }
                this.read(70);
                break;
            }
            case 223: 
            case 224: {
                int i = 0;
                ArrayList<Column> columns = Utils.newSmallArrayList();
                do {
                    String columnName = this.readAliasIdentifier();
                    Column column = this.parseColumnWithType(columnName, false);
                    columns.add(column);
                    this.read(59);
                    function.setParameter(i, this.readExpression());
                    ++i;
                } while (this.readIfMore(true));
                TableFunction tf = (TableFunction)function;
                tf.setColumns(columns);
                break;
            }
            case 233: {
                ArrayList<Column> columns = Utils.newSmallArrayList();
                if (!this.readIf(70)) {
                    int i = 0;
                    do {
                        function.setParameter(i++, this.readExpression());
                        columns.add(new Column("C" + i, 0));
                    } while (this.readIfMore(true));
                }
                if (this.readIf(55)) {
                    this.read("ORDINALITY");
                    columns.add(new Column("NORD", 4));
                }
                TableFunction tf = (TableFunction)function;
                tf.setColumns(columns);
                break;
            }
            default: {
                if (this.readIf(70)) break;
                int i = 0;
                do {
                    function.setParameter(i++, this.readExpression());
                } while (this.readIfMore(true));
            }
        }
        function.doneWithParameters();
        return function;
    }

    private WindowFunction readWindowFunction(String name) {
        WindowFunctionType type;
        if (!this.identifiersToUpper) {
            name = StringUtils.toUpperEnglish(name);
        }
        if ((type = WindowFunctionType.get(name)) == null) {
            return null;
        }
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        int numArgs = WindowFunction.getMinArgumentCount(type);
        Expression[] args = null;
        if (numArgs > 0) {
            int numArgsMax = WindowFunction.getMaxArgumentCount(type);
            args = new Expression[numArgsMax];
            if (numArgs == numArgsMax) {
                for (int i = 0; i < numArgs; ++i) {
                    if (i > 0) {
                        this.read(73);
                    }
                    args[i] = this.readExpression();
                }
            } else {
                int i;
                for (i = 0; i < numArgsMax && (i <= 0 || this.readIf(73)); ++i) {
                    args[i] = this.readExpression();
                }
                if (i < numArgs) {
                    throw this.getSyntaxError();
                }
                if (i != numArgsMax) {
                    args = Arrays.copyOf(args, i);
                }
            }
        }
        this.read(70);
        WindowFunction function = new WindowFunction(type, this.currentSelect, args);
        if (type == WindowFunctionType.NTH_VALUE) {
            this.readFromFirstOrLast(function);
        }
        switch (type) {
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case NTH_VALUE: {
                this.readRespectOrIgnoreNulls(function);
            }
        }
        this.readOver(function);
        return function;
    }

    private void readFromFirstOrLast(WindowFunction function) {
        if (this.readIf(20) && !this.readIf("FIRST")) {
            this.read("LAST");
            function.setFromLast(true);
        }
    }

    private void readRespectOrIgnoreNulls(WindowFunction function) {
        if (this.readIf("RESPECT")) {
            this.read("NULLS");
        } else if (this.readIf("IGNORE")) {
            this.read("NULLS");
            function.setIgnoreNulls(true);
        }
    }

    private Expression readKeywordFunction(String name) {
        if (this.readIf(69)) {
            return this.readFunction(null, name);
        }
        return this.readFunctionWithoutParameters(name);
    }

    private Expression readFunctionWithoutParameters(String name) {
        FunctionAlias functionAlias;
        if (this.database.isAllowBuiltinAliasOverride() && (functionAlias = this.database.getSchema(this.session.getCurrentSchemaName()).findFunction(name)) != null) {
            return new JavaFunction(functionAlias, new Expression[0]);
        }
        Function function = Function.getFunction(this.database, name);
        function.doneWithParameters();
        return function;
    }

    private Expression readWildcardRowidOrSequenceValue(String schema, String objectName) {
        Sequence sequence;
        if (this.readIf(72)) {
            return this.parseWildcard(schema, objectName);
        }
        if (this.readIf(45)) {
            return new ExpressionColumn(this.database, schema, objectName, "_ROWID_", true);
        }
        if (schema == null) {
            schema = this.session.getCurrentSchemaName();
        }
        if (this.readIf("NEXTVAL")) {
            Sequence sequence2 = this.findSequence(schema, objectName);
            if (sequence2 != null) {
                return new SequenceValue(sequence2);
            }
        } else if (this.readIf("CURRVAL") && (sequence = this.findSequence(schema, objectName)) != null) {
            Function function = Function.getFunction(this.database, "CURRVAL");
            function.setParameter(0, ValueExpression.get(ValueString.get(sequence.getSchema().getName())));
            function.setParameter(1, ValueExpression.get(ValueString.get(sequence.getName())));
            function.doneWithParameters();
            return function;
        }
        return null;
    }

    private Wildcard parseWildcard(String schema, String objectName) {
        Wildcard wildcard = new Wildcard(schema, objectName);
        if (this.readIf(14)) {
            this.read(69);
            ArrayList<ExpressionColumn> exceptColumns = Utils.newSmallArrayList();
            do {
                String s = null;
                String t = null;
                String name = this.readColumnIdentifier();
                if (this.readIf(74)) {
                    t = name;
                    name = this.readColumnIdentifier();
                    if (this.readIf(74)) {
                        s = t;
                        t = name;
                        name = this.readColumnIdentifier();
                        if (this.readIf(74)) {
                            if (!this.equalsToken(this.database.getShortName(), s)) {
                                throw DbException.get(90013, s);
                            }
                            s = t;
                            t = name;
                            name = this.readColumnIdentifier();
                        }
                    }
                }
                exceptColumns.add(new ExpressionColumn(this.database, s, t, name, false));
            } while (this.readIfMore(true));
            wildcard.setExceptColumns(exceptColumns);
        }
        return wildcard;
    }

    private Expression readTermObjectDot(String objectName) {
        Expression expr = this.readWildcardRowidOrSequenceValue(null, objectName);
        if (expr != null) {
            return expr;
        }
        String name = this.readColumnIdentifier();
        Schema s = this.database.findSchema(objectName);
        if (this.readIf(69)) {
            return this.readFunction(s, name);
        }
        if (this.readIf(74)) {
            String schema = objectName;
            expr = this.readWildcardRowidOrSequenceValue(schema, objectName = name);
            if (expr != null) {
                return expr;
            }
            name = this.readColumnIdentifier();
            if (this.readIf(69)) {
                String databaseName = schema;
                if (!this.equalsToken(this.database.getShortName(), databaseName)) {
                    throw DbException.get(90013, databaseName);
                }
                schema = objectName;
                return this.readFunction(this.database.getSchema(schema), name);
            }
            if (this.readIf(74)) {
                String databaseName = schema;
                if (!this.equalsToken(this.database.getShortName(), databaseName)) {
                    throw DbException.get(90013, databaseName);
                }
                schema = objectName;
                expr = this.readWildcardRowidOrSequenceValue(schema, objectName = name);
                if (expr != null) {
                    return expr;
                }
                name = this.readColumnIdentifier();
                return new ExpressionColumn(this.database, schema, objectName, name, false);
            }
            return new ExpressionColumn(this.database, schema, objectName, name, false);
        }
        return new ExpressionColumn(this.database, null, objectName, name, false);
    }

    private Parameter readParameter() {
        Parameter p;
        boolean indexed = Character.isDigit(this.sqlCommandChars[this.parseIndex]);
        if (indexed) {
            int index;
            this.readParameterIndex();
            if (this.indexedParameterList == null) {
                if (this.parameters == null) {
                    throw this.getSyntaxError();
                }
                if (!this.parameters.isEmpty()) {
                    throw DbException.get(90123);
                }
                this.indexedParameterList = Utils.newSmallArrayList();
            }
            if ((index = this.currentValue.getInt() - 1) < 0 || index >= 100000) {
                throw DbException.getInvalidValueException("parameter index", index + 1);
            }
            if (this.indexedParameterList.size() <= index) {
                this.indexedParameterList.ensureCapacity(index + 1);
                while (this.indexedParameterList.size() <= index) {
                    this.indexedParameterList.add(null);
                }
            }
            if ((p = this.indexedParameterList.get(index)) == null) {
                p = new Parameter(index);
                this.indexedParameterList.set(index, p);
            }
            this.read();
        } else {
            this.read();
            if (this.indexedParameterList != null) {
                throw DbException.get(90123);
            }
            p = new Parameter(this.parameters.size());
        }
        this.parameters.add(p);
        return p;
    }

    private Expression readTerm() {
        Function function;
        Expression r;
        switch (this.currentTokenType) {
            case 65: {
                this.read();
                r = new Variable(this.session, this.readAliasIdentifier());
                if (!this.readIf(85)) break;
                Expression value = this.readExpression();
                function = Function.getFunction(this.database, "SET");
                function.setParameter(0, r);
                function.setParameter(1, value);
                r = function;
                break;
            }
            case 56: {
                r = this.readParameter();
                break;
            }
            case 20: 
            case 47: 
            case 55: {
                r = new Subquery(this.parseSelect());
                break;
            }
            case 48: {
                int index = this.lastParseIndex;
                this.read();
                if (this.readIf(69)) {
                    r = this.readFunction(null, "TABLE");
                    break;
                }
                this.parseIndex = index;
                this.read();
                r = new Subquery(this.parseSelect());
                break;
            }
            case 2: {
                String name = this.currentToken;
                if (this.currentTokenQuoted) {
                    this.read();
                    if (this.readIf(69)) {
                        r = this.readFunction(null, name);
                        break;
                    }
                    if (this.readIf(74)) {
                        r = this.readTermObjectDot(name);
                        break;
                    }
                    r = new ExpressionColumn(this.database, null, null, name, false);
                    break;
                }
                this.read();
                if (this.readIf(74)) {
                    r = this.readTermObjectDot(name);
                    break;
                }
                if (this.readIf(69)) {
                    r = this.readFunction(null, name);
                    break;
                }
                r = this.readTermWithIdentifier(name);
                break;
            }
            case 66: {
                this.read();
                if (this.currentTokenType == 58) {
                    r = ValueExpression.get(this.currentValue.negate());
                    int rType = ((Expression)r).getType().getValueType();
                    if (rType == 5 && ((Expression)r).getValue(this.session).getLong() == Integer.MIN_VALUE) {
                        r = ValueExpression.get(ValueInt.get(Integer.MIN_VALUE));
                    } else if (rType == 6 && ((Expression)r).getValue(this.session).getBigDecimal().compareTo(Value.MIN_LONG_DECIMAL) == 0) {
                        r = ValueExpression.get(ValueLong.MIN);
                    }
                    this.read();
                    break;
                }
                r = new UnaryOperation(this.readTerm());
                break;
            }
            case 67: {
                this.read();
                r = this.readTerm();
                break;
            }
            case 69: {
                this.read();
                if (this.readIf(70)) {
                    r = ValueExpression.get(ValueRow.getEmpty());
                    break;
                }
                r = this.readExpression();
                if (!this.readIfMore(true)) break;
                ArrayList<Expression> list = Utils.newSmallArrayList();
                list.add(r);
                if (!this.readIf(70)) {
                    do {
                        list.add(this.readExpression());
                    } while (this.readIfMore(false));
                }
                r = new ExpressionList(list.toArray(new Expression[0]), false);
                break;
            }
            case 4: {
                this.read();
                this.read(81);
                if (this.readIf(82)) {
                    r = ValueExpression.get(ValueArray.getEmpty());
                    break;
                }
                ArrayList<Expression> list = Utils.newSmallArrayList();
                list.add(this.readExpression());
                while (this.readIf(73)) {
                    list.add(this.readExpression());
                }
                this.read(82);
                r = new ExpressionList(list.toArray(new Expression[0]), true);
                break;
            }
            case 28: {
                this.read();
                r = this.readInterval();
                break;
            }
            case 44: {
                this.read();
                this.read(69);
                if (this.readIf(70)) {
                    r = ValueExpression.get(ValueRow.getEmpty());
                    break;
                }
                ArrayList<Expression> list = Utils.newSmallArrayList();
                do {
                    list.add(this.readExpression());
                } while (this.readIfMore(true));
                r = new ExpressionList(list.toArray(new Expression[0]), false);
                break;
            }
            case 49: {
                this.read();
                r = ValueExpression.get(ValueBoolean.TRUE);
                break;
            }
            case 16: {
                this.read();
                r = ValueExpression.get(ValueBoolean.FALSE);
                break;
            }
            case 46: {
                this.read();
                if (this.readIf(69)) {
                    this.read(70);
                }
                if (this.currentSelect == null && this.currentPrepared == null) {
                    throw this.getSyntaxError();
                }
                r = new Rownum(this.currentSelect == null ? this.currentPrepared : this.currentSelect);
                break;
            }
            case 38: {
                this.read();
                r = ValueExpression.getNull();
                break;
            }
            case 45: {
                this.read();
                r = new ExpressionColumn(this.database, null, null, "_ROWID_", true);
                break;
            }
            case 58: {
                r = ValueExpression.get(this.currentValue);
                this.read();
                break;
            }
            case 52: {
                if (this.database.getMode().onDuplicateKeyUpdate) {
                    this.read();
                    r = this.readKeywordFunction("VALUES");
                    break;
                }
                r = new Subquery(this.parseSelect());
                break;
            }
            case 5: {
                this.read();
                r = this.readCase();
                break;
            }
            case 9: {
                this.read();
                r = this.readKeywordFunction("CURRENT_DATE");
                break;
            }
            case 10: {
                this.read();
                r = this.readKeywordFunction("CURRENT_TIME");
                break;
            }
            case 11: {
                this.read();
                r = this.readKeywordFunction("CURRENT_TIMESTAMP");
                break;
            }
            case 12: {
                this.read();
                r = this.readKeywordFunction("USER");
                break;
            }
            case 33: {
                this.read();
                r = this.readKeywordFunction("LOCALTIME");
                break;
            }
            case 34: {
                this.read();
                r = this.readKeywordFunction("LOCALTIMESTAMP");
                break;
            }
            default: {
                throw this.getSyntaxError();
            }
        }
        if (this.readIf(81)) {
            Function function2 = Function.getFunction(this.database, "ARRAY_GET");
            function2.setParameter(0, r);
            function2.setParameter(1, this.readExpression());
            r = function2;
            this.read(82);
        }
        if (this.readIf(84)) {
            if (this.isToken("PG_CATALOG")) {
                this.read("PG_CATALOG");
                this.read(74);
            }
            if (this.readIf("REGCLASS")) {
                FunctionAlias f = this.findFunctionAlias(this.database.getMainSchema().getName(), "PG_GET_OID");
                if (f == null) {
                    throw this.getSyntaxError();
                }
                Expression[] args = new Expression[]{r};
                r = new JavaFunction(f, args);
            } else {
                Column col = this.parseColumnWithType(null, false);
                function = Function.getFunction(this.database, "CAST");
                function.setDataType(col);
                function.setParameter(0, r);
                r = function;
            }
        }
        return r;
    }

    private Expression readTermWithIdentifier(String name) {
        char ch = name.charAt(0);
        if (!this.identifiersToUpper) {
            ch = (char)(ch & 0xFFDF);
        }
        switch (ch) {
            case 'C': {
                if (this.database.getMode().getEnum() != Mode.ModeEnum.DB2 || !this.equalsToken("CURRENT", name)) break;
                return this.parseDB2SpecialRegisters(name);
            }
            case 'D': {
                if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13 || !this.equalsToken("DATE", name) && !this.equalsToken("D", name)) break;
                String date = this.currentValue.getString();
                this.read();
                return ValueExpression.get(ValueDate.parse(date));
            }
            case 'E': {
                if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13 || !this.equalsToken("E", name)) break;
                String text = this.currentValue.getString();
                text = StringUtils.replaceAll(text, "\\\\", "\\");
                this.read();
                return ValueExpression.get(ValueString.get(text));
            }
            case 'N': {
                if (this.equalsToken("NEXT", name) && this.readIf("VALUE")) {
                    this.read(18);
                    return new SequenceValue(this.readSequence());
                }
                if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13 || !this.equalsToken("N", name)) break;
                String text = this.currentValue.getString();
                this.read();
                return ValueExpression.get(ValueString.get(text));
            }
            case 'S': {
                if (this.equalsToken("SYSDATE", name)) {
                    return this.readFunctionWithoutParameters("CURRENT_TIMESTAMP");
                }
                if (this.equalsToken("SYSTIME", name)) {
                    return this.readFunctionWithoutParameters("CURRENT_TIME");
                }
                if (!this.equalsToken("SYSTIMESTAMP", name)) break;
                return this.readFunctionWithoutParameters("CURRENT_TIMESTAMP");
            }
            case 'T': {
                if (this.equalsToken("TIME", name)) {
                    boolean without = this.readIf("WITHOUT");
                    if (without) {
                        this.read("TIME");
                        this.read("ZONE");
                    }
                    if (this.currentTokenType == 58 && this.currentValue.getValueType() == 13) {
                        String time = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTime.parse(time));
                    }
                    if (!without) break;
                    throw this.getSyntaxError();
                }
                if (this.equalsToken("TIMESTAMP", name)) {
                    if (this.readIf(55)) {
                        this.read("TIME");
                        this.read("ZONE");
                        if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13) {
                            throw this.getSyntaxError();
                        }
                        String timestamp = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTimestampTimeZone.parse(timestamp));
                    }
                    boolean without = this.readIf("WITHOUT");
                    if (without) {
                        this.read("TIME");
                        this.read("ZONE");
                    }
                    if (this.currentTokenType == 58 && this.currentValue.getValueType() == 13) {
                        String timestamp = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTimestamp.parse(timestamp, this.database.getMode()));
                    }
                    if (!without) break;
                    throw this.getSyntaxError();
                }
                if (this.equalsToken("TODAY", name)) {
                    return this.readFunctionWithoutParameters("CURRENT_DATE");
                }
                if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13) break;
                if (this.equalsToken("T", name)) {
                    String time = this.currentValue.getString();
                    this.read();
                    return ValueExpression.get(ValueTime.parse(time));
                }
                if (!this.equalsToken("TS", name)) break;
                String timestamp = this.currentValue.getString();
                this.read();
                return ValueExpression.get(ValueTimestamp.parse(timestamp, this.database.getMode()));
            }
            case 'X': {
                if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13 || !this.equalsToken("X", name)) break;
                byte[] buffer = StringUtils.convertHexToBytes(this.currentValue.getString());
                this.read();
                return ValueExpression.get(ValueBytes.getNoCopy(buffer));
            }
        }
        return new ExpressionColumn(this.database, null, null, name, false);
    }

    private Expression readInterval() {
        IntervalQualifier qualifier;
        boolean negative = this.readIf(66);
        if (!negative) {
            this.readIf(67);
        }
        String s = this.readString();
        if (this.readIf("YEAR")) {
            if (this.readIf("TO")) {
                this.read("MONTH");
                qualifier = IntervalQualifier.YEAR_TO_MONTH;
            } else {
                qualifier = IntervalQualifier.YEAR;
            }
        } else if (this.readIf("MONTH")) {
            qualifier = IntervalQualifier.MONTH;
        } else if (this.readIf("DAY")) {
            if (this.readIf("TO")) {
                if (this.readIf("HOUR")) {
                    qualifier = IntervalQualifier.DAY_TO_HOUR;
                } else if (this.readIf("MINUTE")) {
                    qualifier = IntervalQualifier.DAY_TO_MINUTE;
                } else {
                    this.read("SECOND");
                    qualifier = IntervalQualifier.DAY_TO_SECOND;
                }
            } else {
                qualifier = IntervalQualifier.DAY;
            }
        } else if (this.readIf("HOUR")) {
            if (this.readIf("TO")) {
                if (this.readIf("MINUTE")) {
                    qualifier = IntervalQualifier.HOUR_TO_MINUTE;
                } else {
                    this.read("SECOND");
                    qualifier = IntervalQualifier.HOUR_TO_SECOND;
                }
            } else {
                qualifier = IntervalQualifier.HOUR;
            }
        } else if (this.readIf("MINUTE")) {
            if (this.readIf("TO")) {
                this.read("SECOND");
                qualifier = IntervalQualifier.MINUTE_TO_SECOND;
            } else {
                qualifier = IntervalQualifier.MINUTE;
            }
        } else {
            this.read("SECOND");
            qualifier = IntervalQualifier.SECOND;
        }
        try {
            return ValueExpression.get(IntervalUtils.parseInterval(qualifier, negative, s));
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "INTERVAL", s);
        }
    }

    private Expression parseDB2SpecialRegisters(String name) {
        if (this.readIf("TIMESTAMP")) {
            if (this.readIf(55)) {
                this.read("TIME");
                this.read("ZONE");
                return this.readKeywordFunction("CURRENT_TIMESTAMP");
            }
            return this.readKeywordFunction("LOCALTIMESTAMP");
        }
        if (this.readIf("TIME")) {
            return this.readFunctionWithoutParameters("CURRENT_TIME");
        }
        if (this.readIf("DATE")) {
            return this.readFunctionWithoutParameters("CURRENT_DATE");
        }
        return new ExpressionColumn(this.database, null, null, name, false);
    }

    private Expression readCase() {
        int i;
        Function function;
        if (this.readIf("END")) {
            this.readIf(5);
            return ValueExpression.getNull();
        }
        if (this.readIf("ELSE")) {
            Expression elsePart = this.readExpression().optimize(this.session);
            this.read("END");
            this.readIf(5);
            return elsePart;
        }
        if (this.readIf("WHEN")) {
            function = Function.getFunction(this.database, "CASE");
            function.setParameter(0, null);
            i = 1;
            do {
                function.setParameter(i++, this.readExpression());
                this.read("THEN");
                function.setParameter(i++, this.readExpression());
            } while (this.readIf("WHEN"));
        } else {
            Expression expr = this.readExpression();
            if (this.readIf("END")) {
                this.readIf(5);
                return ValueExpression.getNull();
            }
            if (this.readIf("ELSE")) {
                Expression elsePart = this.readExpression().optimize(this.session);
                this.read("END");
                this.readIf(5);
                return elsePart;
            }
            function = Function.getFunction(this.database, "CASE");
            function.setParameter(0, expr);
            i = 1;
            this.read("WHEN");
            do {
                function.setParameter(i++, this.readExpression());
                this.read("THEN");
                function.setParameter(i++, this.readExpression());
            } while (this.readIf("WHEN"));
        }
        if (this.readIf("ELSE")) {
            function.setParameter(i, this.readExpression());
        }
        this.read("END");
        this.readIf("CASE");
        function.doneWithParameters();
        return function;
    }

    private int readNonNegativeInt() {
        int v = this.readInt();
        if (v < 0) {
            throw DbException.getInvalidValueException("non-negative integer", v);
        }
        return v;
    }

    private int readInt() {
        boolean minus = false;
        if (this.currentTokenType == 66) {
            minus = true;
            this.read();
        } else if (this.currentTokenType == 67) {
            this.read();
        }
        if (this.currentTokenType != 58) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "integer");
        }
        if (minus) {
            this.currentValue = this.currentValue.negate();
        }
        int i = this.currentValue.getInt();
        this.read();
        return i;
    }

    private long readNonNegativeLong() {
        long v = this.readLong();
        if (v < 0L) {
            throw DbException.getInvalidValueException("non-negative long", v);
        }
        return v;
    }

    private long readLong() {
        boolean minus = false;
        if (this.currentTokenType == 66) {
            minus = true;
            this.read();
        } else if (this.currentTokenType == 67) {
            this.read();
        }
        if (this.currentTokenType != 58) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "long");
        }
        if (minus) {
            this.currentValue = this.currentValue.negate();
        }
        long i = this.currentValue.getLong();
        this.read();
        return i;
    }

    private boolean readBooleanSetting() {
        switch (this.currentTokenType) {
            case 40: 
            case 49: {
                this.read();
                return true;
            }
            case 16: {
                this.read();
                return false;
            }
            case 58: {
                boolean result = this.currentValue.getBoolean();
                this.read();
                return result;
            }
        }
        if (this.readIf("OFF")) {
            return false;
        }
        throw this.getSyntaxError();
    }

    private String readString() {
        Expression expr = this.readExpression().optimize(this.session);
        if (!(expr instanceof ValueExpression)) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "string");
        }
        return expr.getValue(this.session).getString();
    }

    private String readIdentifierWithSchema(String defaultSchemaName) {
        String s = this.readColumnIdentifier();
        this.schemaName = defaultSchemaName;
        if (this.readIf(74)) {
            this.schemaName = s;
            s = this.readColumnIdentifier();
        }
        if (this.currentTokenType == 74 && this.equalsToken(this.schemaName, this.database.getShortName())) {
            this.read();
            this.schemaName = s;
            s = this.readColumnIdentifier();
        }
        return s;
    }

    private String readIdentifierWithSchema() {
        return this.readIdentifierWithSchema(this.session.getCurrentSchemaName());
    }

    private String readAliasIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readUniqueIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readColumnIdentifier() {
        if (!(this.currentTokenType == 2 || this.session.getDatabase().isStarting() && this.isKeyword(this.currentToken))) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String s = this.currentToken;
        this.read();
        return s;
    }

    private void read(String expected) {
        if (this.currentTokenQuoted || !this.equalsToken(expected, this.currentToken)) {
            this.addExpected(expected);
            throw this.getSyntaxError();
        }
        this.read();
    }

    private void read(int tokenType) {
        if (tokenType != this.currentTokenType) {
            this.addExpected(tokenType);
            throw this.getSyntaxError();
        }
        this.read();
    }

    private boolean readIf(String token) {
        if (!this.currentTokenQuoted && this.equalsToken(token, this.currentToken)) {
            this.read();
            return true;
        }
        this.addExpected(token);
        return false;
    }

    private boolean readIf(int tokenType) {
        if (tokenType == this.currentTokenType) {
            this.read();
            return true;
        }
        this.addExpected(tokenType);
        return false;
    }

    private boolean isToken(String token) {
        if (!this.currentTokenQuoted && this.equalsToken(token, this.currentToken)) {
            return true;
        }
        this.addExpected(token);
        return false;
    }

    private boolean isToken(int tokenType) {
        if (tokenType == this.currentTokenType) {
            return true;
        }
        this.addExpected(tokenType);
        return false;
    }

    private boolean equalsToken(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b) || !this.identifiersToUpper && a.equalsIgnoreCase(b);
    }

    private static boolean equalsTokenIgnoreCase(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b) || a.equalsIgnoreCase(b);
    }

    private boolean isTokenInList(Collection<String> upperCaseTokenList) {
        String upperCaseCurrentToken = this.currentToken.toUpperCase();
        return upperCaseTokenList.contains(upperCaseCurrentToken);
    }

    private void addExpected(String token) {
        if (this.expectedList != null) {
            this.expectedList.add(token);
        }
    }

    private void addExpected(int tokenType) {
        if (this.expectedList != null) {
            this.expectedList.add(TOKENS[tokenType]);
        }
    }

    private void read() {
        this.currentTokenQuoted = false;
        if (this.expectedList != null) {
            this.expectedList.clear();
        }
        int[] types = this.characterTypes;
        this.lastParseIndex = this.parseIndex;
        int i = this.parseIndex;
        int type = types[i];
        while (type == 0) {
            type = types[++i];
        }
        int start = i;
        char[] chars = this.sqlCommandChars;
        char c = chars[i++];
        this.currentToken = "";
        switch (type) {
            case 4: {
                while ((type = types[i]) == 4 || type == 2) {
                    ++i;
                }
                this.currentTokenType = ParserUtil.getSaveTokenType(this.sqlCommand, !this.identifiersToUpper, start, i, false);
                this.currentToken = this.currentTokenType == 2 ? StringUtils.cache(this.sqlCommand.substring(start, i)) : TOKENS[this.currentTokenType];
                this.parseIndex = i;
                return;
            }
            case 3: {
                String result = null;
                while (true) {
                    int begin = ++i;
                    while (true) {
                        if (chars[i] == c) {
                            if (result == null) {
                                result = this.sqlCommand.substring(begin, i);
                                break;
                            }
                            result = result + this.sqlCommand.substring(begin - 1, i);
                            break;
                        }
                        ++i;
                    }
                    if (chars[++i] != c) break;
                }
                this.currentToken = StringUtils.cache(result);
                this.parseIndex = i;
                this.currentTokenQuoted = true;
                this.currentTokenType = 2;
                return;
            }
            case 6: {
                if (types[i] == 6) {
                    char c1 = chars[i++];
                    this.currentTokenType = this.getSpecialType2(c, c1);
                } else {
                    this.currentTokenType = this.getSpecialType1(c);
                }
                this.parseIndex = i;
                return;
            }
            case 5: {
                this.currentTokenType = this.getSpecialType1(c);
                this.parseIndex = i;
                return;
            }
            case 2: {
                if (c == '0' && (chars[i] == 'X' || chars[i] == 'x')) {
                    long number = 0L;
                    start += 2;
                    ++i;
                    while (true) {
                        if ((c = chars[i]) >= '0' && c <= '9') {
                            number = (number << 4) + (long)c - 48L;
                        } else if (c >= 'A' && c <= 'F') {
                            number = (number << 4) + (long)c - 55L;
                        } else if (c >= 'a' && c <= 'f') {
                            number = (number << 4) + (long)c - 87L;
                        } else {
                            this.checkLiterals(false);
                            this.currentValue = ValueInt.get((int)number);
                            this.currentTokenType = 58;
                            this.currentToken = "0";
                            this.parseIndex = i;
                            return;
                        }
                        if (number > Integer.MAX_VALUE) {
                            this.readHexDecimal(start, i);
                            return;
                        }
                        ++i;
                    }
                }
                long number = c - 48;
                while (true) {
                    if ((c = chars[i]) < '0' || c > '9') {
                        switch (c) {
                            case '.': 
                            case 'E': 
                            case 'e': {
                                this.readDecimal(start, i, false);
                                break;
                            }
                            case 'L': 
                            case 'l': {
                                this.readDecimal(start, i, true);
                                break;
                            }
                            default: {
                                this.checkLiterals(false);
                                this.currentValue = ValueInt.get((int)number);
                                this.currentTokenType = 58;
                                this.currentToken = "0";
                                this.parseIndex = i;
                                break;
                            }
                        }
                        break;
                    }
                    if ((number = number * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        this.readDecimal(start, i, true);
                        break;
                    }
                    ++i;
                }
                return;
            }
            case 8: {
                if (types[i] != 2) {
                    this.currentTokenType = 74;
                    this.currentToken = ".";
                    this.parseIndex = i;
                    return;
                }
                this.readDecimal(i - 1, i, false);
                return;
            }
            case 7: {
                String result = null;
                while (true) {
                    int begin = ++i;
                    while (true) {
                        if (chars[i] == '\'') {
                            if (result == null) {
                                result = this.sqlCommand.substring(begin, i);
                                break;
                            }
                            result = result + this.sqlCommand.substring(begin - 1, i);
                            break;
                        }
                        ++i;
                    }
                    if (chars[++i] != '\'') break;
                }
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(result, this.database.getMode().treatEmptyStringsAsNull);
                this.parseIndex = i;
                this.currentTokenType = 58;
                return;
            }
            case 9: {
                int begin = i - 1;
                while (types[i] == 9) {
                    ++i;
                }
                String result = this.sqlCommand.substring(begin, i);
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(result, this.database.getMode().treatEmptyStringsAsNull);
                this.parseIndex = i;
                this.currentTokenType = 58;
                return;
            }
            case 1: {
                this.currentTokenType = 57;
                this.parseIndex = i;
                return;
            }
        }
        throw this.getSyntaxError();
    }

    private void readParameterIndex() {
        int i = this.parseIndex;
        char[] chars = this.sqlCommandChars;
        char c = chars[i++];
        long number = c - 48;
        while (true) {
            if ((c = chars[i]) < '0' || c > '9') break;
            if ((number = number * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                throw DbException.getInvalidValueException("parameter index", number);
            }
            ++i;
        }
        this.currentValue = ValueInt.get((int)number);
        this.currentTokenType = 58;
        this.currentToken = "0";
        this.parseIndex = i;
    }

    private void checkLiterals(boolean text) {
        int allowed;
        if (!this.literalsChecked && !this.session.getAllowLiterals() && ((allowed = this.database.getAllowLiterals()) == 0 || text && allowed != 2)) {
            throw DbException.get(90116);
        }
    }

    private void readHexDecimal(int start, int i) {
        char c;
        char[] chars = this.sqlCommandChars;
        while ((c = chars[++i]) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
        }
        this.parseIndex = i;
        String sub = this.sqlCommand.substring(start, i);
        BigDecimal bd = new BigDecimal(new BigInteger(sub, 16));
        this.checkLiterals(false);
        this.currentValue = ValueDecimal.get(bd);
        this.currentTokenType = 58;
    }

    private void readDecimal(int start, int i, boolean integer) {
        BigDecimal bd;
        char[] chars = this.sqlCommandChars;
        int[] types = this.characterTypes;
        while (true) {
            int t;
            if ((t = types[i]) == 8) {
                integer = false;
            } else if (t != 2) break;
            ++i;
        }
        char c = chars[i];
        if (c == 'E' || c == 'e') {
            integer = false;
            if ((c = chars[++i]) == '+' || c == '-') {
                ++i;
            }
            if (types[i] != 2) {
                throw this.getSyntaxError();
            }
            while (types[++i] == 2) {
            }
        }
        this.parseIndex = i;
        this.checkLiterals(false);
        if (integer && i - start <= 19) {
            BigInteger bi = new BigInteger(this.sqlCommand.substring(start, i));
            if (bi.compareTo(ValueLong.MAX_BI) <= 0) {
                c = chars[i];
                if (c == 'L' || c == 'l') {
                    ++this.parseIndex;
                }
                this.currentValue = ValueLong.get(bi.longValue());
                this.currentTokenType = 58;
                return;
            }
            bd = new BigDecimal(bi);
        } else {
            try {
                bd = new BigDecimal(this.sqlCommandChars, start, i - start);
            }
            catch (NumberFormatException e) {
                throw DbException.get(22018, e, this.sqlCommand.substring(start, i));
            }
        }
        this.currentValue = ValueDecimal.get(bd);
        this.currentTokenType = 58;
    }

    private void initialize(String sql) {
        if (sql == null) {
            sql = "";
        }
        this.originalSQL = sql;
        this.sqlCommand = sql;
        int len = sql.length() + 1;
        char[] command = new char[len];
        int[] types = new int[len];
        sql.getChars(0, --len, command, 0);
        boolean changed = false;
        command[len] = 32;
        int startLoop = 0;
        int lastType = 0;
        for (int i = 0; i < len; ++i) {
            char c = command[i];
            int type = 0;
            switch (c) {
                case '/': {
                    if (command[i + 1] == '*') {
                        changed = true;
                        command[i] = 32;
                        command[i + 1] = 32;
                        startLoop = i;
                        this.checkRunOver(i += 2, len, startLoop);
                        while (command[i] != '*' || command[i + 1] != '/') {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 32;
                        command[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (command[i + 1] == '/') {
                        changed = true;
                        startLoop = i;
                        while ((c = command[i]) != '\n' && c != '\r' && i < len - 1) {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        break;
                    }
                    type = 5;
                    break;
                }
                case '-': {
                    if (command[i + 1] == '-') {
                        changed = true;
                        startLoop = i;
                        while ((c = command[i]) != '\n' && c != '\r' && i < len - 1) {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        break;
                    }
                    type = 5;
                    break;
                }
                case '$': {
                    if (command[i + 1] == '$' && (i == 0 || command[i - 1] <= ' ')) {
                        changed = true;
                        command[i] = 32;
                        command[i + 1] = 32;
                        startLoop = i;
                        this.checkRunOver(i += 2, len, startLoop);
                        while (command[i] != '$' || command[i + 1] != '$') {
                            types[i++] = 9;
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 32;
                        command[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (lastType == 4 || lastType == 2) {
                        type = 4;
                        break;
                    }
                    type = 5;
                    break;
                }
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '?': 
                case '@': 
                case ']': 
                case '{': 
                case '}': {
                    type = 5;
                    break;
                }
                case '!': 
                case '&': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '|': 
                case '~': {
                    type = 6;
                    break;
                }
                case '.': {
                    type = 8;
                    break;
                }
                case '\'': {
                    types[i] = 7;
                    type = 7;
                    startLoop = i;
                    while (command[++i] != '\'') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '[': {
                    if (this.database.getMode().squareBracketQuotedNames) {
                        command[i] = 34;
                        changed = true;
                        types[i] = 3;
                        type = 3;
                        startLoop = i;
                        while (command[++i] != ']') {
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 34;
                        break;
                    }
                    type = 5;
                    break;
                }
                case '`': {
                    char u;
                    types[i] = 3;
                    type = 3;
                    startLoop = i;
                    while (command[++i] != '`') {
                        this.checkRunOver(i, len, startLoop);
                        c = command[i];
                        if (!this.identifiersToUpper && !this.identifiersToLower || (u = this.identifiersToUpper ? Character.toUpperCase(c) : Character.toLowerCase(c)) == c) continue;
                        command[i] = u;
                        changed = true;
                    }
                    break;
                }
                case '\"': {
                    types[i] = 3;
                    type = 3;
                    startLoop = i;
                    while (command[++i] != '\"') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '_': {
                    type = 4;
                    break;
                }
                case '#': {
                    if (this.database.getMode().supportPoundSymbolForColumnNames) {
                        type = 4;
                        break;
                    }
                    type = 5;
                    break;
                }
                default: {
                    char u;
                    if (c >= 'a' && c <= 'z') {
                        if (this.identifiersToUpper) {
                            command[i] = (char)(c - 32);
                            changed = true;
                        }
                        type = 4;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        if (this.identifiersToLower) {
                            command[i] = (char)(c + 32);
                            changed = true;
                        }
                        type = 4;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        type = 2;
                        break;
                    }
                    if (c <= ' ' || Character.isSpaceChar(c)) break;
                    if (Character.isJavaIdentifierPart(c)) {
                        type = 4;
                        if (!this.identifiersToUpper && !this.identifiersToLower) break;
                        char c2 = u = this.identifiersToUpper ? Character.toUpperCase(c) : Character.toLowerCase(c);
                        if (u == c) break;
                        command[i] = u;
                        changed = true;
                        break;
                    }
                    type = 5;
                }
            }
            types[i] = type;
            lastType = type;
        }
        this.sqlCommandChars = command;
        types[len] = 1;
        this.characterTypes = types;
        if (changed) {
            this.sqlCommand = new String(command);
        }
        this.parseIndex = 0;
    }

    private void checkRunOver(int i, int len, int startLoop) {
        if (i >= len) {
            this.parseIndex = startLoop;
            throw this.getSyntaxError();
        }
    }

    private int getSpecialType1(char c0) {
        switch (c0) {
            case '$': 
            case '?': {
                return 56;
            }
            case '@': {
                return 65;
            }
            case '+': {
                return 67;
            }
            case '-': {
                return 66;
            }
            case '*': {
                return 72;
            }
            case ',': {
                return 73;
            }
            case '{': {
                return 75;
            }
            case '}': {
                return 76;
            }
            case '/': {
                return 77;
            }
            case '%': {
                return 78;
            }
            case ';': {
                return 79;
            }
            case ':': {
                return 80;
            }
            case '[': {
                return 81;
            }
            case ']': {
                return 82;
            }
            case '~': {
                return 83;
            }
            case '(': {
                return 69;
            }
            case ')': {
                return 70;
            }
            case '<': {
                return 62;
            }
            case '>': {
                return 61;
            }
            case '=': {
                return 59;
            }
        }
        throw this.getSyntaxError();
    }

    private int getSpecialType2(char c0, char c1) {
        switch (c0) {
            case ':': {
                if (c1 == ':') {
                    return 84;
                }
                if (c1 != '=') break;
                return 85;
            }
            case '>': {
                if (c1 != '=') break;
                return 60;
            }
            case '<': {
                if (c1 == '=') {
                    return 63;
                }
                if (c1 != '>') break;
                return 64;
            }
            case '!': {
                if (c1 == '=') {
                    return 64;
                }
                if (c1 != '~') break;
                return 86;
            }
            case '|': {
                if (c1 != '|') break;
                return 68;
            }
            case '&': {
                if (c1 != '&') break;
                return 71;
            }
        }
        throw this.getSyntaxError();
    }

    private boolean isKeyword(String s) {
        return ParserUtil.isKeyword(s, !this.identifiersToUpper);
    }

    private Column parseColumnForTable(String columnName, boolean defaultNullable, boolean forTable) {
        String comment;
        Column column;
        boolean isIdentity = this.readIf("IDENTITY");
        if (isIdentity || this.readIf("BIGSERIAL")) {
            if (isIdentity && this.database.getMode().disallowedTypes.contains("IDENTITY")) {
                throw DbException.get(50004, this.currentToken);
            }
            column = new Column(columnName, 5);
            column.setOriginalSQL("IDENTITY");
            this.parseAutoIncrement(column);
            if (!this.database.getMode().serialColumnIsNotPK) {
                column.setPrimaryKey(true);
            }
        } else if (this.readIf("SERIAL")) {
            column = new Column(columnName, 4);
            column.setOriginalSQL("SERIAL");
            this.parseAutoIncrement(column);
            if (!this.database.getMode().serialColumnIsNotPK) {
                column.setPrimaryKey(true);
            }
        } else {
            column = this.parseColumnWithType(columnName, forTable);
        }
        if (this.readIf("INVISIBLE")) {
            column.setVisible(false);
        } else if (this.readIf("VISIBLE")) {
            column.setVisible(true);
        }
        NullConstraintType nullConstraint = this.parseNotNullConstraint();
        switch (nullConstraint) {
            case NULL_IS_ALLOWED: {
                column.setNullable(true);
                break;
            }
            case NULL_IS_NOT_ALLOWED: {
                column.setNullable(false);
                break;
            }
            case NO_NULL_CONSTRAINT_FOUND: {
                column.setNullable(defaultNullable & column.isNullable());
                break;
            }
            default: {
                throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraint.name());
            }
        }
        if (this.readIf("AS")) {
            if (isIdentity) {
                this.getSyntaxError();
            }
            Expression expr = this.readExpression();
            column.setComputedExpression(expr);
        } else if (this.readIf("DEFAULT")) {
            Expression defaultExpression = this.readExpression();
            column.setDefaultExpression(this.session, defaultExpression);
        } else if (this.readIf("GENERATED")) {
            if (!this.readIf("ALWAYS")) {
                this.read("BY");
                this.read("DEFAULT");
            }
            this.read("AS");
            this.read("IDENTITY");
            SequenceOptions options = new SequenceOptions();
            if (this.readIf(69)) {
                this.parseSequenceOptions(options, null, true);
                this.read(70);
            }
            column.setAutoIncrementOptions(options);
        }
        if (this.readIf(40)) {
            this.read("UPDATE");
            Expression onUpdateExpression = this.readExpression();
            column.setOnUpdateExpression(this.session, onUpdateExpression);
        }
        if (NullConstraintType.NULL_IS_NOT_ALLOWED == this.parseNotNullConstraint()) {
            column.setNullable(false);
        }
        if (this.readIf("AUTO_INCREMENT") || this.readIf("BIGSERIAL") || this.readIf("SERIAL")) {
            this.parseAutoIncrement(column);
            this.parseNotNullConstraint();
        } else if (this.readIf("IDENTITY")) {
            this.parseAutoIncrement(column);
            column.setPrimaryKey(true);
            this.parseNotNullConstraint();
        }
        if (this.readIf("NULL_TO_DEFAULT")) {
            column.setConvertNullToDefault(true);
        }
        if (this.readIf("SEQUENCE")) {
            Sequence sequence = this.readSequence();
            column.setSequence(sequence);
        }
        if (this.readIf("SELECTIVITY")) {
            int value = this.readNonNegativeInt();
            column.setSelectivity(value);
        }
        if ((comment = this.readCommentIf()) != null) {
            column.setComment(comment);
        }
        return column;
    }

    private void parseAutoIncrement(Column column) {
        SequenceOptions options = new SequenceOptions();
        if (this.readIf(69)) {
            options.setStartValue(ValueExpression.get(ValueLong.get(this.readLong())));
            if (this.readIf(73)) {
                options.setIncrement(ValueExpression.get(ValueLong.get(this.readLong())));
            }
            this.read(70);
        }
        column.setAutoIncrementOptions(options);
    }

    private String readCommentIf() {
        if (this.readIf("COMMENT")) {
            this.readIf(29);
            return this.readString();
        }
        return null;
    }

    private Column parseColumnWithType(String columnName, boolean forTable) {
        DataType dataType;
        Domain domain;
        String original = this.currentToken;
        boolean regular = false;
        int originalPrecision = -1;
        int originalScale = -1;
        if (this.readIf("LONG")) {
            if (this.readIf("RAW")) {
                original = "LONG RAW";
            }
        } else if (this.readIf("DOUBLE")) {
            if (this.readIf("PRECISION")) {
                original = "DOUBLE PRECISION";
            }
        } else if (this.readIf("CHARACTER")) {
            if (this.readIf("VARYING")) {
                original = "CHARACTER VARYING";
            } else if (this.readIf("LARGE")) {
                this.read("OBJECT");
                original = "CHARACTER LARGE OBJECT";
            }
        } else if (this.readIf("BINARY")) {
            if (this.readIf("VARYING")) {
                original = "BINARY VARYING";
            } else if (this.readIf("LARGE")) {
                this.read("OBJECT");
                original = "BINARY LARGE OBJECT";
            }
        } else if (this.readIf("TIME")) {
            if (this.readIf(69)) {
                originalScale = this.readNonNegativeInt();
                if (originalScale > 9) {
                    throw DbException.get(90051, Integer.toString(originalScale));
                }
                this.read(70);
            }
            if (this.readIf("WITHOUT")) {
                this.read("TIME");
                this.read("ZONE");
                original = "TIME WITHOUT TIME ZONE";
            }
        } else if (this.readIf("TIMESTAMP")) {
            if (this.readIf(69)) {
                originalScale = this.readNonNegativeInt();
                if (this.readIf(73)) {
                    originalScale = this.readNonNegativeInt();
                }
                if (originalScale > 9) {
                    throw DbException.get(90051, Integer.toString(originalScale));
                }
                this.read(70);
            }
            if (this.readIf(55)) {
                this.read("TIME");
                this.read("ZONE");
                original = "TIMESTAMP WITH TIME ZONE";
            } else if (this.readIf("WITHOUT")) {
                this.read("TIME");
                this.read("ZONE");
                original = "TIMESTAMP WITHOUT TIME ZONE";
            }
        } else if (this.readIf(28)) {
            if (this.readIf("YEAR")) {
                if (this.readIf(69)) {
                    originalPrecision = this.readNonNegativeInt();
                    this.read(70);
                }
                if (this.readIf("TO")) {
                    this.read("MONTH");
                    original = "INTERVAL YEAR TO MONTH";
                } else {
                    original = "INTERVAL YEAR";
                }
            } else if (this.readIf("MONTH")) {
                if (this.readIf(69)) {
                    originalPrecision = this.readNonNegativeInt();
                    this.read(70);
                }
                original = "INTERVAL MONTH";
            } else if (this.readIf("DAY")) {
                if (this.readIf(69)) {
                    originalPrecision = this.readNonNegativeInt();
                    this.read(70);
                }
                if (this.readIf("TO")) {
                    if (this.readIf("HOUR")) {
                        original = "INTERVAL DAY TO HOUR";
                    } else if (this.readIf("MINUTE")) {
                        original = "INTERVAL DAY TO MINUTE";
                    } else {
                        this.read("SECOND");
                        if (this.readIf(69)) {
                            originalScale = this.readNonNegativeInt();
                            this.read(70);
                        }
                        original = "INTERVAL DAY TO SECOND";
                    }
                } else {
                    original = "INTERVAL DAY";
                }
            } else if (this.readIf("HOUR")) {
                if (this.readIf(69)) {
                    originalPrecision = this.readNonNegativeInt();
                    this.read(70);
                }
                if (this.readIf("TO")) {
                    if (this.readIf("MINUTE")) {
                        original = "INTERVAL HOUR TO MINUTE";
                    } else {
                        this.read("SECOND");
                        if (this.readIf(69)) {
                            originalScale = this.readNonNegativeInt();
                            this.read(70);
                        }
                        original = "INTERVAL HOUR TO SECOND";
                    }
                } else {
                    original = "INTERVAL HOUR";
                }
            } else if (this.readIf("MINUTE")) {
                if (this.readIf(69)) {
                    originalPrecision = this.readNonNegativeInt();
                    this.read(70);
                }
                if (this.readIf("TO")) {
                    this.read("SECOND");
                    if (this.readIf(69)) {
                        originalScale = this.readNonNegativeInt();
                        this.read(70);
                    }
                    original = "INTERVAL MINUTE TO SECOND";
                } else {
                    original = "INTERVAL MINUTE";
                }
            } else {
                this.read("SECOND");
                if (this.readIf(69)) {
                    originalPrecision = this.readNonNegativeInt();
                    if (this.readIf(73)) {
                        originalScale = this.readNonNegativeInt();
                    }
                    this.read(70);
                }
                original = "INTERVAL SECOND";
            }
        } else {
            regular = true;
        }
        long precision = -1L;
        ExtTypeInfo extTypeInfo = null;
        int scale = -1;
        String comment = null;
        Column templateColumn = null;
        if (!this.identifiersToUpper) {
            original = StringUtils.toUpperEnglish(original);
        }
        if ((domain = this.database.findDomain(original)) != null) {
            templateColumn = domain.getColumn();
            TypeInfo type = templateColumn.getType();
            dataType = DataType.getDataType(type.getValueType());
            comment = templateColumn.getComment();
            original = forTable ? domain.getSQL(true) : templateColumn.getOriginalSQL();
            precision = type.getPrecision();
            scale = type.getScale();
            extTypeInfo = type.getExtTypeInfo();
        } else {
            Mode mode = this.database.getMode();
            dataType = DataType.getTypeByName(original, mode);
            if (dataType == null || mode.disallowedTypes.contains(original)) {
                throw DbException.get(50004, this.currentToken);
            }
        }
        if (this.database.getIgnoreCase() && dataType.type == 13 && !this.equalsToken("VARCHAR_CASESENSITIVE", original)) {
            original = "VARCHAR_IGNORECASE";
            dataType = DataType.getTypeByName(original, this.database.getMode());
        }
        if (regular) {
            this.read();
        }
        precision = precision == -1L ? dataType.defaultPrecision : precision;
        int n = scale = scale == -1 ? dataType.defaultScale : scale;
        if (dataType.supportsPrecision || dataType.supportsScale) {
            int t = dataType.type;
            if (t == 9 || t == 11 || t == 24) {
                if (originalScale >= 0) {
                    scale = originalScale;
                    switch (t) {
                        case 9: {
                            if (original.equals("TIME WITHOUT TIME ZONE")) {
                                original = "TIME(" + originalScale + ") WITHOUT TIME ZONE";
                                break;
                            }
                            original = original + '(' + originalScale + ')';
                            break;
                        }
                        case 11: {
                            if (original.equals("TIMESTAMP WITHOUT TIME ZONE")) {
                                original = "TIMESTAMP(" + originalScale + ") WITHOUT TIME ZONE";
                                break;
                            }
                            original = original + '(' + originalScale + ')';
                            break;
                        }
                        case 24: {
                            original = "TIMESTAMP(" + originalScale + ") WITH TIME ZONE";
                        }
                    }
                } else if (original.equals("DATETIME") || original.equals("DATETIME2")) {
                    if (this.readIf(69)) {
                        originalScale = this.readNonNegativeInt();
                        if (originalScale > 9) {
                            throw DbException.get(90051, Integer.toString(originalScale));
                        }
                        this.read(70);
                        scale = originalScale;
                        original = original + '(' + originalScale + ')';
                    }
                } else if (original.equals("SMALLDATETIME")) {
                    scale = 0;
                }
            } else if (DataType.isIntervalType(t)) {
                if (originalPrecision >= 0 || originalScale >= 0) {
                    IntervalQualifier qualifier = IntervalQualifier.valueOf(t - 26);
                    original = qualifier.getTypeName(originalPrecision, originalScale);
                    if (originalPrecision >= 0) {
                        if (originalPrecision <= 0 || originalPrecision > 18) {
                            throw DbException.get(90051, Integer.toString(originalPrecision));
                        }
                        precision = originalPrecision;
                    }
                    if (originalScale >= 0) {
                        if (originalScale > 9) {
                            throw DbException.get(90051, Integer.toString(originalScale));
                        }
                        scale = originalScale;
                    }
                }
            } else if (this.readIf(69)) {
                if (!this.readIf("MAX")) {
                    long p = this.readPrecision();
                    original = original + "(" + p;
                    if (dataType.supportsScale) {
                        if (this.readIf(73)) {
                            scale = this.readInt();
                            original = original + ", " + scale;
                        } else {
                            scale = 0;
                        }
                    }
                    precision = p;
                    original = original + ")";
                }
                this.read(70);
            }
        } else if (dataType.type == 7 && original.equals("FLOAT")) {
            if (this.readIf(69)) {
                int p = this.readNonNegativeInt();
                this.read(70);
                if (p > 53) {
                    throw DbException.get(90051, Integer.toString(p));
                }
                if (p <= 24) {
                    dataType = DataType.getDataType(8);
                }
                original = original + '(' + p + ')';
            }
        } else if (dataType.type == 25) {
            if (extTypeInfo == null) {
                String[] enumerators = null;
                if (this.readIf(69)) {
                    ArrayList<String> enumeratorList = new ArrayList<String>();
                    String enumerator0 = this.readString();
                    enumeratorList.add(enumerator0);
                    while (this.readIfMore(true)) {
                        String enumeratorN = this.readString();
                        enumeratorList.add(enumeratorN);
                    }
                    enumerators = enumeratorList.toArray(new String[0]);
                }
                try {
                    extTypeInfo = new ExtTypeInfoEnum(enumerators);
                }
                catch (DbException e) {
                    throw e.addSQL(original);
                }
                original = original + extTypeInfo.getCreateSQL();
            }
        } else if (dataType.type == 22) {
            if (extTypeInfo == null && this.readIf(69)) {
                int type = 0;
                if (this.currentTokenType != 2 || this.currentTokenQuoted) {
                    throw this.getSyntaxError();
                }
                if (!this.readIf("GEOMETRY")) {
                    try {
                        type = EWKTUtils.parseGeometryType(this.currentToken);
                        this.read();
                        if (type / 1000 == 0 && this.currentTokenType == 2 && !this.currentTokenQuoted) {
                            type += EWKTUtils.parseDimensionSystem(this.currentToken) * 1000;
                            this.read();
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        throw this.getSyntaxError();
                    }
                }
                Integer srid = null;
                if (this.readIf(73)) {
                    srid = this.readInt();
                }
                this.read(70);
                extTypeInfo = new ExtTypeInfoGeometry(type, srid);
                original = original + extTypeInfo.getCreateSQL();
            }
        } else if (this.readIf(69)) {
            this.readNonNegativeInt();
            this.read(70);
        }
        if (this.readIf(18)) {
            this.read("BIT");
            this.read("DATA");
            if (dataType.type == 13) {
                dataType = DataType.getTypeByName("BINARY", this.database.getMode());
            }
        }
        this.readIf("UNSIGNED");
        int type = dataType.type;
        if ((long)scale > precision && dataType.supportsPrecision && dataType.supportsScale && !DataType.isIntervalType(type)) {
            throw DbException.get(90051, Integer.toString(scale), Long.toString(precision));
        }
        Column column = new Column(columnName, TypeInfo.getTypeInfo(type, precision, scale, extTypeInfo));
        if (templateColumn != null) {
            column.setNullable(templateColumn.isNullable());
            column.setDefaultExpression(this.session, templateColumn.getDefaultExpression());
            int selectivity = templateColumn.getSelectivity();
            if (selectivity != 50) {
                column.setSelectivity(selectivity);
            }
            Expression checkConstraint = templateColumn.getCheckConstraint(this.session, columnName);
            column.addCheckConstraint(this.session, checkConstraint);
        }
        column.setComment(comment);
        column.setOriginalSQL(original);
        if (forTable) {
            column.setDomain(domain);
        }
        return column;
    }

    private long readPrecision() {
        long p = this.readNonNegativeLong();
        if (this.currentTokenType == 2 && !this.currentTokenQuoted && this.currentToken.length() == 1) {
            long mul;
            char ch = this.currentToken.charAt(0);
            switch (this.identifiersToUpper ? ch : Character.toUpperCase(ch)) {
                case 'K': {
                    mul = 1024L;
                    break;
                }
                case 'M': {
                    mul = 0x100000L;
                    break;
                }
                case 'G': {
                    mul = 0x40000000L;
                    break;
                }
                case 'T': {
                    mul = 0x10000000000L;
                    break;
                }
                case 'P': {
                    mul = 0x4000000000000L;
                    break;
                }
                default: {
                    throw this.getSyntaxError();
                }
            }
            if (p > Long.MAX_VALUE / mul) {
                throw DbException.getInvalidValueException("precision", p + this.currentToken);
            }
            p *= mul;
            this.read();
        }
        if (!(this.currentTokenType != 2 || this.currentTokenQuoted || this.readIf("CHARACTERS") || this.readIf("OCTETS") || this.readIf("CHAR"))) {
            this.readIf("BYTE");
        }
        return p;
    }

    private Prepared parseCreate() {
        boolean orReplace = false;
        if (this.readIf("OR")) {
            this.read("REPLACE");
            orReplace = true;
        }
        boolean force = this.readIf("FORCE");
        if (this.readIf("VIEW")) {
            return this.parseCreateView(force, orReplace);
        }
        if (this.readIf("ALIAS")) {
            return this.parseCreateFunctionAlias(force);
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseCreateSequence();
        }
        if (this.readIf("USER")) {
            return this.parseCreateUser();
        }
        if (this.readIf("TRIGGER")) {
            return this.parseCreateTrigger(force);
        }
        if (this.readIf("ROLE")) {
            return this.parseCreateRole();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseCreateSchema();
        }
        if (this.readIf("CONSTANT")) {
            return this.parseCreateConstant();
        }
        if (this.readIf("DOMAIN") || this.readIf("TYPE") || this.readIf("DATATYPE")) {
            return this.parseCreateDomain();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseCreateAggregate(force);
        }
        if (this.readIf("LINKED")) {
            return this.parseCreateLinkedTable(false, false, force);
        }
        boolean memory = false;
        boolean cached = false;
        if (this.readIf("MEMORY")) {
            memory = true;
        } else if (this.readIf("CACHED")) {
            cached = true;
        }
        if (this.readIf("LOCAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, false, force);
            }
            this.read(48);
            return this.parseCreateTable(true, false, cached);
        }
        if (this.readIf("GLOBAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, force);
            }
            this.read(48);
            return this.parseCreateTable(true, true, cached);
        }
        if (this.readIf("TEMP") || this.readIf("TEMPORARY")) {
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, force);
            }
            this.read(48);
            return this.parseCreateTable(true, true, cached);
        }
        if (this.readIf(48)) {
            if (!cached && !memory) {
                cached = this.database.getDefaultTableType() == 0;
            }
            return this.parseCreateTable(false, false, cached);
        }
        if (this.readIf("SYNONYM")) {
            return this.parseCreateSynonym(orReplace);
        }
        boolean hash = false;
        boolean primaryKey = false;
        boolean unique = false;
        boolean spatial = false;
        String indexName = null;
        Schema oldSchema = null;
        boolean ifNotExists = false;
        if (this.readIf(42)) {
            this.read("KEY");
            if (this.readIf("HASH")) {
                hash = true;
            }
            primaryKey = true;
            if (!this.isToken(40)) {
                ifNotExists = this.readIfNotExists();
                indexName = this.readIdentifierWithSchema(null);
                oldSchema = this.getSchema();
            }
        } else {
            if (this.readIf(51)) {
                unique = true;
            }
            if (this.readIf("HASH")) {
                hash = true;
            }
            if (this.readIf("SPATIAL")) {
                spatial = true;
            }
            if (this.readIf("INDEX")) {
                if (!this.isToken(40)) {
                    ifNotExists = this.readIfNotExists();
                    indexName = this.readIdentifierWithSchema(null);
                    oldSchema = this.getSchema();
                }
            } else {
                throw this.getSyntaxError();
            }
        }
        this.read(40);
        String tableName = this.readIdentifierWithSchema();
        this.checkSchema(oldSchema);
        CreateIndex command = new CreateIndex(this.session, this.getSchema());
        command.setIfNotExists(ifNotExists);
        command.setPrimaryKey(primaryKey);
        command.setTableName(tableName);
        command.setUnique(unique);
        command.setIndexName(indexName);
        command.setComment(this.readCommentIf());
        this.read(69);
        command.setIndexColumns(this.parseIndexColumnList());
        if (this.readIf("USING")) {
            if (hash) {
                throw this.getSyntaxError();
            }
            if (spatial) {
                throw this.getSyntaxError();
            }
            if (!this.readIf("BTREE")) {
                if (this.readIf("RTREE")) {
                    spatial = true;
                } else if (this.readIf("HASH")) {
                    hash = true;
                } else {
                    throw this.getSyntaxError();
                }
            }
        }
        command.setHash(hash);
        command.setSpatial(spatial);
        return command;
    }

    private boolean addRoleOrRight(GrantRevoke command) {
        if (this.readIf(47)) {
            command.addRight(1);
            return true;
        }
        if (this.readIf("DELETE")) {
            command.addRight(2);
            return true;
        }
        if (this.readIf("INSERT")) {
            command.addRight(4);
            return true;
        }
        if (this.readIf("UPDATE")) {
            command.addRight(8);
            return true;
        }
        if (this.readIf(3)) {
            command.addRight(15);
            return true;
        }
        if (this.readIf("ALTER")) {
            this.read("ANY");
            this.read("SCHEMA");
            command.addRight(16);
            command.addTable(null);
            return false;
        }
        if (this.readIf("CONNECT")) {
            return true;
        }
        if (this.readIf("RESOURCE")) {
            return true;
        }
        command.addRoleName(this.readUniqueIdentifier());
        return false;
    }

    private GrantRevoke parseGrantRevoke(int operationType) {
        GrantRevoke command = new GrantRevoke(this.session);
        command.setOperationType(operationType);
        boolean tableClauseExpected = this.addRoleOrRight(command);
        while (this.readIf(73)) {
            this.addRoleOrRight(command);
            if (!command.isRightMode() || !command.isRoleMode()) continue;
            throw DbException.get(90072);
        }
        if (tableClauseExpected && this.readIf(40)) {
            if (this.readIf("SCHEMA")) {
                Schema schema = this.database.getSchema(this.readAliasIdentifier());
                command.setSchema(schema);
            } else {
                do {
                    Table table = this.readTableOrView();
                    command.addTable(table);
                } while (this.readIf(73));
            }
        }
        if (operationType == 49) {
            this.read("TO");
        } else {
            this.read(20);
        }
        command.setGranteeName(this.readUniqueIdentifier());
        return command;
    }

    private Select parseValues() {
        Select command;
        this.currentSelect = command = new Select(this.session, this.currentSelect);
        TableFilter filter = this.parseValuesTable(0);
        command.setWildcard();
        command.addTableFilter(filter, true);
        return command;
    }

    private TableFilter parseValuesTable(int orderInFrom) {
        Schema mainSchema = this.database.getMainSchema();
        TableFunction tf = (TableFunction)Function.getFunction(this.database, "TABLE");
        ArrayList<Column> columns = Utils.newSmallArrayList();
        ArrayList<ArrayList> rows = Utils.newSmallArrayList();
        do {
            boolean multiColumn;
            int i = 0;
            ArrayList row = Utils.newSmallArrayList();
            if (this.readIf(44)) {
                this.read(69);
                multiColumn = true;
            } else {
                multiColumn = this.readIf(69);
            }
            do {
                Column column;
                Expression expr = this.readExpression();
                expr = expr.optimize(this.session);
                TypeInfo type = expr.getType();
                String columnName = "C" + (i + 1);
                if (rows.isEmpty()) {
                    if (type.getValueType() == -1) {
                        type = TypeInfo.TYPE_STRING;
                    }
                    column = new Column(columnName, type);
                    columns.add(column);
                } else {
                    if (i >= columns.size()) {
                        throw DbException.get(21002);
                    }
                    type = Value.getHigherType(((Column)columns.get(i)).getType(), type);
                    column = new Column(columnName, type);
                    columns.set(i, column);
                }
                row.add(expr);
                ++i;
            } while (multiColumn && this.readIfMore(true));
            rows.add(row);
        } while (this.readIf(73));
        int columnCount = columns.size();
        int rowCount = rows.size();
        for (ArrayList row : rows) {
            if (row.size() == columnCount) continue;
            throw DbException.get(21002);
        }
        for (int i = 0; i < columnCount; ++i) {
            Column c = (Column)columns.get(i);
            if (c.getType().getValueType() == -1) {
                c = new Column(c.getName(), 13);
                columns.set(i, c);
            }
            Expression[] array = new Expression[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                array[j] = (Expression)rows.get(j).get(i);
            }
            ExpressionList list = new ExpressionList(array, false);
            tf.setParameter(i, list);
        }
        tf.setColumns(columns);
        tf.doneWithParameters();
        FunctionTable table = new FunctionTable(mainSchema, this.session, tf, tf);
        return new TableFilter(this.session, table, null, this.rightsChecked, this.currentSelect, orderInFrom, null);
    }

    private Call parseCall() {
        Call command = new Call(this.session);
        this.currentPrepared = command;
        command.setExpression(this.readExpression());
        return command;
    }

    private CreateRole parseCreateRole() {
        CreateRole command = new CreateRole(this.session);
        command.setIfNotExists(this.readIfNotExists());
        command.setRoleName(this.readUniqueIdentifier());
        return command;
    }

    private CreateSchema parseCreateSchema() {
        CreateSchema command = new CreateSchema(this.session);
        command.setIfNotExists(this.readIfNotExists());
        command.setSchemaName(this.readUniqueIdentifier());
        if (this.readIf("AUTHORIZATION")) {
            command.setAuthorization(this.readUniqueIdentifier());
        } else {
            command.setAuthorization(this.session.getUser().getName());
        }
        if (this.readIf(55)) {
            command.setTableEngineParams(this.readTableEngineParams());
        }
        return command;
    }

    private ArrayList<String> readTableEngineParams() {
        ArrayList<String> tableEngineParams = Utils.newSmallArrayList();
        do {
            tableEngineParams.add(this.readUniqueIdentifier());
        } while (this.readIf(73));
        return tableEngineParams;
    }

    private CreateSequence parseCreateSequence() {
        boolean ifNotExists = this.readIfNotExists();
        String sequenceName = this.readIdentifierWithSchema();
        CreateSequence command = new CreateSequence(this.session, this.getSchema());
        command.setIfNotExists(ifNotExists);
        command.setSequenceName(sequenceName);
        SequenceOptions options = new SequenceOptions();
        this.parseSequenceOptions(options, command, true);
        command.setOptions(options);
        return command;
    }

    private boolean readIfNotExists() {
        if (this.readIf(24)) {
            this.read(37);
            this.read(15);
            return true;
        }
        return false;
    }

    private boolean readIfAffinity() {
        return this.readIf("AFFINITY") || this.readIf("SHARD");
    }

    private CreateConstant parseCreateConstant() {
        boolean ifNotExists = this.readIfNotExists();
        String constantName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.isKeyword(constantName)) {
            throw DbException.get(90114, constantName);
        }
        this.read("VALUE");
        Expression expr = this.readExpression();
        CreateConstant command = new CreateConstant(this.session, schema);
        command.setConstantName(constantName);
        command.setExpression(expr);
        command.setIfNotExists(ifNotExists);
        return command;
    }

    private CreateAggregate parseCreateAggregate(boolean force) {
        boolean ifNotExists = this.readIfNotExists();
        CreateAggregate command = new CreateAggregate(this.session);
        command.setForce(force);
        String name = this.readIdentifierWithSchema();
        if (this.isKeyword(name) || Function.getFunction(this.database, name) != null || this.getAggregateType(name) != null) {
            throw DbException.get(90076, name);
        }
        command.setName(name);
        command.setSchema(this.getSchema());
        command.setIfNotExists(ifNotExists);
        this.read(18);
        command.setJavaClassMethod(this.readUniqueIdentifier());
        return command;
    }

    private CreateDomain parseCreateDomain() {
        boolean ifNotExists = this.readIfNotExists();
        CreateDomain command = new CreateDomain(this.session);
        command.setTypeName(this.readUniqueIdentifier());
        this.read("AS");
        Column col = this.parseColumnForTable("VALUE", true, false);
        if (this.readIf(6)) {
            Expression expr = this.readExpression();
            col.addCheckConstraint(this.session, expr);
        }
        col.rename(null);
        command.setColumn(col);
        command.setIfNotExists(ifNotExists);
        return command;
    }

    private CreateTrigger parseCreateTrigger(boolean force) {
        boolean insteadOf;
        boolean isBefore;
        boolean ifNotExists = this.readIfNotExists();
        String triggerName = this.readIdentifierWithSchema(null);
        Schema schema = this.getSchema();
        if (this.readIf("INSTEAD")) {
            this.read("OF");
            isBefore = true;
            insteadOf = true;
        } else if (this.readIf("BEFORE")) {
            insteadOf = false;
            isBefore = true;
        } else {
            this.read("AFTER");
            insteadOf = false;
            isBefore = false;
        }
        int typeMask = 0;
        boolean onRollback = false;
        do {
            if (this.readIf("INSERT")) {
                typeMask |= 1;
                continue;
            }
            if (this.readIf("UPDATE")) {
                typeMask |= 2;
                continue;
            }
            if (this.readIf("DELETE")) {
                typeMask |= 4;
                continue;
            }
            if (this.readIf(47)) {
                typeMask |= 8;
                continue;
            }
            if (this.readIf("ROLLBACK")) {
                onRollback = true;
                continue;
            }
            throw this.getSyntaxError();
        } while (this.readIf(73) || this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL && this.readIf("OR"));
        this.read(40);
        String tableName = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateTrigger command = new CreateTrigger(this.session, this.getSchema());
        command.setForce(force);
        command.setTriggerName(triggerName);
        command.setIfNotExists(ifNotExists);
        command.setInsteadOf(insteadOf);
        command.setBefore(isBefore);
        command.setOnRollback(onRollback);
        command.setTypeMask(typeMask);
        command.setTableName(tableName);
        if (this.readIf(18)) {
            this.read("EACH");
            this.read(44);
            command.setRowBased(true);
        } else {
            command.setRowBased(false);
        }
        if (this.readIf("QUEUE")) {
            command.setQueueSize(this.readNonNegativeInt());
        }
        command.setNoWait(this.readIf("NOWAIT"));
        if (this.readIf("AS")) {
            command.setTriggerSource(this.readString());
        } else {
            this.read("CALL");
            command.setTriggerClassName(this.readUniqueIdentifier());
        }
        return command;
    }

    private CreateUser parseCreateUser() {
        CreateUser command = new CreateUser(this.session);
        command.setIfNotExists(this.readIfNotExists());
        command.setUserName(this.readUniqueIdentifier());
        command.setComment(this.readCommentIf());
        if (this.readIf("PASSWORD")) {
            command.setPassword(this.readExpression());
        } else if (this.readIf("SALT")) {
            command.setSalt(this.readExpression());
            this.read("HASH");
            command.setHash(this.readExpression());
        } else if (this.readIf("IDENTIFIED")) {
            this.read("BY");
            command.setPassword(ValueExpression.get(ValueString.get(this.readColumnIdentifier())));
        } else {
            throw this.getSyntaxError();
        }
        if (this.readIf("ADMIN")) {
            command.setAdmin(true);
        }
        return command;
    }

    private CreateFunctionAlias parseCreateFunctionAlias(boolean force) {
        boolean newAliasSameNameAsBuiltin;
        String aliasName;
        boolean ifNotExists = this.readIfNotExists();
        if (this.currentTokenType != 2) {
            aliasName = this.currentToken;
            this.read();
            this.schemaName = this.session.getCurrentSchemaName();
        } else {
            aliasName = this.readIdentifierWithSchema();
        }
        boolean bl = newAliasSameNameAsBuiltin = Function.getFunction(this.database, aliasName) != null;
        if (!(this.database.isAllowBuiltinAliasOverride() && newAliasSameNameAsBuiltin || !this.isKeyword(aliasName) && !newAliasSameNameAsBuiltin && this.getAggregateType(aliasName) == null)) {
            throw DbException.get(90076, aliasName);
        }
        CreateFunctionAlias command = new CreateFunctionAlias(this.session, this.getSchema());
        command.setForce(force);
        command.setAliasName(aliasName);
        command.setIfNotExists(ifNotExists);
        command.setDeterministic(this.readIf("DETERMINISTIC"));
        command.setBufferResultSetToLocalTemp(!this.readIf("NOBUFFER"));
        if (this.readIf("AS")) {
            command.setSource(this.readString());
        } else {
            this.read(18);
            command.setJavaClassMethod(this.readUniqueIdentifier());
        }
        return command;
    }

    private Prepared parseWith() {
        ArrayList<TableView> viewsCreated = new ArrayList<TableView>();
        try {
            return this.parseWith1(viewsCreated);
        }
        catch (Throwable t) {
            CommandContainer.clearCTE(this.session, viewsCreated);
            throw t;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Prepared parseWith1(List<TableView> viewsCreated) {
        Prepared p;
        this.readIf("RECURSIVE");
        boolean isTemporary = !this.session.isParsingCreateView();
        do {
            viewsCreated.add(this.parseSingleCommonTableExpression(isTemporary));
        } while (this.readIf(73));
        Collections.reverse(viewsCreated);
        int parentheses = 0;
        while (this.readIf(69)) {
            ++parentheses;
        }
        if (this.isToken(47) || this.isToken(52)) {
            p = this.parseWithQuery();
        } else if (this.isToken(48)) {
            int index = this.lastParseIndex;
            this.read();
            if (this.isToken(69)) throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            this.parseIndex = index;
            this.read();
            p = this.parseWithQuery();
        } else if (this.readIf("INSERT")) {
            p = this.parseInsert();
            p.setPrepareAlways(true);
        } else if (this.readIf("UPDATE")) {
            p = this.parseUpdate();
            p.setPrepareAlways(true);
        } else if (this.readIf("MERGE")) {
            p = this.parseMerge();
            p.setPrepareAlways(true);
        } else if (this.readIf("DELETE")) {
            p = this.parseDelete();
            p.setPrepareAlways(true);
        } else {
            if (!this.readIf("CREATE")) throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            if (!this.isToken(48)) {
                throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            }
            p = this.parseCreate();
            p.setPrepareAlways(true);
        }
        while (parentheses > 0) {
            this.read(70);
            --parentheses;
        }
        if (!isTemporary) return p;
        p.setCteCleanups(viewsCreated);
        return p;
    }

    private Prepared parseWithQuery() {
        Query query = this.parseSelectUnion();
        query.setPrepareAlways(true);
        query.setNeverLazy(true);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableView parseSingleCommonTableExpression(boolean isTemporary) {
        List<Column> columnTemplateList;
        Table oldViewFound;
        String cteViewName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        ArrayList<Column> columns = Utils.newSmallArrayList();
        String[] cols = null;
        if (this.readIf(69)) {
            for (String c : cols = this.parseColumnList()) {
                columns.add(new Column(c, 13));
            }
        }
        if ((oldViewFound = !isTemporary ? this.getSchema().findTableOrView(this.session, cteViewName) : this.session.findLocalTempTable(cteViewName)) != null) {
            if (!(oldViewFound instanceof TableView)) {
                throw DbException.get(42101, cteViewName);
            }
            TableView tv = (TableView)oldViewFound;
            if (!tv.isTableExpression()) {
                throw DbException.get(42101, cteViewName);
            }
            if (!isTemporary) {
                oldViewFound.lock(this.session, true, true);
                this.database.removeSchemaObject(this.session, oldViewFound);
            } else {
                this.session.removeLocalTempTable(oldViewFound);
            }
        }
        Table recursiveTable = TableView.createShadowTableForRecursiveTableExpression(isTemporary, this.session, cteViewName, schema, columns, this.database);
        String[] querySQLOutput = new String[]{null};
        try {
            this.read("AS");
            this.read(69);
            Query withQuery = this.parseSelect();
            if (!isTemporary) {
                withQuery.session = this.session;
            }
            this.read(70);
            columnTemplateList = TableView.createQueryColumnTemplateList(cols, withQuery, querySQLOutput);
        }
        finally {
            TableView.destroyShadowTableForRecursiveExpression(isTemporary, this.session, recursiveTable);
        }
        return this.createCTEView(cteViewName, querySQLOutput[0], columnTemplateList, true, true, isTemporary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableView createCTEView(String cteViewName, String querySQL, List<Column> columnTemplateList, boolean allowRecursiveQueryDetection, boolean addViewToSession, boolean isTemporary) {
        TableView view;
        Database db = this.session.getDatabase();
        Schema schema = this.getSchemaWithDefault();
        int id = db.allocateObjectId();
        Column[] columnTemplateArray = columnTemplateList.toArray(new Column[0]);
        Session session = this.session;
        synchronized (session) {
            view = new TableView(schema, id, cteViewName, querySQL, this.parameters, columnTemplateArray, this.session, allowRecursiveQueryDetection, false, true, isTemporary);
            if (!view.isRecursiveQueryDetected() && allowRecursiveQueryDetection) {
                if (!isTemporary) {
                    db.addSchemaObject(this.session, view);
                    view.lock(this.session, true, true);
                    db.removeSchemaObject(this.session, view);
                } else {
                    this.session.removeLocalTempTable(view);
                }
                view = new TableView(schema, id, cteViewName, querySQL, this.parameters, columnTemplateArray, this.session, false, false, true, isTemporary);
            }
            db.unlockMeta(this.session);
        }
        view.setTableExpression(true);
        view.setTemporary(isTemporary);
        view.setHidden(true);
        view.setOnCommitDrop(false);
        if (addViewToSession) {
            if (!isTemporary) {
                db.addSchemaObject(this.session, view);
                view.unlock(this.session);
                db.unlockMeta(this.session);
            } else {
                this.session.addLocalTempTable(view);
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateView parseCreateView(boolean force, boolean orReplace) {
        CreateView command;
        boolean ifNotExists = this.readIfNotExists();
        boolean isTableExpression = this.readIf("TABLE_EXPRESSION");
        String viewName = this.readIdentifierWithSchema();
        this.createView = command = new CreateView(this.session, this.getSchema());
        command.setViewName(viewName);
        command.setIfNotExists(ifNotExists);
        command.setComment(this.readCommentIf());
        command.setOrReplace(orReplace);
        command.setForce(force);
        command.setTableExpression(isTableExpression);
        if (this.readIf(69)) {
            String[] cols = this.parseColumnList();
            command.setColumnNames(cols);
        }
        String select = StringUtils.cache(this.sqlCommand.substring(this.parseIndex));
        this.read("AS");
        try {
            Query query;
            this.session.setParsingCreateView(true, viewName);
            try {
                query = this.parseSelect();
                query.prepare();
            }
            finally {
                this.session.setParsingCreateView(false, viewName);
            }
            command.setSelect(query);
        }
        catch (DbException e) {
            if (force) {
                command.setSelectSQL(select);
                while (this.currentTokenType != 57) {
                    this.read();
                }
            }
            throw e;
        }
        return command;
    }

    private TransactionCommand parseCheckpoint() {
        TransactionCommand command = this.readIf("SYNC") ? new TransactionCommand(this.session, 76) : new TransactionCommand(this.session, 73);
        return command;
    }

    private Prepared parseAlter() {
        if (this.readIf(48)) {
            return this.parseAlterTable();
        }
        if (this.readIf("USER")) {
            return this.parseAlterUser();
        }
        if (this.readIf("INDEX")) {
            return this.parseAlterIndex();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseAlterSchema();
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseAlterSequence();
        }
        if (this.readIf("VIEW")) {
            return this.parseAlterView();
        }
        throw this.getSyntaxError();
    }

    private void checkSchema(Schema old) {
        if (old != null && this.getSchema() != old) {
            throw DbException.get(90080);
        }
    }

    private AlterIndexRename parseAlterIndex() {
        boolean ifExists = this.readIfExists(false);
        String indexName = this.readIdentifierWithSchema();
        Schema old = this.getSchema();
        AlterIndexRename command = new AlterIndexRename(this.session);
        command.setOldSchema(old);
        command.setOldName(indexName);
        command.setIfExists(ifExists);
        this.read("RENAME");
        this.read("TO");
        String newName = this.readIdentifierWithSchema(old.getName());
        this.checkSchema(old);
        command.setNewName(newName);
        return command;
    }

    private DefineCommand parseAlterView() {
        boolean ifExists = this.readIfExists(false);
        String viewName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        Table tableView = schema.findTableOrView(this.session, viewName);
        if (!(tableView instanceof TableView) && !ifExists) {
            throw DbException.get(90037, viewName);
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            String newName = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            AlterTableRename command = new AlterTableRename(this.session, this.getSchema());
            command.setOldTableName(viewName);
            command.setNewTableName(newName);
            command.setIfTableExists(ifExists);
            return command;
        }
        this.read("RECOMPILE");
        TableView view = (TableView)tableView;
        AlterView command = new AlterView(this.session);
        command.setIfExists(ifExists);
        command.setView(view);
        return command;
    }

    private Prepared parseAlterSchema() {
        boolean ifExists = this.readIfExists(false);
        String schemaName = this.readIdentifierWithSchema();
        Schema old = this.getSchema();
        this.read("RENAME");
        this.read("TO");
        String newName = this.readIdentifierWithSchema(old.getName());
        Schema schema = this.findSchema(schemaName);
        if (schema == null) {
            if (ifExists) {
                return new NoOperation(this.session);
            }
            throw DbException.get(90079, schemaName);
        }
        AlterSchemaRename command = new AlterSchemaRename(this.session);
        command.setOldSchema(schema);
        this.checkSchema(old);
        command.setNewName(newName);
        return command;
    }

    private AlterSequence parseAlterSequence() {
        boolean ifExists = this.readIfExists(false);
        String sequenceName = this.readIdentifierWithSchema();
        AlterSequence command = new AlterSequence(this.session, this.getSchema());
        command.setSequenceName(sequenceName);
        command.setIfExists(ifExists);
        SequenceOptions options = new SequenceOptions();
        this.parseSequenceOptions(options, null, false);
        command.setOptions(options);
        return command;
    }

    private void parseSequenceOptions(SequenceOptions options, CreateSequence command, boolean forCreate) {
        while (true) {
            if (this.readIf(forCreate ? "START" : "RESTART")) {
                this.readIf(55);
                options.setStartValue(this.readExpression());
                continue;
            }
            if (this.readIf("INCREMENT")) {
                this.readIf("BY");
                options.setIncrement(this.readExpression());
                continue;
            }
            if (this.readIf("MINVALUE")) {
                options.setMinValue(this.readExpression());
                continue;
            }
            if (this.readIf("NOMINVALUE")) {
                options.setMinValue(ValueExpression.getNull());
                continue;
            }
            if (this.readIf("MAXVALUE")) {
                options.setMaxValue(this.readExpression());
                continue;
            }
            if (this.readIf("NOMAXVALUE")) {
                options.setMaxValue(ValueExpression.getNull());
                continue;
            }
            if (this.readIf("CYCLE")) {
                options.setCycle(true);
                continue;
            }
            if (this.readIf("NOCYCLE")) {
                options.setCycle(false);
                continue;
            }
            if (this.readIf("NO")) {
                if (this.readIf("MINVALUE")) {
                    options.setMinValue(ValueExpression.getNull());
                    continue;
                }
                if (this.readIf("MAXVALUE")) {
                    options.setMaxValue(ValueExpression.getNull());
                    continue;
                }
                if (this.readIf("CYCLE")) {
                    options.setCycle(false);
                    continue;
                }
                if (!this.readIf("CACHE")) break;
                options.setCacheSize(ValueExpression.get(ValueLong.get(1L)));
                continue;
            }
            if (this.readIf("CACHE")) {
                options.setCacheSize(this.readExpression());
                continue;
            }
            if (this.readIf("NOCACHE")) {
                options.setCacheSize(ValueExpression.get(ValueLong.get(1L)));
                continue;
            }
            if (command == null) break;
            if (this.readIf("BELONGS_TO_TABLE")) {
                command.setBelongsToTable(true);
                continue;
            }
            if (!this.readIf(41)) break;
        }
    }

    private AlterUser parseAlterUser() {
        String userName = this.readUniqueIdentifier();
        if (this.readIf("SET")) {
            AlterUser command = new AlterUser(this.session);
            command.setType(19);
            command.setUser(this.database.getUser(userName));
            if (this.readIf("PASSWORD")) {
                command.setPassword(this.readExpression());
            } else if (this.readIf("SALT")) {
                command.setSalt(this.readExpression());
                this.read("HASH");
                command.setHash(this.readExpression());
            } else {
                throw this.getSyntaxError();
            }
            return command;
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            AlterUser command = new AlterUser(this.session);
            command.setType(18);
            command.setUser(this.database.getUser(userName));
            String newName = this.readUniqueIdentifier();
            command.setNewName(newName);
            return command;
        }
        if (this.readIf("ADMIN")) {
            AlterUser command = new AlterUser(this.session);
            command.setType(17);
            User user = this.database.getUser(userName);
            command.setUser(user);
            if (this.readIf(49)) {
                command.setAdmin(true);
            } else if (this.readIf(16)) {
                command.setAdmin(false);
            } else {
                throw this.getSyntaxError();
            }
            return command;
        }
        throw this.getSyntaxError();
    }

    private void readIfEqualOrTo() {
        if (!this.readIf(59)) {
            this.readIf("TO");
        }
    }

    private Prepared parseSet() {
        int type;
        if (this.readIf(65)) {
            Set command = new Set(this.session, 34);
            command.setString(this.readAliasIdentifier());
            this.readIfEqualOrTo();
            command.setExpression(this.readExpression());
            return command;
        }
        if (this.readIf("AUTOCOMMIT")) {
            this.readIfEqualOrTo();
            boolean value = this.readBooleanSetting();
            int setting = value ? 69 : 70;
            return new TransactionCommand(this.session, setting);
        }
        if (this.readIf("MVCC")) {
            this.readIfEqualOrTo();
            this.readBooleanSetting();
            return new NoOperation(this.session);
        }
        if (this.readIf("EXCLUSIVE")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 32);
            command.setExpression(this.readExpression());
            return command;
        }
        if (this.readIf("IGNORECASE")) {
            this.readIfEqualOrTo();
            boolean value = this.readBooleanSetting();
            Set command = new Set(this.session, 1);
            command.setInt(value ? 1 : 0);
            return command;
        }
        if (this.readIf("PASSWORD")) {
            this.readIfEqualOrTo();
            AlterUser command = new AlterUser(this.session);
            command.setType(19);
            command.setUser(this.session.getUser());
            command.setPassword(this.readExpression());
            return command;
        }
        if (this.readIf("SALT")) {
            this.readIfEqualOrTo();
            AlterUser command = new AlterUser(this.session);
            command.setType(19);
            command.setUser(this.session.getUser());
            command.setSalt(this.readExpression());
            this.read("HASH");
            command.setHash(this.readExpression());
            return command;
        }
        if (this.readIf("MODE")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 3);
            command.setString(this.readAliasIdentifier());
            return command;
        }
        if (this.readIf("COMPRESS_LOB")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 23);
            if (this.currentTokenType == 58) {
                command.setString(this.readString());
            } else {
                command.setString(this.readUniqueIdentifier());
            }
            return command;
        }
        if (this.readIf("DATABASE")) {
            this.readIfEqualOrTo();
            this.read("COLLATION");
            return this.parseSetCollation();
        }
        if (this.readIf("COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetCollation();
        }
        if (this.readIf("BINARY_COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetBinaryCollation(37);
        }
        if (this.readIf("UUID_COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetBinaryCollation(50);
        }
        if (this.readIf("CLUSTER")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 13);
            command.setString(this.readString());
            return command;
        }
        if (this.readIf("DATABASE_EVENT_LISTENER")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 15);
            command.setString(this.readString());
            return command;
        }
        if (this.readIf("ALLOW_LITERALS")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 24);
            if (this.readIf("NONE")) {
                command.setInt(0);
            } else if (this.readIf(3)) {
                command.setInt(2);
            } else if (this.readIf("NUMBERS")) {
                command.setInt(1);
            } else {
                command.setInt(this.readNonNegativeInt());
            }
            return command;
        }
        if (this.readIf("DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 7);
            if (this.readIf("MEMORY")) {
                command.setInt(1);
            } else if (this.readIf("CACHED")) {
                command.setInt(0);
            } else {
                command.setInt(this.readNonNegativeInt());
            }
            return command;
        }
        if (this.readIf("CREATE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("HSQLDB.DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_STORE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("CACHE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("FILE_LOCK")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("DB_CLOSE_ON_EXIT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_SERVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_SERVER_PORT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_RECONNECT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ASSERT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ACCESS_MODE_DATA")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("OPEN_NEW")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("JMX")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_SIZE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("RECOVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("NAMES")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCOPE_GENERATED_KEYS")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCHEMA")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 26);
            command.setString(this.readAliasIdentifier());
            return command;
        }
        if (this.readIf("DATESTYLE")) {
            String s;
            this.readIfEqualOrTo();
            if (!this.readIf("ISO") && !this.equalsToken(s = this.readString(), "ISO")) {
                throw this.getSyntaxError();
            }
            return new NoOperation(this.session);
        }
        if (this.readIf("SEARCH_PATH") || this.readIf(SetTypes.getTypeName(28))) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 28);
            ArrayList<String> list = Utils.newSmallArrayList();
            do {
                list.add(this.readAliasIdentifier());
            } while (this.readIf(73));
            command.setStringArray(list.toArray(new String[0]));
            return command;
        }
        if (this.readIf("JAVA_OBJECT_SERIALIZER")) {
            this.readIfEqualOrTo();
            return this.parseSetJavaObjectSerializer();
        }
        if (this.isToken("LOGSIZE")) {
            this.currentToken = SetTypes.getTypeName(2);
        }
        if (this.isToken("FOREIGN_KEY_CHECKS")) {
            this.currentToken = SetTypes.getTypeName(30);
        }
        String typeName = this.currentToken;
        if (!this.identifiersToUpper) {
            typeName = StringUtils.toUpperEnglish(typeName);
        }
        if ((type = SetTypes.getType(typeName)) < 0) {
            throw this.getSyntaxError();
        }
        this.read();
        this.readIfEqualOrTo();
        Set command = new Set(this.session, type);
        command.setExpression(this.readExpression());
        return command;
    }

    private Prepared parseUse() {
        this.readIfEqualOrTo();
        Set command = new Set(this.session, 26);
        command.setString(this.readAliasIdentifier());
        return command;
    }

    private Set parseSetCollation() {
        Set command = new Set(this.session, 12);
        String name = this.readAliasIdentifier();
        command.setString(name);
        if (this.equalsToken(name, "OFF")) {
            return command;
        }
        Collator coll = CompareMode.getCollator(name);
        if (coll == null) {
            throw DbException.getInvalidValueException("collation", name);
        }
        if (this.readIf("STRENGTH")) {
            if (this.readIf(42)) {
                command.setInt(0);
            } else if (this.readIf("SECONDARY")) {
                command.setInt(1);
            } else if (this.readIf("TERTIARY")) {
                command.setInt(2);
            } else if (this.readIf("IDENTICAL")) {
                command.setInt(3);
            }
        } else {
            command.setInt(coll.getStrength());
        }
        return command;
    }

    private Set parseSetBinaryCollation(int type) {
        String name = this.readAliasIdentifier();
        if (this.equalsToken(name, "UNSIGNED") || this.equalsToken(name, "SIGNED")) {
            Set command = new Set(this.session, type);
            command.setString(name);
            return command;
        }
        throw DbException.getInvalidValueException(SetTypes.getTypeName(type), name);
    }

    private Set parseSetJavaObjectSerializer() {
        Set command = new Set(this.session, 38);
        String name = this.readString();
        command.setString(name);
        return command;
    }

    private RunScriptCommand parseRunScript() {
        RunScriptCommand command = new RunScriptCommand(this.session);
        this.read(20);
        command.setFileNameExpr(this.readExpression());
        if (this.readIf("COMPRESSION")) {
            command.setCompressionAlgorithm(this.readUniqueIdentifier());
        }
        if (this.readIf("CIPHER")) {
            command.setCipher(this.readUniqueIdentifier());
            if (this.readIf("PASSWORD")) {
                command.setPassword(this.readExpression());
            }
        }
        if (this.readIf("CHARSET")) {
            command.setCharset(Charset.forName(this.readString()));
        }
        return command;
    }

    private ScriptCommand parseScript() {
        ScriptCommand command = new ScriptCommand(this.session);
        boolean data = true;
        boolean passwords = true;
        boolean settings = true;
        boolean dropTables = false;
        boolean simple = false;
        boolean withColumns = false;
        if (this.readIf("NODATA")) {
            data = false;
        } else {
            if (this.readIf("SIMPLE")) {
                simple = true;
            }
            if (this.readIf("COLUMNS")) {
                withColumns = true;
            }
        }
        if (this.readIf("NOPASSWORDS")) {
            passwords = false;
        }
        if (this.readIf("NOSETTINGS")) {
            settings = false;
        }
        if (this.readIf("DROP")) {
            dropTables = true;
        }
        if (this.readIf("BLOCKSIZE")) {
            long blockSize = this.readLong();
            command.setLobBlockSize(blockSize);
        }
        command.setData(data);
        command.setPasswords(passwords);
        command.setSettings(settings);
        command.setDrop(dropTables);
        command.setSimple(simple);
        command.setWithColumns(withColumns);
        if (this.readIf("TO")) {
            command.setFileNameExpr(this.readExpression());
            if (this.readIf("COMPRESSION")) {
                command.setCompressionAlgorithm(this.readUniqueIdentifier());
            }
            if (this.readIf("CIPHER")) {
                command.setCipher(this.readUniqueIdentifier());
                if (this.readIf("PASSWORD")) {
                    command.setPassword(this.readExpression());
                }
            }
            if (this.readIf("CHARSET")) {
                command.setCharset(Charset.forName(this.readString()));
            }
        }
        if (this.readIf("SCHEMA")) {
            HashSet<String> schemaNames = new HashSet<String>();
            do {
                schemaNames.add(this.readUniqueIdentifier());
            } while (this.readIf(73));
            command.setSchemaNames(schemaNames);
        } else if (this.readIf(48)) {
            ArrayList<Table> tables = Utils.newSmallArrayList();
            do {
                tables.add(this.readTableOrView());
            } while (this.readIf(73));
            command.setTables(tables);
        }
        return command;
    }

    boolean isDualTable(String tableName) {
        return (this.schemaName == null || this.equalsToken(this.schemaName, "SYS")) && this.equalsToken("DUAL", tableName) || this.database.getMode().sysDummy1 && (this.schemaName == null || this.equalsToken(this.schemaName, "SYSIBM")) && this.equalsToken("SYSDUMMY1", tableName);
    }

    private Table readTableOrView() {
        return this.readTableOrView(this.readIdentifierWithSchema(null));
    }

    private Table readTableOrView(String tableName) {
        if (this.schemaName != null) {
            Table table = this.getSchema().resolveTableOrView(this.session, tableName);
            if (table != null) {
                return table;
            }
        } else {
            Table table = this.database.getSchema(this.session.getCurrentSchemaName()).resolveTableOrView(this.session, tableName);
            if (table != null) {
                return table;
            }
            String[] schemaNames = this.session.getSchemaSearchPath();
            if (schemaNames != null) {
                for (String name : schemaNames) {
                    Schema s = this.database.getSchema(name);
                    table = s.resolveTableOrView(this.session, tableName);
                    if (table == null) continue;
                    return table;
                }
            }
        }
        if (this.isDualTable(tableName)) {
            return this.getDualTable(false);
        }
        throw DbException.get(42102, tableName);
    }

    private FunctionAlias findFunctionAlias(String schema, String aliasName) {
        FunctionAlias functionAlias = this.database.getSchema(schema).findFunction(aliasName);
        if (functionAlias != null) {
            return functionAlias;
        }
        String[] schemaNames = this.session.getSchemaSearchPath();
        if (schemaNames != null) {
            for (String n : schemaNames) {
                functionAlias = this.database.getSchema(n).findFunction(aliasName);
                if (functionAlias == null) continue;
                return functionAlias;
            }
        }
        return null;
    }

    private Sequence findSequence(String schema, String sequenceName) {
        Sequence sequence = this.database.getSchema(schema).findSequence(sequenceName);
        if (sequence != null) {
            return sequence;
        }
        String[] schemaNames = this.session.getSchemaSearchPath();
        if (schemaNames != null) {
            for (String n : schemaNames) {
                sequence = this.database.getSchema(n).findSequence(sequenceName);
                if (sequence == null) continue;
                return sequence;
            }
        }
        return null;
    }

    private Sequence readSequence() {
        String sequenceName = this.readIdentifierWithSchema(null);
        if (this.schemaName != null) {
            return this.getSchema().getSequence(sequenceName);
        }
        Sequence sequence = this.findSequence(this.session.getCurrentSchemaName(), sequenceName);
        if (sequence != null) {
            return sequence;
        }
        throw DbException.get(90036, sequenceName);
    }

    private Prepared parseAlterTable() {
        boolean ifTableExists = this.readIfExists(false);
        String tableName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.readIf("ADD")) {
            DefineCommand command = this.parseAlterTableAddConstraintIf(tableName, schema, ifTableExists);
            if (command != null) {
                return command;
            }
            return this.parseAlterTableAddColumn(tableName, schema, ifTableExists);
        }
        if (this.readIf("SET")) {
            this.read("REFERENTIAL_INTEGRITY");
            int type = 55;
            boolean value = this.readBooleanSetting();
            AlterTableSet command = new AlterTableSet(this.session, schema, type, value);
            command.setTableName(tableName);
            command.setIfTableExists(ifTableExists);
            if (this.readIf(6)) {
                command.setCheckExisting(true);
            } else if (this.readIf("NOCHECK")) {
                command.setCheckExisting(false);
            }
            return command;
        }
        if (this.readIf("RENAME")) {
            if (this.readIf("COLUMN")) {
                String columnName = this.readColumnIdentifier();
                this.read("TO");
                AlterTableRenameColumn command = new AlterTableRenameColumn(this.session, schema);
                command.setTableName(tableName);
                command.setIfTableExists(ifTableExists);
                command.setOldColumnName(columnName);
                String newName = this.readColumnIdentifier();
                command.setNewColumnName(newName);
                return command;
            }
            if (this.readIf(7)) {
                String constraintName = this.readIdentifierWithSchema(schema.getName());
                this.checkSchema(schema);
                this.read("TO");
                AlterTableRenameConstraint command = new AlterTableRenameConstraint(this.session, schema);
                command.setConstraintName(constraintName);
                String newName = this.readColumnIdentifier();
                command.setNewConstraintName(newName);
                return this.commandIfTableExists(schema, tableName, ifTableExists, command);
            }
            this.read("TO");
            String newName = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            AlterTableRename command = new AlterTableRename(this.session, this.getSchema());
            command.setOldTableName(tableName);
            command.setNewTableName(newName);
            command.setIfTableExists(ifTableExists);
            command.setHidden(this.readIf("HIDDEN"));
            return command;
        }
        if (this.readIf("DROP")) {
            if (this.readIf(7)) {
                boolean ifExists = this.readIfExists(false);
                String constraintName = this.readIdentifierWithSchema(schema.getName());
                ifExists = this.readIfExists(ifExists);
                this.checkSchema(schema);
                AlterTableDropConstraint command = new AlterTableDropConstraint(this.session, this.getSchema(), ifExists);
                command.setConstraintName(constraintName);
                return this.commandIfTableExists(schema, tableName, ifTableExists, command);
            }
            if (this.readIf(19)) {
                this.read("KEY");
                String constraintName = this.readIdentifierWithSchema(schema.getName());
                this.checkSchema(schema);
                AlterTableDropConstraint command = new AlterTableDropConstraint(this.session, this.getSchema(), false);
                command.setConstraintName(constraintName);
                return this.commandIfTableExists(schema, tableName, ifTableExists, command);
            }
            if (this.readIf("INDEX")) {
                SchemaCommand command;
                String indexOrConstraintName = this.readIdentifierWithSchema(schema.getName());
                if (schema.findIndex(this.session, indexOrConstraintName) != null) {
                    DropIndex dropIndexCommand = new DropIndex(this.session, this.getSchema());
                    dropIndexCommand.setIndexName(indexOrConstraintName);
                    command = dropIndexCommand;
                } else {
                    AlterTableDropConstraint dropCommand = new AlterTableDropConstraint(this.session, this.getSchema(), false);
                    dropCommand.setConstraintName(indexOrConstraintName);
                    command = dropCommand;
                }
                return this.commandIfTableExists(schema, tableName, ifTableExists, command);
            }
            if (this.readIf(42)) {
                this.read("KEY");
                Table table = this.tableIfTableExists(schema, tableName, ifTableExists);
                if (table == null) {
                    return new NoOperation(this.session);
                }
                Index idx = table.getPrimaryKey();
                DropIndex command = new DropIndex(this.session, schema);
                command.setIndexName(idx.getName());
                return command;
            }
            this.readIf("COLUMN");
            boolean ifExists = this.readIfExists(false);
            ArrayList<Column> columnsToRemove = new ArrayList<Column>();
            Table table = this.tableIfTableExists(schema, tableName, ifTableExists);
            boolean openingBracketDetected = this.readIf(69);
            do {
                String columnName = this.readColumnIdentifier();
                if (table == null || ifExists && !table.doesColumnExist(columnName)) continue;
                Column column = table.getColumn(columnName);
                columnsToRemove.add(column);
            } while (this.readIf(73));
            if (openingBracketDetected) {
                this.read(70);
            }
            if (table == null || columnsToRemove.isEmpty()) {
                return new NoOperation(this.session);
            }
            AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
            command.setType(12);
            command.setTableName(tableName);
            command.setIfTableExists(ifTableExists);
            command.setColumnsToRemove(columnsToRemove);
            return command;
        }
        if (this.readIf("CHANGE")) {
            this.readIf("COLUMN");
            String columnName = this.readColumnIdentifier();
            String newColumnName = this.readColumnIdentifier();
            Column column = this.columnIfTableExists(schema, tableName, columnName, ifTableExists);
            boolean nullable = column == null ? true : column.isNullable();
            this.parseColumnForTable(newColumnName, nullable, true);
            AlterTableRenameColumn command = new AlterTableRenameColumn(this.session, schema);
            command.setTableName(tableName);
            command.setIfTableExists(ifTableExists);
            command.setOldColumnName(columnName);
            command.setNewColumnName(newColumnName);
            return command;
        }
        if (this.readIf("MODIFY")) {
            AlterTableAlterColumn command;
            this.readIf("COLUMN");
            boolean hasOpeningBracket = this.readIf(69);
            String columnName = this.readColumnIdentifier();
            NullConstraintType nullConstraint = this.parseNotNullConstraint();
            switch (nullConstraint) {
                case NULL_IS_ALLOWED: 
                case NULL_IS_NOT_ALLOWED: {
                    command = new AlterTableAlterColumn(this.session, schema);
                    command.setTableName(tableName);
                    command.setIfTableExists(ifTableExists);
                    Column column = this.columnIfTableExists(schema, tableName, columnName, ifTableExists);
                    command.setOldColumn(column);
                    if (nullConstraint == NullConstraintType.NULL_IS_ALLOWED) {
                        command.setType(9);
                        break;
                    }
                    command.setType(8);
                    break;
                }
                case NO_NULL_CONSTRAINT_FOUND: {
                    command = this.parseAlterTableAlterColumnType(schema, tableName, columnName, ifTableExists);
                    break;
                }
                default: {
                    throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraint.name());
                }
            }
            if (hasOpeningBracket) {
                this.read(70);
            }
            return command;
        }
        if (this.readIf("ALTER")) {
            this.readIf("COLUMN");
            String columnName = this.readColumnIdentifier();
            Column column = this.columnIfTableExists(schema, tableName, columnName, ifTableExists);
            if (this.readIf("RENAME")) {
                this.read("TO");
                AlterTableRenameColumn command = new AlterTableRenameColumn(this.session, schema);
                command.setTableName(tableName);
                command.setIfTableExists(ifTableExists);
                command.setOldColumnName(columnName);
                String newName = this.readColumnIdentifier();
                command.setNewColumnName(newName);
                return command;
            }
            if (this.readIf("DROP")) {
                if (this.readIf("DEFAULT")) {
                    AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
                    command.setTableName(tableName);
                    command.setIfTableExists(ifTableExists);
                    command.setOldColumn(column);
                    command.setType(10);
                    command.setDefaultExpression(null);
                    return command;
                }
                if (this.readIf(40)) {
                    this.read("UPDATE");
                    AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
                    command.setTableName(tableName);
                    command.setIfTableExists(ifTableExists);
                    command.setOldColumn(column);
                    command.setType(90);
                    command.setDefaultExpression(null);
                    return command;
                }
                this.read(37);
                this.read(38);
                AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
                command.setTableName(tableName);
                command.setIfTableExists(ifTableExists);
                command.setOldColumn(column);
                command.setType(9);
                return command;
            }
            if (this.readIf("TYPE")) {
                return this.parseAlterTableAlterColumnDataType(schema, tableName, columnName, ifTableExists);
            }
            if (this.readIf("SET")) {
                if (this.readIf("DATA")) {
                    this.read("TYPE");
                    return this.parseAlterTableAlterColumnDataType(schema, tableName, columnName, ifTableExists);
                }
                AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
                command.setTableName(tableName);
                command.setIfTableExists(ifTableExists);
                command.setOldColumn(column);
                NullConstraintType nullConstraint = this.parseNotNullConstraint();
                switch (nullConstraint) {
                    case NULL_IS_ALLOWED: {
                        command.setType(9);
                        break;
                    }
                    case NULL_IS_NOT_ALLOWED: {
                        command.setType(8);
                        break;
                    }
                    case NO_NULL_CONSTRAINT_FOUND: {
                        if (this.readIf("DEFAULT")) {
                            Expression defaultExpression = this.readExpression();
                            command.setType(10);
                            command.setDefaultExpression(defaultExpression);
                            break;
                        }
                        if (this.readIf(40)) {
                            this.read("UPDATE");
                            Expression onUpdateExpression = this.readExpression();
                            command.setType(90);
                            command.setDefaultExpression(onUpdateExpression);
                            break;
                        }
                        if (this.readIf("INVISIBLE")) {
                            command.setType(87);
                            command.setVisible(false);
                            break;
                        }
                        if (!this.readIf("VISIBLE")) break;
                        command.setType(87);
                        command.setVisible(true);
                        break;
                    }
                    default: {
                        throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraint.name());
                    }
                }
                return command;
            }
            if (this.readIf("RESTART")) {
                this.readIf(55);
                Expression start = this.readExpression();
                AlterSequence command = new AlterSequence(this.session, schema);
                command.setColumn(column);
                SequenceOptions options = new SequenceOptions();
                options.setStartValue(start);
                command.setOptions(options);
                return this.commandIfTableExists(schema, tableName, ifTableExists, command);
            }
            if (this.readIf("SELECTIVITY")) {
                AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
                command.setTableName(tableName);
                command.setIfTableExists(ifTableExists);
                command.setType(13);
                command.setOldColumn(column);
                command.setSelectivity(this.readExpression());
                return command;
            }
            return this.parseAlterTableAlterColumnType(schema, tableName, columnName, ifTableExists);
        }
        throw this.getSyntaxError();
    }

    private Table tableIfTableExists(Schema schema, String tableName, boolean ifTableExists) {
        Table table = schema.resolveTableOrView(this.session, tableName);
        if (table == null && !ifTableExists) {
            throw DbException.get(42102, tableName);
        }
        return table;
    }

    private Column columnIfTableExists(Schema schema, String tableName, String columnName, boolean ifTableExists) {
        Table table = this.tableIfTableExists(schema, tableName, ifTableExists);
        return table == null ? null : table.getColumn(columnName);
    }

    private Prepared commandIfTableExists(Schema schema, String tableName, boolean ifTableExists, Prepared commandIfTableExists) {
        return this.tableIfTableExists(schema, tableName, ifTableExists) == null ? new NoOperation(this.session) : commandIfTableExists;
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnType(Schema schema, String tableName, String columnName, boolean ifTableExists) {
        Column oldColumn = this.columnIfTableExists(schema, tableName, columnName, ifTableExists);
        Column newColumn = this.parseColumnForTable(columnName, oldColumn == null ? true : oldColumn.isNullable(), true);
        if (this.readIf(6)) {
            Expression expr = this.readExpression();
            newColumn.addCheckConstraint(this.session, expr);
        }
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        command.setType(11);
        command.setOldColumn(oldColumn);
        command.setNewColumn(newColumn);
        return command;
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnDataType(Schema schema, String tableName, String columnName, boolean ifTableExists) {
        Column oldColumn = this.columnIfTableExists(schema, tableName, columnName, ifTableExists);
        Column newColumn = this.parseColumnWithType(columnName, true);
        if (oldColumn != null) {
            String c;
            Expression e;
            if (!oldColumn.isNullable()) {
                newColumn.setNullable(false);
            }
            if (!oldColumn.getVisible()) {
                newColumn.setVisible(false);
            }
            if ((e = oldColumn.getDefaultExpression()) != null) {
                newColumn.setDefaultExpression(this.session, e);
            }
            if ((e = oldColumn.getOnUpdateExpression()) != null) {
                newColumn.setOnUpdateExpression(this.session, e);
            }
            if ((e = oldColumn.getCheckConstraint(this.session, columnName)) != null) {
                newColumn.addCheckConstraint(this.session, e);
            }
            if ((c = oldColumn.getComment()) != null) {
                newColumn.setComment(c);
            }
        }
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        command.setType(11);
        command.setOldColumn(oldColumn);
        command.setNewColumn(newColumn);
        return command;
    }

    private AlterTableAlterColumn parseAlterTableAddColumn(String tableName, Schema schema, boolean ifTableExists) {
        this.readIf("COLUMN");
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
        command.setType(7);
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        if (this.readIf(69)) {
            command.setIfNotExists(false);
            do {
                this.parseTableColumnDefinition(command, schema, tableName, false);
            } while (this.readIfMore(true));
        } else {
            boolean ifNotExists = this.readIfNotExists();
            command.setIfNotExists(ifNotExists);
            this.parseTableColumnDefinition(command, schema, tableName, false);
        }
        if (this.readIf("BEFORE")) {
            command.setAddBefore(this.readColumnIdentifier());
        } else if (this.readIf("AFTER")) {
            command.setAddAfter(this.readColumnIdentifier());
        } else if (this.readIf("FIRST")) {
            command.setAddFirst();
        }
        return command;
    }

    private ConstraintActionType parseAction() {
        ConstraintActionType result = this.parseCascadeOrRestrict();
        if (result != null) {
            return result;
        }
        if (this.readIf("NO")) {
            this.read("ACTION");
            return ConstraintActionType.RESTRICT;
        }
        this.read("SET");
        if (this.readIf(38)) {
            return ConstraintActionType.SET_NULL;
        }
        this.read("DEFAULT");
        return ConstraintActionType.SET_DEFAULT;
    }

    private ConstraintActionType parseCascadeOrRestrict() {
        if (this.readIf("CASCADE")) {
            return ConstraintActionType.CASCADE;
        }
        if (this.readIf("RESTRICT")) {
            return ConstraintActionType.RESTRICT;
        }
        return null;
    }

    private DefineCommand parseAlterTableAddConstraintIf(String tableName, Schema schema, boolean ifTableExists) {
        AlterTableAddConstraint command;
        String constraintName = null;
        String comment = null;
        boolean ifNotExists = false;
        boolean allowIndexDefinition = this.database.getMode().indexDefinitionInCreateTable;
        boolean allowAffinityKey = this.database.getMode().allowAffinityKey;
        if (this.readIf(7)) {
            ifNotExists = this.readIfNotExists();
            constraintName = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            comment = this.readCommentIf();
            allowIndexDefinition = true;
        }
        if (this.readIf(42)) {
            this.read("KEY");
            AlterTableAddConstraint command2 = new AlterTableAddConstraint(this.session, schema, ifNotExists);
            command2.setType(6);
            command2.setComment(comment);
            command2.setConstraintName(constraintName);
            command2.setTableName(tableName);
            command2.setIfTableExists(ifTableExists);
            if (this.readIf("HASH")) {
                command2.setPrimaryKeyHash(true);
            }
            this.read(69);
            command2.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String indexName = this.readIdentifierWithSchema();
                command2.setIndex(this.getSchema().findIndex(this.session, indexName));
            }
            return command2;
        }
        if (allowIndexDefinition && (this.isToken("INDEX") || this.isToken("KEY"))) {
            int start = this.lastParseIndex;
            this.read();
            if (DataType.getTypeByName(this.currentToken, this.database.getMode()) != null) {
                this.parseIndex = start;
                this.read();
                return null;
            }
            CreateIndex command3 = new CreateIndex(this.session, schema);
            command3.setComment(comment);
            command3.setTableName(tableName);
            command3.setIfTableExists(ifTableExists);
            if (!this.readIf(69)) {
                command3.setIndexName(this.readUniqueIdentifier());
                this.read(69);
            }
            command3.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("USING")) {
                this.read("BTREE");
            }
            return command3;
        }
        if (allowAffinityKey && this.readIfAffinity()) {
            this.read("KEY");
            this.read(69);
            CreateIndex command4 = this.createAffinityIndex(schema, tableName, this.parseIndexColumnList());
            command4.setIfTableExists(ifTableExists);
            return command4;
        }
        if (this.readIf(6)) {
            command = new AlterTableAddConstraint(this.session, schema, ifNotExists);
            command.setType(3);
            command.setCheckExpression(this.readExpression());
        } else if (this.readIf(51)) {
            this.readIf("KEY");
            this.readIf("INDEX");
            command = new AlterTableAddConstraint(this.session, schema, ifNotExists);
            command.setType(4);
            if (!this.readIf(69)) {
                constraintName = this.readUniqueIdentifier();
                this.read(69);
            }
            command.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String indexName = this.readIdentifierWithSchema();
                command.setIndex(this.getSchema().findIndex(this.session, indexName));
            }
            if (this.readIf("USING")) {
                this.read("BTREE");
            }
        } else if (this.readIf(19)) {
            command = new AlterTableAddConstraint(this.session, schema, ifNotExists);
            command.setType(5);
            this.read("KEY");
            this.read(69);
            command.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String indexName = this.readIdentifierWithSchema();
                command.setIndex(schema.findIndex(this.session, indexName));
            }
            this.read("REFERENCES");
            this.parseReferences(command, schema, tableName);
        } else {
            if (constraintName != null) {
                throw this.getSyntaxError();
            }
            return null;
        }
        if (this.readIf("NOCHECK")) {
            command.setCheckExisting(false);
        } else {
            this.readIf(6);
            command.setCheckExisting(true);
        }
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        command.setConstraintName(constraintName);
        command.setComment(comment);
        return command;
    }

    private void parseReferences(AlterTableAddConstraint command, Schema schema, String tableName) {
        if (this.readIf(69)) {
            command.setRefTableName(schema, tableName);
            command.setRefIndexColumns(this.parseIndexColumnList());
        } else {
            String refTableName = this.readIdentifierWithSchema(schema.getName());
            command.setRefTableName(this.getSchema(), refTableName);
            if (this.readIf(69)) {
                command.setRefIndexColumns(this.parseIndexColumnList());
            }
        }
        if (this.readIf("INDEX")) {
            String indexName = this.readIdentifierWithSchema();
            command.setRefIndex(this.getSchema().findIndex(this.session, indexName));
        }
        while (this.readIf(40)) {
            if (this.readIf("DELETE")) {
                command.setDeleteAction(this.parseAction());
                continue;
            }
            this.read("UPDATE");
            command.setUpdateAction(this.parseAction());
        }
        if (this.readIf(37)) {
            this.read("DEFERRABLE");
        } else {
            this.readIf("DEFERRABLE");
        }
    }

    private CreateLinkedTable parseCreateLinkedTable(boolean temp, boolean globalTemp, boolean force) {
        this.read(48);
        boolean ifNotExists = this.readIfNotExists();
        String tableName = this.readIdentifierWithSchema();
        CreateLinkedTable command = new CreateLinkedTable(this.session, this.getSchema());
        command.setTemporary(temp);
        command.setGlobalTemporary(globalTemp);
        command.setForce(force);
        command.setIfNotExists(ifNotExists);
        command.setTableName(tableName);
        command.setComment(this.readCommentIf());
        this.read(69);
        command.setDriver(this.readString());
        this.read(73);
        command.setUrl(this.readString());
        this.read(73);
        command.setUser(this.readString());
        this.read(73);
        command.setPassword(this.readString());
        this.read(73);
        String originalTable = this.readString();
        if (this.readIf(73)) {
            command.setOriginalSchema(originalTable);
            originalTable = this.readString();
        }
        command.setOriginalTable(originalTable);
        this.read(70);
        if (this.readIf("EMIT")) {
            this.read("UPDATES");
            command.setEmitUpdates(true);
        } else if (this.readIf("READONLY")) {
            command.setReadOnly(true);
        }
        return command;
    }

    private CreateTable parseCreateTable(boolean temp, boolean globalTemp, boolean persistIndexes) {
        boolean ifNotExists = this.readIfNotExists();
        String tableName = this.readIdentifierWithSchema();
        if (temp && globalTemp && this.equalsToken("SESSION", this.schemaName)) {
            this.schemaName = this.session.getCurrentSchemaName();
            globalTemp = false;
        }
        Schema schema = this.getSchema();
        CreateTable command = new CreateTable(this.session, schema);
        command.setPersistIndexes(persistIndexes);
        command.setTemporary(temp);
        command.setGlobalTemporary(globalTemp);
        command.setIfNotExists(ifNotExists);
        command.setTableName(tableName);
        command.setComment(this.readCommentIf());
        if (this.readIf(69) && !this.readIf(70)) {
            do {
                this.parseTableColumnDefinition(command, schema, tableName, true);
            } while (this.readIfMore(false));
        }
        if (this.readIf("COMMENT") && this.readIf(59)) {
            this.readString();
        }
        if (this.readIf("ENGINE")) {
            if (this.readIf(59)) {
                String tableEngine = this.readUniqueIdentifier();
                if (!"InnoDb".equalsIgnoreCase(tableEngine) && !"MyISAM".equalsIgnoreCase(tableEngine)) {
                    throw DbException.getUnsupportedException(tableEngine);
                }
            } else {
                command.setTableEngine(this.readUniqueIdentifier());
            }
        }
        if (this.readIf(55)) {
            command.setTableEngineParams(this.readTableEngineParams());
        }
        if (this.readIf("AUTO_INCREMENT")) {
            this.read(59);
            if (this.currentTokenType != 58 || this.currentValue.getValueType() != 4) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "integer");
            }
            this.read();
        }
        this.readIf("DEFAULT");
        if (this.readIf("CHARSET")) {
            this.read(59);
            if (!this.readIf("UTF8")) {
                this.read("UTF8MB4");
            }
        }
        if (temp) {
            if (this.readIf(40)) {
                this.read("COMMIT");
                if (this.readIf("DROP")) {
                    command.setOnCommitDrop();
                } else if (this.readIf("DELETE")) {
                    this.read("ROWS");
                    command.setOnCommitTruncate();
                }
            } else if (this.readIf(37)) {
                if (this.readIf("PERSISTENT")) {
                    command.setPersistData(false);
                } else {
                    this.read("LOGGED");
                }
            }
            if (this.readIf("TRANSACTIONAL")) {
                command.setTransactional(true);
            }
        } else if (!persistIndexes && this.readIf(37)) {
            this.read("PERSISTENT");
            command.setPersistData(false);
        }
        if (this.readIf("HIDDEN")) {
            command.setHidden(true);
        }
        if (this.readIf("AS")) {
            if (this.readIf("SORTED")) {
                command.setSortedInsertMode(true);
            }
            command.setQuery(this.parseSelect());
            if (this.readIf(55)) {
                command.setWithNoData(this.readIf("NO"));
                this.read("DATA");
            }
        }
        if (this.readIf("ROW_FORMAT") && this.readIf(59)) {
            this.readColumnIdentifier();
        }
        return command;
    }

    private void parseTableColumnDefinition(CommandWithColumns command, Schema schema, String tableName, boolean forCreateTable) {
        DefineCommand c = this.parseAlterTableAddConstraintIf(tableName, schema, false);
        if (c != null) {
            command.addConstraintCommand(c);
        } else {
            IndexColumn[] cols;
            boolean allowAffinityKey;
            boolean affinity;
            String columnName = this.readColumnIdentifier();
            if (forCreateTable && (this.currentTokenType == 73 || this.currentTokenType == 70)) {
                command.addColumn(new Column(columnName, TypeInfo.TYPE_UNKNOWN));
                return;
            }
            Column column = this.parseColumnForTable(columnName, true, true);
            if (column.isAutoIncrement() && column.isPrimaryKey()) {
                column.setPrimaryKey(false);
                IndexColumn[] cols2 = new IndexColumn[]{new IndexColumn()};
                cols2[0].columnName = column.getName();
                AlterTableAddConstraint pk = new AlterTableAddConstraint(this.session, schema, false);
                pk.setType(6);
                pk.setTableName(tableName);
                pk.setIndexColumns(cols2);
                command.addConstraintCommand(pk);
            }
            command.addColumn(column);
            String constraintName = null;
            if (this.readIf(7)) {
                constraintName = this.readColumnIdentifier();
            }
            boolean bl = affinity = (allowAffinityKey = this.database.getMode().allowAffinityKey) && this.readIfAffinity();
            if (this.readIf(42)) {
                this.read("KEY");
                boolean hash = this.readIf("HASH");
                cols = new IndexColumn[]{new IndexColumn()};
                cols[0].columnName = column.getName();
                AlterTableAddConstraint pk = new AlterTableAddConstraint(this.session, schema, false);
                pk.setConstraintName(constraintName);
                pk.setPrimaryKeyHash(hash);
                pk.setType(6);
                pk.setTableName(tableName);
                pk.setIndexColumns(cols);
                command.addConstraintCommand(pk);
                if (this.readIf("AUTO_INCREMENT")) {
                    this.parseAutoIncrement(column);
                }
                if (this.database.getMode().useIdentityAsAutoIncrement) {
                    if (this.readIf(37)) {
                        this.read(38);
                        column.setNullable(false);
                    }
                    if (this.readIf("IDENTITY")) {
                        this.parseAutoIncrement(column);
                    }
                }
                if (affinity) {
                    CreateIndex idx = this.createAffinityIndex(schema, tableName, cols);
                    command.addConstraintCommand(idx);
                }
            } else if (affinity) {
                this.read("KEY");
                IndexColumn[] cols3 = new IndexColumn[]{new IndexColumn()};
                cols3[0].columnName = column.getName();
                CreateIndex idx = this.createAffinityIndex(schema, tableName, cols3);
                command.addConstraintCommand(idx);
            } else if (this.readIf(51)) {
                AlterTableAddConstraint unique = new AlterTableAddConstraint(this.session, schema, false);
                unique.setConstraintName(constraintName);
                unique.setType(4);
                cols = new IndexColumn[]{new IndexColumn()};
                cols[0].columnName = columnName;
                unique.setIndexColumns(cols);
                unique.setTableName(tableName);
                command.addConstraintCommand(unique);
            }
            if (NullConstraintType.NULL_IS_NOT_ALLOWED == this.parseNotNullConstraint()) {
                column.setNullable(false);
            }
            if (this.readIf(6)) {
                Expression expr = this.readExpression();
                column.addCheckConstraint(this.session, expr);
            }
            if (this.readIf("REFERENCES")) {
                AlterTableAddConstraint ref = new AlterTableAddConstraint(this.session, schema, false);
                ref.setConstraintName(constraintName);
                ref.setType(5);
                cols = new IndexColumn[]{new IndexColumn()};
                cols[0].columnName = columnName;
                ref.setIndexColumns(cols);
                ref.setTableName(tableName);
                this.parseReferences(ref, schema, tableName);
                command.addConstraintCommand(ref);
            }
        }
    }

    private NullConstraintType parseNotNullConstraint() {
        NullConstraintType nullConstraint = NullConstraintType.NO_NULL_CONSTRAINT_FOUND;
        if (this.isToken(37) || this.isToken(38)) {
            if (this.readIf(37)) {
                this.read(38);
                nullConstraint = NullConstraintType.NULL_IS_NOT_ALLOWED;
            } else {
                this.read(38);
                nullConstraint = NullConstraintType.NULL_IS_ALLOWED;
            }
            if (this.database.getMode().getEnum() == Mode.ModeEnum.Oracle) {
                if (this.readIf("ENABLE")) {
                    this.readIf("VALIDATE");
                    if (this.readIf("NOVALIDATE")) {
                        nullConstraint = NullConstraintType.NULL_IS_ALLOWED;
                    }
                }
                if (this.readIf("DISABLE")) {
                    nullConstraint = NullConstraintType.NULL_IS_ALLOWED;
                    this.readIf("VALIDATE");
                    this.readIf("NOVALIDATE");
                }
            }
        }
        return nullConstraint;
    }

    private CreateSynonym parseCreateSynonym(boolean orReplace) {
        boolean ifNotExists = this.readIfNotExists();
        String name = this.readIdentifierWithSchema();
        Schema synonymSchema = this.getSchema();
        this.read(18);
        String tableName = this.readIdentifierWithSchema();
        Schema targetSchema = this.getSchema();
        CreateSynonym command = new CreateSynonym(this.session, synonymSchema);
        command.setName(name);
        command.setSynonymFor(tableName);
        command.setSynonymForSchema(targetSchema);
        command.setComment(this.readCommentIf());
        command.setIfNotExists(ifNotExists);
        command.setOrReplace(orReplace);
        return command;
    }

    private CreateIndex createAffinityIndex(Schema schema, String tableName, IndexColumn[] indexColumns) {
        CreateIndex idx = new CreateIndex(this.session, schema);
        idx.setTableName(tableName);
        idx.setIndexColumns(indexColumns);
        idx.setAffinity(true);
        return idx;
    }

    private static int getCompareType(int tokenType) {
        switch (tokenType) {
            case 59: {
                return 0;
            }
            case 60: {
                return 1;
            }
            case 61: {
                return 2;
            }
            case 62: {
                return 4;
            }
            case 63: {
                return 3;
            }
            case 64: {
                return 5;
            }
            case 71: {
                return 11;
            }
        }
        return -1;
    }

    public static String quoteIdentifier(String s, boolean alwaysQuote) {
        if (s == null) {
            return "\"\"";
        }
        if (!alwaysQuote && ParserUtil.isSimpleIdentifier(s, false, false)) {
            return s;
        }
        return StringUtils.quoteIdentifier(s);
    }

    public static StringBuilder quoteIdentifier(StringBuilder builder, String s, boolean alwaysQuote) {
        if (s == null) {
            return builder.append("\"\"");
        }
        if (!alwaysQuote && ParserUtil.isSimpleIdentifier(s, false, false)) {
            return builder.append(s);
        }
        return StringUtils.quoteIdentifier(builder, s);
    }

    public void setLiteralsChecked(boolean literalsChecked) {
        this.literalsChecked = literalsChecked;
    }

    public void setRightsChecked(boolean rightsChecked) {
        this.rightsChecked = rightsChecked;
    }

    public void setSuppliedParameterList(ArrayList<Parameter> suppliedParameterList) {
        this.suppliedParameterList = suppliedParameterList;
    }

    public Expression parseExpression(String sql) {
        this.parameters = Utils.newSmallArrayList();
        this.initialize(sql);
        this.read();
        return this.readExpression();
    }

    public Table parseTableName(String sql) {
        this.parameters = Utils.newSmallArrayList();
        this.initialize(sql);
        this.read();
        return this.readTableOrView();
    }

    public String toString() {
        return StringUtils.addAsterisk(this.sqlCommand, this.parseIndex);
    }

    private static enum NullConstraintType {
        NULL_IS_ALLOWED,
        NULL_IS_NOT_ALLOWED,
        NO_NULL_CONSTRAINT_FOUND;

    }
}

