/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import org.gridgain.internal.h2.command.ddl.SchemaCommand;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Constant;
import org.gridgain.internal.h2.schema.Schema;

public class DropConstant
extends SchemaCommand {
    private String constantName;
    private boolean ifExists;

    public DropConstant(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setConstantName(String constantName) {
        this.constantName = constantName;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        Constant constant = this.getSchema().findConstant(this.constantName);
        if (constant == null) {
            if (!this.ifExists) {
                throw DbException.get(90115, this.constantName);
            }
        } else {
            db.removeSchemaObject(this.session, constant);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 37;
    }
}

