/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class SequenceOptions {
    private Expression start;
    private Expression increment;
    private Expression maxValue;
    private Expression minValue;
    private Boolean cycle;
    private Expression cacheSize;

    private static Long getLong(Session session, Expression expr) {
        Value value;
        if (expr != null && (value = expr.optimize(session).getValue(session)) != ValueNull.INSTANCE) {
            return value.getLong();
        }
        return null;
    }

    public Long getStartValue(Session session) {
        return SequenceOptions.getLong(session, this.start);
    }

    public void setStartValue(Expression start) {
        this.start = start;
    }

    public Long getIncrement(Session session) {
        return SequenceOptions.getLong(session, this.increment);
    }

    public void setIncrement(Expression increment) {
        this.increment = increment;
    }

    public Long getMaxValue(Sequence sequence, Session session) {
        if (this.maxValue == ValueExpression.getNull() && sequence != null) {
            return Sequence.getDefaultMaxValue(this.getCurrentStart(sequence, session), this.increment != null ? this.getIncrement(session).longValue() : sequence.getIncrement());
        }
        return SequenceOptions.getLong(session, this.maxValue);
    }

    public void setMaxValue(Expression maxValue) {
        this.maxValue = maxValue;
    }

    public Long getMinValue(Sequence sequence, Session session) {
        if (this.minValue == ValueExpression.getNull() && sequence != null) {
            return Sequence.getDefaultMinValue(this.getCurrentStart(sequence, session), this.increment != null ? this.getIncrement(session).longValue() : sequence.getIncrement());
        }
        return SequenceOptions.getLong(session, this.minValue);
    }

    public void setMinValue(Expression minValue) {
        this.minValue = minValue;
    }

    public Boolean getCycle() {
        return this.cycle;
    }

    public void setCycle(Boolean cycle) {
        this.cycle = cycle;
    }

    public Long getCacheSize(Session session) {
        return SequenceOptions.getLong(session, this.cacheSize);
    }

    public void setCacheSize(Expression cacheSize) {
        this.cacheSize = cacheSize;
    }

    boolean isRangeSet() {
        return this.start != null || this.minValue != null || this.maxValue != null || this.increment != null;
    }

    private long getCurrentStart(Sequence sequence, Session session) {
        return this.start != null ? this.getStartValue(session) : sequence.getCurrentValue() + sequence.getIncrement();
    }
}

