/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObjectBase;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.Table;

public class Setting
extends DbObjectBase {
    private int intValue;
    private String stringValue;

    public Setting(Database database, int id, String settingName) {
        super(database, id, settingName, 10);
    }

    @Override
    public String getSQL(boolean alwaysQuote) {
        return this.getName();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        return builder.append(this.getName());
    }

    public void setIntValue(int value) {
        this.intValue = value;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void setStringValue(String value) {
        this.stringValue = value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        StringBuilder buff = new StringBuilder("SET ");
        this.getSQL(buff, true).append(' ');
        if (this.stringValue != null) {
            buff.append(this.stringValue);
        } else {
            buff.append(this.intValue);
        }
        return buff.toString();
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("RENAME");
    }
}

