/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import java.util.ArrayList;
import java.util.HashMap;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.UndoLogRecord;
import org.gridgain.internal.h2.store.Data;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.store.FileStore;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.util.Utils;

public class UndoLog {
    private final Database database;
    private final ArrayList<Long> storedEntriesPos = Utils.newSmallArrayList();
    private final ArrayList<UndoLogRecord> records = Utils.newSmallArrayList();
    private FileStore file;
    private Data rowBuff;
    private int memoryUndo;
    private int storedEntries;
    private HashMap<Integer, Table> tables;

    UndoLog(Database database) {
        this.database = database;
    }

    int size() {
        return this.storedEntries + this.records.size();
    }

    void clear() {
        this.records.clear();
        this.storedEntries = 0;
        this.storedEntriesPos.clear();
        this.memoryUndo = 0;
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }

    public UndoLogRecord getLast() {
        UndoLogRecord entry;
        int i = this.records.size() - 1;
        if (i < 0 && this.storedEntries > 0) {
            int last = this.storedEntriesPos.size() - 1;
            long pos = this.storedEntriesPos.remove(last);
            long end = this.file.length();
            int bufferLength = (int)(end - pos);
            Data buff = Data.create((DataHandler)this.database, bufferLength, true);
            this.file.seek(pos);
            this.file.readFully(buff.getBytes(), 0, bufferLength);
            while (buff.length() < bufferLength) {
                UndoLogRecord e = UndoLogRecord.loadFromBuffer(buff, this);
                this.records.add(e);
                ++this.memoryUndo;
            }
            this.storedEntries -= this.records.size();
            this.file.setLength(pos);
            this.file.seek(pos);
        }
        if ((entry = this.records.get(i = this.records.size() - 1)).isStored()) {
            UndoLogRecord e;
            int start = Math.max(0, i - this.database.getMaxMemoryUndo() / 2);
            UndoLogRecord first = null;
            for (int j = start; j <= i; ++j) {
                e = this.records.get(j);
                if (!e.isStored()) continue;
                e.load(this.rowBuff, this.file, this);
                ++this.memoryUndo;
                if (first != null) continue;
                first = e;
            }
            for (int k = 0; k < i; ++k) {
                e = this.records.get(k);
                e.invalidatePos();
            }
            this.seek(first.getFilePos());
        }
        return entry;
    }

    void seek(long filePos) {
        this.file.seek(filePos * 16L);
    }

    void removeLast() {
        int i = this.records.size() - 1;
        UndoLogRecord r = this.records.remove(i);
        if (!r.isStored()) {
            --this.memoryUndo;
        }
    }

    void add(UndoLogRecord entry) {
        this.records.add(entry);
        ++this.memoryUndo;
        if (this.memoryUndo > this.database.getMaxMemoryUndo() && this.database.isPersistent() && !this.database.isMVStore()) {
            if (this.file == null) {
                String fileName = this.database.createTempFile();
                this.file = this.database.openFile(fileName, "rw", false);
                this.file.autoDelete();
                this.file.setCheckedWriting(false);
                this.file.setLength(48L);
            }
            Data buff = Data.create((DataHandler)this.database, 4096, true);
            for (int i = 0; i < this.records.size(); ++i) {
                UndoLogRecord r = this.records.get(i);
                buff.checkCapacity(4096);
                r.append(buff, this);
                if (i != this.records.size() - 1 && buff.length() <= 0x100000) continue;
                this.storedEntriesPos.add(this.file.getFilePointer());
                this.file.write(buff.getBytes(), 0, buff.length());
                buff.reset();
            }
            this.storedEntries += this.records.size();
            this.memoryUndo = 0;
            this.records.clear();
        }
    }

    int getTableId(Table table) {
        int id = table.getId();
        if (this.tables == null) {
            this.tables = new HashMap();
        }
        this.tables.put(id, table);
        return id;
    }

    Table getTable(int id) {
        return this.tables.get(id);
    }
}

