/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.ParameterInterface;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueString;

public class Parameter
extends Expression
implements ParameterInterface {
    private Value value;
    private Column column;
    private final int index;

    public Parameter(int index) {
        this.index = index;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        return builder.append('?').append(this.index + 1);
    }

    @Override
    public void setValue(Value v, boolean closeOld) {
        this.value = v;
    }

    public void setValue(Value v) {
        this.value = v;
    }

    @Override
    public Value getParamValue() {
        if (this.value == null) {
            return ValueNull.INSTANCE;
        }
        return this.value;
    }

    @Override
    public Value getValue(Session session) {
        return this.getParamValue();
    }

    @Override
    public TypeInfo getType() {
        if (this.value != null) {
            return this.value.getType();
        }
        if (this.column != null) {
            return this.column.getType();
        }
        return TypeInfo.TYPE_UNKNOWN;
    }

    @Override
    public int getValueType() {
        if (this.value != null) {
            return this.value.getValueType();
        }
        if (this.column != null) {
            return this.column.getType().getValueType();
        }
        return -1;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
    }

    @Override
    public void checkSet() {
        if (this.value == null) {
            throw DbException.get(90012, "#" + (this.index + 1));
        }
    }

    @Override
    public Expression optimize(Session session) {
        if (session.getDatabase().getMode().treatEmptyStringsAsNull && this.value instanceof ValueString && this.value.getString().isEmpty()) {
            this.value = ValueNull.INSTANCE;
        }
        return this;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isValueSet() {
        return this.value != null;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
    }

    @Override
    public int getScale() {
        if (this.value != null) {
            return this.value.getType().getScale();
        }
        if (this.column != null) {
            return this.column.getType().getScale();
        }
        return 0;
    }

    @Override
    public long getPrecision() {
        if (this.value != null) {
            return this.value.getType().getPrecision();
        }
        if (this.column != null) {
            return this.column.getType().getPrecision();
        }
        return 0L;
    }

    @Override
    public void updateAggregate(Session session, int stage) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
            case 0: {
                return this.value != null;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.FALSE));
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public int getIndex() {
        return this.index;
    }
}

