/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import java.util.ArrayList;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionList;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueRow;

public class Subquery
extends Expression {
    private final Query query;
    private Expression expression;

    public Subquery(Query query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        ResultInterface lastResult = this.query.getLastResult();
        ResultInterface result = this.query.query(2);
        try {
            Value v;
            if (!result.next()) {
                v = ValueNull.INSTANCE;
            } else {
                Value[] values = result.currentRow();
                v = result.getVisibleColumnCount() == 1 ? values[0] : ValueRow.get(values);
                if (result.hasNext()) {
                    throw DbException.get(90053);
                }
            }
            ValueNull valueNull = v;
            return valueNull;
        }
        finally {
            if (lastResult != null || this.query.ignoreCaching()) {
                result.close();
            }
        }
    }

    @Override
    public TypeInfo getType() {
        return this.getExpression().getType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.query.mapColumns(resolver, level + 1);
    }

    @Override
    public Expression optimize(Session session) {
        session.optimizeQueryExpression(this.query);
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.query.setEvaluatable(tableFilter, b);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        return builder.append('(').append(this.query.getPlanSQL(alwaysQuote)).append(')');
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.query.updateAggregate(session, stage);
    }

    private Expression getExpression() {
        if (this.expression == null) {
            ArrayList<Expression> expressions = this.query.getExpressions();
            int columnCount = this.query.getColumnCount();
            if (columnCount == 1) {
                this.expression = expressions.get(0);
            } else {
                Expression[] list = new Expression[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    list[i] = expressions.get(i);
                }
                this.expression = new ExpressionList(list, false);
            }
        }
        return this.expression;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.query.isEverything(visitor);
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public int getCost() {
        return this.query.getCostAsExpression();
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        return this.getExpression().getExpressionColumns(session);
    }
}

