/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.aggregate;

import java.sql.Connection;
import java.sql.SQLException;
import org.gridgain.internal.h2.api.Aggregate;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.command.dml.Select;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.UserAggregate;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.aggregate.AbstractAggregate;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataCollecting;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueRow;

public class JavaAggregate
extends AbstractAggregate {
    private final UserAggregate userAggregate;
    private int[] argTypes;
    private int dataType;
    private Connection userConnection;

    public JavaAggregate(UserAggregate userAggregate, Expression[] args, Select select, boolean distinct) {
        super(select, args, distinct);
        this.userAggregate = userAggregate;
    }

    @Override
    public int getCost() {
        int cost = 5;
        for (Expression e : this.args) {
            cost += e.getCost();
        }
        if (this.filterCondition != null) {
            cost += this.filterCondition.getCost();
        }
        return cost;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        Parser.quoteIdentifier(builder, this.userAggregate.getName(), alwaysQuote).append('(');
        JavaAggregate.writeExpressions(builder, this.args, alwaysQuote);
        builder.append(')');
        return this.appendTailConditions(builder, alwaysQuote);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!super.isEverything(visitor)) {
            return false;
        }
        switch (visitor.getType()) {
            case 1: 
            case 2: {
                return false;
            }
            case 7: {
                visitor.addDependency(this.userAggregate);
                break;
            }
        }
        for (Expression e : this.args) {
            if (e == null || e.isEverything(visitor)) continue;
            return false;
        }
        return this.filterCondition == null || this.filterCondition.isEverything(visitor);
    }

    @Override
    public Expression optimize(Session session) {
        super.optimize(session);
        this.userConnection = session.createConnection(false);
        int len = this.args.length;
        this.argTypes = new int[len];
        for (int i = 0; i < len; ++i) {
            int type;
            this.argTypes[i] = type = this.args[i].getType().getValueType();
        }
        try {
            Aggregate aggregate = this.getInstance();
            this.dataType = aggregate.getInternalType(this.argTypes);
            this.type = TypeInfo.getTypeInfo(this.dataType);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
        return this;
    }

    private Aggregate getInstance() {
        Aggregate agg = this.userAggregate.getInstance();
        try {
            agg.init(this.userConnection);
        }
        catch (SQLException ex) {
            throw DbException.convert(ex);
        }
        return agg;
    }

    @Override
    public Value getAggregatedValue(Session session, Object aggregateData) {
        try {
            Object obj;
            Aggregate agg;
            if (this.distinct) {
                agg = this.getInstance();
                AggregateDataCollecting data = (AggregateDataCollecting)aggregateData;
                if (data != null) {
                    for (Value value : data.values) {
                        if (this.args.length == 1) {
                            agg.add(value.getObject());
                            continue;
                        }
                        Value[] values = ((ValueRow)value).getList();
                        Object[] argValues = new Object[this.args.length];
                        int len = this.args.length;
                        for (int i = 0; i < len; ++i) {
                            argValues[i] = values[i].getObject();
                        }
                        agg.add(argValues);
                    }
                }
            } else {
                agg = (Aggregate)aggregateData;
                if (agg == null) {
                    agg = this.getInstance();
                }
            }
            if ((obj = agg.getResult()) == null) {
                return ValueNull.INSTANCE;
            }
            return DataType.convertToValue(session, obj, this.dataType);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    @Override
    protected void updateAggregate(Session session, Object aggregateData) {
        this.updateData(session, aggregateData, null);
    }

    private void updateData(Session session, Object aggregateData, Value[] remembered) {
        try {
            if (this.distinct) {
                AggregateDataCollecting data = (AggregateDataCollecting)aggregateData;
                Value[] argValues = new Value[this.args.length];
                Value arg = null;
                int len = this.args.length;
                for (int i = 0; i < len; ++i) {
                    arg = remembered == null ? this.args[i].getValue(session) : remembered[i];
                    argValues[i] = arg = arg.convertTo(this.argTypes[i]);
                }
                data.add(session, this.args.length == 1 ? arg : ValueRow.get(argValues));
            } else {
                Aggregate agg = (Aggregate)aggregateData;
                Object[] argValues = new Object[this.args.length];
                Object arg = null;
                int len = this.args.length;
                for (int i = 0; i < len; ++i) {
                    Value v = remembered == null ? this.args[i].getValue(session) : remembered[i];
                    v = v.convertTo(this.argTypes[i]);
                    argValues[i] = arg = v.getObject();
                }
                agg.add(this.args.length == 1 ? arg : argValues);
            }
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    @Override
    protected void updateGroupAggregates(Session session, int stage) {
        super.updateGroupAggregates(session, stage);
        for (Expression expr : this.args) {
            expr.updateAggregate(session, stage);
        }
    }

    @Override
    protected int getNumExpressions() {
        int n = this.args.length;
        if (this.filterCondition != null) {
            ++n;
        }
        return n;
    }

    @Override
    protected void rememberExpressions(Session session, Value[] array) {
        int length = this.args.length;
        for (int i = 0; i < length; ++i) {
            array[i] = this.args[i].getValue(session);
        }
        if (this.filterCondition != null) {
            array[length] = ValueBoolean.get(this.filterCondition.getBooleanValue(session));
        }
    }

    @Override
    protected void updateFromExpressions(Session session, Object aggregateData, Value[] array) {
        if (this.filterCondition == null || array[this.getNumExpressions() - 1].getBoolean()) {
            this.updateData(session, aggregateData, array);
        }
    }

    @Override
    protected Object createAggregateData() {
        return this.distinct ? new AggregateDataCollecting(true) : this.getInstance();
    }

    public UserAggregate getUserAggregate() {
        return this.userAggregate;
    }
}

