/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.condition;

import java.util.ArrayList;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.aggregate.Aggregate;
import org.gridgain.internal.h2.expression.aggregate.AggregateType;
import org.gridgain.internal.h2.expression.condition.Condition;
import org.gridgain.internal.h2.expression.condition.ConditionIn;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueGeometry;
import org.gridgain.internal.h2.value.ValueNull;

public class Comparison
extends Condition {
    public static final int NULL_SAFE = 16;
    public static final int EQUAL = 0;
    public static final int EQUAL_NULL_SAFE = 16;
    public static final int BIGGER_EQUAL = 1;
    public static final int BIGGER = 2;
    public static final int SMALLER_EQUAL = 3;
    public static final int SMALLER = 4;
    public static final int NOT_EQUAL = 5;
    public static final int NOT_EQUAL_NULL_SAFE = 21;
    public static final int IS_NULL = 6;
    public static final int IS_NOT_NULL = 7;
    public static final int FALSE = 8;
    public static final int IN_LIST = 9;
    public static final int IN_QUERY = 10;
    public static final int SPATIAL_INTERSECTS = 11;
    private final Database database;
    private int compareType;
    private Expression left;
    private Expression right;

    public Comparison(Session session, int compareType, Expression left, Expression right) {
        this.database = session.getDatabase();
        this.left = left;
        this.right = right;
        this.compareType = compareType;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        boolean encloseRight = false;
        builder.append('(');
        switch (this.compareType) {
            case 6: {
                this.left.getSQL(builder, alwaysQuote).append(" IS NULL");
                break;
            }
            case 7: {
                this.left.getSQL(builder, alwaysQuote).append(" IS NOT NULL");
                break;
            }
            case 11: {
                builder.append("INTERSECTS(");
                this.left.getSQL(builder, alwaysQuote).append(", ");
                this.right.getSQL(builder, alwaysQuote).append(')');
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.right instanceof Aggregate && ((Aggregate)this.right).getAggregateType() == AggregateType.ANY) {
                    encloseRight = true;
                }
            }
            default: {
                this.left.getSQL(builder, alwaysQuote).append(' ').append(Comparison.getCompareOperator(this.compareType)).append(' ');
                if (encloseRight) {
                    builder.append('(');
                }
                this.right.getSQL(builder, alwaysQuote);
                if (!encloseRight) break;
                builder.append(')');
            }
        }
        return builder.append(')');
    }

    static String getCompareOperator(int compareType) {
        switch (compareType) {
            case 0: {
                return "=";
            }
            case 16: {
                return "IS";
            }
            case 1: {
                return ">=";
            }
            case 2: {
                return ">";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "<";
            }
            case 5: {
                return "<>";
            }
            case 21: {
                return "IS NOT";
            }
            case 11: {
                return "&&";
            }
        }
        throw DbException.throwInternalError("compareType=" + compareType);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
            if (this.right.getType().getValueType() == 17 && this.left.getType().getValueType() != 17) {
                throw DbException.get(90110);
            }
            if (this.right instanceof ExpressionColumn && (this.left.isConstant() || this.left instanceof Parameter)) {
                Expression temp = this.left;
                this.left = this.right;
                this.right = temp;
                this.compareType = this.getReversedCompareType(this.compareType);
            }
            if (this.left instanceof ExpressionColumn) {
                if (this.right.isConstant()) {
                    TypeInfo resType;
                    Value r = this.right.getValue(session);
                    if (r == ValueNull.INSTANCE && (this.compareType & 0x10) == 0) {
                        return ValueExpression.getNull();
                    }
                    TypeInfo colType = this.left.getType();
                    TypeInfo constType = r.getType();
                    int constValueType = constType.getValueType();
                    if (constValueType != colType.getValueType() && constValueType != (resType = Value.getHigherType(colType, constType)).getValueType()) {
                        Column column = ((ExpressionColumn)this.left).getColumn();
                        this.right = ValueExpression.get(r.convertTo(resType, session.getDatabase().getMode(), column));
                    }
                } else if (this.right instanceof Parameter) {
                    ((Parameter)this.right).setColumn(((ExpressionColumn)this.left).getColumn());
                }
            }
        }
        if (this.compareType == 6 || this.compareType == 7) {
            if (this.left.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        } else {
            if (this.left == null || this.right == null) {
                DbException.throwInternalError(this.left + " " + this.right);
            }
            if ((this.left == ValueExpression.getNull() || this.right == ValueExpression.getNull()) && (this.compareType & 0x10) == 0) {
                return ValueExpression.getNull();
            }
            if (this.left.isConstant() && this.right.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        }
        return this;
    }

    @Override
    public Value getValue(Session session) {
        Value l = this.left.getValue(session);
        if (this.right == null) {
            boolean result;
            switch (this.compareType) {
                case 6: {
                    result = l == ValueNull.INSTANCE;
                    break;
                }
                case 7: {
                    result = l != ValueNull.INSTANCE;
                    break;
                }
                default: {
                    throw DbException.throwInternalError("type=" + this.compareType);
                }
            }
            return ValueBoolean.get(result);
        }
        if (l == ValueNull.INSTANCE && (this.compareType & 0x10) == 0) {
            return ValueNull.INSTANCE;
        }
        return Comparison.compare(this.database, l, this.right.getValue(session), this.compareType);
    }

    static Value compare(Database database, Value l, Value r, int compareType) {
        Value result;
        switch (compareType) {
            case 0: {
                int cmp = database.compareWithNull(l, r, true);
                if (cmp == 0) {
                    result = ValueBoolean.TRUE;
                    break;
                }
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.FALSE;
                break;
            }
            case 16: {
                result = ValueBoolean.get(database.areEqual(l, r));
                break;
            }
            case 5: {
                int cmp = database.compareWithNull(l, r, true);
                if (cmp == 0) {
                    result = ValueBoolean.FALSE;
                    break;
                }
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.TRUE;
                break;
            }
            case 21: {
                result = ValueBoolean.get(!database.areEqual(l, r));
                break;
            }
            case 1: {
                int cmp = database.compareWithNull(l, r, false);
                if (cmp >= 0) {
                    result = ValueBoolean.TRUE;
                    break;
                }
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.FALSE;
                break;
            }
            case 2: {
                int cmp = database.compareWithNull(l, r, false);
                if (cmp > 0) {
                    result = ValueBoolean.TRUE;
                    break;
                }
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.FALSE;
                break;
            }
            case 3: {
                int cmp = database.compareWithNull(l, r, false);
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.get(cmp <= 0);
                break;
            }
            case 4: {
                int cmp = database.compareWithNull(l, r, false);
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.get(cmp < 0);
                break;
            }
            case 11: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                ValueGeometry lg = (ValueGeometry)l.convertTo(22);
                ValueGeometry rg = (ValueGeometry)r.convertTo(22);
                result = ValueBoolean.get(lg.intersectsBoundingBox(rg));
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + compareType);
            }
        }
        return result;
    }

    private int getReversedCompareType(int type) {
        switch (this.compareType) {
            case 0: 
            case 5: 
            case 11: 
            case 16: 
            case 21: {
                return type;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw DbException.throwInternalError("type=" + this.compareType);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        if (this.compareType == 11) {
            return null;
        }
        int type = this.getNotCompareType();
        return new Comparison(session, type, this.left, this.right);
    }

    private int getNotCompareType() {
        switch (this.compareType) {
            case 0: {
                return 5;
            }
            case 16: {
                return 21;
            }
            case 5: {
                return 0;
            }
            case 21: {
                return 16;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 6;
            }
        }
        throw DbException.throwInternalError("type=" + this.compareType);
    }

    @Override
    public void createIndexConditions(Session session, TableFilter filter) {
        boolean addIndex;
        ExpressionVisitor visitor;
        if (!filter.getTable().isQueryComparable()) {
            return;
        }
        ExpressionColumn l = null;
        if (this.left instanceof ExpressionColumn && filter != (l = (ExpressionColumn)this.left).getTableFilter()) {
            l = null;
        }
        if (this.right == null) {
            if (l != null) {
                switch (this.compareType) {
                    case 6: {
                        filter.addIndexCondition(IndexCondition.get(16, l, ValueExpression.getNull()));
                    }
                }
            }
            return;
        }
        ExpressionColumn r = null;
        if (this.right instanceof ExpressionColumn && filter != (r = (ExpressionColumn)this.right).getTableFilter()) {
            r = null;
        }
        if (l == null && r == null) {
            return;
        }
        if (l != null && r != null) {
            return;
        }
        if (l == null) {
            visitor = ExpressionVisitor.getNotFromResolverVisitor(filter);
            if (!this.left.isEverything(visitor)) {
                return;
            }
        } else if (r == null) {
            visitor = ExpressionVisitor.getNotFromResolverVisitor(filter);
            if (!this.right.isEverything(visitor)) {
                return;
            }
        } else {
            return;
        }
        switch (this.compareType) {
            case 5: 
            case 21: {
                addIndex = false;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 16: {
                addIndex = true;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.compareType);
            }
        }
        if (addIndex) {
            if (l != null) {
                int rType = this.right.getType().getValueType();
                if (l.getType().getValueType() == rType || rType != 14) {
                    filter.addIndexCondition(IndexCondition.get(this.compareType, l, this.right));
                }
            } else if (r != null) {
                int lType = this.left.getType().getValueType();
                if (r.getType().getValueType() == lType || lType != 14) {
                    int compareRev = this.getReversedCompareType(this.compareType);
                    filter.addIndexCondition(IndexCondition.get(compareRev, r, this.left));
                }
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.left.updateAggregate(session, stage);
        if (this.right != null) {
            this.right.updateAggregate(session, stage);
        }
    }

    @Override
    public void addFilterConditions(TableFilter filter, boolean outerJoin) {
        if (this.compareType == 6 && outerJoin) {
            return;
        }
        super.addFilterConditions(filter, outerJoin);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        if (this.right != null) {
            this.right.mapColumns(resolver, level, state);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && (this.right == null || this.right.isEverything(visitor));
    }

    @Override
    public int getCost() {
        return this.left.getCost() + (this.right == null ? 0 : this.right.getCost()) + 1;
    }

    Expression getIfEquals(Expression match) {
        if (this.compareType == 0) {
            String sql = match.getSQL(true);
            if (this.left.getSQL(true).equals(sql)) {
                return this.right;
            }
            if (this.right.getSQL(true).equals(sql)) {
                return this.left;
            }
        }
        return null;
    }

    Expression getAdditional(Session session, Comparison other, boolean and) {
        if (this.compareType == other.compareType && this.compareType == 0) {
            boolean lc = this.left.isConstant() || this.left instanceof Parameter;
            boolean rc = this.right.isConstant() || this.right instanceof Parameter;
            boolean l2c = other.left.isConstant() || other.left instanceof Parameter;
            boolean r2c = other.right.isConstant() || other.right instanceof Parameter;
            String l = this.left.getSQL(true);
            String l2 = other.left.getSQL(true);
            String r = this.right.getSQL(true);
            String r2 = other.right.getSQL(true);
            if (and) {
                if (!(rc && r2c || !l.equals(l2))) {
                    return new Comparison(session, 0, this.right, other.right);
                }
                if (!(rc && l2c || !l.equals(r2))) {
                    return new Comparison(session, 0, this.right, other.left);
                }
                if (!(lc && r2c || !r.equals(l2))) {
                    return new Comparison(session, 0, this.left, other.right);
                }
                if (!(lc && l2c || !r.equals(r2))) {
                    return new Comparison(session, 0, this.left, other.left);
                }
            } else {
                if (rc && r2c && l.equals(l2)) {
                    return Comparison.getConditionIn(session, this.left, this.right, other.right);
                }
                if (rc && l2c && l.equals(r2)) {
                    return Comparison.getConditionIn(session, this.left, this.right, other.left);
                }
                if (lc && r2c && r.equals(l2)) {
                    return Comparison.getConditionIn(session, this.right, this.left, other.right);
                }
                if (lc && l2c && r.equals(r2)) {
                    return Comparison.getConditionIn(session, this.right, this.left, other.left);
                }
            }
        }
        return null;
    }

    private static ConditionIn getConditionIn(Session session, Expression left, Expression value1, Expression value2) {
        ArrayList<Expression> right = new ArrayList<Expression>(2);
        right.add(value1);
        right.add(value2);
        return new ConditionIn(session.getDatabase(), left, right);
    }

    @Override
    public int getSubexpressionCount() {
        return this.compareType == 6 || this.compareType == 7 ? 1 : 2;
    }

    @Override
    public Expression getSubexpression(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                if (this.compareType == 6 || this.compareType == 7) break;
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

