/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.condition;

import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.expression.condition.Condition;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.LocalResult;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueRow;

public class ConditionInSelect
extends Condition {
    private final Database database;
    private Expression left;
    private final Query query;
    private final boolean all;
    private final int compareType;

    public ConditionInSelect(Database database, Expression left, Query query, boolean all, int compareType) {
        this.database = database;
        this.left = left;
        this.query = query;
        query.setRandomAccessResult(true);
        this.all = all;
        this.compareType = compareType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getValue(Session session) {
        ResultInterface lastResult = this.query.getLastResult();
        this.query.setSession(session);
        this.query.setNeverLazy(true);
        this.query.setDistinctIfPossible();
        LocalResult rows = (LocalResult)this.query.query(0);
        try {
            Value value;
            Value l = this.left.getValue(session);
            if (!rows.hasNext()) {
                ValueBoolean valueBoolean = ValueBoolean.get(this.all);
                return valueBoolean;
            }
            if (l.containsNull()) {
                ValueNull valueNull = ValueNull.INSTANCE;
                return valueNull;
            }
            if (!this.database.getSettings().optimizeInSelect) {
                Value value2 = this.getValueSlow(rows, l);
                return value2;
            }
            if (this.all || this.compareType != 0 && this.compareType != 16) {
                Value value3 = this.getValueSlow(rows, l);
                return value3;
            }
            int columnCount = this.query.getColumnCount();
            if (columnCount != 1) {
                Value[] leftValue = ((ValueRow)(l = l.convertTo(39))).getList();
                if (columnCount == leftValue.length && rows.containsDistinct(leftValue)) {
                    ValueBoolean valueBoolean = ValueBoolean.TRUE;
                    return valueBoolean;
                }
            } else {
                TypeInfo colType = rows.getColumnType(0);
                if (colType.getValueType() == 0) {
                    ValueBoolean valueBoolean = ValueBoolean.FALSE;
                    return valueBoolean;
                }
                if (l.getValueType() == 39) {
                    Value[] leftList = ((ValueRow)l).getList();
                    if (leftList.length != 1) {
                        throw DbException.get(21002);
                    }
                    l = leftList[0];
                }
                if (rows.containsDistinct(new Value[]{l = l.convertTo(colType, this.database.getMode(), null)})) {
                    ValueBoolean valueBoolean = ValueBoolean.TRUE;
                    return valueBoolean;
                }
            }
            if (rows.containsNull()) {
                value = ValueNull.INSTANCE;
                return value;
            }
            value = ValueBoolean.FALSE;
            return value;
        }
        finally {
            if (lastResult != null || this.query.ignoreCaching()) {
                rows.close();
            }
        }
    }

    private Value getValueSlow(ResultInterface rows, Value l) {
        boolean hasNull = false;
        if (this.all) {
            while (rows.next()) {
                Value cmp = this.compare(l, rows);
                if (cmp == ValueNull.INSTANCE) {
                    hasNull = true;
                    continue;
                }
                if (cmp != ValueBoolean.FALSE) continue;
                return cmp;
            }
        } else {
            while (rows.next()) {
                Value cmp = this.compare(l, rows);
                if (cmp == ValueNull.INSTANCE) {
                    hasNull = true;
                    continue;
                }
                if (cmp != ValueBoolean.TRUE) continue;
                return cmp;
            }
        }
        if (hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(this.all);
    }

    private Value compare(Value l, ResultInterface rows) {
        Value[] currentRow = rows.currentRow();
        ValueRow r = l.getValueType() != 39 && this.query.getColumnCount() == 1 ? currentRow[0] : ValueRow.get(currentRow);
        return Comparison.compare(this.database, l, r, this.compareType);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        this.query.mapColumns(resolver, level + 1);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        session.optimizeQueryExpression(this.query);
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.query.setEvaluatable(tableFilter, b);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append('(');
        this.left.getSQL(builder, alwaysQuote).append(' ');
        if (this.all) {
            builder.append(Comparison.getCompareOperator(this.compareType)).append(" ALL");
        } else if (this.compareType == 0) {
            builder.append("IN");
        } else {
            builder.append(Comparison.getCompareOperator(this.compareType)).append(" ANY");
        }
        builder.append("(\n");
        return StringUtils.indent(builder, this.query.getPlanSQL(alwaysQuote), 4, false).append("))");
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.left.updateAggregate(session, stage);
        this.query.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.query.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.query.getCostAsExpression();
    }

    @Override
    public void createIndexConditions(Session session, TableFilter filter) {
        if (!session.getDatabase().getSettings().optimizeInList) {
            return;
        }
        if (this.compareType != 0) {
            return;
        }
        if (this.query.getColumnCount() != 1) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        ExpressionVisitor visitor = ExpressionVisitor.getNotFromResolverVisitor(filter);
        if (!this.query.isEverything(visitor)) {
            return;
        }
        filter.addIndexCondition(IndexCondition.getInQuery(l, this.query));
    }
}

