/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.function;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gridgain.internal.h2.command.Command;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.engine.Constants;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.SequenceValue;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.Variable;
import org.gridgain.internal.h2.expression.function.DateTimeFunctions;
import org.gridgain.internal.h2.expression.function.FunctionCall;
import org.gridgain.internal.h2.expression.function.FunctionInfo;
import org.gridgain.internal.h2.expression.function.TableFunction;
import org.gridgain.internal.h2.expression.function.ToChar;
import org.gridgain.internal.h2.expression.function.ToDateParser;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mode.FunctionsMSSQLServer;
import org.gridgain.internal.h2.mode.FunctionsMySQL;
import org.gridgain.internal.h2.mvstore.db.MVSpatialIndex;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.security.BlockCipher;
import org.gridgain.internal.h2.security.CipherFactory;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.LinkSchema;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.tools.CompressTool;
import org.gridgain.internal.h2.tools.Csv;
import org.gridgain.internal.h2.util.Bits;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.IOUtils;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueBytes;
import org.gridgain.internal.h2.value.ValueCollectionBase;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueFloat;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueResultSet;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;
import org.gridgain.internal.h2.value.ValueUuid;

public class Function
extends Expression
implements FunctionCall {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int COSH = 36;
    public static final int SINH = 37;
    public static final int TANH = 38;
    public static final int LN = 39;
    public static final int BITGET = 40;
    public static final int ORA_HASH = 41;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTR = 72;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int REGEXP_REPLACE = 89;
    public static final int RPAD = 90;
    public static final int LPAD = 91;
    public static final int CONCAT_WS = 92;
    public static final int TO_CHAR = 93;
    public static final int TRANSLATE = 94;
    public static final int TO_DATE = 96;
    public static final int TO_TIMESTAMP = 97;
    public static final int ADD_MONTHS = 98;
    public static final int TO_TIMESTAMP_TZ = 99;
    public static final int CURRENT_DATE = 100;
    public static final int CURRENT_TIME = 101;
    public static final int LOCALTIME = 102;
    public static final int CURRENT_TIMESTAMP = 103;
    public static final int LOCALTIMESTAMP = 104;
    public static final int DATE_ADD = 105;
    public static final int DATE_DIFF = 106;
    public static final int DAY_NAME = 107;
    public static final int DAY_OF_MONTH = 108;
    public static final int DAY_OF_WEEK = 109;
    public static final int DAY_OF_YEAR = 110;
    public static final int HOUR = 111;
    public static final int MINUTE = 112;
    public static final int MONTH = 113;
    public static final int MONTH_NAME = 114;
    public static final int QUARTER = 115;
    public static final int SECOND = 116;
    public static final int WEEK = 117;
    public static final int YEAR = 118;
    public static final int EXTRACT = 119;
    public static final int FORMATDATETIME = 120;
    public static final int PARSEDATETIME = 121;
    public static final int ISO_YEAR = 122;
    public static final int ISO_WEEK = 123;
    public static final int ISO_DAY_OF_WEEK = 124;
    public static final int DATE_TRUNC = 125;
    public static final int MILLISECOND = 126;
    public static final int EPOCH = 127;
    public static final int MICROSECOND = 128;
    public static final int NANOSECOND = 129;
    public static final int TIMEZONE_HOUR = 130;
    public static final int TIMEZONE_MINUTE = 131;
    public static final int DECADE = 132;
    public static final int CENTURY = 133;
    public static final int MILLENNIUM = 134;
    public static final int DOW = 135;
    public static final int DATABASE = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int SCOPE_IDENTITY = 154;
    public static final int AUTOCOMMIT = 155;
    public static final int READONLY = 156;
    public static final int DATABASE_PATH = 157;
    public static final int LOCK_TIMEOUT = 158;
    public static final int DISK_SPACE_USED = 159;
    public static final int SIGNAL = 160;
    public static final int ESTIMATED_ENVELOPE = 161;
    private static final Pattern SIGNAL_PATTERN = Pattern.compile("[0-9A-Z]{5}");
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int SCHEMA = 215;
    public static final int SESSION_ID = 216;
    public static final int ARRAY_LENGTH = 217;
    public static final int LINK_SCHEMA = 218;
    public static final int GREATEST = 219;
    public static final int LEAST = 220;
    public static final int CANCEL_SESSION = 221;
    public static final int SET = 222;
    public static final int TABLE = 223;
    public static final int TABLE_DISTINCT = 224;
    public static final int FILE_READ = 225;
    public static final int TRANSACTION_ID = 226;
    public static final int TRUNCATE_VALUE = 227;
    public static final int NVL2 = 228;
    public static final int DECODE = 229;
    public static final int ARRAY_CONTAINS = 230;
    public static final int FILE_WRITE = 232;
    public static final int UNNEST = 233;
    public static final int ARRAY_CONCAT = 234;
    public static final int ARRAY_APPEND = 235;
    public static final int ARRAY_SLICE = 236;
    public static final int REGEXP_LIKE = 240;
    public static final int VALUES = 250;
    public static final int H2VERSION = 231;
    protected static final int VAR_ARGS = -1;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap(256);
    private static final char[] SOUNDEX_INDEX = new char[128];
    protected Expression[] args;
    protected final FunctionInfo info;
    private ArrayList<Expression> varArgs;
    protected TypeInfo type;
    private final Database database;

    public Function(Database database, FunctionInfo info) {
        this.database = database;
        this.info = info;
        if (info.parameterCount == -1) {
            this.varArgs = Utils.newSmallArrayList();
        } else {
            this.args = new Expression[info.parameterCount];
        }
    }

    private static void addFunction(String name, int type, int parameterCount, int returnDataType, boolean nullIfParameterIsNull, boolean deterministic, boolean bufferResultSetToLocalTemp, boolean requireParentheses) {
        FUNCTIONS.put(name, new FunctionInfo(name, type, parameterCount, returnDataType, nullIfParameterIsNull, deterministic, bufferResultSetToLocalTemp, requireParentheses));
    }

    private static void addFunctionNotDeterministic(String name, int type, int parameterCount, int returnDataType) {
        Function.addFunctionNotDeterministic(name, type, parameterCount, returnDataType, true);
    }

    private static void addFunctionNotDeterministic(String name, int type, int parameterCount, int returnDataType, boolean requireParentheses) {
        Function.addFunction(name, type, parameterCount, returnDataType, true, false, true, requireParentheses);
    }

    private static void addFunction(String name, int type, int parameterCount, int returnDataType) {
        Function.addFunction(name, type, parameterCount, returnDataType, true, true, true, true);
    }

    private static void addFunctionWithNull(String name, int type, int parameterCount, int returnDataType) {
        Function.addFunction(name, type, parameterCount, returnDataType, false, true, true, true);
    }

    public static Function getFunction(Database database, String name) {
        FunctionInfo info;
        if (!database.getSettings().databaseToUpper) {
            name = StringUtils.toUpperEnglish(name);
        }
        if ((info = FUNCTIONS.get(name)) == null) {
            switch (database.getMode().getEnum()) {
                case MSSQLServer: {
                    return FunctionsMSSQLServer.getFunction(database, name);
                }
                case MySQL: {
                    return FunctionsMySQL.getFunction(database, name);
                }
            }
            return null;
        }
        switch (info.type) {
            case 223: 
            case 224: 
            case 233: {
                return new TableFunction(database, info, Long.MAX_VALUE);
            }
        }
        return new Function(database, info);
    }

    public static FunctionInfo getFunctionInfo(String upperName) {
        return FUNCTIONS.get(upperName);
    }

    public void setParameter(int index, Expression param) {
        if (this.varArgs != null) {
            this.varArgs.add(param);
        } else {
            if (index >= this.args.length) {
                throw DbException.get(7001, this.info.name, Integer.toString(this.args.length));
            }
            this.args[index] = param;
        }
    }

    @Override
    public Value getValue(Session session) {
        return this.getValueWithArgs(session, this.args);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Value getSimpleValue(Session session, Value v0, Expression[] args, Value[] values) {
        Expression then;
        block112: {
            int i;
            int len;
            switch (this.info.type) {
                case 0: {
                    return v0.getSignum() >= 0 ? v0 : v0.negate();
                }
                case 1: {
                    return ValueDouble.get(Math.acos(v0.getDouble()));
                }
                case 2: {
                    return ValueDouble.get(Math.asin(v0.getDouble()));
                }
                case 3: {
                    return ValueDouble.get(Math.atan(v0.getDouble()));
                }
                case 8: {
                    return Function.getCeilOrFloor(v0, false);
                }
                case 9: {
                    return ValueDouble.get(Math.cos(v0.getDouble()));
                }
                case 36: {
                    return ValueDouble.get(Math.cosh(v0.getDouble()));
                }
                case 10: {
                    double d = Math.tan(v0.getDouble());
                    if (d != 0.0) return ValueDouble.get(1.0 / d);
                    throw DbException.get(22012, this.getSQL(false));
                }
                case 11: {
                    return ValueDouble.get(Math.toDegrees(v0.getDouble()));
                }
                case 12: {
                    return ValueDouble.get(Math.exp(v0.getDouble()));
                }
                case 13: {
                    return Function.getCeilOrFloor(v0, true);
                }
                case 39: {
                    return ValueDouble.get(Math.log(v0.getDouble()));
                }
                case 14: {
                    if (!this.database.getMode().logIsLogBase10) return ValueDouble.get(Math.log(v0.getDouble()));
                    return ValueDouble.get(Math.log10(v0.getDouble()));
                }
                case 15: {
                    return ValueDouble.get(Math.log10(v0.getDouble()));
                }
                case 17: {
                    return ValueDouble.get(Math.PI);
                }
                case 19: {
                    return ValueDouble.get(Math.toRadians(v0.getDouble()));
                }
                case 20: {
                    if (v0 == null) return ValueDouble.get(session.getRandom().nextDouble());
                    session.getRandom().setSeed(v0.getInt());
                    return ValueDouble.get(session.getRandom().nextDouble());
                }
                case 22: {
                    return ValueDouble.get(Function.roundMagic(v0.getDouble()));
                }
                case 23: {
                    return ValueInt.get(v0.getSignum());
                }
                case 24: {
                    return ValueDouble.get(Math.sin(v0.getDouble()));
                }
                case 37: {
                    return ValueDouble.get(Math.sinh(v0.getDouble()));
                }
                case 25: {
                    return ValueDouble.get(Math.sqrt(v0.getDouble()));
                }
                case 26: {
                    return ValueDouble.get(Math.tan(v0.getDouble()));
                }
                case 38: {
                    return ValueDouble.get(Math.tanh(v0.getDouble()));
                }
                case 28: {
                    return ValueBytes.getNoCopy(MathUtils.secureRandomBytes(v0.getInt()));
                }
                case 33: {
                    return ValueBytes.getNoCopy(CompressTool.getInstance().expand(v0.getBytesNoCopy()));
                }
                case 34: {
                    return ValueInt.get(0);
                }
                case 35: {
                    return ValueUuid.getNewRandom();
                }
                case 50: {
                    String s = v0.getString();
                    if (!s.isEmpty()) return ValueInt.get(s.charAt(0));
                    return ValueNull.INSTANCE;
                }
                case 51: {
                    return ValueLong.get(16L * Function.length(v0));
                }
                case 52: {
                    return ValueString.get(String.valueOf((char)v0.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 53: 
                case 61: {
                    return ValueLong.get(Function.length(v0));
                }
                case 64: {
                    return ValueLong.get(2L * Function.length(v0));
                }
                case 54: 
                case 92: {
                    Value result = ValueNull.INSTANCE;
                    int start = 0;
                    String separator = "";
                    if (this.info.type == 92) {
                        start = 1;
                        separator = Function.getNullOrValue(session, args, values, 0).getString();
                    }
                    int i2 = start;
                    while (true) {
                        if (i2 >= args.length) {
                            if (this.info.type != 92) return result;
                            if (separator == null) return result;
                            if (result != ValueNull.INSTANCE) return result;
                            return ValueString.get("", this.database.getMode().treatEmptyStringsAsNull);
                        }
                        Value v = Function.getNullOrValue(session, args, values, i2);
                        if (v != ValueNull.INSTANCE) {
                            if (result == ValueNull.INSTANCE) {
                                result = v;
                            } else {
                                String tmp = v.getString();
                                if (!StringUtils.isNullOrEmpty(separator) && !StringUtils.isNullOrEmpty(tmp)) {
                                    tmp = separator + tmp;
                                }
                                result = ValueString.get(result.getString() + tmp, this.database.getMode().treatEmptyStringsAsNull);
                            }
                        }
                        ++i2;
                    }
                }
                case 56: {
                    return ValueString.get(Function.hexToRaw(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 59: 
                case 75: {
                    return ValueString.get(v0.getString().toLowerCase(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 65: {
                    return ValueString.get(Function.rawToHex(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 70: {
                    return ValueString.get(Function.getSoundex(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 71: {
                    int len2 = Math.max(0, v0.getInt());
                    char[] chars = new char[len2];
                    int i3 = len2 - 1;
                    while (true) {
                        if (i3 < 0) {
                            return ValueString.get(new String(chars), this.database.getMode().treatEmptyStringsAsNull);
                        }
                        chars[i3] = 32;
                        --i3;
                    }
                }
                case 74: 
                case 76: {
                    return ValueString.get(v0.getString().toUpperCase(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 79: {
                    return ValueString.get(StringUtils.javaEncode(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 80: {
                    return ValueString.get(StringUtils.javaDecode(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 81: {
                    return ValueBytes.getNoCopy(v0.getString().getBytes(StandardCharsets.UTF_8));
                }
                case 82: {
                    return ValueString.get(new String(v0.getBytesNoCopy(), StandardCharsets.UTF_8), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 85: {
                    return ValueString.get(StringUtils.xmlComment(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 86: {
                    return ValueString.get(StringUtils.xmlCData(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 87: {
                    return ValueString.get(StringUtils.xmlStartDoc(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 100: {
                    return (this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart()).convertTo(10);
                }
                case 101: 
                case 102: {
                    ValueTime vt = (ValueTime)(this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart()).convertTo(9);
                    return vt.convertScale(false, v0 == null ? 0 : v0.getInt());
                }
                case 103: {
                    ValueTimestampTimeZone vt = this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart();
                    return vt.convertScale(false, v0 == null ? 6 : v0.getInt());
                }
                case 104: {
                    Value vt = (this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart()).convertTo(11);
                    return vt.convertScale(false, v0 == null ? 6 : v0.getInt());
                }
                case 107: {
                    int dayOfWeek = DateTimeUtils.getSundayDayOfWeek(DateTimeUtils.dateAndTimeFromValue(v0)[0]);
                    return ValueString.get(DateTimeFunctions.getMonthsAndWeeks(1)[dayOfWeek], this.database.getMode().treatEmptyStringsAsNull);
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 122: 
                case 123: 
                case 124: {
                    return ValueInt.get(DateTimeFunctions.getIntDatePart(v0, this.info.type, this.database.getMode()));
                }
                case 114: {
                    int month = DateTimeUtils.monthFromDateValue(DateTimeUtils.dateAndTimeFromValue(v0)[0]);
                    return ValueString.get(DateTimeFunctions.getMonthsAndWeeks(0)[month - 1], this.database.getMode().treatEmptyStringsAsNull);
                }
                case 150: {
                    return ValueString.get(this.database.getShortName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 151: 
                case 152: {
                    return ValueString.get(session.getUser().getName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 153: {
                    return session.getLastIdentity();
                }
                case 154: {
                    return session.getLastScopeIdentity();
                }
                case 155: {
                    return ValueBoolean.get(session.getAutoCommit());
                }
                case 156: {
                    return ValueBoolean.get(this.database.isReadOnly());
                }
                case 157: {
                    String path = this.database.getDatabasePath();
                    return path == null ? ValueNull.INSTANCE : ValueString.get(path, this.database.getMode().treatEmptyStringsAsNull);
                }
                case 158: {
                    return ValueInt.get(session.getLockTimeout());
                }
                case 159: {
                    return ValueLong.get(Function.getDiskSpaceUsed(session, v0));
                }
                case 161: {
                    return Function.getEstimatedEnvelope(session, v0, values[1]);
                }
                case 202: 
                case 203: {
                    Mode mode = this.database.getMode();
                    TypeInfo type = this.type;
                    v0 = v0.convertTo(type, mode, null);
                    v0 = v0.convertScale(mode.convertOnlyToSmallerScale, type.getScale());
                    return v0 = v0.convertPrecision(type.getPrecision(), false);
                }
                case 212: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryFree());
                }
                case 213: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryUsed());
                }
                case 214: {
                    return ValueInt.get(this.database.getLockMode());
                }
                case 215: {
                    return ValueString.get(session.getCurrentSchemaName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 216: {
                    return ValueInt.get(session.getId());
                }
                case 200: {
                    Value result = v0;
                    if (v0 != ValueNull.INSTANCE) return result.convertTo(this.type, this.database.getMode(), null);
                    result = Function.getNullOrValue(session, args, values, 1);
                    return result.convertTo(this.type, this.database.getMode(), null);
                }
                case 201: {
                    Value v = !v0.getBoolean() ? Function.getNullOrValue(session, args, values, 2) : Function.getNullOrValue(session, args, values, 1);
                    return v.convertTo(this.type, this.database.getMode(), null);
                }
                case 229: {
                    int index = -1;
                    int len3 = args.length - 1;
                    for (int i4 = 1; i4 < len3; i4 += 2) {
                        if (!this.database.areEqual(v0, Function.getNullOrValue(session, args, values, i4))) continue;
                        index = i4 + 1;
                        break;
                    }
                    if (index < 0 && args.length % 2 == 0) {
                        index = args.length - 1;
                    }
                    ValueNull v = index < 0 ? ValueNull.INSTANCE : Function.getNullOrValue(session, args, values, index);
                    return v.convertTo(this.type, this.database.getMode(), null);
                }
                case 228: {
                    Value v = v0 == ValueNull.INSTANCE ? Function.getNullOrValue(session, args, values, 2) : Function.getNullOrValue(session, args, values, 1);
                    return v.convertTo(this.type, this.database.getMode(), null);
                }
                case 204: {
                    Value result = v0;
                    int i5 = 0;
                    while (i5 < args.length) {
                        Value v = Function.getNullOrValue(session, args, values, i5);
                        if (v != ValueNull.INSTANCE) {
                            return v.convertTo(this.type, this.database.getMode(), null);
                        }
                        ++i5;
                    }
                    return result;
                }
                case 219: 
                case 220: {
                    Value result = ValueNull.INSTANCE;
                    int i6 = 0;
                    while (i6 < args.length) {
                        Value v = Function.getNullOrValue(session, args, values, i6);
                        if (v != ValueNull.INSTANCE) {
                            v = v.convertTo(this.type, this.database.getMode(), null);
                            if (result == ValueNull.INSTANCE) {
                                result = v;
                            } else {
                                int comp = this.database.compareTypeSafe(result, v);
                                if (this.info.type == 219 && comp < 0) {
                                    result = v;
                                } else if (this.info.type == 220 && comp > 0) {
                                    result = v;
                                }
                            }
                        }
                        ++i6;
                    }
                    return result;
                }
                case 206: {
                    then = null;
                    if (v0 == null) {
                        len = args.length - 1;
                        break;
                    }
                    if (v0 == ValueNull.INSTANCE) break block112;
                    int len4 = args.length - 1;
                    for (i = 1; i < len4; i += 2) {
                        Value when = args[i].getValue(session);
                        if (!this.database.areEqual(v0, when)) continue;
                        then = args[i + 1];
                        break block112;
                    }
                    break block112;
                }
                case 209: {
                    Value[] list = Function.getArray(v0);
                    if (list == null) {
                        return ValueNull.INSTANCE;
                    }
                    Value v1 = Function.getNullOrValue(session, args, values, 1);
                    int element = v1.getInt();
                    if (element < 1) return ValueNull.INSTANCE;
                    if (element > list.length) return ValueNull.INSTANCE;
                    return list[element - 1];
                }
                case 217: {
                    Value[] list = Function.getArray(v0);
                    if (list == null) return ValueNull.INSTANCE;
                    return ValueInt.get(list.length);
                }
                case 230: {
                    Value result = ValueBoolean.FALSE;
                    Value[] list = Function.getArray(v0);
                    if (list == null) {
                        return ValueNull.INSTANCE;
                    }
                    Value v1 = Function.getNullOrValue(session, args, values, 1);
                    Value[] valueArray = list;
                    int n = valueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Value v = valueArray[n2];
                        if (this.database.areEqual(v, v1)) {
                            return ValueBoolean.TRUE;
                        }
                        ++n2;
                    }
                    return result;
                }
                case 221: {
                    return ValueBoolean.get(Function.cancelStatement(session, v0.getInt()));
                }
                case 226: {
                    return session.getTransactionId();
                }
                default: {
                    return null;
                }
            }
            for (i = 1; i < len; i += 2) {
                Value when = args[i].getValue(session);
                if (!when.getBoolean()) continue;
                then = args[i + 1];
                break;
            }
        }
        if (then == null && args.length % 2 == 0) {
            then = args[args.length - 1];
        }
        ValueNull v = then == null ? ValueNull.INSTANCE : then.getValue(session);
        return v.convertTo(this.type, this.database.getMode(), null);
    }

    private static Value getCeilOrFloor(Value v0, boolean floor) {
        Value result;
        int t = v0.getValueType();
        if (t == 7 || t == 8) {
            double v = v0.getDouble();
            v = floor ? Math.floor(v) : Math.ceil(v);
            result = t == 7 ? ValueDouble.get(v) : ValueFloat.get((float)v);
        } else {
            result = ValueDecimal.get(v0.getBigDecimal().setScale(0, floor ? RoundingMode.FLOOR : RoundingMode.CEILING));
        }
        return result;
    }

    private static Value[] getArray(Value v0) {
        int t = v0.getValueType();
        Object list = t == 17 || t == 39 ? ((ValueCollectionBase)v0).getList() : null;
        return list;
    }

    private static boolean cancelStatement(Session session, int targetSessionId) {
        Session[] sessions;
        session.getUser().checkAdmin();
        for (Session s : sessions = session.getDatabase().getSessions(false)) {
            if (s.getId() != targetSessionId) continue;
            Command c = s.getCurrentCommand();
            if (c == null) {
                return false;
            }
            c.cancel();
            return true;
        }
        return false;
    }

    private static long getDiskSpaceUsed(Session session, Value tableName) {
        return Function.getTable(session, tableName).getDiskSpaceUsed();
    }

    private static Value getEstimatedEnvelope(Session session, Value tableName, Value columnName) {
        Table table = Function.getTable(session, tableName);
        Column column = table.getColumn(columnName.getString());
        ArrayList<Index> indexes = table.getIndexes();
        if (indexes != null) {
            int size = indexes.size();
            for (int i = 1; i < size; ++i) {
                Index index = indexes.get(i);
                if (!(index instanceof MVSpatialIndex) || !index.isFirstColumn(column)) continue;
                return ((MVSpatialIndex)index).getEstimatedBounds(session);
            }
        }
        return ValueNull.INSTANCE;
    }

    private static Table getTable(Session session, Value tableName) {
        return new Parser(session).parseTableName(tableName.getString());
    }

    protected static Value getNullOrValue(Session session, Expression[] args, Value[] values, int i) {
        if (i >= args.length) {
            return null;
        }
        Value v = values[i];
        if (v == null) {
            Expression e = args[i];
            if (e == null) {
                return null;
            }
            v = values[i] = e.getValue(session);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Value getValueWithArgs(Session session, Expression[] args) {
        values = new Value[args.length];
        if (this.info.nullIfParameterIsNull) {
            for (i = 0; i < args.length; ++i) {
                e = args[i];
                v = e.getValue(session);
                if (v == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                values[i] = v;
            }
        }
        if ((resultSimple = this.getSimpleValue(session, v0 = Function.getNullOrValue(session, args, values, 0), args, values)) != null) {
            return resultSimple;
        }
        v1 = Function.getNullOrValue(session, args, values, 1);
        v2 = Function.getNullOrValue(session, args, values, 2);
        v3 = Function.getNullOrValue(session, args, values, 3);
        v4 = Function.getNullOrValue(session, args, values, 4);
        v5 = Function.getNullOrValue(session, args, values, 5);
        block10 : switch (this.info.type) {
            case 4: {
                result = ValueDouble.get(Math.atan2(v0.getDouble(), v1.getDouble()));
                break;
            }
            case 5: {
                result = ValueLong.get(v0.getLong() & v1.getLong());
                break;
            }
            case 40: {
                result = ValueBoolean.get((v0.getLong() & 1L << v1.getInt()) != 0L);
                break;
            }
            case 6: {
                result = ValueLong.get(v0.getLong() | v1.getLong());
                break;
            }
            case 7: {
                result = ValueLong.get(v0.getLong() ^ v1.getLong());
                break;
            }
            case 16: {
                x = v1.getLong();
                if (x == 0L) {
                    throw DbException.get(22012, this.getSQL(false));
                }
                result = ValueLong.get(v0.getLong() % x);
                break;
            }
            case 18: {
                result = ValueDouble.get(Math.pow(v0.getDouble(), v1.getDouble()));
                break;
            }
            case 21: {
                result = this.round(v0, v1);
                break;
            }
            case 27: {
                result = Function.truncate(session, v0, v1);
                break;
            }
            case 29: {
                result = Function.getHash(v0.getString(), v1, v2 == null ? 1 : v2.getInt());
                break;
            }
            case 30: {
                result = ValueBytes.getNoCopy(Function.encrypt(v0.getString(), v1.getBytesNoCopy(), v2.getBytesNoCopy()));
                break;
            }
            case 31: {
                result = ValueBytes.getNoCopy(Function.decrypt(v0.getString(), v1.getBytesNoCopy(), v2.getBytesNoCopy()));
                break;
            }
            case 32: {
                algorithm = null;
                if (v1 != null) {
                    algorithm = v1.getString();
                }
                result = ValueBytes.getNoCopy(CompressTool.getInstance().compress(v0.getBytesNoCopy(), algorithm));
                break;
            }
            case 41: {
                result = Function.oraHash(v0, v1 == null ? 0xFFFFFFFFL : v1.getLong(), v2 == null ? 0L : v2.getLong());
                break;
            }
            case 55: {
                result = ValueInt.get(Function.getDifference(v0.getString(), v1.getString()));
                break;
            }
            case 57: {
                if (v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE) {
                    result = v1;
                    break;
                }
                result = ValueString.get(Function.insert(v0.getString(), v1.getInt(), v2.getInt(), v3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 60: {
                result = ValueString.get(Function.left(v0.getString(), v1.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 62: {
                start = v2 == null ? 0 : v2.getInt();
                result = ValueInt.get(Function.locate(v0.getString(), v1.getString(), start));
                break;
            }
            case 58: {
                start = v2 == null ? 0 : v2.getInt();
                result = ValueInt.get(Function.locate(v1.getString(), v0.getString(), start));
                break;
            }
            case 66: {
                count = Math.max(0, v1.getInt());
                result = ValueString.get(Function.repeat(v0.getString(), count), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 67: {
                if (v0 == ValueNull.INSTANCE || v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE && this.database.getMode().getEnum() != Mode.ModeEnum.Oracle) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                s0 = v0.getString();
                s1 = v1.getString();
                v0 = s2 = v2 == null ? "" : v2.getString();
                if (s2 == null) {
                    s2 = "";
                }
                result = ValueString.get(StringUtils.replaceAll(s0, s1, s2), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 68: {
                result = ValueString.get(Function.right(v0.getString(), v1.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 63: {
                result = ValueString.get(StringUtils.trim(v0.getString(), true, false, v1 == null ? " " : v1.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 78: {
                result = ValueString.get(StringUtils.trim(v0.getString(), true, true, v1 == null ? " " : v1.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 69: {
                result = ValueString.get(StringUtils.trim(v0.getString(), false, true, v1 == null ? " " : v1.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 72: 
            case 73: {
                s = v0.getString();
                offset = v1.getInt();
                if (offset < 0) {
                    offset = s.length() + offset + 1;
                }
                length = v2 == null ? s.length() : v2.getInt();
                result = ValueString.get(Function.substring(s, offset, length), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 77: {
                result = ValueInt.get(Function.locate(v0.getString(), v1.getString(), 0));
                break;
            }
            case 83: {
                result = ValueString.get(StringUtils.xmlAttr(v0.getString(), v1.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 84: {
                v1 = v1 == null ? null : (attr = v1 == ValueNull.INSTANCE ? null : v1.getString());
                content = v2 == null ? null : (v2 == ValueNull.INSTANCE ? null : v2.getString());
                indent = v3 == null ? true : v3.getBoolean();
                result = ValueString.get(StringUtils.xmlNode(v0.getString(), attr, content, indent), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 89: {
                input = v0.getString();
                regexp = v1.getString();
                replacement = v2.getString();
                regexpMode = v3 != null ? v3.getString() : null;
                result = this.regexpReplace(input, regexp, replacement, regexpMode);
                break;
            }
            case 90: {
                result = ValueString.get(StringUtils.pad(v0.getString(), v1.getInt(), v2 == null ? null : v2.getString(), true), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 91: {
                result = ValueString.get(StringUtils.pad(v0.getString(), v1.getInt(), v2 == null ? null : v2.getString(), false), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 93: {
                switch (v0.getValueType()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 24: {
                        result = ValueString.get(ToChar.toCharDateTime(v0, v1 == null ? null : v1.getString(), v2 == null ? null : v2.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block10;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        result = ValueString.get(ToChar.toChar(v0.getBigDecimal(), v1 == null ? null : v1.getString(), v2 == null ? null : v2.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block10;
                    }
                }
                result = ValueString.get(v0.getString(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 96: {
                result = ToDateParser.toDate(session, v0.getString(), v1 == null ? null : v1.getString());
                break;
            }
            case 97: {
                result = ToDateParser.toTimestamp(session, v0.getString(), v1 == null ? null : v1.getString());
                break;
            }
            case 98: {
                result = DateTimeFunctions.dateadd("MONTH", v1.getInt(), v0);
                break;
            }
            case 99: {
                result = ToDateParser.toTimestampTz(session, v0.getString(), v1 == null ? null : v1.getString());
                break;
            }
            case 94: {
                matching = v1.getString();
                replacement = v2.getString();
                result = ValueString.get(Function.translate(v0.getString(), matching, replacement), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 231: {
                result = ValueString.get(Constants.getVersion(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 105: {
                result = DateTimeFunctions.dateadd(v0.getString(), v1.getLong(), v2);
                break;
            }
            case 106: {
                result = ValueLong.get(DateTimeFunctions.datediff(v0.getString(), v1, v2));
                break;
            }
            case 125: {
                result = DateTimeFunctions.truncateDate(v0.getString(), v1);
                break;
            }
            case 119: {
                result = DateTimeFunctions.extract(v0.getString(), v1, this.database.getMode());
                break;
            }
            case 120: {
                if (v0 == ValueNull.INSTANCE || v1 == ValueNull.INSTANCE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                v2 = v2 == null ? null : (locale = v2 == ValueNull.INSTANCE ? null : v2.getString());
                v3 = v3 == null ? null : (tz = v3 == ValueNull.INSTANCE ? null : v3.getString());
                if (v0 instanceof ValueTimestampTimeZone) {
                    tz = DateTimeUtils.timeZoneNameFromOffsetMins(((ValueTimestampTimeZone)v0).getTimeZoneOffsetMins());
                }
                result = ValueString.get(DateTimeFunctions.formatDateTime(v0.getTimestamp(), v1.getString(), locale, tz), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 121: {
                if (v0 == ValueNull.INSTANCE || v1 == ValueNull.INSTANCE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                v4 = v2 == null ? null : (locale = v2 == ValueNull.INSTANCE ? null : v2.getString());
                tz = v3 == null ? null : (v3 == ValueNull.INSTANCE ? null : v3.getString());
                d = DateTimeFunctions.parseDateTime(v0.getString(), v1.getString(), locale, tz);
                result = ValueTimestamp.fromMillis(d.getTime());
                break;
            }
            case 205: {
                result = this.database.areEqual(v0, v1) != false ? ValueNull.INSTANCE : v0;
                break;
            }
            case 207: {
                sequence = this.getSequence(session, v0, v1);
                value = new SequenceValue(sequence);
                result = value.getValue(session);
                break;
            }
            case 208: {
                sequence = this.getSequence(session, v0, v1);
                result = ValueLong.get(sequence.getCurrentValue());
                break;
            }
            case 210: {
                fileName = v0.getString();
                columnList = v1 == null ? null : v1.getString();
                csv = new Csv();
                options = v2 == null ? null : v2.getString();
                charset = null;
                if (options != null && options.indexOf(61) >= 0) {
                    charset = csv.setOptions(options);
                } else {
                    charset = options;
                    fieldSeparatorRead = v3 == null ? null : v3.getString();
                    fieldDelimiter = v4 == null ? null : v4.getString();
                    escapeCharacter = v5 == null ? null : v5.getString();
                    v6 = Function.getNullOrValue(session, args, values, 6);
                    nullString = v6 == null ? null : v6.getString();
                    Function.setCsvDelimiterEscape(csv, fieldSeparatorRead, fieldDelimiter, escapeCharacter);
                    csv.setNullString(nullString);
                }
                fieldSeparator = csv.getFieldSeparatorRead();
                columns = StringUtils.arraySplit(columnList, fieldSeparator, true);
                try {
                    result = ValueResultSet.get(session, csv.read(fileName, columns, charset), 0x7FFFFFFF);
                    break;
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
            }
            case 234: {
                array = (ValueArray)v0.convertTo(17);
                array2 = (ValueArray)v1.convertTo(17);
                if (!array.getComponentType().equals(array2.getComponentType())) {
                    throw DbException.get(50000, "Expected component type " + array.getComponentType() + " but got " + array2.getComponentType());
                }
                res = Arrays.copyOf(array.getList(), array.getList().length + array2.getList().length);
                System.arraycopy(array2.getList(), 0, res, array.getList().length, array2.getList().length);
                result = ValueArray.get(array.getComponentType(), res);
                break;
            }
            case 235: {
                array = (ValueArray)v0.convertTo(17);
                if (v1 != ValueNull.INSTANCE && array.getComponentType() != Object.class && !array.getComponentType().isInstance(v1.getObject())) {
                    throw DbException.get(50000, "Expected component type " + array.getComponentType() + " but got " + v1.getClass());
                }
                res = Arrays.copyOf(array.getList(), array.getList().length + 1);
                res[array.getList().length] = v1;
                result = ValueArray.get(array.getComponentType(), res);
                break;
            }
            case 236: {
                result = null;
                array = (ValueArray)v0.convertTo(17);
                index1 = v1.getInt() - 1;
                index2 = v2.getInt();
                v5 = isPG = this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL;
                if (index1 > index2) {
                    result = isPG ? ValueArray.get(array.getComponentType(), new Value[0]) : ValueNull.INSTANCE;
                } else {
                    if (index1 < 0) {
                        if (isPG) {
                            index1 = 0;
                        } else {
                            result = ValueNull.INSTANCE;
                        }
                    }
                    if (index2 > array.getList().length) {
                        if (isPG) {
                            index2 = array.getList().length;
                        } else {
                            result = ValueNull.INSTANCE;
                        }
                    }
                }
                if (result != null) break;
                result = ValueArray.get(array.getComponentType(), Arrays.copyOfRange(array.getList(), index1, index2));
                break;
            }
            case 218: {
                session.getUser().checkAdmin();
                conn = session.createConnection(false);
                rs = LinkSchema.linkSchema(conn, v0.getString(), v1.getString(), v2.getString(), v3.getString(), v4.getString(), v5.getString());
                result = ValueResultSet.get(session, rs, 0x7FFFFFFF);
                break;
            }
            case 211: {
                session.getUser().checkAdmin();
                conn = session.createConnection(false);
                csv = new Csv();
                options = v2 == null ? null : v2.getString();
                charset = null;
                if (options != null && options.indexOf(61) >= 0) {
                    charset = csv.setOptions(options);
                } else {
                    charset = options;
                    fieldSeparatorWrite = v3 == null ? null : v3.getString();
                    fieldDelimiter = v4 == null ? null : v4.getString();
                    escapeCharacter = v5 == null ? null : v5.getString();
                    v6 = Function.getNullOrValue(session, args, values, 6);
                    nullString = v6 == null ? null : v6.getString();
                    v7 = Function.getNullOrValue(session, args, values, 7);
                    lineSeparator = v7 == null ? null : v7.getString();
                    Function.setCsvDelimiterEscape(csv, fieldSeparatorWrite, fieldDelimiter, escapeCharacter);
                    csv.setNullString(nullString);
                    if (lineSeparator != null) {
                        csv.setLineSeparator(lineSeparator);
                    }
                }
                try {
                    rows = csv.write(conn, v0.getString(), v1.getString(), charset);
                    result = ValueInt.get(rows);
                    break;
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
            }
            case 222: {
                var = (Variable)args[0];
                session.setVariable(var.getName(), v1);
                result = v1;
                break;
            }
            case 225: {
                session.getUser().checkAdmin();
                fileName = v0.getString();
                blob = args.length == 1;
                try {
                    fileLength = FileUtils.size(fileName);
                    in = FileUtils.newInputStream(fileName);
                    try {
                        if (blob) {
                            result = this.database.getLobStorage().createBlob(in, fileLength);
                        } else {
                            reader = v1 == ValueNull.INSTANCE ? new InputStreamReader(in) : new InputStreamReader(in, v1.getString());
                            result = this.database.getLobStorage().createClob(reader, fileLength);
                        }
                    }
                    finally {
                        IOUtils.closeSilently(in);
                    }
                    session.addTemporaryLob(result);
                    break;
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, fileName);
                }
            }
            case 232: {
                session.getUser().checkAdmin();
                result = ValueNull.INSTANCE;
                fileName = v1.getString();
                try {
                    fileOutputStream = new FileOutputStream(fileName);
                    in = v0.getInputStream();
                    charset = null;
                    result = ValueLong.get(IOUtils.copyAndClose(in, fileOutputStream));
                    if (in == null) break;
                    if (charset == null) ** GOTO lbl359
                    try {
                        in.close();
                    }
                    catch (Throwable var16_83) {
                        charset.addSuppressed(var16_83);
                    }
                    break;
lbl359:
                    // 1 sources

                    in.close();
                    ** break;
                    catch (Throwable var16_84) {
                        try {
                            charset = var16_84;
                            throw var16_84;
                        }
                        catch (Throwable var24_100) {
                            if (in != null) {
                                if (charset != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable var25_101) {
                                        charset.addSuppressed(var25_101);
                                    }
                                } else {
                                    in.close();
                                }
                            }
                            throw var24_100;
lbl376:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, fileName);
                }
            }
            case 227: {
                result = v0.convertPrecision(v1.getLong(), v2.getBoolean());
                break;
            }
            case 88: {
                if (v1 == null) {
                    result = ValueString.get(StringUtils.xmlText(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                result = ValueString.get(StringUtils.xmlText(v0.getString(), v1.getBoolean()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 240: {
                regexp = v1.getString();
                regexpMode = v2 != null ? v2.getString() : null;
                flags = Function.makeRegexpFlags(regexpMode, false);
                try {
                    result = ValueBoolean.get(Pattern.compile(regexp, flags).matcher(v0.getString()).find());
                    break;
                }
                catch (PatternSyntaxException e) {
                    throw DbException.get(22025, e, new String[]{regexp});
                }
            }
            case 250: {
                a0 = args[0];
                builder = new StringBuilder();
                Parser.quoteIdentifier(builder, a0.getSchemaName(), true).append('.');
                Parser.quoteIdentifier(builder, a0.getTableName(), true).append('.');
                Parser.quoteIdentifier(builder, a0.getColumnName(), true);
                result = session.getVariable(builder.toString());
                break;
            }
            case 160: {
                sqlState = v0.getString();
                if (sqlState.startsWith("00") || !Function.SIGNAL_PATTERN.matcher(sqlState).matches()) {
                    throw DbException.getInvalidValueException("SQLSTATE", sqlState);
                }
                msgText = v1.getString();
                throw DbException.fromUser(sqlState, msgText);
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return result;
    }

    private Value round(Value v0, Value v1) {
        Value result;
        BigDecimal bd = v0.getBigDecimal().setScale(v1 == null ? 0 : v1.getInt(), RoundingMode.HALF_UP);
        switch (this.type.getValueType()) {
            case 7: {
                result = ValueDouble.get(bd.doubleValue());
                break;
            }
            case 8: {
                result = ValueFloat.get(bd.floatValue());
                break;
            }
            default: {
                result = ValueDecimal.get(bd);
            }
        }
        return result;
    }

    private static Value truncate(Session session, Value v0, Value v1) {
        Value result;
        int t = v0.getValueType();
        switch (t) {
            case 11: {
                result = ValueTimestamp.fromDateValueAndNanos(((ValueTimestamp)v0).getDateValue(), 0L);
                break;
            }
            case 10: {
                result = ValueTimestamp.fromDateValueAndNanos(((ValueDate)v0).getDateValue(), 0L);
                break;
            }
            case 24: {
                ValueTimestampTimeZone ts = (ValueTimestampTimeZone)v0;
                result = ValueTimestampTimeZone.fromDateValueAndNanos(ts.getDateValue(), 0L, ts.getTimeZoneOffsetMins());
                break;
            }
            case 13: {
                result = ValueTimestamp.fromDateValueAndNanos(ValueTimestamp.parse(v0.getString(), session.getDatabase().getMode()).getDateValue(), 0L);
                break;
            }
            default: {
                int scale;
                int n = scale = v1 == null ? 0 : v1.getInt();
                if (t == 7 || t == 8) {
                    double f;
                    double d = v0.getDouble();
                    d = scale == 0 ? (d < 0.0 ? Math.ceil(d) : Math.floor(d)) : ((d *= (f = Math.pow(10.0, scale))) < 0.0 ? Math.ceil(d) : Math.floor(d)) / f;
                    result = t == 7 ? ValueDouble.get(d) : ValueFloat.get((float)d);
                    break;
                }
                result = ValueDecimal.get(v0.getBigDecimal().setScale(scale, RoundingMode.DOWN));
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sequence getSequence(Session session, Value v0, Value v1) {
        Sequence seq;
        Schema s;
        String sequenceName;
        String schemaName;
        if (v1 == null) {
            Parser p = new Parser(session);
            String sql = v0.getString();
            Expression expr = p.parseExpression(sql);
            if (!(expr instanceof ExpressionColumn)) throw DbException.getSyntaxError(sql, 1);
            ExpressionColumn seq2 = (ExpressionColumn)expr;
            schemaName = seq2.getOriginalTableAliasName();
            if (schemaName == null) {
                schemaName = session.getCurrentSchemaName();
                sequenceName = sql;
            } else {
                sequenceName = seq2.getColumnName();
            }
        } else {
            schemaName = v0.getString();
            sequenceName = v1.getString();
        }
        if ((s = this.database.findSchema(schemaName)) == null) {
            schemaName = StringUtils.toUpperEnglish(schemaName);
            s = this.database.getSchema(schemaName);
        }
        if ((seq = s.findSequence(sequenceName)) != null) return seq;
        sequenceName = StringUtils.toUpperEnglish(sequenceName);
        return s.getSequence(sequenceName);
    }

    private static long length(Value v) {
        switch (v.getValueType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return v.getType().getPrecision();
            }
        }
        return v.getString().length();
    }

    private static byte[] getPaddedArrayCopy(byte[] data, int blockSize) {
        int size = MathUtils.roundUpInt(data.length, blockSize);
        return Utils.copyBytes(data, size);
    }

    private static byte[] decrypt(String algorithm, byte[] key, byte[] data) {
        BlockCipher cipher = CipherFactory.getBlockCipher(algorithm);
        byte[] newKey = Function.getPaddedArrayCopy(key, cipher.getKeyLength());
        cipher.setKey(newKey);
        byte[] newData = Function.getPaddedArrayCopy(data, 16);
        cipher.decrypt(newData, 0, newData.length);
        return newData;
    }

    private static byte[] encrypt(String algorithm, byte[] key, byte[] data) {
        BlockCipher cipher = CipherFactory.getBlockCipher(algorithm);
        byte[] newKey = Function.getPaddedArrayCopy(key, cipher.getKeyLength());
        cipher.setKey(newKey);
        byte[] newData = Function.getPaddedArrayCopy(data, 16);
        cipher.encrypt(newData, 0, newData.length);
        return newData;
    }

    private static Value getHash(String algorithm, Value value, int iterations) {
        if (!"SHA256".equalsIgnoreCase(algorithm)) {
            throw DbException.getInvalidValueException("algorithm", algorithm);
        }
        if (iterations <= 0) {
            throw DbException.getInvalidValueException("iterations", iterations);
        }
        MessageDigest md = Function.hashImpl(value, "SHA-256");
        if (md == null) {
            return ValueNull.INSTANCE;
        }
        byte[] b = md.digest();
        for (int i = 1; i < iterations; ++i) {
            b = md.digest(b);
        }
        return ValueBytes.getNoCopy(b);
    }

    private static String substring(String s, int start, int length) {
        int len = s.length();
        if (--start < 0) {
            start = 0;
        }
        if (length < 0) {
            length = 0;
        }
        int n = start = start > len ? len : start;
        if (start + length > len) {
            length = len - start;
        }
        return s.substring(start, start + length);
    }

    private static String repeat(String s, int count) {
        StringBuilder buff = new StringBuilder(s.length() * count);
        while (count-- > 0) {
            buff.append(s);
        }
        return buff.toString();
    }

    private static String rawToHex(String s) {
        int length = s.length();
        StringBuilder buff = new StringBuilder(4 * length);
        for (int i = 0; i < length; ++i) {
            String hex = Integer.toHexString(s.charAt(i) & 0xFFFF);
            for (int j = hex.length(); j < 4; ++j) {
                buff.append('0');
            }
            buff.append(hex);
        }
        return buff.toString();
    }

    private static int locate(String search, String s, int start) {
        if (start < 0) {
            int i = s.length() + start;
            return s.lastIndexOf(search, i) + 1;
        }
        int i = start == 0 ? 0 : start - 1;
        return s.indexOf(search, i) + 1;
    }

    private static String right(String s, int count) {
        if (count < 0) {
            count = 0;
        } else if (count > s.length()) {
            count = s.length();
        }
        return s.substring(s.length() - count);
    }

    private static String left(String s, int count) {
        if (count < 0) {
            count = 0;
        } else if (count > s.length()) {
            count = s.length();
        }
        return s.substring(0, count);
    }

    private static String insert(String s1, int start, int length, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        if (--start < 0 || length <= 0 || len2 == 0 || start > len1) {
            return s1;
        }
        if (start + length > len1) {
            length = len1 - start;
        }
        return s1.substring(0, start) + s2 + s1.substring(start + length);
    }

    private static String hexToRaw(String s) {
        int len = s.length();
        if (len % 4 != 0) {
            throw DbException.get(22018, s);
        }
        StringBuilder buff = new StringBuilder(len / 4);
        for (int i = 0; i < len; i += 4) {
            try {
                char raw = (char)Integer.parseInt(s.substring(i, i + 4), 16);
                buff.append(raw);
                continue;
            }
            catch (NumberFormatException e) {
                throw DbException.get(22018, s);
            }
        }
        return buff.toString();
    }

    private static int getDifference(String s1, String s2) {
        s1 = Function.getSoundex(s1);
        s2 = Function.getSoundex(s2);
        int e = 0;
        for (int i = 0; i < 4; ++i) {
            if (s1.charAt(i) != s2.charAt(i)) continue;
            ++e;
        }
        return e;
    }

    private static String translate(String original, String findChars, String replaceChars) {
        if (StringUtils.isNullOrEmpty(original) || StringUtils.isNullOrEmpty(findChars)) {
            return original;
        }
        StringBuilder buff = null;
        int replaceSize = replaceChars == null ? 0 : replaceChars.length();
        int size = original.length();
        for (int i = 0; i < size; ++i) {
            char ch = original.charAt(i);
            int index = findChars.indexOf(ch);
            if (index >= 0) {
                if (buff == null) {
                    buff = new StringBuilder(size);
                    if (i > 0) {
                        buff.append(original, 0, i);
                    }
                }
                if (index < replaceSize) {
                    ch = replaceChars.charAt(index);
                }
            }
            if (buff == null) continue;
            buff.append(ch);
        }
        return buff == null ? original : buff.toString();
    }

    private static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuilder s = new StringBuilder();
        s.append(d);
        if (s.toString().indexOf(69) >= 0) {
            return d;
        }
        int len = s.length();
        if (len < 16) {
            return d;
        }
        if (s.toString().indexOf(46) > len - 3) {
            return d;
        }
        s.delete(len - 2, len);
        char c1 = s.charAt((len -= 2) - 2);
        char c2 = s.charAt(len - 3);
        char c3 = s.charAt(len - 4);
        if (c1 == '0' && c2 == '0' && c3 == '0') {
            s.setCharAt(len - 1, '0');
        } else if (c1 == '9' && c2 == '9' && c3 == '9') {
            s.setCharAt(len - 1, '9');
            s.append('9');
            s.append('9');
            s.append('9');
        }
        return Double.parseDouble(s.toString());
    }

    private static String getSoundex(String s) {
        int len = s.length();
        char[] chars = new char[]{'0', '0', '0', '0'};
        char lastDigit = '0';
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            char newDigit;
            char c = s.charAt(i);
            char c2 = newDigit = c > SOUNDEX_INDEX.length ? (char)'\u0000' : SOUNDEX_INDEX[c];
            if (newDigit == '\u0000') continue;
            if (j == 0) {
                chars[j++] = c;
                lastDigit = newDigit;
                continue;
            }
            if (newDigit <= '6') {
                if (newDigit == lastDigit) continue;
                chars[j++] = newDigit;
                lastDigit = newDigit;
                continue;
            }
            if (newDigit != '7') continue;
            lastDigit = newDigit;
        }
        return new String(chars);
    }

    private static Value oraHash(Value value, long bucket, long seed) {
        if ((bucket & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("bucket", bucket);
        }
        if ((seed & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("seed", seed);
        }
        MessageDigest md = Function.hashImpl(value, "SHA-1");
        if (md == null) {
            return ValueNull.INSTANCE;
        }
        if (seed != 0L) {
            byte[] b = new byte[4];
            Bits.writeInt(b, 0, (int)seed);
            md.update(b);
        }
        long hc = Bits.readLong(md.digest(), 0);
        return ValueLong.get((hc & Long.MAX_VALUE) % (bucket + 1L));
    }

    /*
     * Unable to fully structure code
     */
    private static MessageDigest hashImpl(Value value, String algorithm) {
        switch (value.getValueType()) {
            case 0: {
                return null;
            }
            case 13: 
            case 14: 
            case 21: {
                try {
                    md = MessageDigest.getInstance(algorithm);
                    md.update(value.getString().getBytes(StandardCharsets.UTF_8));
                    break;
                }
                catch (Exception ex) {
                    throw DbException.convert(ex);
                }
            }
            case 15: 
            case 16: {
                try {
                    md = MessageDigest.getInstance(algorithm);
                    buf = new byte[4096];
                    is = value.getInputStream();
                    var5_8 = null;
                    while ((r = is.read(buf)) > 0) {
                        md.update(buf, 0, r);
                    }
                    if (is == null) break;
                    if (var5_8 == null) ** GOTO lbl29
                    try {
                        is.close();
                    }
                    catch (Throwable var6_10) {
                        var5_8.addSuppressed(var6_10);
                    }
                    break;
lbl29:
                    // 1 sources

                    is.close();
                    ** break;
                    catch (Throwable var6_11) {
                        try {
                            var5_8 = var6_11;
                            throw var6_11;
                        }
                        catch (Throwable var7_12) {
                            if (is != null) {
                                if (var5_8 != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable var8_13) {
                                        var5_8.addSuppressed(var8_13);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                            throw var7_12;
lbl46:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    throw DbException.convert(ex);
                }
            }
            default: {
                try {
                    md = MessageDigest.getInstance(algorithm);
                    md.update(value.getBytesNoCopy());
                    break;
                }
                catch (Exception ex) {
                    throw DbException.convert(ex);
                }
            }
        }
        return md;
    }

    private Value regexpReplace(String input, String regexp, String replacement, String regexpMode) {
        Mode mode = this.database.getMode();
        if (mode.regexpReplaceBackslashReferences && (replacement.indexOf(92) >= 0 || replacement.indexOf(36) >= 0)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < replacement.length(); ++i) {
                char c = replacement.charAt(i);
                if (c == '$') {
                    sb.append('\\');
                } else if (c == '\\' && ++i < replacement.length()) {
                    c = replacement.charAt(i);
                    sb.append((char)(c >= '0' && c <= '9' ? 36 : 92));
                }
                sb.append(c);
            }
            replacement = sb.toString();
        }
        boolean isInPostgreSqlMode = Mode.ModeEnum.PostgreSQL.equals((Object)mode.getEnum());
        int flags = Function.makeRegexpFlags(regexpMode, isInPostgreSqlMode);
        try {
            Matcher matcher = Pattern.compile(regexp, flags).matcher(input);
            return ValueString.get(isInPostgreSqlMode && (regexpMode == null || regexpMode.indexOf(103) < 0) ? matcher.replaceFirst(replacement) : matcher.replaceAll(replacement), mode.treatEmptyStringsAsNull);
        }
        catch (PatternSyntaxException e) {
            throw DbException.get(22025, e, regexp);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException e) {
            throw DbException.get(22025, e, replacement);
        }
    }

    private static int makeRegexpFlags(String stringFlags, boolean ignoreGlobalFlag) {
        int flags = 64;
        if (stringFlags != null) {
            block7: for (int i = 0; i < stringFlags.length(); ++i) {
                switch (stringFlags.charAt(i)) {
                    case 'i': {
                        flags |= 2;
                        continue block7;
                    }
                    case 'c': {
                        flags &= 0xFFFFFFFD;
                        continue block7;
                    }
                    case 'n': {
                        flags |= 0x20;
                        continue block7;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block7;
                    }
                    case 'g': {
                        if (ignoreGlobalFlag) continue block7;
                    }
                    default: {
                        throw DbException.get(90008, stringFlags);
                    }
                }
            }
        }
        return flags;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public int getValueType() {
        return this.type.getValueType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.mapColumns(resolver, level, state);
        }
    }

    protected void checkParameterCount(int len) {
        boolean ok;
        int min = 0;
        int max = Integer.MAX_VALUE;
        switch (this.info.type) {
            case 204: 
            case 210: 
            case 219: 
            case 220: {
                min = 1;
                break;
            }
            case 20: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                max = 1;
                break;
            }
            case 21: 
            case 27: 
            case 32: 
            case 63: 
            case 69: 
            case 78: 
            case 88: 
            case 97: 
            case 99: 
            case 225: {
                min = 1;
                max = 2;
                break;
            }
            case 125: {
                min = 2;
                max = 2;
                break;
            }
            case 93: 
            case 96: {
                min = 1;
                max = 3;
                break;
            }
            case 41: {
                min = 1;
                max = 3;
                break;
            }
            case 29: 
            case 58: 
            case 62: 
            case 67: 
            case 72: 
            case 73: 
            case 90: 
            case 91: {
                min = 2;
                max = 3;
                break;
            }
            case 54: 
            case 92: 
            case 211: {
                min = 2;
                break;
            }
            case 84: {
                min = 1;
                max = 4;
                break;
            }
            case 120: 
            case 121: {
                min = 2;
                max = 4;
                break;
            }
            case 207: 
            case 208: {
                min = 1;
                max = 2;
                break;
            }
            case 206: 
            case 229: {
                min = 3;
                break;
            }
            case 89: {
                min = 3;
                max = 4;
                break;
            }
            case 240: {
                min = 2;
                max = 3;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
            }
        }
        boolean bl = ok = len >= min && len <= max;
        if (!ok) {
            throw DbException.get(7001, this.info.name, min + ".." + max);
        }
    }

    public void doneWithParameters() {
        if (this.info.parameterCount == -1) {
            this.checkParameterCount(this.varArgs.size());
            this.args = this.varArgs.toArray(new Expression[0]);
            this.varArgs = null;
        } else {
            int len = this.args.length;
            if (len > 0 && this.args[len - 1] == null) {
                throw DbException.get(7001, this.info.name, Integer.toString(len));
            }
        }
    }

    public void setDataType(Column col) {
        TypeInfo type;
        this.type = type = col.getType();
    }

    @Override
    public Expression optimize(Session session) {
        TypeInfo typeInfo;
        boolean allConst = this.info.deterministic;
        for (int i = 0; i < this.args.length; ++i) {
            Expression e = this.args[i];
            if (e == null) continue;
            this.args[i] = e = e.optimize(session);
            if (e.isConstant()) continue;
            allConst = false;
        }
        Expression p0 = this.args.length < 1 ? null : this.args[0];
        block0 : switch (this.info.type) {
            case 105: {
                typeInfo = TypeInfo.TYPE_TIMESTAMP;
                if (!p0.isConstant()) break;
                Expression p2 = this.args[2];
                block25 : switch (p2.getType().getValueType()) {
                    case 9: {
                        typeInfo = TypeInfo.TYPE_TIME;
                        break;
                    }
                    case 10: {
                        int field = DateTimeFunctions.getDatePart(p0.getValue(session).getString());
                        switch (field) {
                            case 111: 
                            case 112: 
                            case 116: 
                            case 126: 
                            case 127: 
                            case 128: 
                            case 129: {
                                break block25;
                            }
                        }
                        this.type = TypeInfo.TYPE_DATE;
                        break;
                    }
                    case 24: {
                        this.type = TypeInfo.TYPE_TIMESTAMP_TZ;
                    }
                }
                break;
            }
            case 119: {
                if (p0.isConstant() && DateTimeFunctions.getDatePart(p0.getValue(session).getString()) == 127) {
                    typeInfo = TypeInfo.getTypeInfo(6, 28L, 9, null);
                    break;
                }
                typeInfo = TypeInfo.TYPE_INT;
                break;
            }
            case 125: {
                typeInfo = this.args[1].getType();
                if (typeInfo.getValueType() == 24) break;
                typeInfo = TypeInfo.TYPE_TIMESTAMP;
                break;
            }
            case 200: 
            case 204: 
            case 205: 
            case 219: 
            case 220: {
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                for (Expression e : this.args) {
                    TypeInfo type;
                    int valueType;
                    if (e == ValueExpression.getNull() || (valueType = (type = e.getType()).getValueType()) == -1 || valueType == 0) continue;
                    typeInfo = Value.getHigherType(typeInfo, type);
                }
                if (typeInfo.getValueType() != -1) break;
                typeInfo = TypeInfo.TYPE_STRING;
                break;
            }
            case 206: 
            case 229: {
                TypeInfo type;
                int valueType;
                Expression elsePart;
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                int len = this.args.length;
                for (int i = 2; i < len; i += 2) {
                    TypeInfo type2;
                    int valueType2;
                    Expression then = this.args[i];
                    if (then == ValueExpression.getNull() || (valueType2 = (type2 = then.getType()).getValueType()) == -1 || valueType2 == 0) continue;
                    typeInfo = Value.getHigherType(typeInfo, type2);
                }
                if (this.args.length % 2 == 0 && (elsePart = this.args[this.args.length - 1]) != ValueExpression.getNull() && (valueType = (type = elsePart.getType()).getValueType()) != -1 && valueType != 0) {
                    typeInfo = Value.getHigherType(typeInfo, type);
                }
                if (typeInfo.getValueType() != -1) break;
                typeInfo = TypeInfo.TYPE_STRING;
                break;
            }
            case 201: {
                typeInfo = Value.getHigherType(this.args[1].getType(), this.args[2].getType());
                break;
            }
            case 228: {
                TypeInfo t1 = this.args[1].getType();
                TypeInfo t2 = this.args[2].getType();
                switch (t1.getValueType()) {
                    case 13: 
                    case 14: 
                    case 16: 
                    case 21: {
                        typeInfo = TypeInfo.getTypeInfo(t1.getValueType(), -1L, 0, null);
                        break block0;
                    }
                }
                typeInfo = Value.getHigherType(t1, t2);
                break;
            }
            case 202: 
            case 203: 
            case 227: {
                if (this.type != null) {
                    typeInfo = this.type;
                    break;
                }
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                break;
            }
            case 8: 
            case 13: 
            case 21: {
                switch (p0.getType().getValueType()) {
                    case 7: {
                        typeInfo = TypeInfo.TYPE_DOUBLE;
                        break block0;
                    }
                    case 8: {
                        typeInfo = TypeInfo.TYPE_FLOAT;
                        break block0;
                    }
                }
                typeInfo = this.getRoundNumericType(session);
                break;
            }
            case 27: {
                switch (p0.getType().getValueType()) {
                    case 7: {
                        typeInfo = TypeInfo.TYPE_DOUBLE;
                        break block0;
                    }
                    case 8: {
                        typeInfo = TypeInfo.TYPE_FLOAT;
                        break block0;
                    }
                    case 10: 
                    case 11: 
                    case 13: {
                        if (this.args.length > 1) {
                            throw DbException.get(7001, this.info.name, "1");
                        }
                        typeInfo = TypeInfo.getTypeInfo(11, -1L, 0, null);
                        break block0;
                    }
                    case 24: {
                        if (this.args.length > 1) {
                            throw DbException.get(7001, this.info.name, "1");
                        }
                        typeInfo = TypeInfo.getTypeInfo(24, -1L, 0, null);
                        break block0;
                    }
                }
                typeInfo = this.getRoundNumericType(session);
                break;
            }
            case 0: {
                TypeInfo type;
                typeInfo = type = p0.getType();
                if (typeInfo.getValueType() != 0) break;
                typeInfo = TypeInfo.TYPE_INT;
                break;
            }
            case 222: {
                typeInfo = this.args[1].getType();
                if (p0 instanceof Variable) break;
                throw DbException.get(90137, p0.getSQL(false));
            }
            case 225: {
                if (this.args.length == 1) {
                    typeInfo = TypeInfo.getTypeInfo(15, Integer.MAX_VALUE, 0, null);
                    break;
                }
                typeInfo = TypeInfo.getTypeInfo(16, Integer.MAX_VALUE, 0, null);
                break;
            }
            case 72: 
            case 73: {
                long p = this.args[0].getType().getPrecision();
                if (this.args[1].isConstant()) {
                    p -= this.args[1].getValue(session).getLong() - 1L;
                }
                if (this.args.length == 3 && this.args[2].isConstant()) {
                    p = Math.min(p, this.args[2].getValue(session).getLong());
                }
                p = Math.max(0L, p);
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, p, 0, null);
                break;
            }
            case 30: 
            case 31: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[2].getType().getPrecision(), 0, null);
                break;
            }
            case 32: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision(), 0, null);
                break;
            }
            case 52: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 1L, 0, null);
                break;
            }
            case 54: {
                long p = 0L;
                for (Expression e : this.args) {
                    TypeInfo type = e.getType();
                    if ((p += type.getPrecision()) >= 0L) continue;
                    p = Long.MAX_VALUE;
                }
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, p, 0, null);
                break;
            }
            case 56: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, (this.args[0].getType().getPrecision() + 3L) / 4L, 0, null);
                break;
            }
            case 59: 
            case 63: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision(), 0, null);
                break;
            }
            case 65: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision() * 4L, 0, null);
                break;
            }
            case 70: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 4L, 0, null);
                break;
            }
            case 107: 
            case 114: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 20L, 0, null);
                break;
            }
            default: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, -1L, -1, null);
            }
        }
        this.type = typeInfo;
        if (allConst) {
            Value v = this.getValue(session);
            if (this.info.type == 203 || this.info.type == 202) {
                if (v == ValueNull.INSTANCE) {
                    return this;
                }
                DataType dt = DataType.getDataType(this.type.getValueType());
                TypeInfo vt = v.getType();
                if (dt.supportsPrecision && this.type.getPrecision() != vt.getPrecision() || dt.supportsScale && this.type.getScale() != vt.getScale()) {
                    return this;
                }
            }
            return ValueExpression.get(v);
        }
        return this;
    }

    private TypeInfo getRoundNumericType(Session session) {
        int scale = 0;
        if (this.args.length > 1) {
            Expression scaleExpr = this.args[1];
            if (scaleExpr.isConstant()) {
                Value scaleValue = scaleExpr.getValue(session);
                if (scaleValue != ValueNull.INSTANCE) {
                    scale = scaleValue.getInt();
                }
            } else {
                scale = Integer.MAX_VALUE;
            }
        }
        return TypeInfo.getTypeInfo(6, Integer.MAX_VALUE, scale, null);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        boolean addParentheses;
        builder.append(this.info.name);
        if (this.info.type == 206) {
            if (this.args[0] != null) {
                builder.append(' ');
                this.args[0].getSQL(builder, alwaysQuote);
            }
            int len = this.args.length - 1;
            for (int i = 1; i < len; i += 2) {
                builder.append(" WHEN ");
                this.args[i].getSQL(builder, alwaysQuote);
                builder.append(" THEN ");
                this.args[i + 1].getSQL(builder, alwaysQuote);
            }
            if (this.args.length % 2 == 0) {
                builder.append(" ELSE ");
                this.args[this.args.length - 1].getSQL(builder, alwaysQuote);
            }
            return builder.append(" END");
        }
        boolean bl = addParentheses = this.args.length > 0 || this.info.requireParentheses;
        if (addParentheses) {
            builder.append('(');
        }
        switch (this.info.type) {
            case 203: {
                this.args[0].getSQL(builder, alwaysQuote).append(" AS ").append(new Column(null, this.type).getCreateSQL());
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    builder.append(new Column(null, this.type).getCreateSQL()).append(',');
                    this.args[0].getSQL(builder, alwaysQuote);
                    break;
                }
                this.args[0].getSQL(builder, alwaysQuote).append(',').append(new Column(null, this.type).getCreateSQL());
                break;
            }
            case 119: {
                ValueString v = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                builder.append(v.getString()).append(" FROM ");
                this.args[1].getSQL(builder, alwaysQuote);
                break;
            }
            default: {
                Function.writeExpressions(builder, this.args, alwaysQuote);
            }
        }
        if (addParentheses) {
            builder.append(')');
        }
        return builder;
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.updateAggregate(session, stage);
        }
    }

    public int getFunctionType() {
        return this.info.type;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] argList) {
        switch (this.info.type) {
            case 210: {
                ValueResultSet x;
                String fileName = argList[0].getValue(session).getString();
                if (fileName == null) {
                    throw DbException.get(90012, "fileName");
                }
                String columnList = argList.length < 2 ? null : argList[1].getValue(session).getString();
                Csv csv = new Csv();
                String options = argList.length < 3 ? null : argList[2].getValue(session).getString();
                String charset = null;
                if (options != null && options.indexOf(61) >= 0) {
                    charset = csv.setOptions(options);
                } else {
                    charset = options;
                    String fieldSeparatorRead = argList.length < 4 ? null : argList[3].getValue(session).getString();
                    String fieldDelimiter = argList.length < 5 ? null : argList[4].getValue(session).getString();
                    String escapeCharacter = argList.length < 6 ? null : argList[5].getValue(session).getString();
                    Function.setCsvDelimiterEscape(csv, fieldSeparatorRead, fieldDelimiter, escapeCharacter);
                }
                char fieldSeparator = csv.getFieldSeparatorRead();
                String[] columns = StringUtils.arraySplit(columnList, fieldSeparator, true);
                ResultSet rs = null;
                try {
                    rs = csv.read(fileName, columns, charset);
                    x = ValueResultSet.get(session, rs, 0);
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
                finally {
                    csv.close();
                    JdbcUtils.closeSilently(rs);
                }
                return x;
            }
        }
        return (ValueResultSet)this.getValueWithArgs(session, argList);
    }

    private static void setCsvDelimiterEscape(Csv csv, String fieldSeparator, String fieldDelimiter, String escapeCharacter) {
        if (fieldSeparator != null) {
            csv.setFieldSeparatorWrite(fieldSeparator);
            if (!fieldSeparator.isEmpty()) {
                char fs = fieldSeparator.charAt(0);
                csv.setFieldSeparatorRead(fs);
            }
        }
        if (fieldDelimiter != null) {
            char fd = fieldDelimiter.isEmpty() ? (char)'\u0000' : fieldDelimiter.charAt(0);
            csv.setFieldDelimiter(fd);
        }
        if (escapeCharacter != null) {
            char ec = escapeCharacter.isEmpty() ? (char)'\u0000' : escapeCharacter.charAt(0);
            csv.setEscapeCharacter(ec);
        }
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        for (Expression e : this.args) {
            if (e == null || e.isEverything(visitor)) continue;
            return false;
        }
        switch (visitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return this.info.deterministic;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public int getCost() {
        int cost = 3;
        for (Expression e : this.args) {
            if (e == null) continue;
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public boolean isDeterministic() {
        return this.info.deterministic;
    }

    @Override
    public boolean isBufferResultSetToLocalTemp() {
        return this.info.bufferResultSetToLocalTemp;
    }

    @Override
    public boolean isGeneratedKey() {
        return this.info.type == 207;
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.args[index];
    }

    static {
        String index = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char number = '\u0000';
        int length = index.length();
        for (int i = 0; i < length; ++i) {
            char c = index.charAt(i);
            if (c < '9') {
                number = c;
                continue;
            }
            Function.SOUNDEX_INDEX[c] = number;
            Function.SOUNDEX_INDEX[Character.toLowerCase((char)c)] = number;
        }
        Function.addFunction("ABS", 0, 1, 0);
        Function.addFunction("ACOS", 1, 1, 7);
        Function.addFunction("ASIN", 2, 1, 7);
        Function.addFunction("ATAN", 3, 1, 7);
        Function.addFunction("ATAN2", 4, 2, 7);
        Function.addFunction("BITAND", 5, 2, 5);
        Function.addFunction("BITGET", 40, 2, 1);
        Function.addFunction("BITOR", 6, 2, 5);
        Function.addFunction("BITXOR", 7, 2, 5);
        Function.addFunction("CEILING", 8, 1, 0);
        Function.addFunction("CEIL", 8, 1, 0);
        Function.addFunction("COS", 9, 1, 7);
        Function.addFunction("COSH", 36, 1, 7);
        Function.addFunction("COT", 10, 1, 7);
        Function.addFunction("DEGREES", 11, 1, 7);
        Function.addFunction("EXP", 12, 1, 7);
        Function.addFunction("FLOOR", 13, 1, 0);
        Function.addFunction("LOG", 14, 1, 7);
        Function.addFunction("LN", 39, 1, 7);
        Function.addFunction("LOG10", 15, 1, 7);
        Function.addFunction("MOD", 16, 2, 5);
        Function.addFunction("PI", 17, 0, 7);
        Function.addFunction("POWER", 18, 2, 7);
        Function.addFunction("RADIANS", 19, 1, 7);
        Function.addFunctionNotDeterministic("RAND", 20, -1, 7);
        Function.addFunctionNotDeterministic("RANDOM", 20, -1, 7);
        Function.addFunction("ROUND", 21, -1, 0);
        Function.addFunction("ROUNDMAGIC", 22, 1, 7);
        Function.addFunction("SIGN", 23, 1, 4);
        Function.addFunction("SIN", 24, 1, 7);
        Function.addFunction("SINH", 37, 1, 7);
        Function.addFunction("SQRT", 25, 1, 7);
        Function.addFunction("TAN", 26, 1, 7);
        Function.addFunction("TANH", 38, 1, 7);
        Function.addFunction("TRUNCATE", 27, -1, 0);
        Function.addFunction("TRUNC", 27, -1, 0);
        Function.addFunction("HASH", 29, -1, 12);
        Function.addFunction("ENCRYPT", 30, 3, 12);
        Function.addFunction("DECRYPT", 31, 3, 12);
        Function.addFunctionNotDeterministic("SECURE_RAND", 28, 1, 12);
        Function.addFunction("COMPRESS", 32, -1, 12);
        Function.addFunction("EXPAND", 33, 1, 12);
        Function.addFunction("ZERO", 34, 0, 4);
        Function.addFunctionNotDeterministic("RANDOM_UUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("SYS_GUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("UUID", 35, 0, 20);
        Function.addFunction("ORA_HASH", 41, -1, 5);
        Function.addFunction("ASCII", 50, 1, 4);
        Function.addFunction("BIT_LENGTH", 51, 1, 5);
        Function.addFunction("CHAR", 52, 1, 13);
        Function.addFunction("CHR", 52, 1, 13);
        Function.addFunction("CHAR_LENGTH", 53, 1, 4);
        Function.addFunction("CHARACTER_LENGTH", 53, 1, 4);
        Function.addFunctionWithNull("CONCAT", 54, -1, 13);
        Function.addFunctionWithNull("CONCAT_WS", 92, -1, 13);
        Function.addFunction("DIFFERENCE", 55, 2, 4);
        Function.addFunction("HEXTORAW", 56, 1, 13);
        Function.addFunctionWithNull("INSERT", 57, 4, 13);
        Function.addFunction("LCASE", 59, 1, 13);
        Function.addFunction("LEFT", 60, 2, 13);
        Function.addFunction("LENGTH", 61, 1, 5);
        Function.addFunction("LOCATE", 62, -1, 4);
        Function.addFunction("POSITION", 62, 2, 4);
        Function.addFunction("INSTR", 58, -1, 4);
        Function.addFunction("LTRIM", 63, -1, 13);
        Function.addFunction("OCTET_LENGTH", 64, 1, 5);
        Function.addFunction("RAWTOHEX", 65, 1, 13);
        Function.addFunction("REPEAT", 66, 2, 13);
        Function.addFunctionWithNull("REPLACE", 67, -1, 13);
        Function.addFunction("RIGHT", 68, 2, 13);
        Function.addFunction("RTRIM", 69, -1, 13);
        Function.addFunction("SOUNDEX", 70, 1, 13);
        Function.addFunction("SPACE", 71, 1, 13);
        Function.addFunction("SUBSTR", 72, -1, 13);
        Function.addFunction("SUBSTRING", 73, -1, 13);
        Function.addFunction("UCASE", 74, 1, 13);
        Function.addFunction("LOWER", 75, 1, 13);
        Function.addFunction("UPPER", 76, 1, 13);
        Function.addFunction("POSITION", 77, 2, 4);
        Function.addFunction("TRIM", 78, -1, 13);
        Function.addFunction("STRINGENCODE", 79, 1, 13);
        Function.addFunction("STRINGDECODE", 80, 1, 13);
        Function.addFunction("STRINGTOUTF8", 81, 1, 12);
        Function.addFunction("UTF8TOSTRING", 82, 1, 13);
        Function.addFunction("XMLATTR", 83, 2, 13);
        Function.addFunctionWithNull("XMLNODE", 84, -1, 13);
        Function.addFunction("XMLCOMMENT", 85, 1, 13);
        Function.addFunction("XMLCDATA", 86, 1, 13);
        Function.addFunction("XMLSTARTDOC", 87, 0, 13);
        Function.addFunction("XMLTEXT", 88, -1, 13);
        Function.addFunction("REGEXP_REPLACE", 89, -1, 13);
        Function.addFunction("RPAD", 90, -1, 13);
        Function.addFunction("LPAD", 91, -1, 13);
        Function.addFunction("TO_CHAR", 93, -1, 13);
        Function.addFunction("TRANSLATE", 94, 3, 13);
        Function.addFunction("REGEXP_LIKE", 240, -1, 1);
        Function.addFunctionNotDeterministic("CURRENT_DATE", 100, 0, 10, true);
        Function.addFunctionNotDeterministic("CURDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("SYSDATE", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("TODAY", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("CURRENT_TIME", 101, -1, 9);
        Function.addFunctionNotDeterministic("LOCALTIME", 102, -1, 9, false);
        Function.addFunctionNotDeterministic("SYSTIME", 102, 0, 9, false);
        Function.addFunctionNotDeterministic("CURTIME", 102, -1, 9);
        Function.addFunctionNotDeterministic("CURRENT_TIMESTAMP", 103, -1, 24, false);
        Function.addFunctionNotDeterministic("SYSTIMESTAMP", 103, -1, 24, false);
        Function.addFunctionNotDeterministic("LOCALTIMESTAMP", 104, -1, 11, false);
        Function.addFunctionNotDeterministic("NOW", 104, -1, 11);
        Function.addFunction("TO_DATE", 96, -1, 11);
        Function.addFunction("TO_TIMESTAMP", 97, -1, 11);
        Function.addFunction("ADD_MONTHS", 98, 2, 11);
        Function.addFunction("TO_TIMESTAMP_TZ", 99, -1, 24);
        Function.addFunction("DATEADD", 105, 3, 11);
        Function.addFunction("TIMESTAMPADD", 105, 3, 11);
        Function.addFunction("DATEDIFF", 106, 3, 5);
        Function.addFunction("TIMESTAMPDIFF", 106, 3, 5);
        Function.addFunction("DAYNAME", 107, 1, 13);
        Function.addFunction("DAYNAME", 107, 1, 13);
        Function.addFunction("DAY", 108, 1, 4);
        Function.addFunction("DAY_OF_MONTH", 108, 1, 4);
        Function.addFunction("DAY_OF_WEEK", 109, 1, 4);
        Function.addFunction("DAY_OF_YEAR", 110, 1, 4);
        Function.addFunction("DAYOFMONTH", 108, 1, 4);
        Function.addFunction("DAYOFWEEK", 109, 1, 4);
        Function.addFunction("DAYOFYEAR", 110, 1, 4);
        Function.addFunction("HOUR", 111, 1, 4);
        Function.addFunction("MINUTE", 112, 1, 4);
        Function.addFunction("MONTH", 113, 1, 4);
        Function.addFunction("MONTHNAME", 114, 1, 13);
        Function.addFunction("QUARTER", 115, 1, 4);
        Function.addFunction("SECOND", 116, 1, 4);
        Function.addFunction("WEEK", 117, 1, 4);
        Function.addFunction("YEAR", 118, 1, 4);
        Function.addFunction("EXTRACT", 119, 2, 4);
        Function.addFunctionWithNull("FORMATDATETIME", 120, -1, 13);
        Function.addFunctionWithNull("PARSEDATETIME", 121, -1, 11);
        Function.addFunction("ISO_YEAR", 122, 1, 4);
        Function.addFunction("ISO_WEEK", 123, 1, 4);
        Function.addFunction("ISO_DAY_OF_WEEK", 124, 1, 4);
        Function.addFunction("DATE_TRUNC", 125, 2, 0);
        Function.addFunctionNotDeterministic("DATABASE", 150, 0, 13);
        Function.addFunctionNotDeterministic("USER", 151, 0, 13);
        Function.addFunctionNotDeterministic("CURRENT_USER", 152, 0, 13);
        Function.addFunctionNotDeterministic("IDENTITY", 153, 0, 5);
        Function.addFunctionNotDeterministic("SCOPE_IDENTITY", 154, 0, 5);
        Function.addFunctionNotDeterministic("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("LAST_INSERT_ID", 153, 0, 5);
        Function.addFunctionNotDeterministic("LASTVAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("AUTOCOMMIT", 155, 0, 1);
        Function.addFunctionNotDeterministic("READONLY", 156, 0, 1);
        Function.addFunction("DATABASE_PATH", 157, 0, 13);
        Function.addFunctionNotDeterministic("LOCK_TIMEOUT", 158, 0, 4);
        Function.addFunctionWithNull("IFNULL", 200, 2, 0);
        Function.addFunctionWithNull("ISNULL", 200, 2, 0);
        Function.addFunctionWithNull("CASEWHEN", 201, 3, 0);
        Function.addFunctionWithNull("CONVERT", 202, 1, 0);
        Function.addFunctionWithNull("CAST", 203, 1, 0);
        Function.addFunctionWithNull("TRUNCATE_VALUE", 227, 3, 0);
        Function.addFunctionWithNull("COALESCE", 204, -1, 0);
        Function.addFunctionWithNull("NVL", 204, -1, 0);
        Function.addFunctionWithNull("NVL2", 228, 3, 0);
        Function.addFunctionWithNull("NULLIF", 205, 2, 0);
        Function.addFunctionWithNull("CASE", 206, -1, 0);
        Function.addFunctionNotDeterministic("NEXTVAL", 207, -1, 5);
        Function.addFunctionNotDeterministic("CURRVAL", 208, -1, 5);
        Function.addFunction("ARRAY_GET", 209, 2, 0);
        Function.addFunctionWithNull("ARRAY_CONTAINS", 230, 2, 1);
        Function.addFunction("ARRAY_CAT", 234, 2, 17);
        Function.addFunction("ARRAY_APPEND", 235, 2, 17);
        Function.addFunction("ARRAY_SLICE", 236, 3, 17);
        Function.addFunction("CSVREAD", 210, -1, 18, false, false, false, true);
        Function.addFunction("CSVWRITE", 211, -1, 4, false, false, true, true);
        Function.addFunctionNotDeterministic("MEMORY_FREE", 212, 0, 4);
        Function.addFunctionNotDeterministic("MEMORY_USED", 213, 0, 4);
        Function.addFunctionNotDeterministic("LOCK_MODE", 214, 0, 4);
        Function.addFunctionNotDeterministic("SCHEMA", 215, 0, 13);
        Function.addFunctionNotDeterministic("SESSION_ID", 216, 0, 4);
        Function.addFunction("ARRAY_LENGTH", 217, 1, 4);
        Function.addFunctionNotDeterministic("LINK_SCHEMA", 218, 6, 18);
        Function.addFunctionWithNull("LEAST", 220, -1, 0);
        Function.addFunctionWithNull("GREATEST", 219, -1, 0);
        Function.addFunctionNotDeterministic("CANCEL_SESSION", 221, 1, 1);
        Function.addFunction("SET", 222, 2, 0, false, false, true, true);
        Function.addFunction("FILE_READ", 225, -1, 0, false, false, true, true);
        Function.addFunction("FILE_WRITE", 232, 2, 5, false, false, true, true);
        Function.addFunctionNotDeterministic("TRANSACTION_ID", 226, 0, 13);
        Function.addFunctionWithNull("DECODE", 229, -1, 0);
        Function.addFunctionNotDeterministic("DISK_SPACE_USED", 159, 1, 5);
        Function.addFunctionWithNull("SIGNAL", 160, 2, 0);
        Function.addFunctionNotDeterministic("ESTIMATED_ENVELOPE", 161, 2, 5);
        Function.addFunction("H2VERSION", 231, 0, 13);
        Function.addFunctionWithNull("TABLE", 223, -1, 18);
        Function.addFunctionWithNull("TABLE_DISTINCT", 224, -1, 18);
        Function.addFunctionWithNull("UNNEST", 233, -1, 18);
        Function.addFunction("VALUES", 250, 1, 0, false, true, false, true);
    }
}

