/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.function;

import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.engine.FunctionAlias;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.function.FunctionCall;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueCollectionBase;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueResultSet;

public class JavaFunction
extends Expression
implements FunctionCall {
    private final FunctionAlias functionAlias;
    private final FunctionAlias.JavaMethod javaMethod;
    private final Expression[] args;

    public JavaFunction(FunctionAlias functionAlias, Expression[] args) {
        this.functionAlias = functionAlias;
        this.javaMethod = functionAlias.findJavaMethod(args);
        this.args = args;
    }

    @Override
    public Value getValue(Session session) {
        return this.javaMethod.getValue(session, this.args, false);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.getTypeInfo(this.javaMethod.getDataType());
    }

    @Override
    public int getValueType() {
        return this.javaMethod.getDataType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        for (Expression e : this.args) {
            e.mapColumns(resolver, level, state);
        }
    }

    @Override
    public Expression optimize(Session session) {
        boolean allConst = this.isDeterministic();
        int len = this.args.length;
        for (int i = 0; i < len; ++i) {
            Expression e;
            this.args[i] = e = this.args[i].optimize(session);
            allConst &= e.isConstant();
        }
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        if (this.functionAlias.getDatabase().getSettings().functionsInSchema || this.functionAlias.getSchema().getId() != 0) {
            Parser.quoteIdentifier(builder, this.functionAlias.getSchema().getName(), alwaysQuote).append('.');
        }
        Parser.quoteIdentifier(builder, this.functionAlias.getName(), false).append('(');
        JavaFunction.writeExpressions(builder, this.args, alwaysQuote);
        return builder.append(')');
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.updateAggregate(session, stage);
        }
    }

    @Override
    public String getName() {
        return this.functionAlias.getName();
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] argList) {
        Value v = this.javaMethod.getValue(session, argList, true);
        return v == ValueNull.INSTANCE ? null : (ValueResultSet)v;
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                if (this.isDeterministic()) break;
                return false;
            }
            case 7: {
                visitor.addDependency(this.functionAlias);
                break;
            }
        }
        for (Expression e : this.args) {
            if (e == null || e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = this.javaMethod.hasConnectionParam() ? 25 : 5;
        for (Expression e : this.args) {
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public boolean isDeterministic() {
        return this.functionAlias.isDeterministic();
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        switch (this.getValueType()) {
            case 18: {
                ValueResultSet rs = this.getValueForColumnList(session, this.getArgs());
                return JavaFunction.getExpressionColumns(session, rs.getResult());
            }
            case 17: 
            case 39: {
                return JavaFunction.getExpressionColumns(session, (ValueCollectionBase)this.getValue(session));
            }
        }
        return super.getExpressionColumns(session);
    }

    @Override
    public boolean isBufferResultSetToLocalTemp() {
        return this.functionAlias.isBufferResultSetToLocalTemp();
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.args[index];
    }
}

