/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.FunctionIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.value.Value;

abstract class AbstractFunctionCursor
implements Cursor {
    private final FunctionIndex index;
    private final SearchRow first;
    private final SearchRow last;
    final Session session;
    Value[] values;
    Row row;

    AbstractFunctionCursor(FunctionIndex index, SearchRow first, SearchRow last, Session session) {
        this.index = index;
        this.first = first;
        this.last = last;
        this.session = session;
    }

    @Override
    public Row get() {
        if (this.values == null) {
            return null;
        }
        if (this.row == null) {
            this.row = this.session.createRow(this.values, 1);
        }
        return this.row;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        SearchRow first = this.first;
        SearchRow last = this.last;
        if (first == null && last == null) {
            return this.nextImpl();
        }
        while (this.nextImpl()) {
            int comp;
            Row current = this.get();
            if (first != null && (comp = this.index.compareRows(current, first)) < 0 || last != null && (comp = this.index.compareRows(current, last)) > 0) continue;
            return true;
        }
        return false;
    }

    abstract boolean nextImpl();

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

